$!-----------------------------------------------------------------------------
$! AUTHACE.COM
$!
$! WASD (HFRD) VMS Hypertext Services, Copyright (c) 1996-1998 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! An example procedure for applying an ACE to one or more directories to allow
$! the server to create, update or delete files within it (in conjunction with
$! the appropriate server authorization configuration of course!)
$! See the WASD Technical Overview for details on authorization.
$!
$! 27-JUN-98  MGD  initial, v5.1 (q&d)
$!-----------------------------------------------------------------------------
$!
$ HTTPD_ACCOUNT_NAME = "HTTP$SERVER"
$!
$ say = "write sys$output"
$!
$ if P1 .eqs. ""
$ then
$    type sys$input

  PRECIS:    This command procedure adds/deletes ACEs to directories to
             permit the WASD HTTP server write access to the contents.
             Use with discretion!

  USAGE:     P1 must be the directory to be modified
             Pn can be "PROFILE" for WASD /PROFILE access ACE
                       "PROPAGATE" to generate default ACEs
                       "DELETE" to delete matching ACEs (removing access)
             Delete must be done with same parameters as the original add!

  EXAMPLES:  @AUTHACE WEB:[TEST]  !applies ACE to WEB:[000000]TEST.DIR

             @AUTHACE WEB:[TEST.*]  !applies ACE to WEB:[000000]TEST.DIR and
                                    !to all first level subdirectories

             @AUTHACE WEB:[TEST...]  !applies ACE to WEB:[000000]TEST.DIR and
                                     !to all subdirectories in tree
$    exit
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$!(Ahhh, for a Unix-like file system syntax!!)
$!
$ p1Elipsis = 0
$ if P1 - "..." .nes. P1 then p1Elipsis = 1
$!
$ p1WildDir = 0
$ if P1 - ".*]" .nes. P1 then p1WildDir = 1
$ if p1WildDir then P1 = P1 - ".*]" + "]"
$!
$ p1Device = f$parse(P1,,,"DEVICE","NO_CONCEAL")
$ p1Directory = f$parse(P1,,,"DIRECTORY","NO_CONCEAL") - "..."
$ p1TopLevel = p1Device + p1Directory - "][" - "..."
$ if f$element(1,".",p1TopLevel) .eqs. "."
$ then
$!   (no subdirectories)
$    p1DirFile = p1Device + "[000000]" +-
                 (f$element(1,"[",p1TopLevel) - "]") + ".DIR"
$ else
$    if p1TopLevel - ".000000]" .nes. p1TopLevel
$    then
$!      (concealed logical device, top-level directory)
$       p1DirFile = p1Device + "[000000]" +-
                    (f$element(0,".",p1Directory) - "[") + ".DIR"
$    else
$!      (device plus multiple directories)
$       p1DirFile = ""
$       p1NextDir = ""
$       count = 0
$       subDirLoop:
$          if f$element(count,".",p1TopLevel) .eqs. "." then goto endSubDirLoop
$          if p1DirFile .nes. "" then p1DirFile = p1DirFile + "."
$          p1DirFile = p1DirFile + p1NextDir
$          p1NextDir = f$element(count,".",p1TopLevel)
$          count = count + 1
$          goto subDirLoop
$       endSubDirLoop:
$       p1DirFile = p1DirFile + "]" + (p1NextDir - "]") + ".DIR"
$    endif
$ endif
$!
$ if f$search(p1DirFile) .eqs. ""
$ then
$    asterLength = f$length(P1) + 27
$    asters = f$fao("!''asterLength'**")
$    say ""
$    say "  ''asters'"
$    say "  *  Directory ''P1' not found!  *"
$    say "  ''asters'"
$    say ""
$    exit
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ propagateAce = 0
$ if P2 .eqs. "PROPAGATE" .or. -
     P3 .eqs. "PROPAGATE" .or. -
     P4 .eqs. "PROPAGATE" .or. -
     P5 .eqs. "PROPAGATE" -
     then propagateAce = 1
$!
$ profileAce = 0
$ if P2 .eqs. "PROFILE" .or. -
     P3 .eqs. "PROFILE" .or. -
     P4 .eqs. "PROFILE" .or. -
     P5 .eqs. "PROFILE" -
     then profileAce = 1
$!
$ deleteAce = ""
$ if P2 .eqs. "DELETE" .or. -
     P3 .eqs. "DELETE" .or. -
     P4 .eqs. "DELETE" .or. -
     P5 .eqs. "DELETE" -
     then deleteAce = " /DELETE"
$!
$ noConfirm = 0
$ if P2 .eqs. "NOCONFIRM" .or. -
     P3 .eqs. "NOCONFIRM" .or. -
     P4 .eqs. "NOCONFIRM" .or. -
     P5 .eqs. "NOCONFIRM" -
     then noConfirm = 1
$!
$ if profileAce
$ then
$    if propagateAce
$    then
$       ace = "((IDENT=''HTTPD_ACCOUNT_NAME',OPTIONS=DEFAULT," +-
               "ACCESS=READ+WRITE+EXECUTE+DELETE+CONTROL)," +-
              "(IDENT=''HTTPD_ACCOUNT_NAME'," +-
               "ACCESS=READ+WRITE+EXECUTE+DELETE+CONTROL))"
$    else
$       ace = "(IDENT=''HTTPD_ACCOUNT_NAME'," +-
               "ACCESS=READ+WRITE+EXECUTE+DELETE+CONTROL)"
$    endif
$ else
$    if propagateAce
$    then
$       ace = "((IDENT=''HTTPD_ACCOUNT_NAME',OPTIONS=DEFAULT," +-
                 "ACCESS=READ+WRITE+EXECUTE+DELETE)," +-
               "(IDENT=''HTTPD_ACCOUNT_NAME',ACCESS=READ+WRITE+EXECUTE+DELETE))"
$    else
$       ace = "(IDENT=''HTTPD_ACCOUNT_NAME',ACCESS=READ+WRITE+EXECUTE+DELETE)"
$    endif
$ endif
$!
$ setAcl1 = "SET ACL /LOG ''p1DirFile' /ACL=''ace'''deleteAce'"
$ setAcl2 = "SET ACL /LOG ''P1'*.DIR /ACL=''ace'''deleteAce'"
$ say ""
$ say "The following command(s) will be issued:"
$ say ""
$ say setAcl1
$ if p1Elipsis .or. p1WildDir
$ then
$    say ""
$    say setAcl2
$ endif
$!
$ if noConfirm
$ then
$    set noon
$    say ""
$    'setAcl1'
$    if p1Elipsis .or. p1WildDir then 'setAcl2'
$    set on
$    say ""
$    exit
$ endif
$!
$ say ""
$ say "Continue?"
$ say ""
$ read sys$command response /prompt="[No]: "
$ if response
$ then
$    set noon
$    say ""
$    'setAcl1'
$    if p1Elipsis .or. p1WildDir then 'setAcl2'
$    set on
$ endif
$ say ""
$!
$!-----------------------------------------------------------------------------
