$!-----------------------------------------------------------------------------
$! STARTUP.COM
$!
$! WASD (HFRD) VMS Hypertext Services, Copyright (c) 1996-2002 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! Example WASD HTTPd server startup procedure.
$! This does most of what is needed for the average installation.
$! Using startup symbols (see below) this procedure should not need to be
$! modified.  The objective of course is to make future upgrades as simple
$! as possible with minimum hard-wiring changes.
$!
$! DO NOT MODIFY THIS PROCEDURE!
$! *****************************
$!
$! Startup options are provided by either by supplying symbol values on the
$! command-line or by explicitly assigning the symbols before calling this
$! procedure.  Reasonable defaults apply if these symbols do not exist.
$!
$!   WASD_ACCOUNT ..... account server runs under (default is HTTP$SERVER)
$!   WASD_BATCH_LOG ... if true log the batch job (for problem resolution)
$!   WASD_BATCH_QUEUE ... startup batch queue (default is SYS$BATCH)
$!   WASD_DECNET ...... if true DECnet scripting should be started
$!   WASD_HT_ROOT ..... explicit location for defining the HT_ROOT logical
$!   WASD_HT_CACHE_ROOT ... location for defining the HT_ROOT_CACHE logical
$!   WASD_HTTPD_GMT ... if not using SYS$TIMEZONE_DIFFERENTIAL (e.g. "+09:30")
$!   WASD_HTTPD_LOG ... if supplied defines a corresponding HTTPD$LOG logical
$!   WASD_NETWORK ..... run server (including detached scripts) in network mode
$!   WASD_NON_SSL ..... if true the non-SSL image should be used 
$!   WASD_SSL ......... if true the SSL image should be used 
$!   WASD_VMS_SSL ..... if true use the SSL image and VMS OpenSSL libraries 
$!   WASD_SSL_CAFILE ... file location for client certificate CA verification
$!   WASD_SSL_CERT .... file location for the server certificate
$!
$! As in the following examples:
$!
$!   $! command-line example
$!   $ @DKA0:[HT_ROOT.LOCAL]STARTUP WASD_DECNET=1 WASD_SSL=1 -
$!   WASD_SSL_CERT="HT_ROOT:[LOCAL]SITE.PEM"
$!
$!   $! symbol assignment example
$!   $ WASD_DECNET = 1
$!   $ WASD_SSL = 1
$!   $ WASD_SSL_CERT = "HT_ROOT:[LOCAL]SITE.PEM"
$!   $ @DKA0:[HT_ROOT.LOCAL]STARTUP
$!
$!   $! specifying an alternate batch queue
$!   $ @DKA0:[HT_ROOT.LOCAL]STARTUP WASD_DECNET=1 WASD_BATCH_QUEUE="THISONE" 
$!
$! If an SSL image is available that is used unless explicitly set.
$! Detects VMS V7.n and uses SYS$TIMEZONE_DIFFERENTIAL for GMT unless set.
$! By default HT_ROOT logical is generated from the location of this procedure.
$!
$! If the procedure STARTUP_LOCAL.COM exists in the same directory as this
$! procedure then it is executed after all this procedure's setup and
$! immediately before the server is actually started.  Local setup can be
$! customized in that procedure leaving this one completely untouched.
$! For instance, the local startup should be used for defining local logicals,
$! installing local scripts, etc.
$!
$! Server process startup is provided via STARTUP_SERVER.COM,
$! STARTUP_SERVER_nodename.COM, STARTUP_SERVER_nodename_port.COM,
$! see STARTUP_SERVER.COM and the Technical Overview for details.
$!
$! VERSION HISTORY
$! ---------------
$! 22-DEC-2003  MGD  support for IA64,
$!                   CMKRNL required for v8.4,
$!                   WASD_NETWORK to run server (and scripts) in network mode
$! 30-DEC-2002  MGD  bugfix; batch startup endless loop
$! 15-OCT-2002  MGD  WASD 8.1 and later detects it's own startup procedure,
$!                   new logicals and revised locations for post-8.1
$! 10-AUG-2002  MGD  allow for using VMS OpenSSL v1.0-A
$! 03-NOV-2001  MGD  PERSONA_MACRO for pre-VMS 6.2 VAX
$! 13-JUL-2001  MGD  define SSL_CAFILE only if it exists
$! 12-MAY-2001  MGD  install PRMGBL,SYSGBL,SHMEM for monitor global section,
$!                   add wildcards to F$SEARCH to prevent "run-aways"
$! 26-JAN-2001  MGD  v7.2, add WASD_SSL_CAFILE and HTTPD$SSL_CAFILE
$! 07-DEC-2000  MGD  add HT_SCRATCH
$! 01-JUL-2000  MGD  v7.1, add WORLD,SYSLCK privileges,
$!                         CGI-BIN changed to "CGI-BIN" for VMS V5.5-2,
$!                         conditional definition of HTTP$SERVICE logical,
$!                         WASD_BATCH_QUEUE allows non-default SYS$BATCH,
$!                         allow for a STARTUP_SERVER_LOCAL.COM
$! 31-OCT-1999  MGD  v6.1, remove NETLIB support
$! 15-JAN-1999  MGD  v6.0, proxy cache directory
$! 04-DEC-1998  MGD  bugfix; to above commentary, provide WASD_HTTPD_LOG
$! 01-NOV-1998  MGD  v5.3, (better support for virtual services)
$! 27-JUN-1998  MGD  v5.1
$! 07-FEB-1998  MGD  v5.0
$! ??-???-????  MGD  long unrecorded pre-history :^)
$!-----------------------------------------------------------------------------
$!
$ SAY = "WRITE SYS$OUTPUT"
$ PROCEDURE = F$ENVIRONMENT("PROCEDURE")
$ PROC_DEVICE = F$PARSE(PROCEDURE,,,"DEVICE","NO_CONCEAL")
$ PROC_DIRECTORY = F$PARSE(PROCEDURE,,,"DIRECTORY","NO_CONCEAL")
$ ARCH_NAME = F$GETSYI("ARCH_NAME")
$ IF F$EDIT(ARCH_NAME,"UPCASE") .EQS. "ALPHA" THEN ARCH_NAME = "AXP"
$ VMS_VERSION = F$INTEGER(F$EXTRACT(1,1,F$GETSYI("VERSION"))) * 10 +-
                F$INTEGER(F$EXTRACT(3,1,F$GETSYI("VERSION")))
$!
$ SAY "%HTTPD-I-STARTUPROC, begin"
$!
$! ---------------
$! STARTUP SYMBOLS
$! ---------------
$!
$ IF P1 .NES. "" THEN 'P1'
$ IF P2 .NES. "" THEN 'P2'
$ IF P3 .NES. "" THEN 'P3'
$ IF P4 .NES. "" THEN 'P4'
$ IF P5 .NES. "" THEN 'P5'
$ IF P6 .NES. "" THEN 'P6'
$ IF P7 .NES. "" THEN 'P7'
$ IF P8 .NES. "" THEN 'P8'
$!
$ IF F$TYPE(WASD_ACCOUNT) .EQS. "" THEN WASD_ACCOUNT = "HTTP$SERVER"
$ IF F$TYPE(WASD_BATCH_QUEUE) .EQS. "" THEN WASD_BATCH_QUEUE = "SYS$BATCH"
$ IF F$TYPE(WASD_BATCH_LOG) .EQS. "" THEN WASD_BATCH_LOG = 0
$ IF F$TYPE(WASD_DECNET) .EQS. "" THEN WASD_DECNET = 0
$ IF F$TYPE(WASD_HT_ROOT) .EQS. "" THEN WASD_HT_ROOT = ""
$ IF F$TYPE(WASD_HT_CACHE_ROOT) .EQS. "" THEN WASD_HT_CACHE_ROOT = ""
$ IF F$TYPE(WASD_HTTPD_GMT) .EQS. "" THEN WASD_HTTPD_GMT = ""
$ IF F$TYPE(WASD_NON_SSL) .EQS. "" THEN WASD_NON_SSL = 0
$ IF F$TYPE(WASD_NETWORK) .EQS. "" THEN WASD_NETWORK = 0
$ IF F$TYPE(WASD_SSL) .EQS. "" THEN WASD_SSL = 0
$ IF F$TYPE(WASD_VMS_SSL) .EQS. "" THEN WASD_VMS_SSL = 0
$ IF F$TYPE(WASD_SSL_CERT) .EQS. "" -
     THEN WASD_SSL_CERT = "HT_ROOT:[LOCAL]HTTPD.PEM"
$ IF F$TYPE(WASD_SSL_CAFILE) .EQS. "" -
     THEN WASD_SSL_CAFILE = "HT_ROOT:[LOCAL]CA-BUNDLE_CRT.TXT"
$!
$!(this is primarily to support IA64 on evaluation releases of VMS 8.n)
$!(use as any other startup symbol, e.g. $ @STARTUP WASD_VMS_VERSION="V8.1")
$ IF F$TYPE(WASD_VMS_VERSION) .EQS. "" .AND. -
     F$EXTRACT(0,1,F$GETSYI("VERSION")) .EQS. "X" -
     THEN WASD_VMS_VERSION  = "V8.1"
$ IF F$TYPE(WASD_VMS_VERSION) .NES. "" -
     THEN VMS_VERSION = F$INTEGER(F$EXTRACT(1,1,WASD_VMS_VERSION)) * 10 +-
                        F$INTEGER(F$EXTRACT(3,1,WASD_VMS_VERSION))
$!
$! ---------------------
$! DEFINE HTTPd LOGICALS
$! ---------------------
$!
$ IF WASD_HT_ROOT .EQS. ""
$ THEN
$!   (derive from location of this procedure, assumes it's in HT_ROOT tree!)
$    HT_ROOT = PROC_DEVICE +-
        (PROC_DIRECTORY --
         F$EXTRACT(F$LOCATE("HT_ROOT",PROC_DIRECTORY),999,PROC_DIRECTORY)) +-
        "HT_ROOT.]"
$ ELSE
$    HT_ROOT = WASD_HT_ROOT
$ ENDIF
$ DEFINE /NOLOG /SYSTEM /EXEC /TRANSLATION=CONCEALED HT_ROOT 'HT_ROOT'
$ IF F$SEARCH("HT_ROOT:[000000]*.*") .EQS. ""
$ THEN
$    SAY "%HTTPD-E-STARTUPROC, problem with HT_ROOT logical"
$    EXIT
$ ENDIF
$!
$ IF WASD_HT_CACHE_ROOT .NES. ""
$ THEN
$    DEFINE /NOLOG /SYSTEM /EXEC /TRANSLATION=CONCEALED -
            HT_CACHE_ROOT 'WASD_HT_CACHE_ROOT'
$    SET NOON
$    DIR /NOOUTPUT HT_CACHE_ROOT:[000000]
$    IF .NOT. $STATUS .AND. $STATUS .NE. %X10018290
$    THEN
$       CREATE_HT_CACHE_ROOT = WASD_HT_CACHE_ROOT - ".]" + "]"
$       SAY "%HTTPD-I-STARTUPPROC, creating proxy cache directory " +-
            CREATE_HT_CACHE_ROOT
$       CREATE /DIR /OWN=HTTP$SERVER /PROT=(S:RWED,O:RWED,G:RWED,W) -
               'CREATE_HT_CACHE_ROOT'
$       DIR /NOOUTPUT HT_CACHE_ROOT:[000000]
$       IF .NOT. $STATUS .AND. $STATUS .NE. %X10018290
$       THEN
$          SAY "%HTTPD-E-STARTUPROC, problem with HT_CACHE_ROOT logical"
$          EXIT
$       ENDIF
$    ENDIF
$    SET ON
$ ENDIF
$!
$ DEFINE /NOLOG /SYSTEM /EXEC HT_SCRIPT HT_ROOT:[SCRIPT]
$ SCRIPT_LOCAL_ROOT = HT_ROOT - ".]" + ".SCRIPT_LOCAL.]"
$ DEFINE /NOLOG /SYSTEM /EXEC HT_SCRIPT_LOCAL HT_ROOT:[SCRIPT_LOCAL]
$ JAVA_ROOT = HT_ROOT - ".]" + ".JAVA.]"
$ DEFINE /NOLOG /SYSTEM /EXEC HT_JAVA HT_ROOT:[JAVA]
$!
$ DEFINE /NOLOG /SYSTEM /EXEC HT_AXP HT_ROOT:[AXP]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_IA64 HT_ROOT:[IA64]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_VAX HT_ROOT:[VAX]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_EXE HT_ROOT:['ARCH_NAME']
$!
$ DEFINE /NOLOG /SYSTEM /EXEC CGI_BIN HT_ROOT:[CGI-BIN]
$ DEFINE /NOLOG /SYSTEM /EXEC CGI_AXP HT_ROOT:[AXP-BIN]
$ DEFINE /NOLOG /SYSTEM /EXEC CGI_IA64 HT_ROOT:[IA64-BIN]
$ DEFINE /NOLOG /SYSTEM /EXEC CGI_VAX HT_ROOT:[VAX-BIN]
$ DEFINE /NOLOG /SYSTEM /EXEC CGI_EXE HT_ROOT:['ARCH_NAME'-BIN]
$ CGI_BIN = HT_ROOT - ".]" + ".CGI-BIN.]"
$ CGI_EXE = HT_ROOT - ".]" + ".''ARCH_NAME'-BIN.]"
$ DEFINE /NOLOG /SYSTEM /EXEC /TRANSLATION=(CONCEALED) "CGI-BIN" -
         'CGI_BIN','CGI_EXE'
$!
$ DEFINE /NOLOG /SYSTEM /EXEC HT_AUTH HT_ROOT:[LOCAL]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_LOCAL HT_ROOT:[LOCAL]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_LOGS HT_ROOT:[LOG]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_SCRATCH HT_ROOT:[SCRATCH]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_SERVER_LOGS HT_ROOT:[LOG_SERVER]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_STARTUP HT_ROOT:[STARTUP]
$!
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$AUTH HT_ROOT:[LOCAL]HTTPD$AUTH.CONF
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$CONFIG HT_ROOT:[LOCAL]HTTPD$CONFIG.CONF
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$MAP HT_ROOT:[LOCAL]HTTPD$MAP.CONF
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$MSG HT_ROOT:[LOCAL]HTTPD$MSG.CONF
$ IF F$SEARCH("HT_ROOT:[LOCAL]HTTPD$SERVICE.CONF") .NES. "" -
     THEN DEFINE /NOLOG /SYSTEM /EXEC -
                 HTTPD$SERVICE HT_ROOT:[LOCAL]HTTPD$SERVICE.CONF
$ IF F$TYPE(WASD_HTTPD_LOG) .NES. "" -
     THEN DEFINE /NOLOG /SYSTEM /EXEC HTTPD$LOG 'WASD_HTTPD_LOG'
$!
$ IF WASD_HTTPD_GMT .EQS. ""
$ THEN
$    IF VMS_VERSION .LT. 70
$    THEN
$       SAY "%HTTPD-E-STARTUPROC, unreliable UTC time (set WASD_HTTPD_GMT symbol)"
$       EXIT
$    ENDIF
$ ELSE
$    DEFINE /NOLOG /SYSTEM /EXEC HTTPD$GMT "''WASD_HTTPD_GMT'"
$ ENDIF
$!
$ IF WASD_NETWORK
$   THEN SLASH_NETWORK = "/NETWORK"
$   ELSE SLASH_NETWORK = ""
$ ENDIF
$!
$! --------------------
$! DECNET/OSU SCRIPTING
$! --------------------
$!
$ IF WASD_DECNET
$ THEN
$!
$    SAY "%HTTPD-I-STARTUPROC, providing DECnet/OSU scripting"
$!
$!   (derive from the location of this procedure)
$    STARTUP_DECNET = PROC_DEVICE + PROC_DIRECTORY + "STARTUP_DECNET.COM"
$    @'STARTUP_DECNET'
$!
$ ENDIF
$!
$! ------------------------
$! INSTALL PRIVILEGED IMAGE
$! ------------------------
$!
$ IF WASD_VMS_SSL THEN WASD_SSL = 1
$ IF WASD_NON_SSL THEN WASD_SSL = 0
$ IF .NOT. WASD_SSL .AND. .NOT. WASD_NON_SSL
$ THEN
$    IF F$SEARCH("HT_EXE:HTTPD_SSL.EXE") .EQS. ""
$       THEN WASD_SSL = 0
$       ELSE WASD_SSL = 1
$    ENDIF
$ ENDIF
$ IF .NOT. WASD_SSL THEN SAY "%HTTPD-I-STARTUPROC, using non-SSL image"
$ IF WASD_SSL THEN SAY "%HTTPD-I-STARTUPROC, using SSL image"
$ IF WASD_VMS_SSL THEN SAY "%HTTPD-I-VMSOPENSSL, using VMS OpenSSL shareable images"
$!
$ HTTPD_EXE = "HT_EXE:HTTPD"
$ IF WASD_SSL THEN HTTPD_EXE = HTTPD_EXE + "_SSL"
$ HTTPD_EXE = HTTPD_EXE + ".EXE"
$ HTTPD = "$''HTTPD_EXE'"
$!
$ SECHAN = "$HT_EXE:SECHAN"
$ SECHAN /ASIF=STARTUP 'HTTPD_EXE'
$!
$ INSTALL = "$SYS$SYSTEM:INSTALL/COMMAND_MODE"
$ INSTPRV = "ALTPRI,CMKRNL,DETACH,PRMGBL,PRMMBX,PSWAPM," +-
            "SYSGBL,SYSLCK,SYSPRV,SYSNAM,WORLD"
$ IF ARCH_NAME .EQS. "VAX" THEN INSTPRV = INSTPRV + ",SHMEM"
$ DEFINE /USER SYS$OUTPUT NL:
$ DEFINE /USER SYS$ERROR NL:
$ INSTALL REMOVE 'HTTPD_EXE'
$ INSTALL ADD 'HTTPD_EXE' /PRIVILEGE=('INSTPRV')
$!
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$EXE 'HTTPD_EXE'
$!
$! ----------------
$! SSL REQUIREMENTS
$! ----------------
$!
$ IF WASD_SSL
$ THEN
$    IF F$SEARCH("''WASD_SSL_CERT'") .NES. "" -
        THEN DEFINE /NOLOG /SYSTEM /EXEC HTTPD$SSL_CERT 'WASD_SSL_CERT'
$    IF F$SEARCH("''WASD_SSL_CAFILE'") .NES. "" -
        THEN DEFINE /NOLOG /SYSTEM /EXEC HTTPD$SSL_CAFILE 'WASD_SSL_CAFILE'
$    IF WASD_VMS_SSL
$    THEN
$!      (ensure VMS OpenSSL shareable images are INSTALLed)
$       IF .NOT. F$FILE("SYS$LIBRARY:SSL$LIBCRYPTO_SHR32.EXE","KNOWN") -
           THEN INSTALL ADD /OPEN /HEADER /SHARE SYS$LIBRARY:SSL$LIBCRYPTO_SHR32.EXE
$       IF .NOT. F$FILE("SYS$LIBRARY:SSL$LIBSSL_SHR32.EXE","KNOWN") -
           THEN INSTALL ADD /OPEN /HEADER /SHARE SYS$LIBRARY:SSL$LIBSSL_SHR32.EXE
$    ENDIF
$ ENDIF
$!
$! -------------
$! LOCAL STARTUP
$! -------------
$!
$!(derive from the location of this procedure)
$ STARTUP_LOCAL = PROC_DEVICE + PROC_DIRECTORY + "STARTUP_LOCAL.COM"
$ IF F$SEARCH(STARTUP_LOCAL) .NES. "" THEN @'STARTUP_LOCAL'
$!
$! ------------------
$! START HTTPd SERVER
$! ------------------
$!
$ STARTUP_PROCEDURE = ""
$ IF VMS_VERSION .GE. 62
$ THEN
$!   (look for version 8.n or later of the server)
$    DEFINE /USER SYS$OUTPUT NL:
$    DEFINE /USER SYS$ERROR NL:
$    SEARCH 'HTTPD_EXE' "[STARTUP]"
$    IF $SEVERITY .EQS. "1" THEN STARTUP_PROCEDURE = "[STARTUP]"
$    STARTUP_SERVER = ""
$ ENDIF
$ IF STARTUP_PROCEDURE .EQS. ""
$ THEN
$!   (look for STARTUP_SERVER_nodename_port.COM)
$    STARTUP_SERVER = PROC_DEVICE + PROC_DIRECTORY + "STARTUP_SERVER_" + -
                      F$EDIT(F$GETSYI("SCSNODE"),"COLLAPSE") + "_*.COM;0"
$    STARTUP_PROCEDURE = F$SEARCH(STARTUP_SERVER)
$    STARTUP_SERVER = ""
$ ENDIF
$ IF STARTUP_PROCEDURE .EQS. ""
$ THEN
$!   (look for STARTUP_SERVER_nodename.COM)
$    STARTUP_SERVER = PROC_DEVICE + PROC_DIRECTORY + "STARTUP_SERVER_" + -
                      F$EDIT(F$GETSYI("SCSNODE"),"COLLAPSE") + ".C%M;0"
$    STARTUP_PROCEDURE = F$SEARCH(STARTUP_SERVER)
$    STARTUP_SERVER = ""
$ ENDIF
$ IF STARTUP_PROCEDURE .EQS. ""
$ THEN
$!   (nothing node/port specific look for a local, site-specific startup file)
$    STARTUP_SERVER = PROC_DEVICE + PROC_DIRECTORY +-
                      "STARTUP_SERVER_LOCAL.C%M;0"
$    STARTUP_PROCEDURE = F$SEARCH(STARTUP_SERVER)
$    STARTUP_SERVER = ""
$ ENDIF
$ IF STARTUP_PROCEDURE .EQS. ""
$ THEN
$!   (nothing node/port/local specific, look for post-v5.3 startup)
$    STARTUP_SERVER = PROC_DEVICE + PROC_DIRECTORY + "STARTUP_SERVER.C%M;0"
$    STARTUP_PROCEDURE = F$SEARCH(STARTUP_SERVER)
$    STARTUP_SERVER = ""
$ ENDIF
$ IF STARTUP_PROCEDURE .EQS. ""
$ THEN
$!   (none was found, pre-v5.3 startup)
$    STARTUP_PROCEDURE = "HT_ROOT:[HTTP$SERVER]HTTPD_BATCH.C%M"
$ ENDIF
$ STARTUP_SERVER_LOOP:
$    IF STARTUP_PROCEDURE .EQS. "" THEN GOTO END_STARTUP_SERVER_LOOP
$    STARTUP_NAME = F$PARSE(STARTUP_PROCEDURE,,,"NAME")
$    IF VMS_VERSION .GE. 62
$    THEN
$       IF STARTUP_PROCEDURE .EQS. "[STARTUP]" THEN STARTUP_PROCEDURE = ""
$       HTTPD /DETACH 'SLASH_NETWORK' /USER='WASD_ACCOUNT' 'STARTUP_PROCEDURE'
$    ELSE
$       IF WASD_BATCH_LOG
$          THEN BATCHLOG = "/LOG=HT_SERVER_LOGS:" + STARTUP_NAME + ".LOG"
$          ELSE BATCHLOG = "/NOLOG"
$       ENDIF
$       SUBMIT 'STARTUP_PROCEDURE' /QUEUE='WASD_BATCH_QUEUE' -
               /PARAM=("''SLASH_NETWORK'") /USER='WASD_ACCOUNT' -
               'BATCHLOG' /NOPRINT
$    ENDIF
$    IF STARTUP_PROCEDURE .EQS. "" THEN GOTO END_STARTUP_SERVER_LOOP
$    STARTUP_PROCEDURE = F$SEARCH(STARTUP_SERVER)
$    GOTO STARTUP_SERVER_LOOP
$ END_STARTUP_SERVER_LOOP:
$!
$ SAY "%HTTPD-I-STARTUPROC, end"
$!
$!-----------------------------------------------------------------------------
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              