$!-----------------------------------------------------------------------------
$! STARTUP_SERVER.COM
$!
$! This procedure provides for the startup and execution of the HTTP server.
$! It is designed to support a single server process on a single node, single
$! server processes on separate nodes within a cluster, and multiple server
$! processes within a single node, and of course, a combination of the latter
$! two.  Modification is only necessary if any one server will be supporting
$! a service or services different to any other within a cluster or single
$! system.  If multiple nodes within a cluster provide the same service(s)
$! modification is not required.  For supporting multiple server processes on
$! the one system some modification is required.
$!
$! DO NOT MODIFY THIS PROCEDURE!
$! *****************************
$!
$! To create a site-specific server process startup file copy this to
$! STARTUP_SERVER_LOCAL.COM in the same directory.  Make modifications to that
$! version, not to the original.
$!
$! To create node/port-specific server process startup file copy this to
$! STARTUP_SERVER_node_port.COM or STARTUP_SERVER_node.COM depending if the
$! granularity is required down to port level or just node level.
$!
$! The STARTUP.COM procedure, when executing on any one node, searches for
$! these files, executing the appropriate one when creating and maintaining
$! the detached server process.
$!
$! Ensure the HTTP$SERVER account has R+E permission to any such procedures!
$! Also remember these procedures are executed in the HTTP$SERVER unprivileged
$! account context and so can only be used for job-level purposes, etc.
$!
$! Parameters to be passed to the HTTPD executable may be delivered two ways.
$! First, by "hard-wiring" them into each procedure's 'HTTPD_PARAMETERS'
$! symbol below.  Second, by creating a logical beginning "HTTPD$" and then
$! continued with the procedure's name, i.e. "HTTPD$STARTUP_SERVER_node_port".
$! If the parameters are not hard-wired this logical will be translated with
$! each server startup and the value used as the executable's command line.
$! A system-level logical is best defined in the STARTUP_LOCAL.COM procedure.
$! A job-level logical is best defined in STARTUP_SERVER_LOCAL.COM procedure.
$!
$! 19-JUL-2003  MGD  network mode server process
$! 15-OCT-2002  MGD  reset error count after HTTPd SUCCESS exit
$! 25-JUL-2001  MGD  'STATUS=$STATUS' suggested by didier.morandi@gmx.ch
$! 25-SEP-2000  MGD  allow for STARTUP_SERVER_LOCAL.COM
$! 01-NOV-1998  MGD  initial, v5.3
$!-----------------------------------------------------------------------------
$!
$!(define job-level logicals here)
$!! DEFINE /JOB whatever whereever
$!
$!(modify this symbol to modify server startup parameters)
$ HTTPD_PARAMETERS = ""
$!
$!-----------------------------------------------------------------------------
$!
$! SET VERIFY
$ SET NOON
$ SS$_DUPLNAM = 148
$ PROCEDURE = F$ENVIRONMENT("PROCEDURE")
$ PROCEDURE_NAME = F$PARSE(PROCEDURE,,,"NAME")
$ LOGFILE = PROCEDURE_NAME - "STARTUP_SERVER_" - "STARTUP_SERVER"
$ IF LOGFILE .EQS. "" THEN LOGFILE = F$EDIT(F$GETSYI("NODENAME"),"COLLAPSE")
$ LOGFILE = "HT_SERVER_LOGS:" + LOGFILE + ".LOG"
$ IF F$MODE() .EQS. "BATCH" THEN GOTO MODE_BATCH
$ IF F$MODE() .EQS. "OTHER" THEN GOTO MODE_OTHER_NETWORK
$ IF F$MODE() .EQS. "NETWORK"
$ THEN
$    PURGE /NOLOG /KEEP=3 SYS$LOGIN:STARTUP_SERVER.LOG
$    OPEN /WRITE /SHARE=WRITE SYS_NET SYS$NET
$    DEFINE SYS$OUTPUT SYS_NET
$    GOTO MODE_OTHER_NETWORK
$ ENDIF
$ EXIT
$!
$!-----------------------------------------------------------------------------
$ MODE_BATCH:
$!
$ PURGE /KEEP=3 'LOGFILE'
$ RUN SYS$SYSTEM:LOGINOUT /INPUT='PROCEDURE' /OUTPUT='LOGFILE' -
                          /DETACHED /AUTHORIZE
$ EXIT
$!
$!-----------------------------------------------------------------------------
$ MODE_OTHER_NETWORK:
$!
$ LOGICAL_NAME = "HTTPD$" + PROCEDURE_NAME
$ HTTPD = "$HTTPD$EXE"
$ ERROR_COUNT = 0
$!
$ HTTPD_LOOP:
$!
$    PARAMS = HTTPD_PARAMETERS
$    IF PARAMS .EQS. ""
$    THEN
$       LOGICAL_PARAMS = F$TRNLNM(LOGICAL_NAME)
$!      (ensure enough quotes for command-line substitution)
$       PARAMS = F$ELEMENT(0,"""",LOGICAL_PARAMS)
$       COUNT = 1
$       QUOTE_LOOP:
$          PART = F$ELEMENT(COUNT,"""",LOGICAL_PARAMS)
$          IF PART .EQS. """" THEN GOTO END_QUOTE_LOOP
$          PARAMS = PARAMS + """" + PART
$          COUNT = COUNT + 1
$          GOTO QUOTE_LOOP
$       END_QUOTE_LOOP:
$    ENDIF
$!
$    SET VERIFY
$ HTTPD /PRIORITY=4 'PARAMS'
$!   'F$VERIFY(0)
$!
$!   (non-error exit, must be a restart, loop immediately)
$    STATUS = $STATUS
$    IF STATUS
$    THEN
$       ERROR_COUNT = 0
$       GOTO HTTPD_LOOP
$    ENDIF
$    IF STATUS .EQ. SS$_DUPLNAM THEN EXIT
$!
$    ERROR_COUNT = ERROR_COUNT + 1
$    IF ERROR_COUNT .LT. 120
$       THEN WAIT 00:00:15
$       ELSE WAIT 00:15:00
$    ENDIF
$    GOTO HTTPD_LOOP
$!
$!END_HTTPD_LOOP:
$!
$ EXIT
$!-----------------------------------------------------------------------------

