$!-----------------------------------------------------------------------------
$! DEMO.COM
$!
$! WASD VMS Hypertext Services, Copyright (C) 1996-2004 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! For demonstration/checking of WASD HTTP server and environment.
$!
$! Standard version ........................... @HT_ROOT:[INSTALL]DEMO
$! With SSL support (if installed) ............ @HT_ROOT:[INSTALL]DEMO SSL
$!
$! P1 or P2 can be used to supply an /ACCEPT=<ip-address> qualifier.
$!
$! 02-JAN-2004  MGD  ensure SYSTEM group membership (file and script access)
$! 15-OCT-2002  MGD  updated for v8.1
$! 07-JUN-2002  MGD  /demo required for v8.0 functionality
$! 02-JUN-2001  MGD  add loop around spawn (for more realistic Admin Menu)
$! 30-NOV-1999  MGD  remove NETLIB support,
$!                   bugfix; HT_ROOT derived from concealed device
$! 27-JUN-1998  MGD  allow calling by INSTALL.COM and UPDATE.COM
$! 20-FEB-1998  MGD  add support for optional SSL
$! 23-JUL-1997  MGD  add NETLIB support
$! 01-JUN-1997  MGD  demo uses /promiscuous to provide "authentication"
$! 10-JAN-1996  MGD  initial development
$!-----------------------------------------------------------------------------
$!
$ set noon
$ verified = f$verify(0)
$ ss$_normal = 1
$ ss$_abort = 44
$ ss$_bugcheck = 676
$ say = "write sys$output"
$ vms_version = f$integer(f$extract(1,1,f$getsyi("version"))) * 10 +-
                f$integer(f$extract(3,1,f$getsyi("version")))
$ on controly then exit ss$_abort
$!
$ ssl_demo = 0
$ if p1 .eqs. "SSL" then ssl_demo = 1
$ if p2 .eqs. "SSL" then ssl_demo = 1
$ if f$search("HT_EXE:HTTPD.EXE") .eqs. "" .and. -
     f$search("HT_EXE:HTTPD_SSL.EXE") .nes. "" then ssl_demo = 1 
$!(this symbol is created by SSL_DETECT.COM)
$ if f$type(DEMO_SSL) .nes. ""
$ then
$    ssl_demo = 1
$    delete/symbol/global DEMO_SSL
$ endif
$!
$ accept = ""
$ if f$extract(0,8,f$edit(p1,"upcase")) .eqs. "/ACCEPT=" then accept = p1
$ if f$extract(0,8,f$edit(p2,"upcase")) .eqs. "/ACCEPT=" then accept = p2
$!
$ if f$environment("depth") .eq. 1 then say ""
$ type sys$input
                       *******************************
                       *  WASD PACKAGE DEMONSTRATOR  *
                       *******************************

$ if f$environment("depth") .eq. 1 .and. .not. ssl_demo
$ then
$    type sys$input
If you have the SSL package then just add "SSL" as parameter 1!

$ endif
$ type sys$input
When finished using demonstrator abort server execution using control-Y
(a subprocess will be spawned to preserve current process environment)

$ if ssl_demo
$ then
$    type sys$input
Use a browser to access either of the "%HTTPD-I-SERVICE"s when the server
starts.  (There will be one for a standard service and another for SSL.)
$ else
$    type sys$input
Use a browser to access the "%HTTPD-I-SERVICE" shown when the server starts.
$ endif
$ type sys$input

The server will be running in promiscuous mode!
Any username with the password specified below can be used for authentication.
Enter a string to use as a password when later prompted by your browser.

$!
$ read sys$command prompass /prompt="Password (for demo authentication)? []: "
$ say ""
$ if prompass .eqs. "" then exit ss$_normal
$!
$ on error then goto exit_demo
$ on controly then goto exit_demo
$!
$ archName = f$edit(f$getsyi("ARCH_NAME"),"UPCASE")
$ if archName .eqs. "ALPHA" then archName = "AXP"
$!
$ definedHtRoot = 0
$ if f$trnlnm("HT_ROOT","LNM$JOB") .eqs. ""
$ then
$!   (define local logicals, in line with INSTALL.COM and UPDATE.COM)
$    definedHtRoot = 1
$    procCom = f$environment("PROCEDURE")
$    procDev = f$parse(procCom,,,"DEVICE","NO_CONCEAL")
$    procDir = f$parse(procCom,,,"DIRECTORY","NO_CONCEAL")
$    htRoot = procDev+f$extract(0,f$locate("HT_ROOT",procDir)+7,procDir)+".]"
$    define /job /nolog /translation=concealed HT_ROOT 'htRoot'
$    htExe = "HT_ROOT:[''archName']"
$    define /job /nolog HT_EXE 'htExe'
$ else
$    htRoot = f$trnlnm("HT_ROOT","LNM$JOB")
$ endif
$!
$!(demo uses script files from the build areas, not production areas)
$ exeRoot = htRoot - ".]" + ".''archName'.]"
$ scriptRoot = htRoot - ".]" + ".SCRIPT.]"
$ define /job /translation=concealed CGI-BIN 'exeRoot','scriptRoot'
$!
$!(demo uses configuration files direct from the examples directory)
$ define /job HTTPD$AUTH HT_ROOT:[EXAMPLE]HTTPD$AUTH.CONF
$ define /job HTTPD$CONFIG HT_ROOT:[EXAMPLE]HTTPD$CONFIG.CONF
$ define /job HTTPD$MAP HT_ROOT:[EXAMPLE]HTTPD$MAP_DEMO.CONF
$ define /job HTTPD$MSG HT_ROOT:[EXAMPLE]HTTPD$MSG.CONF
$ define /job HT_AUTH HT_ROOT:[EXAMPLE]
$ define /job HT_SCRATCH HT_ROOT:[SCRATCH]
$ define /job WASD_ENABLE_SHOW 1
$!
$!(if necessary base ourselves in London just for want of anywhere better!)
$ if vms_version .lt. 70 then define /job HTTPD$GMT "+00:00"
$!
$ httpd = "$HT_EXE:HTTPD"
$ if ssl_demo
$ then
$    httpd = httpd + "_SSL"
$    httpService = "http:7080,https:7443"
$ else
$    httpService = "7080"
$ endif
$!(the ";0" ensures the latest version, not any prior INSTALLed version)
$ httpd = httpd + ".EXE;0"
$!
$ curpriv = f$getjpi(0,"CURPRIV")
$ set process /privilege=(SETPRV,SYSPRV)
$!
$!(ensure this process appears to be a member of the SYSTEM group)
$ if f$getjpi(0,"GRP") .ne. 1
$ then
$    uic = f$user()
$    set process /privilege=CMKRNL
$    set uic [1,4]
$ endif
$!
$ restartLoop:
$    spawn /wait httpd /demo /promiscuous='prompass' /service='httpService' 'accept'
$    if $STATUS then goto restartLoop
$!
$ exit_demo:
$!
$ if f$type(uic) .nes. "" then set uic 'uic'
$ if f$type(curpriv) .nes. "" then set proc /privilege=(NOALL,'curpriv')
$!
$ if definedHtRoot
$ then
$    deassign /job HT_ROOT
$    deassign /job HT_EXE
$ endif
$ deassign /job HTTPD$AUTH
$ deassign /job HTTPD$CONFIG
$ deassign /job HTTPD$MAP
$ deassign /job HTTPD$MSG
$ deassign /job HT_AUTH
$ deassign /job HT_SCRATCH
$ deassign /job WASD_ENABLE_SHOW
$ deassign /job CGI-BIN
$ if f$trnlnm("HTTPD$GMT","LNM$JOB") .nes. "" then deassign /job HTTPD$GMT
$!
$ say ""
$ if .not. verified then set noverify
$ exit ss$_normal
$!
$!-----------------------------------------------------------------------------
