$!-----------------------------------------------------------------'f$verify(0)
$! SSL_DETECT.COM
$!
$! WASD VMS Hypertext Services, Copyright (C) 1996-2004 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! Checks for and determines which OpenSSL toolkit will be built against.
$!
$!    none (non-SSL build)
$!    Richard Levitte's OpenSSL toolkit
$!    VMS SSL toolkit product (Compaq/HP)
$!    WASD OpenSSL package
$!
$! If an SSL toolkit and build is selected then one of these global symbols
$! is used to convey this to other procedures including [SRC]BUILD_ALL.COM
$!
$! DEMO_SSL ................ used by DEMO.COM to initiate an SSL demo
$! BUILD_HTTPD_SSL ......... build using an SSL toolkit
$! BUILD_HTTPD_OPEN_SSL .... build using the OpenSSL toolkit
$! BUILD_HTTPD_VMS_SSL ..... build using the VMS SSL product
$! BUILD_HTTPD_WASD_SSL .... build using the WASD SSL package
$! BUILD_HTTPD_SSL_ROOT .... provides SSL_FINISH.COM with the WASD SSL root
$!
$! 07-DEC-2002  MGD  initial (completely reworked for v8.1)
$!-----------------------------------------------------------------------------
$!
$ if f$trnlnm("INSTALL$DBUG") .nes. "" then set verify
$!
$ ss$_abort = 44
$ ss$_bugcheck = 676
$ say = "write sys$command"
$ on controly then exit ss$_abort
$ if f$environment("depth") .le. 1 then say ""
$!
$ dgs = "delete/symbol/global"
$ if f$type(DEMO_SSL) .nes. "" then dgs DEMO_SSL
$ if f$type(BUILD_HTTPD_OPEN_SSL) .nes. "" then dgs BUILD_HTTPD_OPEN_SSL
$ if f$type(BUILD_HTTPD_SSL) .nes. "" then dgs BUILD_HTTPD_SSL
$ if f$type(BUILD_HTTPD_SSL_ROOT) .nes. "" then dgs BUILD_HTTPD_SSL_ROOT
$ if f$type(BUILD_HTTPD_VMS_SSL) .nes. "" then dgs BUILD_HTTPD_VMS_SSL
$ if f$type(BUILD_HTTPD_WASD_SSL) .nes. "" then dgs BUILD_HTTPD_WASD_SSL
$!
$!(Richard Levitte's OpenSSL package - logical from OPENSSL_STARTUP.COM)
$ openSSLdir = f$trnlnm("SSLROOT")
$!
$!(SSL toolkit for OpenVMS - from the logical or look for it's directory)
$ vmsSSLroot = f$trnlnm("SSL$ROOT")
$ if vmsSSLroot
$    then vmsSSLdir = f$search("SSL$ROOT:[000000]*.DIR");
$    else vmsSSLdir = f$search("SYS$COMMON:[000000]SSL.DIR")
$ endif
$!
$!(WASD's OpenSSL package)
$ wasdSSLdir = ""
$!(search for latest version in default WASD location)
$ wasdSSLdirLoop:
$    tmpDir = f$search("HT_ROOT:[SRC]OPENSSL-*_*_*.DIR")
$    if tmpDir .eqs. "" then goto end_wasdSSLdirLoop
$    sslDirPos = f$locate("]OPENSSL",tmpDir)
$    wasdSSLdir = f$extract(0,sslDirPos,tmpDir) + "." + -
                  f$extract(sslDirPos+1,999,tmpDir) - ".DIR;1" + "]"
$    goto wasdSSLdirLoop
$ end_wasdSSLdirLoop:
$!
$ if openSSLdir .eqs. "" .and. vmsSSLdir .eqs. "" .and. wasdSSLdir .eqs. ""
$ then
$    type sys$input
                   **************************************
                   *  NO SSL TOOLKIT COULD BE LOCATED!  *
                   **************************************

None of the following SSL toolkits could be located.

  o  OpenSSL toolkit
  o  VMS SSL product (Compaq/HP)
  o  WASD OpenSSL package

$    if p1 .eqs. "SSL"
$    then
$       type sys$input
As an "SSL" build was specifically requested this cannot continue.

$       exit ss$_abort
$    else
$       type sys$input
A non-SSL version of the server will be built.

$       read sys$command response /prompt="Press RETURN to continue: "
$       say ""
$       exit
$    endif
$ endif
$!
$ if p1 .eqs. "SSL"
$ then
$!   (an SSL build as specifically requested, if there's only one toolkit)
$!
$    if openSSLdir .nes. "" .and. vmsSSLdir .nes. "" .and. wasdSSLdir .eqs. ""
$    then
$!      (only the OpenSSL toolkit was found)
$       say "The OpenSSL toolkit will be used."
$       say ""
$       BUILD_HTTPD_OPEN_SSL == 1
$       DEMO_SSL == 1
$       exit
$    endif
$!
$    if openSSLdir .eqs. "" .and. vmsSSLdir .nes. "" .and. wasdSSLdir .eqs. ""
$    then
$!      (only the VMS SSL product was found)
$       say "The VMS SSL product will be used."
$       say ""
$       BUILD_HTTPD_VMS_SSL == 1
$       DEMO_SSL == 1
$       exit
$    endif
$!
$    if openSSLdir .eqs. "" .and. vmsSSLdir .eqs. "" .and. wasdSSLdir .nes. ""
$    then
$!      (only the WASD OpenSSL package was found)
$       say "The WASD OpenSSL package will be used."
$       say ""
$       BUILD_HTTPD_WASD_SSL == 1
$       DEMO_SSL == 1
$!      (this symbol will be used by SSL_FINISH.COM to build the OpenSSL apps)
$       BUILD_HTTPD_SSL_ROOT == wasdSSLdir
$       exit
$    endif
$!
$    type sys$input
                    ************************************
                    *  MULTIPLE SSL TOOLKITS DETECTED  *
                    ************************************

Multiple supported Secure Sockets Layer (SSL) toolkits have been detected.
$!
$ else
$!
$    type sys$input
                         **************************
                         *  SSL TOOLKIT DETECTED  *
                         **************************

A supported Secure Sockets Layer (SSL) toolkit has been detected.
$!
$ endif
$!
$ type sys$input
Those with item numbers are available for building, 'x's are not available.

  0. do not build an SSL version
$ count = 0
$ defaultResponse = 1
$!
$ if openSSLdir .nes. ""
$ then
$    count = count + 1
$    toolkit'count' = openSSLdir
$    say "  ''count'. OpenSSL toolkit"
$ else
$    say "  x. OpenSSL toolkit"
$ endif
$!
$ if vmsSSLdir .nes. ""
$ then
$    count = count + 1
$    toolkit'count' = vmsSSLdir
$    defaultResponse = count
$    say "  ''count'. OpenVMS SSL product (Compaq/HP)"
$ else
$    say "  x. OpenVMS SSL product (Compaq/HP)"
$ endif
$!
$ if wasdSSLdir .nes. ""
$ then
$    count = count + 1
$    toolkit'count' = wasdSSLdir
$    say "  ''count'. WASD OpenSSL package"
$ else
$    say "  x. WASD OpenSSL package"
$ endif
$!
$ toolkitLoop:
$    response = ""
$    say ""
$    read sys$command response /prompt="Select item number [''defaultResponse']: "
$    say ""
$    if response .eqs. "" then response = defaultResponse
$    number = f$integer(response)
$    if number .lt. 0 .or. number .gt. count
$    then
$       say "RESPONSE ERROR! (enter a single digit 0 to ''count')"
$       goto toolkitLoop
$    endif
$ toolkitLoopEnd:
$!
$ if number .eq. 0
$ then
$    say "A non-SSL version of the server will be built."
$    say ""
$    exit
$ endif
$!
$ if toolkit'number' .eqs. openSSLdir
$ then
$    say "The OpenSSL toolkit has been selected."
$    say ""
$    BUILD_HTTPD_SSL == 1
$    BUILD_HTTPD_OPEN_SSL == 1
$    DEMO_SSL == 1
$    exit
$ endif
$!
$ if toolkit'number' .eqs. vmsSSLdir
$ then
$    type sys$input
The VMS SSL product has been selected.
$    product show product ssl
$    type sys$input

NOTE:  As WASD installs it's server image with required privileges the OpenVMS
SSL shareable images also be installed (but without extended privileges).
Using this product requires the v8.1 startup procedures.

$    read sys$command response /prompt="Press RETURN to continue: "
$    say ""
$    BUILD_HTTPD_SSL == 1
$    BUILD_HTTPD_VMS_SSL == 1
$    DEMO_SSL == 1
$    exit
$ endif
$!
$ if toolkit'number' .eqs. wasdSSLdir
$ then
$    say "The WASD OpenSSL package has been selected."
$    say ""
$    BUILD_HTTPD_SSL == 1
$    BUILD_HTTPD_WASD_SSL == 1
$    DEMO_SSL == 1
$!   (this symbol will be used by SSL_FINISH.COM to build the OpenSSL apps)
$    BUILD_HTTPD_SSL_ROOT == wasdSSLdir
$    exit
$ endif
$!
$ exit ss$_bugcheck
$!-----------------------------------------------------------------------------
