# CGIplusPM_example1.pl
#
# Simple example that just prints the CGI variables, then demonstrates how
# to retrive variable values using the CGIplus module 'var' subroutine.
# May be invoked using either /cgi-bin/cpipluspm_example1 for standard CGI
# environment or using /CGIplus-bin/cpipluspm_example1 for CGIplus environment.
#
# COPYRIGHT
# ---------
# Copyright (c) 2000 Mark G.Daniel
# This program, comes with ABSOLUTELY NO WARRANTY.
# This is free software, and you are welcome to redistribute it
# under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
# 
# VERSION HISTORY
# ----------------
# 31-MAY-2000  MGD  initial
#------------------------------------------------------------------------------

require "HT_ROOT:[SRC.PERL]CGIplus.PM";

# pass the reference of the example function to the CGIplus processor
CGIplus::process(\&exampleScript);

#------------------------------------------------------------------------------
# all the work is done in this function

sub exampleScript
{
   printf ("Content-Type: text/plain
Expires: Fri, 13 Jan 1978 14:00:00 GMT

");

   if (CGIplus::isCGIplus())
   {
      if (CGIplus::var("QUERY_STRING") eq "eoj")
      {
         printf ("Bye! (after %d requests)\n", CGIplus::usageCount());
         exit;
      }
   }

   CGIplus::varPrint();

   printf ("\nWWW_PATH_INFO |%s|\n", CGIplus::var("WWW_PATH_INFO"));
   printf ("WWW_QUERY_STRING |%s|\n\n", CGIplus::var("WWW_QUERY_STRING"));

   if (CGIplus::var("WWW_SERVER_SOFT") eq undef) {
      printf ("WWW_SERVER_SOFT does not exist and looks like an empty string ...\n");
   }
   printf ("WWW_SERVER_SOFT |%s|\n\n", CGIplus::var("WWW_SERVER_SOFT"));

   if (CGIplus::var("WWW_SERVER_SOFTWARE") ne undef) {
      printf ("WWW_SERVER_SOFTWARE should exist ...\n");
   }
   printf ("WWW_SERVER_SOFTWARE |%s|\n", CGIplus::var("WWW_SERVER_SOFTWARE"));
}

#------------------------------------------------------------------------------

