# CGIplusPM_example2.pl
#
# Simple example that demonstrates the low level requirements for handling
# binary output.  Also see CGIplusPM_example3.pl which does virtually the
# same job using a CGIplus module subroutine.
# May be invoked using either /cgi-bin/cpipluspm_example2 for standard CGI
# environment or using /CGIplus-bin/cpipluspm_example2 for CGIplus environment.
#
# COPYRIGHT
# ---------
# Copyright (c) 2000 Mark G.Daniel
# This program, comes with ABSOLUTELY NO WARRANTY.
# This is free software, and you are welcome to redistribute it
# under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
# 
# VERSION HISTORY
# ----------------
# 31-MAY-2000  MGD  initial
#------------------------------------------------------------------------------

require "HT_ROOT:[SRC.PERL]CGIplus.PM";

require VMS::Stdio or die "failed to require VMS::Stdio\n";
use VMS::Stdio qw( :CONSTANTS :FUNCTIONS );

# pass the reference of the example function to the CGIplus processor
CGIplus::process(\&exampleScript);

#------------------------------------------------------------------------------
# all the work is done in this function

sub exampleScript
{
   if (CGIplus::isCGIplus())
   {
      if (CGIplus::var("QUERY_STRING") eq "eoj")
      {
         printf ("Content-Type: text/plain
Expires: Fri, 13 Jan 1978 14:00:00 GMT

Bye! (after %d requests)
", CGIplus::usageCount());
         exit;
      }
   }

   $imageName = "HT_ROOT:[000000]WASDHTTPD.GIF";

   $INFILE = vmssysopen ($imageName, O_RDONLY, 0, "ctx=bin")
      or die ("Could not open \"$imageName\"");

   CGIplus::beginStream ();
   CGIplus::writeStream ("Content-Type: image/gif\n\n", -1);
   while ($bytesRead = sysread ($INFILE, $bytes, 4096)) {
      CGIplus::writeStream ($bytes, $bytesRead);
   }
   CGIplus::endStream ();

   close($INFILE);
}

#------------------------------------------------------------------------------

