$! AUTHAGENT_EXAMPLE_PROC.COM
$!
$! This non-C-language example demonstrates a minimal implementation of
$! authentication agent processing.
$!
$! It also illustrates that a simple wrapper such as this might be used
$! to access some command-line authentication mechanism, and the results
$! used to establish whether the request should be authenticated or not.
$!
$! Example of the HTTPD$AUTH rule required to experiment with this:
$!
$!  ["Authentication Agent Procedure"=AUTHAGENT_EXAMPLE_PROC=agent"]
$!  /some/path/or/other/*
$!
$! 06-SEP-1999  MGD  initial
$!
$ open /read CgiPlusIn CGIPLUSIN
$!
$ RequestLoop:
$!
$!   (block waiting for request, this initial read is always discardable)
$    read CgiPlusIn /end=EndRequestLoop Line
$!
$!   (initialize, read and save required variables from CGIplus stream)
$    WwwAuthAgent = ""
$    WwwAuthPassword = ""
$    WwwAuthRealm = ""
$    WwwRemoteUser = ""
$!
$    CgiVarLoop:
$       read CgiPlusIn /end=EndCgiVarLoop Line
$!      (empty line indicates end of request's variables)
$       if Line .eqs. "" then goto EndCgiVarLoop
$       if f$extract(0,15,Line) .eqs. "WWW_AUTH_AGENT="
$       then
$          WwwAuthAgent = f$extract(15,999,Line)
$          goto CgiVarLoop
$       endif
$       if f$extract(0,18,Line) .eqs. "WWW_AUTH_PASSWORD="
$       then
$          WwwAuthPassword = f$edit(f$extract(18,999,Line),"upcase")
$          goto CgiVarLoop
$       endif
$       if f$extract(0,15,Line) .eqs. "WWW_AUTH_REALM="
$       then
$          WwwAuthRealm = f$extract(15,999,Line)
$          goto CgiVarLoop
$       endif
$       if f$extract(0,16,Line) .eqs. "WWW_REMOTE_USER="
$       then
$          WwwRemoteUser = f$edit(f$extract(16,999,Line),"upcase")
$          goto CgiVarLoop
$       endif
$       goto CgiVarLoop
$    EndCgiVarLoop:
$!
$!   (the actual agent callout)
$    say f$trnlnm("CGIPLUSESC")
$!
$!   (ensure we've got everything we need)
$    if WwwAuthAgent .eqs. "" .or. WwwAuthPassword .eqs "" .or. -
        WwwAuthRealm .eqs. "" .or. WwwRemoteUser .eqs. ""
$    then
$       say "500 implementation error"
$    else
$!      (check the authentication information against our "database" ;^)
$       if WwwRemoteUser .eqs. "MARK" .and. WwwAuthPassword .eqs. "DANIEL"
$       then
$          say "200 READ+WRITE"
$       else
$          say "401 username/password problem"
$       endif
$    endif
$!
$!   (and of agent callout)
$    say f$trnlnm("CGIPLUSEOT")
$!
$!   (and of agent processing)
$    say f$trnlnm("CGIPLUSEOF")
$    goto RequestLoop
$!
$ EndRequestLoop:
