$!-----------------------------------------------------------------------------
$! BUILD_ALL.COM
$!
$! BRUTE-FORCE build procedure for all WASD VMS HTTPd package applications
$!
$! WASD VMS Hypertext Services, Copyright (C) 1996-2002 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it under
$! the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! P1 == "BUILD" to compile and link all applications
$! P1 == "LINK" to only re-link all applications
$! P2 == "SSL" to build/link SSL-version HTTPd executable
$! P3 == "DIST" to build a full distribution (not for general usage)
$!
$! 04-NOV-2002  MGD  check for C compiler,
$!                   add RANDSEED and SECHAN, make STREAMLF a procedure
$! 28-JUN-2002  MGD  add WB and CALOGS,
$!                   remove WWWRKOUT and PERLRTE
$! 03-NOV-2001  MGD  PERSONA_MACRO
$! 20-MAY-2001  MGD  add MD5DIGEST build,
$!                   remove SCRUNCH,DBIV,HWP builds
$! 26-JAN-2001  MGD  "+SSL" for distribution builds
$! 28-OCT-2000  MGD  modified for CGILIB.OLB
$! 27-MAY-2000  MGD  add AB utility
$! 30-NOV-1999  MGD  remove NETLIB/UCX build parameter,
$!                   add SCRUNCH build
$!                   bugfix; HT_ROOT derived from concealed device
$! 03-OCT-1998  MGD  related EXTRACT in with QUERY
$! 27-JUN-1998  MGD  modified for v5.1
$! ??-???-????  MGD  long unrecorded pre-history :^)
$!-----------------------------------------------------------------------------
$!
$ set noverify
$ ss$_abort = 44
$ bell[0,8] = 7
$ copy = "copy/log"
$ delete = "delete/noconfirm/log"
$ say = "write sys$output"
$ archName = f$edit(f$getsyi("ARCH_NAME"),"UPCASE")
$ if archName .eqs. "ALPHA" then archName = "AXP"
$ vms_version = f$integer(f$extract(1,1,f$getsyi("version"))) * 10 +-
                f$integer(f$extract(3,1,f$getsyi("version")))
$ if vms_version .ge. 72 then set process /parse=traditional
$ set noon
$ set control=Y
$ on controly then exit ss$_abort
$!
$ if P1 .eqs. "DIST"
$ then
$    P1 = "BUILD"
$    P2 = ""
$    P3 = "DIST"
$ endif
$ if P1 .nes. "BUILD" .and. P1 .nes. "COMPILE" .and. P1 .nes. "LINK"
$ then
$    say "Usage: @BUILD_ALL LINK|BUILD [SSL]"
$    exit
$ endif
$ if P2 .nes. "" .and. P2 .nes. "SSL"
$ then
$    say "Usage: @BUILD_ALL LINK|BUILD [SSL]"
$    exit
$ endif
$!
$!(look for local HT_ROOT environment used when building)
$ if f$trnlnm("HT_ROOT","LNM$JOB") .eqs. ""
$ then
$!   (subprocess to do the actual work, define local logicals)
$    procCom = f$environment("PROCEDURE")
$    procDev = f$parse(procCom,,,"DEVICE","NO_CONCEAL")
$    procDir = f$parse(procCom,,,"DIRECTORY","NO_CONCEAL")
$    htRoot = procDev+f$extract(0,f$locate("HT_ROOT",procDir)+7,procDir)+".]"
$    define /job /nolog /translation=concealed HT_ROOT 'htRoot'
$    htExe = "HT_ROOT:[''archName']"
$    define /job /nolog HT_EXE 'htExe'
$!   (spawn a subprocess to do the actual build ensures job logical deletion)
$    spawn /wait @'procCom' "''p1'" "''p2'" "''p3'"
$    say ""
$    deassign /job HT_ROOT
$    deassign /job HT_EXE
$    exit
$ endif
$!
$ if P1 .nes. "LINK"
$ then
$!   (make sure we have a C compiler and that it's probably DECC)
$    if archName .eqs. "AXP"
$       then cc /version
$       else cc /decc /version
$    endif
$    status = $status .and. %x0fffffff
$    set on
$    if .not. status then exit status
$    if f$search("sys$system:decc$*.exe") .eqs. ""
$    then
$       say "Can't seem to locate SYS$SYSTEM:DECC$*.EXE"
$       exit %x00038090
$    endif
$ endif
$!
$ on error then goto finished
$ currentDefault = f$environment("DEFAULT")
$ set default HT_ROOT:[SRC]
$!
$!-----------------------------------------------------------------------------
$!
$ say ""
$ say "--- HTTPD ---"
$ say ""
$ set default [.HTTPD]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_HTTPD "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$!(library must be built before other applications using it can!)
$ say ""
$ say "--- CGILIB ---"
$ set default [.MISC]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']CGILIB.OBJ;*
$ @BUILD_CGILIB "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- AGENTs ---"
$ set default [.AGENT]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_ALL "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- CGIPLUS ---"
$ set default [.CGIPLUS]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_CGIPLUS "''P1'" "''P2'"
$ @BUILD_CGISAPI "''P1'" "''P2'"
$ @BUILD_ISAPIEXAMPLE "''P1'" "''P2'"
$ @BUILD_RTE_EXAMPLE "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- CONAN ---"
$ set default [.CONAN]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_CONAN "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- GIFT ---"
$ set default [.GIFT]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_GIFT "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- HYPERREADER & HYPERSHELF ---"
$ set default [.HYPERREADER]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_HYPERREADER "''P1'" "''P2'"
$ @BUILD_HYPERSHELF "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- HYPERSPI ---"
$ set default [.HYPERSPI]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_HYPERSPI$AGENT "''P1'" "''P2'"
$ @BUILD_HYPERSPI "''P1'" "''P2'"
$!'F$VERIFY(0)
$ set default [-]
$!
$ say ""
$ say "--- MISC(ellaneous) ---"
$ set default [.MISC]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_MISC "''P1'" "''P2'"
$ @BUILD_CGILIB "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- OSU ---"
$ set default [.OSU]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_OSU "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- QUERY ---"
$ set default [.QUERY]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_QUERY "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- SDM2HTM ---"
$ set default [.SDM2HTM]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_SDM2HTM "''P1'" "''P2'"
$ set default [-]
$!
$ say ""
$ say "--- UTILITIES ---"
$ set default [.UTILS]
$ if P3 .eqs. "DIST" then delete [.OBJ_'archName']*.OBJ;*
$ @BUILD_AB "''P1'" "''P2'"
$ @BUILD_CALOGS "''P1'" "''P2'"
$ @BUILD_HTADMIN "''P1'" "''P2'"
$ @BUILD_HTTPDMON "''P1'" "''P2'"
$ @BUILD_MD5DIGEST "''P1'" "''P2'"
$ @BUILD_PCACHE "''P1'" "''P2'"
$ @BUILD_QDLOGSTATS "''P1'" "''P2'"
$ @BUILD_RANDSEED "''P1'" "''P2'"
$ @BUILD_SECHAN "''P1'" "''P2'"
$ COPY STREAMLF.COM HT_EXE:
$ @BUILD_WB "''P1'" "''P2'" 
$ set default [-]
$!
$ finished:  !'f$verify(0)
$ say ""
$ set default 'currentDefault'
$!
$!-----------------------------------------------------------------------------
