/*****************************************************************************/
/*
                              CGIplusSkel.c

A skeletal program serving as a template for CGI/CGIplus-capable scripts.

Uses a sophisticated single function for accessing CGI variables. The function
differentiates between standard and CGIplus environments and changes behaviour
accordingly.  The function also serves to block waiting for subsequent CGIplus
requests.


VERSION HISTORY
---------------
24-APR-1999  MGD  v1.2.0, use CGILIB.C
21-JUN-1998  MGD  v1.1.0, revision of CgiVar()
08-JUN-1997  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

int  IsCgiPlus = 0;
char  *CgiPlusEofPtr = NULL;

/*****************************************************************************/
/*
Include the CGILIB.H/.C function code from the standard WASD location if
CGILIB_INCLUDE_H/_C has not been defined.  If it has been defined then the
value must be the #include location.
*/

/* indicate required functionality */
#define CGILIB_CGIVAR_SUPPORT  1
#define CGILIB_CGIPLUS_SUPPORT 1

#include "/ht_root/src/misc/cgilib.h"
#include "/ht_root/src/misc/cgilib.c"

/*****************************************************************************/
/*
*/

main ()

{
   int  Count = 0;
   char  *RemoteHostPtr;

   IsCgiPlus = ((CgiPlusEofPtr = getenv("CGIPLUSEOF")) != NULL);

   do {

      /* with CGIplus this call will block waiting for the next request */
      CgiLibVar ("");

      RemoteHostPtr = CgiLibVar ("WWW_REMOTE_HOST");

      fprintf (stdout,
"Content-Type: text/html\n\
Expires: Thu, 01 Jan 1970 00:00:01 GMT\n\
\n\
%d. <B>Hello world</B> ... well the \
<FONT SIZE=+1>&nbsp;<TT>%s</TT>&nbsp;</FONT> part of it anyway!\n",
               ++Count, RemoteHostPtr);

      /* record-oriented <stdout>, no need to flush, write end-of-output line */
      if (IsCgiPlus) fprintf (stdout, "%s\n", CgiPlusEofPtr);

   } while (IsCgiPlus);

   exit (1);
}

/*****************************************************************************/

