/*****************************************************************************/
/*
                                 CGISAPI.H


20-NOV-1999  MGD  add HSE_REQ_DLL_WRITE_BUFFER_SIZE
14-MAR-1999  MGD  initial
*/
/*****************************************************************************/

/* definitions that normally come from <windows.h> */

#define CONST   const
#define CHAR    char
#define BYTE    char
#define WORD    short
#define BOOL    unsigned int
#define DWORD   unsigned long int
#define LPDWORD DWORD*
#define LPBYTE  BYTE*
#define WINAPI
typedef void*   LPVOID;
typedef char*   LPSTR;

/* ISAPI header information */

#define   HSE_VERSION_MAJOR           1      /* major version */
#define   HSE_VERSION_MINOR           0      /* minor version */
#define   HSE_LOG_BUFFER_LEN         80
#define   HSE_MAX_EXT_DLL_NAME_LEN  256

typedef   LPVOID  HCONN;

/* status codes returned by the Extension DLL */

#define   HSE_STATUS_SUCCESS                  1
#define   HSE_STATUS_SUCCESS_AND_KEEP_CONN    2
#define   HSE_STATUS_PENDING                  3
#define   HSE_STATUS_ERROR                    4

/*
   values to request services with the ServerSupportFunction()
   (0 to 1000 are reserved for future versions of the interface)
*/

#define   HSE_REQ_BASE                        0
#define   HSE_REQ_SEND_URL_REDIRECT_RESP      (HSE_REQ_BASE+1)
#define   HSE_REQ_SEND_URL                    (HSE_REQ_BASE+2)
#define   HSE_REQ_SEND_RESPONSE_HEADER        (HSE_REQ_BASE+3)
#define   HSE_REQ_DONE_WITH_SESSION           (HSE_REQ_BASE+4)
#define   HSE_REQ_END_RESERVED                1000

/* WASD CGIsapi DLL debug extensions */
#define   HSE_REQ_DLL_DEBUG_ON                (HSE_REQ_END_RESERVED+1001)
#define   HSE_REQ_DLL_DEBUG_OFF               (HSE_REQ_END_RESERVED+1002)
#define   HSE_REQ_DLL_WRITE_BUFFER_SIZE       (HSE_REQ_END_RESERVED+1003)

/* structure for GetExtensionVersion() */

typedef struct _HSE_VERSION_INFO
{
   DWORD  dwExtensionVersion;
   CHAR   lpszExtensionDesc[HSE_MAX_EXT_DLL_NAME_LEN];
}
HSE_VERSION_INFO,
*LPHSE_VERSION_INFO;


/* structure for extension procedure on a new request */

typedef struct _EXTENSION_CONTROL_BLOCK
{
   DWORD     cbSize;                 /* size of this structure */
   DWORD     dwVersion;              /* ISAPI version */
   HCONN     ConnID;                 /* context ... not to be modified! */
   DWORD     dwHttpStatusCode;       /* HTTP status code */
   CHAR      lpszLogData [HSE_LOG_BUFFER_LEN];  /* null terminated log info */
   LPSTR     lpszMethod;             /* REQUEST_METHOD */
   LPSTR     lpszQueryString;        /* QUERY_STRING */
   LPSTR     lpszPathInfo;           /* PATH_INFO */
   LPSTR     lpszPathTranslated;     /* PATH_TRANSLATED */
   DWORD     cbTotalBytes;           /* CONTENT_LENGTH */
   DWORD     cbAvailable;            /* bytes available in 'lpbData' */
   LPBYTE    lpbData;                /* pointer to 'cbAvailable' bytes */
   LPSTR     lpszContentType;        /* CONTENT_TYPE */

   /* callback function */
   BOOL (WINAPI * GetServerVariable)(HCONN hConn,
                                     LPSTR lpszVariableName,
                                     LPVOID lpvBuffer,
                                     LPDWORD lpdwSize);

   /* callback function */
   BOOL (WINAPI* WriteClient)(HCONN ConnID,
                              LPVOID Buffer,
                              LPDWORD lpdwBytes,
                              DWORD dwReserved);

   /* callback function */
   BOOL (WINAPI* ReadClient)(HCONN ConnID,
                             LPVOID lpvBuffer,
                             LPDWORD lpdwSize);

   /* callback function */
   BOOL (WINAPI* ServerSupportFunction)(HCONN hConn,
                                        DWORD dwHSERRequest,
                                        LPVOID lpvBuffer,
                                        LPDWORD lpdwSize,
                                        LPDWORD lpdwDataType);

}
EXTENSION_CONTROL_BLOCK,
*LPEXTENSION_CONTROL_BLOCK;

/* prototypes for functions that must be exported from the extension DLL */

BOOL  WINAPI   GetExtensionVersion (HSE_VERSION_INFO *pVer);
DWORD WINAPI   HttpExtensionProc (EXTENSION_CONTROL_BLOCK *pECB);

/*****************************************************************************/
