/*****************************************************************************/
/*
                                 Admin.h
*/
/*****************************************************************************/
                     
#ifndef ADMIN_H_LOADED
#define ADMIN_H_LOADED 1

#include "wasd.h"
#include "auth.h"

/*********************/
/* admin menu macros */
/*********************/

#define HTTPD_ADMIN  "/httpd/-/admin/"
#define HTTPD_LOCAL  "/ht_root/local/"

#define ADMIN_CONTROL              HTTPD_ADMIN   "control/"
#define ADMIN_CONTROL_AUTH_LOAD    ADMIN_CONTROL "auth/load"
#define ADMIN_CONTROL_AUTH_PURGE   ADMIN_CONTROL "auth/purge"
#define ADMIN_CONTROL_CACHE_ON     ADMIN_CONTROL "cache/on"
#define ADMIN_CONTROL_CACHE_OFF    ADMIN_CONTROL "cache/off"
#define ADMIN_CONTROL_CACHE_PURGE  ADMIN_CONTROL "cache/purge"
#define ADMIN_CONTROL_DCL_PURGE    ADMIN_CONTROL "DCL/purge"
#define ADMIN_CONTROL_DCL_DELETE   ADMIN_CONTROL "DCL/delete"
#define ADMIN_CONTROL_DELETE_PROCESS   ADMIN_CONTROL "process/delete"
#define ADMIN_CONTROL_DECNET_DISCONNECT ADMIN_CONTROL "DECnet/disconnect"
#define ADMIN_CONTROL_DECNET_PURGE ADMIN_CONTROL "DECnet/purge"
#define ADMIN_CONTROL_EXIT         ADMIN_CONTROL "exit"
#define ADMIN_CONTROL_EXIT_NOW     ADMIN_CONTROL "exit/now"
#define ADMIN_CONTROL_INSTANCE     ADMIN_CONTROL "instance"
#define ADMIN_CONTROL_LOG_OPEN     ADMIN_CONTROL "log/open"
#define ADMIN_CONTROL_LOG_CLOSE    ADMIN_CONTROL "log/close"
#define ADMIN_CONTROL_LOG_FLUSH    ADMIN_CONTROL "log/flush"
#define ADMIN_CONTROL_MAP ADMIN_CONTROL "mapping/load"
#define ADMIN_CONTROL_PROXY_ON     ADMIN_CONTROL "proxy/on"
#define ADMIN_CONTROL_PROXY_OFF    ADMIN_CONTROL "proxy/off"
#define ADMIN_CONTROL_PROXY_ADJUST ADMIN_CONTROL "proxy/adjust"
#define ADMIN_CONTROL_PROXY_ADJUST_NOW     ADMIN_CONTROL "proxy/adjust/now"
#define ADMIN_CONTROL_PROXY_PURGE_BCKGRND  ADMIN_CONTROL "proxy/purge/background"
#define ADMIN_CONTROL_PROXY_PURGE_ROUTINE  ADMIN_CONTROL "proxy/purge/reactive"
#define ADMIN_CONTROL_PROXY_PURGE_REACTIVE ADMIN_CONTROL "proxy/purge/routine"
#define ADMIN_CONTROL_PROXY_PURGE_HOST     ADMIN_CONTROL "proxy/purge/host"
#define ADMIN_CONTROL_PROXY_STATISTICS     ADMIN_CONTROL "proxy/statistics"
#define ADMIN_CONTROL_PROXY_STOP_SCAN      ADMIN_CONTROL "proxy/stop/scan"
#define ADMIN_CONTROL_RESTART       ADMIN_CONTROL "restart"
#define ADMIN_CONTROL_RESTART_NOW   ADMIN_CONTROL "restart/now"
#define ADMIN_CONTROL_RESTART_QUIET ADMIN_CONTROL "restart/quiet"
#define ADMIN_CONTROL_SSL_CA_LOAD   ADMIN_CONTROL "SSL/CA"
#define ADMIN_CONTROL_THROTTLE_RELEASE ADMIN_CONTROL "throttle/release"
#define ADMIN_CONTROL_THROTTLE_TERMINATE  ADMIN_CONTROL "throttle/terminate"
#define ADMIN_CONTROL_THROTTLE_ZERO ADMIN_CONTROL "throttle/zero"
#define ADMIN_CONTROL_ZERO         ADMIN_CONTROL "admin/zero"

#define ADMIN_GRAPHIC           HTTPD_ADMIN   "graphic/"
#define ADMIN_GRAPHIC_ACTIVITY  ADMIN_GRAPHIC "activity"

#define ADMIN_REPORT            HTTPD_ADMIN  "report/"
#define ADMIN_REPORT_ACTIVITY   ADMIN_REPORT "activity"
#define ADMIN_REPORT_AUTH_USER  ADMIN_REPORT "auth/user"
#define ADMIN_REPORT_AUTH_PATHS ADMIN_REPORT "auth/paths"
#define ADMIN_REPORT_CACHE      ADMIN_REPORT "cache"
#define ADMIN_REPORT_CACHE_ENTRIES  ADMIN_REPORT "cache/entries"
#define ADMIN_REPORT_CONFIG     ADMIN_REPORT "config"
#define ADMIN_REPORT_DCL        ADMIN_REPORT "dcl"
#define ADMIN_REPORT_DECNET     ADMIN_REPORT "DECnet"
#define ADMIN_REPORT_HOSTCACHE  ADMIN_REPORT "hostcache"
#define ADMIN_REPORT_LOCK       ADMIN_REPORT "lock"
#define ADMIN_REPORT_MAPPING    ADMIN_REPORT "mapping"
#define ADMIN_REPORT_MATCH      ADMIN_REPORT "match"
#define ADMIN_REPORT_MEMORY     ADMIN_REPORT "memory"
#define ADMIN_REPORT_MESSAGES   ADMIN_REPORT "messages"
#define ADMIN_REPORT_PROCESS    ADMIN_REPORT "process"
#define ADMIN_REPORT_PROXY      ADMIN_REPORT "proxy"
#define ADMIN_REPORT_REQUEST    ADMIN_REPORT "request"
#define ADMIN_REPORT_REQUEST_HISTORY  ADMIN_REPORT "request/history"
#define ADMIN_REPORT_SERVICES        ADMIN_REPORT "services"
#define ADMIN_REPORT_SERVICE_LOG     ADMIN_REPORT "service/log"
#define ADMIN_REPORT_SHOW_PROCESS    ADMIN_REPORT "process/show"
#define ADMIN_REPORT_PROCESS_OUTPUT  ADMIN_REPORT "process/output"
#define ADMIN_REPORT_PROCESS_INPUT   ADMIN_REPORT "process/input"
#define ADMIN_REPORT_SSL        ADMIN_REPORT "SSL"
#define ADMIN_REPORT_SSL_CA     ADMIN_REPORT "SSL/CA"
#define ADMIN_REPORT_SSL_CLIENT    ADMIN_REPORT "SSL/client"
#define ADMIN_REPORT_STATS      ADMIN_REPORT "stats"
#define ADMIN_REPORT_SUPERVISOR    ADMIN_REPORT "supervisor"
#define ADMIN_REPORT_SYSTEM     ADMIN_REPORT "system"
#define ADMIN_REPORT_THROTTLE   ADMIN_REPORT "throttle"
#define ADMIN_REPORT_WATCH      ADMIN_REPORT "WATCH"
#define ADMIN_REPORT_WATCH_STRUCT  ADMIN_REPORT "WATCH/struct"

#define ADMIN_REVISE            HTTPD_ADMIN  "revise/"
#define ADMIN_REVISE_AUTH_PATHS ADMIN_REVISE "auth/paths"
#define ADMIN_REVISE_CONFIG     ADMIN_REVISE "config"
#define ADMIN_REVISE_HTA        ADMIN_REVISE "hta/"
#define ADMIN_REVISE_HTL        ADMIN_REVISE "htl/"
#define ADMIN_REVISE_MESSAGES   ADMIN_REVISE "messages"
#define ADMIN_REVISE_MAPPING    ADMIN_REVISE "rules"
#define ADMIN_REVISE_SITELOG    ADMIN_REVISE "sitelog"
#define ADMIN_REVISE_SITELOG_ENTRY  ADMIN_REVISE "sitelog/entry"
#define ADMIN_REVISE_SERVICES   ADMIN_REVISE "services"
#define ADMIN_REVISE_SSL_CA     ADMIN_REVISE "SSL/CA"

/************************/
/* virtual server admin */
/************************/

#define HTTPD_VS_ADMIN         "/httpd/-/virtual/"

#define ADMIN_VS_REVISE        HTTPD_VS_ADMIN  "revise/"

#define ADMIN_VS_REVISE_HTA    ADMIN_VS_REVISE "hta/"
#define ADMIN_VS_REVISE_HTL    ADMIN_VS_REVISE "htl/"

#define ADMIN_VS_CONTROL              HTTPD_VS_ADMIN   "control/"
#define ADMIN_VS_CONTROL_AUTH_PURGE   ADMIN_VS_CONTROL "auth/purge"

/***********************/
/* function prototypes */
/***********************/

AdminBegin (REQUEST_STRUCT*, REQUEST_AST);
AdminControl (REQUEST_STRUCT*, REQUEST_AST, BOOL);
AdminDeleteProcess (REQUEST_STRUCT*, REQUEST_AST);
AdminMenu (REQUEST_STRUCT*, REQUEST_AST);
int AdminMenuInstanceCount (REQUEST_STRUCT*, char*);
AdminMenuInstanceList (REQUEST_STRUCT*, char*);
AdminMetaConBeginUpdateForm (REQUEST_STRUCT*);
AdminMetaConEndUpdateForm (REQUEST_STRUCT*);
AdminMetaConReport (REQUEST_STRUCT*, META_CONFIG*, META_CONFIG*);
AdminMetaConSource (REQUEST_STRUCT*, META_CONFIG*, META_CONFIG*, BOOL);
AdminPageTitle (REQUEST_STRUCT*, char*, ...);
int AdminParsePath (REQUEST_STRUCT*, char*);
AdminReportServerStats (REQUEST_STRUCT*, REQUEST_AST);
AdminServerProcessInput (REQUEST_STRUCT*, REQUEST_AST);
AdminServerProcessOutput (REQUEST_STRUCT*, REQUEST_AST);
AdminVirtualServerMenu (REQUEST_STRUCT*, REQUEST_AST);
AdminVirtualServiceForm (REQUEST_STRUCT*, char*, char*, BOOL);

#endif /* ADMIN_H_LOADED */

/*****************************************************************************/

