/*****************************************************************************/
/*
                                   body.h
*/
/*****************************************************************************/

#ifndef BODY_H_LOADED
#define BODY_H_LOADED 1

#include "wasd.h"

/**********/
/* macros */
/**********/

#define BODY_PROCESSED_AS_NONE                0
#define BODY_PROCESSED_AS_TEXT                1
#define BODY_PROCESSED_AS_OTHER               2
#define BODY_PROCESSED_AS_VIRTUALBLOCK        3
#define BODY_PROCESSED_AS_URLENCODED          4
#define BODY_PROCESSED_AS_MULTIPART_FORMDATA  5

/* maximum number of bytes that a request body may be read into memory */ 
#define BODY_PROCESS_ALL_MAX  32767

/* read this number of bytes when a POST or PUT is aborted */
#define BODY_PROCESS_READ_SOME_BYTES 8192

/* min/max number of reads a body undergoes before providing a response */
/* 
(yes, VERY LARGE, experience has show most browser's barf if the body is not
not all uploaded before reporting some problem!)
*/
#define BODY_DISCARD_CHUNK_COUNT 999999999

/**************/
/* structures */
/**************/

typedef struct BodyProcessStruct BODY_PROCESS;

struct  BodyProcessStruct
{
   BOOL  /* document posted is URL-encoded */
         ContentTypeUrlEncoded,
         /* form field CDATA contains '^' substituted for LFs */
         UrlEncodedHiddenLF,
         /* delete file after it's been transfered */
         PreviewOnly,
         /* currently processing a hex-encoded field value */
         UrlEncodedFieldHexEncoded,
         /* the current field name has reserved usage */
         UrlEncodedFieldNameReserved;

   int  /* count of bytes in buffer used for block I/O */
        BlockBufferCount,
        /* size in bytes of buffer used for block I/O */
        BlockBufferSize,
        /* contains the VMS status of the contents of the block buffer */
        BlockBufferStatus,
        /* number of the leading 512 byte block */
        BlockBufferVBN,
        /* plus the number of virtual blocks in the buffer */
        BlockBufferNextVBN,
        /* bytes of data beyond the last whole virtual block */
        BlockLeftOverCount,
        /* position in 'BoundaryBuffer' */
        BoundaryIdx,
        /* final count of characters in buffered MIME header */
        MimeHeaderCount,
        /* when buffering the MIME header */
        MimeHeaderIdx,
        /* length of MIME boundary used to delimit mixed subparts in buffer */
        MultipartBoundaryLength,
        /* current number of bytes in multipart field being buffered to */
        MultipartFormDataCount,
        /* keep track of 'form-data; name="name" filename=\"..\"' */
        MultipartFormDataFileNameCount,
        /* size of current multipart field being buffered to */
        MultipartFormDataSize,
        /* position in 'HexDecode' */
        UrlDecodeIdx,
        /* position in 'UrlDecode' */
        HexDecodeIdx,
        /* progressive number of bytes processed and passed on */
        ProcessedByteCount,
        /* FAB record attributes supplied with file body */
        UrlEncodedFabRat,
        /* FAB record format supplied with file body */
        UrlEncodedFabRfm,
        /* current length of field name while processing URL-encoded file */
        UrlEncodedFieldNameCount,
        /* size of field name while processing URL-encoded file */
        UrlEncodedFieldNameSize,
        /* current length of field value while processing URL-encoded file */
        UrlEncodedFieldValueCount,
        /* size of field value while processing URL-encoded file */
        UrlEncodedFieldValueSize;

   char  /* points to the start of the buffer used for block I/O */
         *BlockBufferPtr,
         /* points to data beyond the last whole virtual block */
         *BlockLeftOverPtr,
         /* pointer to start of multipart field being buffered to */
         *MultipartFormDataPtr,
         /* pointer to next character of multipart field being buffered to */
         *MultipartFormDataCurrentPtr;

   char  /* multipart boundary string */
         BoundaryBuffer [96],
         /* should be "ascii" or "binary" */
         FtpFileType [8],
         /* buffers when hex-encode decoding between reads */
         HexDecode [2],
         /* buffer the MIME part header */
         MimeHeaderBuffer [1024],
         /* multipart boundary string (from content-type) */
         MultipartBoundary [96],
         /* multipart content-type */
         MultipartContentType [64],
         /* buffer the 'form-data; name="uploadfilename"' data */
         MultipartUploadFileName [96],
         /* buffer the 'form-data; filename=".."' data */
         MultipartFileName [96],
         /* used to buffer the 'form-data; name="success"' data */
         MultipartSuccessUrl [256],
         /* buffer a string providing file protection */
         ProtectionHexString [8],
         /* buffer URL-encoded character */
         UrlDecode [4],
         /* store field name while processing URL-encoded file */
         UrlEncodedFieldName [256],
         /* store field value while processing URL-encoded file */
         UrlEncodedFieldValue [256];
};

/***********************/
/* function prototypes */
/***********************/

int BodyGetMimeBoundary (REQUEST_STRUCT*);
BodyProcessByVirtualBlock (REQUEST_STRUCT*);
BodyProcessMultipartFormData (REQUEST_STRUCT*);
int BodyProcessMultipartMimeHeader (REQUEST_STRUCT*);
BodyProcessReadAll (REQUEST_STRUCT*);
BodyProcessReadSome (REQUEST_STRUCT*);
BodyProcessUrlEncoded (REQUEST_STRUCT*);
BodyRead (REQUEST_STRUCT*);
BodyReadAst (REQUEST_STRUCT*);
BodyReadBegin (REQUEST_STRUCT*, REQUEST_AST, REQUEST_AST);
BodyReadEnd (REQUEST_STRUCT*, REQUEST_AST);

#endif /* BODY_H_LOADED */

/*****************************************************************************/

