$!-----------------------------------------------------------------'f$verify(0)
$! BUILD_HTTPD.COM
$!
$! P1..P8
$!
$! "BUILD"         compile/link
$! "BUILD:LOCAL"   compile/link using local VMS and C RTL versions
$! "COMPILE"       compile only
$! "COMPILE:LIST"  compile only, producing machine code listing
$! "JUST:module"   to compile just that module
$! "JUST:SSL"      to compile all the SSL-related modules
$! "LINK"          link only
$! "LINK:MAP"      link only, producing linkage map
$! "PERSONA_STUB"  force compilation of Persona "stub" on VMS 6.2ff 
$! "PERSONA_MACRO" force assembly/linkage of PERSONA Macro 
$! "SSL=1"         build with WASD OpenSSL distribution
$! "OPENSSL=1"     build with standard OpenSSL distribution
$! "VMS_SSL=1"     build with OpenVMS (Open)SSL product
$! "WATCH_CAT=0"   eliminates category WATCHing statements (admin)
$! "WATCH_MOD=1"   includes module WATCHing statements (debugging)
$! "ACME=1"        includes the (functional) ACME module
$!
$! By default the software is built with a base compliance to VMS V6.0.
$! This is done to make the object modules as broadly portable as possible.
$! Using BUILD:LOCAL will build against whatever version of VMS and C RTL is
$! available on the local system.  This may provide run-time efficiencies, etc.
$! Note however that the package is only extensively tested using the
$! base-level build, so unexpected behaviours (i.e. bugs ;^) may be revealed
$! by the different build and run-time environment.
$! 
$! For a non-WASD-default location for the OpenSSL compile-time environment
$! use the VMS OpenSSL standard logical locations (i.e. SSLROOT).
$!
$! When building using VMS OpenSSL be aware that it uses shareable libraries
$! that must be INSTALLed before the WASD server image can be activated.
$! (which is not a bad idea anyway).
$!
$!   $ INSTALL ADD /OPEN /HEADER /SHARE SYS$LIBRARY:SSL$LIBCRYPTO_SHR32.EXE
$!   $ INSTALL ADD /OPEN /HEADER /SHARE SYS$LIBRARY:SSL$LIBSSL_SHR32.EXE
$!
$! 10-APR-2004  MGD  v8.5, AUTHACME.C, TCPIP.C
$! 20-DEC-2003  MGD  v8.4,
$!                   support building under IA64
$! 20-NOV-2003  MGD  PROXYVERIFY.C
$! 03-MAY-2003  MGD  REGEX.C
$! 15-APR-2003  MGD  bugfix; for OpenSSL installed away from original package
$! 08-MAR-2003  MGD  delete all existing object files before full build
$! 22-JAN-2003  MGD  add '.c' to compiles after report of failure (on CGI)
$!                   when a logical name is defined against the string
$! 10-AUG-2002  MGD  build against VMS (Open)SSL v1.0-A
$! 05-JUL-2002  MGD  V8.0,
$!                   rework procedure parameter processing,
$!                   removed requirement for OpenSSL SSL_LOCL.H
$! 28-JAN-2002  MGD  expand SESOLA modules, add FTP and BODY modules
$! 28-OCT-2001  MGD  PERSONA_MACRO/PERSONA.MAR
$! 04-AUG-2001  MGD  WATCH_MOD and WATCH_CAT
$! 01-JUL-2001  MGD  further refinement
$! 18-MAY-2001  MGD  THROTTLE.C, FAO.C modules
$! 07-APR-2001  MGD  explicitly build the link options file,
$!                   use OpenSSL directory logicals
$! 13-FEB-2001  MGD  AUTHIDENT.C module
$! 01-OCT-2000  MGD  PERSONA.C module
$! 12-SEP-2000  MGD  make OpenSSL directory determination more flexible
$! 09-AUG-2000  MGD  WASD_BUILD_DEFINES
$! 13-JUN-2000  MGD  v7.1,
$!                   SERVICE.C module
$! 05-MAR-2000  MGD  v7.0,
$!                   ODS (extended file specification) support,
$!                   OpenSSL v0.9.5 support
$! 23-DEC-1999  MGD  v6.1.2,
$!                   RELAXED_ANSI standard (DECC v6.2)
$! 28-AUG-1999  MGD  v6.1,
$!                   remove support for NETLIB,
$!                   support for OpenSSL v0.9.4,
$!                   remove support for SSLeay
$! 02-APR-1999  MGD  generalize for OpenSSL v0.9.3
$! 24-DEC-1998  MGD  HTTPd version 6,
$!                   add proxy modules,
$!                   suppress informational messages (DECC 5.7)
$! 03-JUL-1998  MGD  SSLeay v0.9.0b,
$!                   build for TCPware in UCX compatibility mode
$! 14-MAY-1998  MGD  add defines for __VMS_VER, __CRTL_VER, __VMS_V6_SOURCE
$!                   (ensure v7.1 compilations can be executed on v6.n),
$!                   distributing as .OBJ ... need UCX and NETLIB object files
$! 07-JAN-1998  MGD  HTTPd version 5
$!                   added SSL (SSLeay) build support
$!                   removed optimization, seemed to be inducing problems
$! 07-SEP-1997  MGD  modified to support DBUG and to retain NETLIB objects
$! 23-JUL-1997  MGD  MultiNet dropped in favour of NETLIB 2.1
$! 01-FEB-1997  MGD  HTTPd version 4
$! 06-JAN-1996  MGD  build for either UCX or MultiNet
$! 01-DEC-1995  MGD  HTTPd version 3
$! 24-MAY-1995  MGD  build for AXP systems
$! 20-DEC-1994  MGD  multi-threaded server
$! 20-JUN-1994  MGD  single-threaded server
$!-----------------------------------------------------------------------------
$!
$!! SET VERIFY
$ SET CONTROL=Y
$ ON CONTROLY THEN GOTO FINISHED
$!
$ IF P3 .EQS. "DIST"
$ THEN
$!   (only for building distributions of the server)
$    @BUILD_HTTPD
$    @BUILD_HTTPD PERSONA_STUB JUST:PERSONA
$    @BUILD_HTTPD PERSONA_MACRO JUST:PERSONA
$    @BUILD_HTTPD SSL JUST:SSL
$    EXIT
$ ENDIF
$!
$ BUILD_BASE_V60 = "WASD_VMS_V6"
$ BUILD_BASE = BUILD_BASE_V60
$ ARCH_NAME = F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE") 
$ IF ARCH_NAME .EQS. "ALPHA" THEN ARCH_NAME = "AXP"
$ VMS_VERSION = F$GETSYI("VERSION")
$! TODO remove later <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$ IF ARCH_NAME .EQS. "IA64" THEN VMS_VERSION = "V8.1"
$ VMS_VERSION = F$INTEGER(F$EXTRACT(1,1,VMS_VERSION)) * 10 +-
                F$INTEGER(F$EXTRACT(3,1,VMS_VERSION))
$ DEBUGTRACE = 0
$ IF DEBUGTRACE
$ THEN
$    DEBUGQUAL == "/DEBUG"
$    TRACEQUAL == "/TRACE"
$ ELSE
$    DEBUGQUAL == "/NODEBUG"
$    TRACEQUAL == "/NOTRACE"
$ ENDIF
$ PREVDEFAULT = F$ENVIRONMENT("DEFAULT")
$ PROCEDURE = F$ENVIRONMENT("PROCEDURE")
$ DEFAULT = F$PARSE(PROCEDURE,,,"DEVICE") + F$PARSE(PROCEDURE,,,"DIRECTORY")
$ SET DEFAULT 'DEFAULT'
$!
$ BUILDLOCAL = 0
$ COMPILEONLY = 0
$ COMPILELIST = ""
$ DBUG = ""
$ JUST = ""
$ LINKONLY = 0
$ LINKMAP = ""
$ WASD_SSL = 0
$ OPEN_SSL = 0
$ VMS_SSL = 0
$ PERSONA_STUB = 0
$ PERSONA_MACRO = 0
$ SESOLA = ""
$ SESOLA_EXE = ""
$ SESOLA_OBJ = ""
$ SESOLA_INCLUDED = "Without SSL"
$ SSL_ROOT = ""
$ SSL_INCLUDE = ""
$ WASD_ACME = ""
$ WATCH_CAT = "WATCH_CAT=1"
$ WATCH_MOD = "WATCH_MOD=0"
$ IF ARCH_NAME .EQS. "VAX"
$    THEN WARN = " /NOWARNING"
$    ELSE WARN = " /WARNING=(NOINFORM,DISABLE=(PREOPTW))"
$ ENDIF
$!
$ COUNT = 0
$ PARAMETER_LOOP:
$    COUNT = COUNT + 1
$    IF COUNT .GT. 8 THEN GOTO END_PARAMETER_LOOP
$    P0 = P'COUNT'
$    IF P0 .EQS. "" THEN GOTO PARAMETER_LOOP
$    WRITE SYS$OUTPUT "P''COUNT'=" + P0
$!
$    IF P0 .EQS. "BUILD"
$    THEN
$       COMPILEONLY = 0
$       LINKONLY = 0
$    ENDIF
$    IF P0 .EQS. "BUILD:LOCAL" .OR. P0 .EQS. "BUILDLOCAL" THEN BUILDLOCAL = 1
$!
$    IF P0 .EQS. "COMPILE" THEN COMPILEONLY = 1
$    IF P0 .EQS. "COMPILE:LIST" .OR. P0 .EQS. "COMPILE_LIST"
$    THEN
$       COMPILELIST = " /LIST /MACHINE"
$       COMPILEONLY = 1
$       LINKONLY = 0
$    ENDIF
$!
$    IF P0 .EQS. "DBUG"
$    THEN
$       DBUG = "DBUG"
$       WATCH_MOD = "WATCH_MOD=1"
$    ENDIF
$!
$    IF F$ELEMENT(0,":",P0) .EQS. "JUST"
$    THEN
$       JUST = F$ELEMENT(1,":",P0)
$       COMPILEONLY = 1
$       LINKONLY = 0
$!      (at least until UPDATESSL.COM catches up transmogrify :SESOLA to :SSL)
$       IF JUST .EQS. "SESOLA" THEN JUST = "SSL"
$    ENDIF
$!
$    IF P0 .EQS. "LINK" THEN LINKONLY = 1
$    IF P0 .EQS. "LINK:MAP" .OR. P0 .EQS. "LINK_MAP"
$    THEN
$       LINKMAP = " /MAP=HTTPD''SESOLA_EXE'.MAP/FULL"
$       LINKONLY = 1
$       COMPILEONLY = 0
$    ENDIF
$!
$!   (BUILD_HTTPD_PERSONA_MACRO is a symbol assigned by INSTALL.COM, etc.)
$    IF P0 .EQS. "PERSONA_MACRO" .OR. F$TYPE(BUILD_HTTPD_PERSONA_MACRO) .NES. ""
$    THEN
$       IF ARCH_NAME .NES. "VAX"
$       THEN
$          TYPE SYS$INPUT
  ***************************************
  *  PERSONA.MAR only supported for VAX *
  ***************************************

$          EXIT
$       ENDIF
$       PERSONA_STUB = 0
$       PERSONA_MACRO = 1
$    ENDIF
$!
$    IF P0 .EQS. "PERSONA_STUB" THEN PERSONA_STUB = 1
$!
$!   (BUILD_HTTPD_WASD_SSL is a symbol assigned by [INSTALL]SSL_DETECT.COM)
$!
$    IF P0 .EQS. "SSL=1" .OR. P0 .EQS. "SSL" .OR. -
        F$TYPE(BUILD_HTTPD_WASD_SSL) .NES. ""
$    THEN
$!
$!      (search for latest version in default WASD location)
$       SSL_ROOT_LOOP:
$          TMP_DIR = F$SEARCH("HT_ROOT:[SRC]OPENSSL-*_*_*.DIR")
$          IF TMP_DIR .EQS. "" THEN GOTO END_SSL_ROOT_LOOP
$          SSL_ROOT_POS = F$LOCATE("]OPENSSL",TMP_DIR)
$          SSL_ROOT = F$EXTRACT(0,SSL_ROOT_POS,TMP_DIR) + "." + -
                      F$EXTRACT(SSL_ROOT_POS+1,999,TMP_DIR) - ".DIR;1"
$          GOTO SSL_ROOT_LOOP
$       END_SSL_ROOT_LOOP:
$!
$       WASD_SSL = 0
$       IF F$LOCATE("OPENSSL",SSL_ROOT) .LT. F$LENGTH(SSL_ROOT) THEN WASD_SSL = 1
$!
$       IF .NOT. WASD_SSL
$       THEN
$          TYPE SYS$INPUT
  ****************************************
  *  WASD OpenSSL directory not located  *
  ****************************************

$          GOTO FINISHED
$       ENDIF
$!
$       SSL_ROOT = SSL_ROOT + "]"
$       SSL_ROOT_DEV = F$PARSE(SSL_ROOT,,,"DEVICE","NO_CONCEAL")
$       SSL_ROOT_DIR = F$PARSE(SSL_ROOT,,,"DIRECTORY","NO_CONCEAL") - "]["
$       SSL_ROOT = SSL_ROOT_DEV + -
           F$EXTRACT(0,F$LENGTH(SSL_ROOT_DIR)-1,SSL_ROOT_DIR) + ".]"
$       DEFINE /NOLOG /PROCESS /TRANSLATION=CONCEALED SSLROOT 'SSL_ROOT'
$       DEFINE /NOLOG /PROCESS OPENSSL SSLROOT:[INCLUDE.OPENSSL]
$       IF F$SEARCH("SSLROOT:[INCLUDE.OPENSSL]OPENSSLCONF.H") .EQS. "" .AND. - 
           F$SEARCH("SSLROOT:[WASD]OPENSSLCONF_''ARCH_NAME'.H") .EQS. "" 
$       THEN
$          TYPE SYS$INPUT
  ******************************************
  *  OpenSSL OPENSSLCONF.H file not found  *
  ******************************************

$          GOTO FINISHED
$       ENDIF
$!
$       SESOLA = "SESOLA"
$       SESOLA_EXE = "_SSL"
$       SESOLA_OBJ = "_SSL"
$       SESOLA_INCLUDED = "WASD OpenSSL from " +-
                          F$TRNLNM("SSLROOT") - ".]" + "]"
$!
$    ENDIF
$!
$!   (BUILD_HTTPD_OPEN_SSL is a symbol assigned by [INSTALL]SSL_DETECT.COM)
$!
$    IF P0 .EQS. "OPENSSL" .OR. F$TYPE(BUILD_HTTPD_OPEN_SSL) .NES. ""
$    THEN
$!
$       IF F$TRNLNM("SSLROOT") .EQS. ""
$       THEN
$          TYPE SYS$INPUT
  ***********************************
  *  OpenSSL directory not located  *
  ***********************************

$          GOTO FINISHED
$       ENDIF
$!
$       OPEN_SSL = 1
$       SESOLA = "SESOLA"
$       SESOLA_EXE = "_SSL"
$       SESOLA_OBJ = "_SSL"
$       SESOLA_INCLUDED = "OpenSSL from " + F$TRNLNM("SSLROOT") - ".]" + "]"
$!
$    ENDIF
$!
$!   (BUILD_HTTPD_VMS_SSL is a symbol assigned by [INSTALL]SSL_DETECT.COM)
$!
$    IF P0 .EQS. "VMS_SSL" .OR. F$TYPE(BUILD_HTTPD_VMS_SSL) .NES. ""
$    THEN
$!
$       VMS_SSL = 1
$!
$       SSL_ROOT = "SYS$COMMON:[SSL]
$       SSL_ROOT_DEV = F$PARSE(SSL_ROOT,,,"DEVICE","NO_CONCEAL")
$       SSL_ROOT_DIR = F$PARSE(SSL_ROOT,,,"DIRECTORY","NO_CONCEAL") - "]["
$       SSL_ROOT = SSL_ROOT_DEV + -
           F$EXTRACT(0,F$LENGTH(SSL_ROOT_DIR)-1,SSL_ROOT_DIR) + ".]"
$!      (just override using the system-defined logical if present)
$       IF F$TRNLNM("SSL$ROOT") THEN SSL_ROOT = F$TRNLNM("SSL$ROOT")
$       DEFINE /NOLOG /PROCESS /TRANSLATION=CONCEALED SSLROOT 'SSL_ROOT'
$       DEFINE /NOLOG /PROCESS OPENSSL SSLROOT:[INCLUDE]
$!
$       IF F$SEARCH("SSLROOT:[INCLUDE]OPENSSLCONF.H") .EQS. "" 
$       THEN
$          TYPE SYS$INPUT
  ******************************************
  *  VMS SSL OPENSSLCONF.H file not found  *
  ******************************************

$          GOTO FINISHED
$       ENDIF
$!
$       IF F$SEARCH("SYS$LIBRARY:SSL$LIBCRYPTO_SHR32.EXE") .EQS. "" .OR. -
           F$SEARCH("SYS$LIBRARY:SSL$LIBSSL_SHR32.EXE") .EQS. ""
$       THEN
$          TYPE SYS$INPUT
  ******************************************
  *  VMS SSL shared libraries not located  *
  ******************************************

$          GOTO FINISHED
$       ENDIF
$!
$       SESOLA = "SESOLA"
$       SESOLA_EXE = "_SSL"
$       SESOLA_OBJ = "_SSL"
$       SESOLA_INCLUDED = "VMS OpenSSL from " +-
                          F$TRNLNM("SSLROOT") - ".]" + "]"
$!
$    ENDIF
$!
$    IF P0 .EQS. "WARN" THEN WARN = ""
$    IF P0 .EQS. "WATCH_CAT=0" THEN WATCH_CAT = "WATCH_CAT=0"
$    IF P0 .EQS. "WATCH_MOD=1" THEN WATCH_MOD = "WATCH_MOD=1"
$    IF P0 .EQS. "ACME=1" THEN WASD_ACME = "WASD_ACME=1"
$    IF P0 .EQS. "ACME=0" THEN WASD_ACME = "WASD_ACME=0"
$!
$    GOTO PARAMETER_LOOP
$!
$ END_PARAMETER_LOOP:
$!
$! (ACME is not available on VAX and only with VMS 7.3 or later)
$ IF WASD_ACME .EQS. "" .AND. VMS_VERSION .GE. 73 .AND. ARCH_NAME .NES. "VAX" -
     THEN WASD_ACME = "WASD_ACME=1"
$ IF WASD_ACME .EQS. "WASD_ACME=1" 
$ THEN
$    ACME_STUB = 0
$    ACME_OBJ = ""
$ ELSE
$    WASD_ACME = "WASD_ACME=0"
$    ACME_STUB = 1
$    ACME_OBJ = "_STUB"
$ ENDIF
$ IF BUILDLOCAL 
$    THEN CC_DEFINES = ""
$    ELSE CC_DEFINES = BUILD_BASE
$ ENDIF
$ IF F$TRNLNM("WASD_BUILD_DEFINES") .NES. "" -
     THEN CC_DEFINES = F$TRNLNM("WASD_BUILD_DEFINES")
$ IF DBUG .NES. ""
$ THEN
$    IF CC_DEFINES .NES. "" THEN CC_DEFINES = CC_DEFINES + ","
$    CC_DEFINES = CC_DEFINES + DBUG
$ ENDIF
$ IF SESOLA .NES. ""
$ THEN
$    IF CC_DEFINES .NES. "" THEN CC_DEFINES = CC_DEFINES + ","
$    CC_DEFINES = CC_DEFINES + SESOLA
$ ENDIF
$ CC_DEFINES = CC_DEFINES + "," + WATCH_CAT + "," + WATCH_MOD + "," + WASD_ACME
$ IF CC_DEFINES .NES. "" THEN CC_DEFINES = " /DEFINE=(" + CC_DEFINES + ")"
$!
$ WRITE SYS$OUTPUT "Building for ""''ARCH_NAME'"" architecture"
$ IF SESOLA_INCLUDED .NES. "" THEN WRITE SYS$OUTPUT SESOLA_INCLUDED
$!
$ IF ARCH_NAME .EQS. "IA64"
$ THEN
$    OBJ_DIR = "[.OBJ_IA64]"
$    IF F$SEARCH("OBJ_IA64.DIR") .EQS. "" THEN CREATE /DIR 'OBJ_DIR'
$    CC_OPTIONS = "/DECC /STAND=RELAXED_ANSI /PREFIX=ALL " +-
                  "/OPTIMIZE ''COMPILELIST'''DEBUGQUAL'''WARN'"
$ ENDIF
$ IF ARCH_NAME .EQS. "AXP"
$ THEN
$    OBJ_DIR = "[.OBJ_AXP]"
$    IF F$SEARCH("OBJ_AXP.DIR") .EQS. "" THEN CREATE /DIR 'OBJ_DIR'
$    CC_OPTIONS = "/DECC /STAND=RELAXED_ANSI /PREFIX=ALL " +-
                  "/OPTIMIZE ''COMPILELIST'''DEBUGQUAL'''WARN'"
$ ENDIF
$ IF ARCH_NAME .EQS. "VAX"
$ THEN
$    OBJ_DIR = "[.OBJ_VAX]"
$    IF F$SEARCH("OBJ_VAX.DIR") .EQS. "" THEN CREATE /DIR 'OBJ_DIR'
$    CC_OPTIONS = "/DECC /STAND=RELAXED_ANSI /PREFIX=ALL " +-
                  "/OPTIMIZE ''COMPILELIST'''DEBUGQUAL'''WARN'"
$ ENDIF
$!
$ IF LINKONLY THEN GOTO LINK
$!
$! ***********
$! * COMPILE *
$! ***********
$!
$ SET NOON
$ SET VERIFY
$ IF JUST .NES. "" THEN GOTO 'JUST'
$!
$ DELETE 'OBJ_DIR'*.*;*
$!
$ ADMIN:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Admin    Admin.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTH:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Auth     Auth.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHACME:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'AuthACME'ACME_OBJ'  AuthACME.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHAGENT:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'AuthAgent  AuthAgent.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHCACHE:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'AuthCACHE  AuthCache.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHCONFIG:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'AuthConfig  AuthConfig.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHHTA:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'AuthHTA  AuthHTA.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHHTL:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'AuthHTL  AuthHTL.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHIDENT:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'AuthIdent  AuthIdent.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHVMS:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'AuthVMS  AuthVMS.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ BASIC:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Basic    Basic.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ BODY:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Body      Body.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CACHE:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Cache    Cache.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CGI:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'CGI      CGI.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CLI:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'CLI      CLI.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CONFIG:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Config   Config.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CONTROL: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Control  Control.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DCL:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Dcl      Dcl.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DECNET:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'DECnet   DECnet.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DESCR:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Descr    Descr.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DIR:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Dir      Dir.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DIGEST:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Digest   Digest.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ ERROR:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Error    Error.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ FAO:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'FAO       FAO.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ FILE:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'File     File.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ FILEDOT:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'FileDot FileDot.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ GRAPH:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Graph    Graph.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ HTADMIN: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'HTAdmin  HTAdmin.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ HTTPD:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'HTTPd    HTTPd.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ INSTANCE:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Instance    Instance.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ ISMAP:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'IsMap    IsMap.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ LOGGING: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Logging  Logging.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MAPURL:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'MapUrl   MapUrl.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MD5:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'MD5      MD5.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MENU:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Menu     Menu.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ METACON:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'MetaCon     MetaCon.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MSG:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Msg      Msg.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ NET:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Net      Net.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ ODS:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'ODS      ODS.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PERSONA:
$    IF ARCH_NAME .EQS. "VAX" .AND. PERSONA_MACRO
$    THEN
$       PERSONA_DEFINES = CC_DEFINES - ")" + ",PERSONA_MACRO)"
$       CC 'CC_OPTIONS''PERSONA_DEFINES' /OBJ='OBJ_DIR'Persona_macro Persona.c
$    ELSE
$       IF VMS_VERSION .LT. 62 .OR. PERSONA_STUB
$       THEN
$          PERSONA_DEFINES = CC_DEFINES - ")" + ",PERSONA_STUB)"
$          CC 'CC_OPTIONS''PERSONA_DEFINES' /OBJ='OBJ_DIR'Persona_stub Persona.c
$       ELSE
$          CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Persona  Persona.c
$       ENDIF
$    ENDIF
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PROXY:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Proxy    Proxy.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PROXYCACHE:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'ProxyCache  ProxyCache.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PROXYFTP:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'ProxyFTP     ProxyFTP.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PROXYMAINT:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'ProxyMaint  ProxyMaint.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PROXYVERIFY:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'ProxyVerify ProxyVerify.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PUT:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Put      Put.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ REGEX:
$    REGEX_DEFINES = CC_DEFINES - ")" + ",STDC_HEADERS,REGEX_MALLOC)"
$    CC 'CC_OPTIONS''REGEX_DEFINES' /OBJ='OBJ_DIR'RegEx     RegEx.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ REQUEST: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Request  Request.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ RESPONSE:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'RESPONSE    Response.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SERVICE:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Service      Service.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SSI:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'SSI      SSI.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$!
$ SSL:
$!'f$VERIFY(0)
$ SESOLA:
$ SESOLACACHE:
$ SESOLACGI:
$ SESOLACLIENT:
$ SESOLANET:
$ IF SESOLA .NES. ""
$ THEN
$!   (OpenSSL 0.9.5/6 has architecture-specific configuration file generated)
$    IF F$SEARCH("SSLROOT:[WASD]OPENSSLCONF_''ARCH_NAME'.H") .NES. "" 
$    THEN
$       COPY SSLROOT:[WASD]OPENSSLCONF_'ARCH_NAME'.H -
             SSLROOT:[INCLUDE.OPENSSL]OPENSSLCONF.H
$       PURGE /NOCONFIRM /NOLOG SSLROOT:[INCLUDE.OPENSSL]OPENSSLCONF.H
$    ENDIF
$ ENDIF
$ IF JUST .NES. "" THEN GOTO 'JUST'_
$! SESOLA_WARN = "/NOWARN"
$ SSL_:
$ SET VERIFY
$ SESOLA_: CC 'CC_OPTIONS''CC_DEFINES''SESOLA_WARN' -
          /OBJ='OBJ_DIR'Sesola'SESOLA_OBJ' Sesola.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLACACHE_: CC 'CC_OPTIONS''CC_DEFINES''SESOLA_WARN' -
               /OBJ='OBJ_DIR'SesolaCache'SESOLA_OBJ' SesolaCache.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLACGI_: CC 'CC_OPTIONS''CC_DEFINES''SESOLA_WARN' -
             /OBJ='OBJ_DIR'SesolaCGI'SESOLA_OBJ' SesolaCGI.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLACLIENT_: CC 'CC_OPTIONS''CC_DEFINES''SESOLA_WARN' -
                /OBJ='OBJ_DIR'SesolaClient'SESOLA_OBJ' SesolaClient.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLANET_: CC 'CC_OPTIONS''CC_DEFINES''SESOLA_WARN' -
          /OBJ='OBJ_DIR'SesolaNet'SESOLA_OBJ' SesolaNet.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SET VERIFY
$!
$ STMLF:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'StmLF    StmLF.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ STRNG:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Strng    Strng.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SUPPORT: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Support  Support.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ TCPIP:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Tcpip      Tcpip.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ THROTTLE:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Throttle  Throttle.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ TRACK:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Track  Track.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ UPD:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'Upd      Upd.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ VM:      CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'VM       VM.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ WATCH:   
$    @BUILD_WATCHFUNC "''CC_OPTIONS'''CC_DEFINES'"
$!   'F$VERIFY(1)
$    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'WATCH  WATCH.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$!
$ VERSION: DATETIME = F$TIME()
$ IF F$EXTRACT(0,1,DATETIME) .EQS. " " THEN DATETIME = F$EXTRACT(1,99,DATETIME)
$ CC_DEFINES = CC_DEFINES - ")" + ",BUILD_DATETIME=""""""''DATETIME'"""""")"
$ CC 'CC_OPTIONS''CC_DEFINES' /OBJ='OBJ_DIR'VERSION  Version.c
$!
$ ENDCOMPILE:
$! 'F$VERIFY(0)
$!
$ IF COMPILEONLY THEN GOTO FINISHED
$!
$! ********
$! * LINK *
$! ********
$!
$ LINK:
$!
$ IF PERSONA_MACRO THEN MACRO PERSONA.MAR /OBJECT='OBJ_DIR'PERSONA_MAR
$!
$ SEARCH VERSION.H HTTPD_VERSION /OUTPUT=IMAGE_IDENT.LIS
$ OPEN /READ IMAGEIDENT IMAGE_IDENT.LIS
$ READ IMAGEIDENT IMAGE_IDENT
$ CLOSE IMAGEIDENT
$ DELETE /NOLOG /NOCONFIRM IMAGE_IDENT.LIS;*
$ IMAGE_IDENT = F$ELEMENT(1,"""",IMAGE_IDENT)
$ IF IMAGE_IDENT .EQS. "" .OR. IMAGE_IDENT .EQS. """" -
     THEN IMAGE_IDENT = "_UNKNOWN_"
$!
$ PROCEDURE = F$ENVIRONMENT("PROCEDURE")
$ PROCEDURE_DEV = F$PARSE(PROCEDURE,,,"DEVICE")
$ PROCEDURE_DIR = F$PARSE(PROCEDURE,,,"DIRECTORY")
$ LINK_OPT = PROCEDURE_DEV + PROCEDURE_DIR + "LINK_" + ARCH_NAME +".OPT"
$ IF F$TRNLNM("WASD_LINK_OPT","LNM$PROCESS") THEN CLOSE WASD_LINK_OPT
$ IF F$SEARCH("''LINK_OPT'") .NES. "" THEN DELETE /NOCONFIRM /NOLOG 'LINK_OPT';*
$!
$ OPEN /WRITE WASD_LINK_OPT 'LINK_OPT'
$ WRITE WASD_LINK_OPT "IDENT=""" + IMAGE_IDENT + """"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Admin"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Auth"
$ IF ACME_STUB
$    THEN WRITE WASD_LINK_OPT OBJ_DIR + "AuthACME" + ACME_OBJ
$    ELSE WRITE WASD_LINK_OPT OBJ_DIR + "AuthACME"
$ ENDIF
$ WRITE WASD_LINK_OPT OBJ_DIR + "AuthAgent"
$ WRITE WASD_LINK_OPT OBJ_DIR + "AuthCache"
$ WRITE WASD_LINK_OPT OBJ_DIR + "AuthConfig"
$ WRITE WASD_LINK_OPT OBJ_DIR + "AuthHTA"
$ WRITE WASD_LINK_OPT OBJ_DIR + "AuthHTL"
$ WRITE WASD_LINK_OPT OBJ_DIR + "AuthIdent"
$ WRITE WASD_LINK_OPT OBJ_DIR + "AuthVMS"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Basic"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Body"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Cache"
$ WRITE WASD_LINK_OPT OBJ_DIR + "CGI"
$ WRITE WASD_LINK_OPT OBJ_DIR + "CLI"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Config"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Control"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Dcl"
$ WRITE WASD_LINK_OPT OBJ_DIR + "DECnet"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Descr"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Dir"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Digest"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Error"
$ WRITE WASD_LINK_OPT OBJ_DIR + "FAO"
$ WRITE WASD_LINK_OPT OBJ_DIR + "File"
$ WRITE WASD_LINK_OPT OBJ_DIR + "FileDot"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Graph"
$ WRITE WASD_LINK_OPT OBJ_DIR + "HTAdmin"
$ WRITE WASD_LINK_OPT OBJ_DIR + "HTTPd"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Instance"
$ WRITE WASD_LINK_OPT OBJ_DIR + "IsMap"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Logging"
$ WRITE WASD_LINK_OPT OBJ_DIR + "MapUrl"
$ WRITE WASD_LINK_OPT OBJ_DIR + "MD5"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Menu"
$ WRITE WASD_LINK_OPT OBJ_DIR + "MetaCon"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Msg"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Net"
$ WRITE WASD_LINK_OPT OBJ_DIR + "ODS"
$ IF PERSONA_MACRO
$ THEN
$    WRITE WASD_LINK_OPT OBJ_DIR + "Persona_macro"
$    WRITE WASD_LINK_OPT OBJ_DIR + "Persona_mar"
$ ELSE
$    IF VMS_VERSION .LT. 62 .OR. PERSONA_STUB
$    THEN
$       WRITE WASD_LINK_OPT OBJ_DIR + "Persona_stub"
$    ELSE
$       WRITE WASD_LINK_OPT OBJ_DIR + "Persona"
$    ENDIF
$ ENDIF
$ WRITE WASD_LINK_OPT OBJ_DIR + "Proxy"
$ WRITE WASD_LINK_OPT OBJ_DIR + "ProxyFTP"
$ WRITE WASD_LINK_OPT OBJ_DIR + "ProxyCache"
$ WRITE WASD_LINK_OPT OBJ_DIR + "ProxyMaint"
$ WRITE WASD_LINK_OPT OBJ_DIR + "ProxyVerify"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Put"
$ WRITE WASD_LINK_OPT OBJ_DIR + "RegEx"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Request"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Response"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Service"
$ IF WASD_SSL .OR. OPEN_SSL .OR. VMS_SSL
$ THEN
$    WRITE WASD_LINK_OPT OBJ_DIR + "Sesola_SSL"
$    WRITE WASD_LINK_OPT OBJ_DIR + "SesolaCache_SSL"
$    WRITE WASD_LINK_OPT OBJ_DIR + "SesolaCGI_SSL"
$    WRITE WASD_LINK_OPT OBJ_DIR + "SesolaClient_SSL"
$    WRITE WASD_LINK_OPT OBJ_DIR + "SesolaNet_SSL"
$ ELSE
$    WRITE WASD_LINK_OPT OBJ_DIR + "Sesola"
$    WRITE WASD_LINK_OPT OBJ_DIR + "SesolaCGI"
$    WRITE WASD_LINK_OPT OBJ_DIR + "SesolaNet"
$ ENDIF
$ WRITE WASD_LINK_OPT OBJ_DIR + "SSI"
$ WRITE WASD_LINK_OPT OBJ_DIR + "StmLF"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Strng"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Support"
$ WRITE WASD_LINK_OPT OBJ_DIR + "TCPIP"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Throttle"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Track"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Upd"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Version"
$ WRITE WASD_LINK_OPT OBJ_DIR + "VM"
$ WRITE WASD_LINK_OPT OBJ_DIR + "Watch"
$ IF OPEN_SSL
$ THEN
$    WRITE WASD_LINK_OPT "SSLLIB:LIBSSL.OLB/LIBRARY"
$    WRITE WASD_LINK_OPT "SSLLIB:LIBCRYPTO.OLB/LIBRARY"
$ ENDIF
$ IF VMS_SSL
$ THEN
$    WRITE WASD_LINK_OPT "SYS$COMMON:[SYSLIB]SSL$LIBSSL_SHR32.EXE/SHARE"
$    WRITE WASD_LINK_OPT "SYS$COMMON:[SYSLIB]SSL$LIBCRYPTO_SHR32.EXE/SHARE"
$ ENDIF
$ IF WASD_SSL
$ THEN
$    WRITE WASD_LINK_OPT "SSLROOT:[" + ARCH_NAME + ".EXE.SSL]LIBSSL.OLB/LIBRARY"
$    WRITE WASD_LINK_OPT "SSLROOT:[" + ARCH_NAME + ".EXE.CRYPTO]LIBCRYPTO.OLB/LIBRARY"
$ ENDIF
$ CLOSE WASD_LINK_OPT
$!
$ SET ON
$ SET VERIFY
$!
$ LINK'LINKMAP' 'TRACEQUAL' -
  /EXECUTABLE=HT_EXE:HTTPD'SESOLA_EXE'.EXE -
  'LINK_OPT'/OPTIONS
$!
$!'F$VERIFY(0)
$ DELETE /NOCONFIRM /NOLOG 'LINK_OPT';*
$ PURGE /LOG 'OBJ_DIR' /KEEP=3
$!
$! ************
$! * FINISHED *
$! ************
$!
$ FINISHED:  !'F$VERIFY(0)
$ SET DEFAULT 'PREVDEFAULT'
$!(clean-up any WASD OpenSSL distribution logicals)
$ IF F$TRNLNM("SSLROOT","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS SSLROOT
$ IF F$TRNLNM("OPENSSL","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS OPENSSL
$!-----------------------------------------------------------------------------
