/*****************************************************************************/
/*
                                  CGI.h

Defines and function prototypes for CGI module.

*/
/*****************************************************************************/

#ifndef CGI_H_LOADED
#define CGI_H_LOADED 1

#include "wasd.h"

#define CGI_VARIABLE_DCL     1
#define CGI_VARIABLE_STREAM  2

#define CGI_OUTPUT_MODE_STREAM  1
#define CGI_OUTPUT_MODE_RECORD  2
#define CGI_OUTPUT_MODE_CRLF    3

#define CGI_OUTPUT_CUTOFF        -19241006
#define CGI_OUTPUT_END           -19830604 
#define CGI_OUTPUT_ESCAPE_BEGIN  -19780106
#define CGI_OUTPUT_ESCAPE        -19631023
#define CGI_OUTPUT_ESCAPE_END    -19540825
#define CGI_OUTPUT_NOT_STRICT    -19790301

/***********************/
/* function prototypes */
/***********************/

#define CgiSequenceBel(charptr,lenptr) CgiSequence ('G', charptr, lenptr);
#define CgiSequenceEot(charptr,lenptr) CgiSequence ('D', charptr, lenptr);
#define CgiSequenceEof(charptr,lenptr) CgiSequence ('Z', charptr, lenptr);
#define CgiSequenceEsc(charptr,lenptr) CgiSequence ('E', charptr, lenptr);

CgiGenerateVariables (REQUEST_STRUCT*, int);
CgiHeader (REQUEST_STRUCT*, char*);
int CgiOutput (REQUEST_STRUCT*, char*, int);
CgiOutputFile (REQUEST_STRUCT*, char*, int);
int CgiScriptControlField (REQUEST_STRUCT*, char*);
CgiSequence (char, char*, int*);
CgiVariable (REQUEST_STRUCT*, char*, char*, int);
CgiVariableBufferMemory (REQUEST_STRUCT*, int);
CgiUrlDecodeString (REQUEST_STRUCT*, char*, char*, int, char);

#endif /* CGI_H_LOADED */

/*****************************************************************************/

