/*****************************************************************************/
/*
                                Control.h
*/
/*****************************************************************************/

#ifndef CONTROL_H_LOADED
#define CONTROL_H_LOADED 1

#include "wasd.h"

#define CONTROL_ABORT                 "ABORT"  /* compatability only */
#define CONTROL_BUFFER                "CONTROL_BUFFER"  /* internal use only */
#define CONTROL_AUTH_LOAD1            "AUTH"
#define CONTROL_AUTH_LOAD2            "AUTH=LOAD"
#define CONTROL_AUTH_PURGE            "AUTH=PURGE"
#define CONTROL_AUTH_SKELETON         "AUTH=SKELKEY="
#define CONTROL_CACHE_ON              "CACHE=ON"
#define CONTROL_CACHE_OFF             "CACHE=OFF"
#define CONTROL_CACHE_PURGE           "CACHE=PURGE"
#define CONTROL_DCL_DELETE            "DCL=DELETE"
#define CONTROL_DCL_PURGE             "DCL=PURGE"
#define CONTROL_DECNET_PURGE          "DECNET=PURGE"
#define CONTROL_DECNET_DISCONNECT     "DECNET=DISCONNECT"
#define CONTROL_EXIT                  "EXIT"
#define CONTROL_EXIT_NOW              "EXIT=NOW"
#define CONTROL_INSTANCE              "INSTANCE="
#define CONTROL_LIST                  "LIST"   /* command-line info only */
#define CONTROL_LOG_OPEN              "LOG=OPEN"
#define CONTROL_LOG_CLOSE             "LOG=CLOSE"
#define CONTROL_LOG_FLUSH             "LOG=FLUSH"
#define CONTROL_LOG_OPEN_AS           "LOG=OPEN="
#define CONTROL_LOG_REOPEN            "LOG=REOPEN"
#define CONTROL_LOG_REOPEN_AS         "LOG=REOPEN="
#define CONTROL_LOG_FORMAT_AS         "LOG=FORMAT="
#define CONTROL_LOG_PERIOD_AS         "LOG=PERIOD="
#define CONTROL_MAP                   "MAP"
#define CONTROL_PROXY_ADJUST          "PROXY=ADJUST"
#define CONTROL_PROXY_ON              "PROXY=ON"
#define CONTROL_PROXY_OFF             "PROXY=OFF"
#define CONTROL_PROXY_PURGE_BCKGRND   "PROXY=PURGE=BACKGROUND"
#define CONTROL_PROXY_PURGE_REACTIVE  "PROXY=PURGE=REACTIVE"
#define CONTROL_PROXY_PURGE_ROUTINE   "PROXY=PURGE=ROUTINE"
#define CONTROL_PROXY_PURGE_HOST      "PROXY=PURGE=HOST"
#define CONTROL_PROXY_PURGE_STOP      "PROXY=PURGE=STOP"
#define CONTROL_PROXY_STATISTICS      "PROXY=STATISTICS"
#define CONTROL_PROXY_STOP_SCAN       "PROXY=STOP=SCAN"
#define CONTROL_RESTART               "RESTART"
#define CONTROL_RESTART_NOW           "RESTART=NOW"
#define CONTROL_RESTART_QUIET         "RESTART=QUIET"
#define CONTROL_SSL_CA_LOAD           "SSL=CA=LOAD"
#define CONTROL_SSL_PKPASSWD          "SSL=KEY=PASSWORD"
#define CONTROL_THROTTLE_RELEASE      "THROTTLE=RELEASE"
#define CONTROL_THROTTLE_TERMINATE    "THROTTLE=TERMINATE"
#define CONTROL_THROTTLE_ZERO         "THROTTLE=ZERO"
#define CONTROL_ZERO                  "ZERO"

#define CONTROL_DELAY_EXIT            0x01
#define CONTROL_DELAY_RESTART         0x02
#define CONTROL_DELAY_RESTART_NOW     0x04
#define CONTROL_DELAY_RESTART_QUIET   0x08
#define CONTROL_DELAY_DO              0x10

/* wait for this many seconds for a response form the server */
#define CONTROL_RESPONSE_SECONDS      5

/***********************/
/* function prototypes */
/***********************/

ControlAllCommand (char*);
ControlAllHttpd (char*);
ControlCommand (char*);
ControlCommandAst ();
ControlDelay (int);
char* ControlEnqueueCommand (int, char*);
ControlHttpdAst (struct lksb*);
ControlInit ();
ControlMessage (char*);
ControlZeroAccounting ();

#endif /* CONTROL_H_LOADED */

/*****************************************************************************/
