/*****************************************************************************/
/*
                                  DECnet.h
*/
/*****************************************************************************/

#ifndef DECNET_H_LOADED
#define DECNET_H_LOADED 1

#include "wasd.h"

/**************/
/* structures */
/**************/

typedef struct DECnetConnectStruct DECNET_CONNECT;

struct DECnetConnectStruct
{
   struct  /* allows a list of these to be constructed */
           ListEntryStruct  DclListEntry;

   BOOL  /* when the current request is finished disconnect from the task */
         IsMarkedForDisconnect,
         /* task has indicated it is capable of reusing the connection */
         ReuseConnection;

   unsigned short  /* zero if no current channel, or channel number */
                  DECnetChannel;

   int  /* timer tick when we'll expire */
        LifeTimeSecond,
        /* number of times it has been reused */
        ReUsageCount,
        /* number of times it has been used */
        UsageCount;

   char  /* node::"task=whatever" */
         ConnectString [64];

   unsigned long  /* last used binary time ;^) */
                  LastUsedBinaryTime[2];

   /* NULL if no associated request, or pointer to assosciated request */
   REQUEST_STRUCT  *RequestPtr;
};

typedef struct DECnetTaskStruct DECNET_TASK;

struct DECnetTaskStruct
{
   BOOL  /* */
         AddNewline,
         /* build <LF> or <CR><LF> delimited records from single bytes */
         BuildRecords,
         /* an  <DNETCGI> was set by the script */
         OsuDnetCgi,
         /* an  <DNETRECMODE> was set by the script */
         OsuDnetRecMode,
         /* the script generated some output */
         ScriptResponded;
 

   int  /* when building records from single bytes */
        BuildCount,
        /* */
        CgiDialogState,
        /* */
        CgiEofLength,
        /* */
        ConnectStringLength,
        /* */
        ContentCount,
        /* */
        FindScriptCount,
        /* */
        FindScriptLength,
        /* */
        FindScriptTotalLength,
        /* */
        OsuDialogState,
        /* outstanding request body reads */
        QueuedBodyRead,
        /* outstanding DECnet I/Os */
        QueuedDECnetIO,
        /* outstanding network (client) writes */
        QueuedNetWrite,
        /* */
        ScriptType,
        /* copied from request structure for WATCHing purposes */
        WatchItem;

   unsigned short  DECnetChannel,
                   DECnetMbxChannel;

   char  /* */
         *ContentPtr,
         /* */
         *FindScriptTypePtr,
         /* current position when sending request header */
         *OsuDnetHdrPtr,
         /* */
         *RunTimePtr,
         /* */
         *ScriptPtr;

   char  /* unsique string used to indicate end of script output */
         CgiEof [48],
         /* node::"task=whatever" */
         ConnectString [64],
         /* buffer for DCL commands */
         DclCommand [256],
         /* VMS file script name used for searching */
         FindScript [256],
         /* VMS file script name */
         MappedScript [256],
         /* DCL required to execute the script */
         CgiScriptDcl [256],
         /* the above command being set up as a foreign verb, if necessary */
         CgiScriptForeignVerb [256],
         /* store the mapped runtime */
         ScriptRunTime [256];

   IO_SB  DECnetConnectIOsb,
                  DECnetReadIOsb,
                  DECnetWriteIOsb;

   /* pointer a request using this DCL task structure */
   REQUEST_STRUCT  *RequestPtr;

   /* pointer to the DECnet connection */
   struct DECnetConnectStruct  *cnptr;

   /* pointer to function, used for specifying the next task */
   REQUEST_AST NextTaskFunction;
};

/***********************/
/* function prototypes */
/***********************/

DECnetBegin (REQUEST_STRUCT*, REQUEST_AST, char*, char*);
DECnetCgiDialog (REQUEST_STRUCT*);
DECnetConnect (REQUEST_STRUCT*, REQUEST_AST, char*);
DECnetConnectAst (REQUEST_STRUCT*);
DECnetEnd (REQUEST_STRUCT*);
DECnetFindCgiScript (REQUEST_STRUCT*);
DECnetOsuCgi (REQUEST_STRUCT*, char*);
DECnetOsuDialog (REQUEST_STRUCT*);
DECnetOsuDnetId (REQUEST_STRUCT*, DECNET_TASK*, BOOL);
DECnetOsuDnetXlate (REQUEST_STRUCT*, DECNET_TASK*, char*);
DECnetRead (REQUEST_STRUCT*);
DECnetReadAst (REQUEST_STRUCT*);
BOOL DECnetSupervisor (int);
DECnetWrite (REQUEST_STRUCT*, char*, int);
DECnetWriteAst (REQUEST_STRUCT*);
DECnetWriteRequest (REQUEST_STRUCT*);
DECnetWriteRequestBody (REQUEST_STRUCT*);
DECnetWriteRequestAst (REQUEST_STRUCT*);

#endif /* DECNET_H_LOADED */

/*****************************************************************************/

