/*****************************************************************************/
/*
                                  Descr.h
*/
/*****************************************************************************/

#ifndef DESCR_H_LOADED
#define DESCR_H_LOADED 1

#include "wasd.h"

#define DESCR_READ_BUFFER_SIZE 2048

/**************/
/* structures */
/**************/

typedef struct DescrTaskStruct DESCR_TASK;

struct DescrTaskStruct
{
   BOOL  /* getting description from HTML, inside <TITLE></TITLE> tag */
         DescriptionInside,
         /* a <TITLE></TITLE> description has been retrieved from HTML */
         DescriptionRetrieved,
         /* file is "text/html", otherwise "text/plain" */
         TextHtmlFile;

   int  /* internal description, number of lines checked from each file */
        DescriptionLineCount,
        /* internal description, number of "<" encountered */
        DescriptionClosingTagCount,
        /* internal description, number of ">" encountered */
        DescriptionOpeningTagCount,
        /* length of locally stored file name */
        FileNameLength,
        /* size of calling function's buffer space */
        SizeOfDescriptionBuffer;

   char  /* pointer */
         *DescriptionPtr,
         /* points to calling function's buffer space */
         *DescriptionBufferPtr;

   char  /* file name stored local to task */
         FileName [ODS_MAX_FILE_NAME_LENGTH+1],
         /* RAB buffer */
         ReadBuffer [DESCR_READ_BUFFER_SIZE];

   struct FAB  FileFab;
   struct RAB  FileRab;

   /* pointer to function, used for specifying the next task */
   REQUEST_AST NextTaskFunction;
};

/***********************/
/* function prototypes */
/***********************/

int Description (REQUEST_STRUCT*, REQUEST_AST, char*, char*, int, int);
DescriptionCloseAst (struct FAB*);
DescriptionConnect (REQUEST_STRUCT*);
DescriptionConnectAst (struct RAB*);
DescriptionEscape (REQUEST_STRUCT*);
DescriptionEnd (REQUEST_STRUCT*);
DescriptionHtml (REQUEST_STRUCT*);
DescriptionHtmlRecord (struct RAB*);
DescriptionOpen (REQUEST_STRUCT*);
DescriptionOpenAst (struct FAB*);
DescriptionPlain (REQUEST_STRUCT*);
DescriptionPlainRecord (struct RAB*);

#endif /* DESCR_H_LOADED */

/*****************************************************************************/

