/*****************************************************************************/
/*
                                  Dir.h
*/
/*****************************************************************************/

#ifndef DIR_H_LOADED
#define DIR_H_LOADED 1

#include "wasd.h"
#include "file.h"

/**************/
/* structures */
/**************/

#ifndef __VAX
#   pragma __member_alignment __save
#   pragma member_alignment
#endif

typedef struct DirTaskStruct DIR_TASK;

struct DirTaskStruct
{
   LIST_ENTRY  DirTaskList;

   BOOL  /* query string directive */
         AsIfNopFound,
         /* query string directive */
         AsIfNosFound,
         /* disables auto-scripting appending version */
         AutoScriptEnabled,
         /* present a directory listing ("Index of") in a VMS-style */
         FormatLikeVms,
         /* */
         DirFormatBlockTotals,
         /* the original specification's file/type/version was not empty */
         DirSpecIncludedFilePart,
         /* query string directive */
         IncludeAnyReadme,
         /* */
         ListParentDir,
         /* */
         ListSubDir,
         /* make the file description a link */
         MakeDescriptionLink,
         /* HTTP header generated by directory lisitng, i.e. not embedded */
         ResponseHeaderSent,
         /* do not display the file's type (e.g. ".TXT") */
         ShowNoType,
         /* force director and file names to upper-case */
         ShowUpperCase;

   int  /* header, footer, both, none */
        Delimit,
        /* */
        DirAccessOkState,
        /* */
        DirAccessOkStatus,
        /* count of directories in listing */
        DirectoryCount,
        /* */
        LayoutFaoLength, 
        /* */
        LayoutHeadingLength, 
        /* */
        DirSpecLength,
        /* */
        FieldWidthCdt,
        /* */
        FieldWidthDescription,
        /* */
        FieldWidthName,
        /* */
        FieldWidthOwner,
        /* */
        FieldWidthProtection,
        /* */
        FieldWidthRdt,
        /* */
        FieldWidthSize,
        /* count of number of files in listing */
        FileCount,
        /* any bits for the NAM NOP field (e.g. NAM$M_NOCONCEAL) */
        NamNop,
        /* */
        ReadMeFileIndex,
        /* */
        SizeKilo,
        /* buffer for most recent task status */
        TaskStatusBuffer;

   unsigned long  /* for directory module, file's allocated blocks */
                  TotalAllocatedBlocks,
                  /* for directory module, file's used blocks */
                  TotalUsedBlocks;

   char  /* pointer to heap storage URL equivalent of directory */
         *DirectoryPathPtr,
         /* */
         *DirFormatParentDirPath,
         /* pointer to column headings string */
         *LayoutHeadingPtr,
         /* pointer to directory layout string */
         *LayoutPtr,
         /* pointer to sys$fao() directive string */
         *LayoutFaoPtr,
         /* pointer to message string describing subdirectory */
         *MsgSubDirPtr,
         /* pointer to request specified content-type */
         *QueryContentTypePtr;
                  
   char  /* */
         Description [256],
         /* directory part of file specification */
         DirectoryPart [ODS_MAX_FILE_NAME_LENGTH+1],
         /* directory specification */
         DirPath [ODS_MAX_FILE_NAME_LENGTH+1],
         /* directory path specification */
         DirSpec [ODS_MAX_FILE_NAME_LENGTH+1],
         /* file part of file specification */
         FilePart [ODS_MAX_FILE_NAME_LENGTH+1],
         /* query string for directory module */
         QueryString [128],
         /* only when specified as "/dir1/dir2" this contains "./dir2/" */
         RealPath [ODS_MAX_FILE_NAME_LENGTH+1],
         /* prepended script name */
         ScriptName [SCRIPT_NAME_SIZE];

   /* */
   CONTENT_TYPE  ContentInfo;

   /* used for retrieving file size, dates, etc. */
   FILE_QIO  FileAcpData;

   /* "on-disk structure" supporting both ODS-2 and ODS-5 */
   ODS_STRUCT  SearchOds;

   /* pointers to functions, used for specifying the next/AST task */
   REQUEST_AST NextTaskFunction;
   REQUEST_AST DirAccessOkAstFunction;
   REQUEST_AST DirFormatAstFunction;
};

#ifndef __VAX
#   pragma __member_alignment __restore
#endif

/***********************/
/* function prototypes */
/***********************/

DirAccessOk (REQUEST_STRUCT*);
DirAuthorizationAst (REQUEST_STRUCT*);
DirBegin (REQUEST_STRUCT*, REQUEST_AST, char*, char*, char*, BOOL);
DirBeginDirectories (REQUEST_STRUCT*);
DirBeginDirectoriesParseAst (struct FAB*);
DirBeginFiles (REQUEST_STRUCT*);
DirBeginFilesParseAst (struct FAB*);
DirDirectories (struct FAB*);
DirDirectoriesAccessOkAst (REQUEST_STRUCT*);
DirEnd (REQUEST_STRUCT*);
DirEndDescription (REQUEST_STRUCT*);
DirEndOutput (REQUEST_STRUCT*);
DirFiles (struct FAB*);
DirFilePart (REQUEST_STRUCT*);
DirFormat (REQUEST_STRUCT*, REQUEST_AST, char*, BOOL);
DirFormatAcpInfoAst (REQUEST_STRUCT*);
DirFormatLayout (REQUEST_STRUCT*);
DirHeading (REQUEST_STRUCT*);
int DirHttpHeader (REQUEST_STRUCT*);
DirReadMe (REQUEST_STRUCT*, void(*NextTaskFunction)(REQUEST_STRUCT*));
int DirIndexOf (REQUEST_STRUCT*, char*, char*);
DirReadMeTop (REQUEST_STRUCT*);
DirReadMeBottom (REQUEST_STRUCT*);
DirSearchDirectories (REQUEST_STRUCT*);
DirSearchFiles (REQUEST_STRUCT*);

#endif /* DIR_H_LOADED */

/*****************************************************************************/
