O /*****************************************************************************/  /*(                                  Graph.c    M This module provides some core plotting and GIF image functions, and although K it's a slight anomaly, activity statistic recording, for which the graphing M is used to produce a GIF image of server activity used in a simple "snapshot"  report.   G The activity report is potentially JavaScript enhanced. Works well with M Netscape Navigator 3.0ff, slightly less well with Microsoft Internet Explorer J 3.02ff. MSIE 3.02 doesn't seem to honour the "onFocus" and "onBlur" window events.      ACTIVITY STATISTICS NOTES  -------------------------   M Server activity is gathered by accumlating all requests and bytes transmitted I on a per-minute basis, along with the request peak for that minute. These O statistics are kept in a two arrays of longwords, and one shorts for the peaks. O The arrays are sized on a per-day basis, 1440 long/short words per-day, maximum L 28 days (although that's an arbitrary number I can't imagine anyone usefullyK using this facility over a longer period - that becomes the provence of log O analysis tools).  The arrays are stored in a permananet global section allowing M these statistics, and the fact of startups and shutdowns, to be stored across G startups and shutdown.  The index into the array is based on the day of M activity (zero to whatever day it is), plus the hour and minute. Days are the N VMS absolute day (day number from start of epoch). The index into the array isN calculated using a modulas of the day of activity by the number of days in theO array (hence ranges from zero to the number of days in the array) multiplied by M the number of minutes in the day, plus the hour multiplied by sixty, plus the  minute.      ACTIVITY REPORT/PLOT NOTES --------------------------  K Activity statistics are reported/plotted from an absolute day and hour BACK L for a specified number of hours. That is, the date and hour specified is theI date and hour the report/plot ends, the start is calculated as a relative J offset backwards from that. Slightly curious, but the idea was for a quickM snapshot of activity up until the current time, so default behaviour (without J any parameters) is for the current hour, beginning at minute 00 and endingK at minute 59. If a duration is specified it is the number of hours prior to J current time, so a duration of 4 at time 11:15 ranges from 08:00 to 11:59!E If a time is specified then it is the period leading up to that, etc.      GIF/PLOTTING NOTES ------------------  N The plot functions have been designed to be a general as possible, so althoughK only used for activity reports at this stage another HTTPd use may be found   for them sometime in the future!  K NOTE: The GIF functions in this module are not designed to be reentrant and I cannot be used for multi-threaded processing. All processing for a single > request must begin and end before returning from AST delivery.  N The GIF code in these functions is implemented in accordance with Compuserve'sL Graphic Interchange Format Programming Reference specification, version 89a, 31st July 1990.   K The LZW compression employed by the GIF algorithm is implemented using code M derived from the PBM suite. This code is copyright by the original author and N used within the specified licensing conditions, as noted immediately above the applicable functions.   L The graphing functions functions use a lazy and faster approach to plotting.I Although only providing 16 colours (4 bits) it represents each pixel in 8 J bits, thus trading off memory against ease of programming and to a certain extent plotting speed.     VERSION HISTORY  --------------- N 30-OCT-2003  MGD  bugfix; GraphActivityPlotBegin() and GraphActivityDataScan()A                   signed/unsigned issue masking out request value 7 02-APR-2003  MGD  bugfix; GraphActivityClearDay() again 1 15-OCT-2002  MGD  bugfix; GraphActivityClearDay() ? 18-MAY-2002  MGD  activity statistics stored in global section, A                   record/display startup events and peak requests ) 06-JAN-2002  MGD  refine instance support * 05-AUG-2001  MGD  support module WATCHing,0                   bugfix; sscanf() from %d to %uG                   bugfix; provide "elbow-room" in activity data storage 0 09-MAY-2000  MGD  remove keep-alive paraphanelia, 04-MAR-2000  MGD  use NetWriteFaol(), et.al.L 07-JAN-1998  MGD  same bugfix (obviously wasn't); in GraphActivityClearDay()B                   (and a plethora of other annoyances/problems ...A                   bit of a holiday does you the world of good :^) 4 01-DEC-1997  MGD  bugfix; in GraphActivityClearDay()K 18-OCT-1997  MGD  remove dependence on Unix time functions after irritating 0                   experience related to VMS 7.1,M                   add JavaScript-driven descriptions to client-side map links F 01-AUG-1997  MGD  new for v4.3 (hope my plotting functions are not too@                   brain-dead, I'm only a graphics novice, sigh!) */O /*****************************************************************************/    #ifdef WASD_VMS_V6, #undef _VMS_V6_SOURCE
#define _VMS_V6_SOURCE+ #undef __VMS_VER
#define __VMS_VER 60000000 - #undef __CRTL_VER
#define __CRTL_VER 60000000  #endif   /* standard C header files */  #include <ctype.h> #include <errno.h> #include <stdio.h> #include <string.h>  #include <time.h>    /* VMS header files */ #include <secdef.h>  #include <ssdef.h> #include <stsdef.h>    /* application header files */ #include "wasd.h"    #define WASD_MODULE "GRAPH"   ! unsigned char  GraphicRgbRed [] = * { 000, 255, 000, 000, 255, 255, 000, 255, +   192, 128, 000, 000, 128, 128, 128, 250 }; # unsigned char  GraphicRgbGreen [] = ) { 000, 000, 255, 000, 255, 000, 255, 255, +   192, 000, 128, 000, 128, 000, 128, 240 }; " unsigned char  GraphicRgbBlue [] =) { 000, 000, 000, 255, 000, 255, 255, 255, +   192, 000, 000, 128, 000, 128, 128, 230 };    #define JAVASCRIPT_ENABLED 1( #define JAVASCRIPT_ONMOUSEOVER_ENABLED 1    #define ACTIVITY_GRAPH_WIDTH 480! #define ACTIVITY_GRAPH_HEIGHT 200    /******************/ /* global storage */ /******************/   BOOL  GraphDebug = false;    int  ActivityConnectCurrent,      ActivityNumberOfDays,      ActivityTotalMinutes;  $ ACTIVITY_GBLSEC  *ActivityGblSecPtr;   int  GraphAbsDay,       GraphicBitsPerPixel = 4, !      GraphicMaximumHeight = 1000,        GraphicMaximumWidth = 1000;   unsigned short  GraphPrevDate;  D char  ErrorGraphNotInit [] = "Activity statistics not initialized!",.       ErrorGraphPeriod [] = "Period problem.",2       ErrorGraphQuery [] = "Query not understood",.       ErrorGraphFuture [] = "Future history!",8       ErrorGraphHistory [] = "Too far back in history!";   /********************/ /* external storage */ /********************/   #ifdef DBUG  extern BOOL Debug; #else  #define Debug 0  #endif   extern BOOL  CliGblSecDelete,               CliGblSecNoPerm;   " extern int  ActivityGblSecVersion,             GblPageCount,              GblPagePermCount,              GblSectionCount,              GblSectionPermCount,#             InstanceConnectCurrent,               InstanceGroupNumber,              InstanceNodeCurrent;  & extern unsigned long  GblSecPrvMask[],%                       HttpdBinTime[];   & extern unsigned short  HttpdNumTime[];   extern char  ServerHostPort[],              Utility[];    extern CONFIG_STRUCT  Config; # extern HTTPD_PROCESS  HttpdProcess;  extern WATCH_STRUCT  Watch;   O /*****************************************************************************/  /*: Initialize the per-minute activity statistics data arrays.N If only one instance can execute (from configuration) then allocate a block ofM process-local dynamic memory and point to that.  If multiple instances create + and map a global section and point to that.  */     GraphActivityGblSecInit ()   { (    static char  ReportActivityPages [] =: "%!AZ-I-ACTIVITY, !AZ global section of !UL page(let)s\n",*                 ReportActivityWarning [] =C "%!AZ-W-ACTIVITY, error mapping !UL page(let)s (disabled)\n-!&M\n";   ?    /* global, allocate space, system, in page file, writable */ B    static int CreFlags = SEC$M_GBL | SEC$M_EXPREG | SEC$M_SYSGBL |?                          SEC$M_PAGFIL | SEC$M_PERM | SEC$M_WRT; &    static int DelFlags = SEC$M_SYSGBL;>    /* system & owner full access, group and world no access */1    static unsigned long  ProtectionMask = 0xff00; M    /* it is recommended to map into any virtual address in the region (P0) */ 7    static unsigned long  InAddr [2] = { 0x200, 0x200 };       int  status, attempt,         BaseGblSecPages,         BytesRequired,         GblSecPages,         PageCount;    short  ShortLength;    unsigned long  RetAddr [2];    char  GblSecName [32]; +    $DESCRIPTOR (GblSecNameDsc, GblSecName);       /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))M       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "GraphActivityGblSecInit()");   :    WriteFao (GblSecName, sizeof(GblSecName), &ShortLength,B              GBLSEC_NAME_FAO, HTTPD_NAME, ACTIVITY_GBLSEC_VERSION,.              InstanceGroupNumber, "ACTIVITY");,    GblSecNameDsc.dsc$w_length = ShortLength;      if (CliGblSecDelete)     {/       /* delete the specified global section */ +       sys$setprv (1, &GblSecPrvMask, 0, 0); 8       status = sys$dgblsc (DelFlags, &GblSecNameDsc, 0);+       sys$setprv (0, &GblSecPrvMask, 0, 0);        return (status);    }  /    if (Config.cfMisc.ActivityNumberOfDays <= 0)     {         ActivityTotalMinutes = 0; 
       return;     }(    ActivityNumberOfDays = ACTIVITY_DAYS;@    ActivityTotalMinutes = ActivityNumberOfDays * MINUTES_IN_DAY;  /    GblSecPages = sizeof(ACTIVITY_GBLSEC) / 512; *    if (GblSecPages & 0x1ff) GblSecPages++;  1    /* do not create a permanent global section */ 0    if (CliGblSecNoPerm) CreFlags &= ~SEC$M_PERM;  -    for (attempt = 1; attempt <= 2; attempt++)     {0       /* create and/or map the global section */+       sys$setprv (1, &GblSecPrvMask, 0, 0); :       status = sys$crmpsc (&InAddr, &RetAddr, 0, CreFlags,C                            &GblSecNameDsc, 0, 0, 0, GblSecPages, 0, 8                            ProtectionMask, GblSecPages);+       sys$setprv (0, &GblSecPrvMask, 0, 0); 3       PageCount = (RetAddr[1]+1) - RetAddr[0] >> 9; 7       ActivityGblSecPtr = (ACTIVITY_GBLSEC*)RetAddr[0]; :       if (VMSnok (status) || status == SS$_CREATED) break;  E       /* section already exists, break if 'same size' and version! */ %       if (PageCount >= GblSecPages && D           ActivityGblSecPtr->GblSecVersion == ActivityGblSecVersion)          break;   D       /* delete the current global section, have one more attempt */+       sys$setprv (1, &GblSecPrvMask, 0, 0); 8       status = sys$dgblsc (DelFlags, &GblSecNameDsc, 0);+       sys$setprv (0, &GblSecPrvMask, 0, 0);        status = SS$_IDMISMATCH;    }      if (VMSnok (status))     {       /* just disable it */        ActivityTotalMinutes = 0; ,       WriteFaoStdout (ReportActivityWarning,4                       Utility, GblSecPages, status);       return (status);    }      if (status == SS$_CREATED)     {'       /* first time it's been mapped */ J       WriteFaoStdout (ReportActivityPages, Utility, "created", PageCount);2       InstanceMutexLock (INSTANCE_MUTEX_ACTIVITY);5       memset (ActivityGblSecPtr, 0, PageCount * 512); ?       ActivityGblSecPtr->GblSecVersion = ActivityGblSecVersion; 4       sys$gettim (&ActivityGblSecPtr->StartBinTime);/       lib$day (&ActivityGblSecPtr->StartAbsDay, 0                &ActivityGblSecPtr->StartBinTime,0                &ActivityGblSecPtr->StartMinute);<       /* adjust from ten milli-second to one minute units */&       ActivityGblSecPtr->StartMinute =:          ActivityGblSecPtr->StartAbsDay * MINUTES_IN_DAY +/          ActivityGblSecPtr->StartMinute / 6000; 4       InstanceMutexUnLock (INSTANCE_MUTEX_ACTIVITY);    }    else K       WriteFaoStdout (ReportActivityPages, Utility, "existing", PageCount);       if (CliGblSecNoPerm)     {       GblSectionCount++;        GblPageCount += PageCount;    }    else     {       GblSectionPermCount++;$       GblPagePermCount += PageCount;    }      return (status);  }   O /*****************************************************************************/  /*M Called with an absolute VMS day number. Return the day number relative to the I start of activity data collection.  Will be in the range of 0 ... maximum L number of days in the activity data.  If the day specified occurs before theH current day/hour it will be folded back into the data so it is up to the= calling code to ensure reading data from there is legitimate.  */  
 #ifdef __DECC $ #pragma inline(GraphActivityDataIdx) #endif  " unsigned long GraphActivityDataIdx (  unsigned long AbsDay,  unsigned long StartHour  )  {     unsigned long  DataDay;      /*********/    /* begin */    /*********/  +    DataDay = AbsDay % ActivityNumberOfDays;   &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, :                  "GraphActivityDataIdx() !UL !UL !UL !UL",#                  AbsDay, StartHour, L                  DataDay, DataDay*MINUTES_IN_DAY+StartHour*MINUTES_IN_HOUR);  C    return (DataDay * MINUTES_IN_DAY + StartHour * MINUTES_IN_HOUR);  }   O /*****************************************************************************/  /*M Resets to zero the activity request and byte acumulators for all days between + the last day that was cleared and this day.  */   GraphActivityClearDay ()   {     int  idx, status;    unsigned long  AbsDay,                    Day;    unsigned long  BinTime [2];    unsigned short  NumTime [7];       /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))K       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "GraphActivityClearDay()");       sys$gettim (&BinTime); "    lib$day (&AbsDay, &BinTime, 0);  /    InstanceMutexLock (INSTANCE_MUTEX_ACTIVITY);   0    if (AbsDay == ActivityGblSecPtr->ClearAbsDay)    {F       /* just return if there are no intervening days to be cleared */4       InstanceMutexUnLock (INSTANCE_MUTEX_ACTIVITY);
       return;     }  (    Day = ActivityGblSecPtr->ClearAbsDay;    if (!Day) Day = AbsDay;	    Day++;     while (Day <= AbsDay)    {*       idx = GraphActivityDataIdx (Day, 0);4       memset (&ActivityGblSecPtr->ByteCount[idx], 0,6               MINUTES_IN_DAY * sizeof(unsigned long));7       memset (&ActivityGblSecPtr->RequestCount[idx], 0, 6               MINUTES_IN_DAY * sizeof(unsigned long));6       memset (&ActivityGblSecPtr->RequestPeak[idx], 0,7               MINUTES_IN_DAY * sizeof(unsigned short));        Day++;    }+    ActivityGblSecPtr->ClearAbsDay = AbsDay;   6    /* check if the data buffer has "wrapped around" */G    if (AbsDay >= ActivityGblSecPtr->StartAbsDay + ActivityNumberOfDays)     {H       /* yep, data is now available from a new start date at midnight */4       sys$gettim (&ActivityGblSecPtr->StartBinTime);       if (VMSnok (status =J           GraphActivityOffsetTime (-(ActivityTotalMinutes-MINUTES_IN_DAY),P                                    &ActivityGblSecPtr->StartBinTime, &BinTime)))I          ErrorExitVmsStatus (status, "GraphActivityOffsetTime()", FI_LI);   &       sys$numtim (&NumTime, &BinTime);<       NumTime[3] = NumTime[4] = NumTime[5] = NumTime[6] = 0;         if (VMSnok (status =G           lib$cvt_vectim (&NumTime, &ActivityGblSecPtr->StartBinTime))) @          ErrorExitVmsStatus (status, "lib$cvt_vectim()", FI_LI);  /       lib$day (&ActivityGblSecPtr->StartAbsDay, 4                &ActivityGblSecPtr->StartBinTime, 0);  &       ActivityGblSecPtr->StartMinute =9          ActivityGblSecPtr->StartAbsDay * MINUTES_IN_DAY;     }  1    InstanceMutexUnLock (INSTANCE_MUTEX_ACTIVITY);  }   O /*****************************************************************************/  /*. Generally called when concluding each request.' Adjusts per-minute activity statistics.  */  . GraphActivityIncrement (REQUEST_STRUCT *rqptr)   {     int  idx;
    long  Day;       /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))L       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "GraphActivityIncrement()");  %    if (!ActivityTotalMinutes) return;   M    /* save the overhead of the lib$day() call if the date has not changed! */ (    if (HttpdNumTime[2] != GraphPrevDate)    {2       if (GraphPrevDate) GraphActivityClearDay ();/       lib$day (&GraphAbsDay, &HttpdBinTime, 0); &       GraphPrevDate = HttpdNumTime[2];    }  /    InstanceMutexLock (INSTANCE_MUTEX_ACTIVITY);   ,    Day = GraphAbsDay % ActivityNumberOfDays;    idx = Day * MINUTES_IN_DAY + 7          rqptr->rqTime.VmsVector[3] * MINUTES_IN_HOUR + $          rqptr->rqTime.VmsVector[4];:    ActivityGblSecPtr->ByteCount[idx] += rqptr->BytesRawTx;*    ActivityGblSecPtr->RequestCount[idx]++;D    if (ActivityConnectCurrent > ActivityGblSecPtr->RequestPeak[idx])C       ActivityGblSecPtr->RequestPeak[idx] = ActivityConnectCurrent;   &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, F                  "!UL-!UL=!SL !UL !UL !UL !UL[!UL] !UL[!UL] !UL[!UL]",=                  ActivityGblSecPtr->StartAbsDay, GraphAbsDay, >                  ActivityGblSecPtr->StartAbsDay - GraphAbsDay,M                  rqptr->rqTime.VmsVector[3], rqptr->rqTime.VmsVector[4], Day, 8                  ActivityGblSecPtr->ByteCount[idx], idx,K                  ActivityGblSecPtr->RequestCount[idx] & ACTIVITY_MASK, idx, ;                  ActivityGblSecPtr->RequestPeak[idx], idx);   1    InstanceMutexUnLock (INSTANCE_MUTEX_ACTIVITY);  }   O /*****************************************************************************/  /*O Place a high-order bit indicating some server event (startup, shutdown, restart C or error-induced exit) into request storage for the specific second  */  + GraphActivityEvent (unsigned long EventBit)    {     int  idx;
    long  Day;       /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, 7                  "GraphActivityEvent() !&X", EventBit);   %    if (!ActivityTotalMinutes) return;   M    /* save the overhead of the lib$day() call if the date has not changed! */ (    if (HttpdNumTime[2] != GraphPrevDate)    {2       if (GraphPrevDate) GraphActivityClearDay ();/       lib$day (&GraphAbsDay, &HttpdBinTime, 0); &       GraphPrevDate = HttpdNumTime[2];    }  F    /* avoid using a mutex just in case it's the cause of the error! */'    if (EventBit != ACTIVITY_EXIT_ERROR) 2       InstanceMutexLock (INSTANCE_MUTEX_ACTIVITY);  ,    Day = GraphAbsDay % ActivityNumberOfDays;    idx = Day * MINUTES_IN_DAY + =          HttpdNumTime[3] * MINUTES_IN_HOUR + HttpdNumTime[4]; 4    ActivityGblSecPtr->RequestCount[idx] |= EventBit;  '    if (EventBit != ACTIVITY_EXIT_ERROR) 4       InstanceMutexUnLock (INSTANCE_MUTEX_ACTIVITY); }   O /*****************************************************************************/  /*I Scan the specified range in the activity statistics finding the peak-per- I minute and total requests and bytes. Returns the number of minutes in the H specified range, -1 for an error. 'StartAbsDay' is the VMS absolute day,A and 'Hour' the hour of the day (0..23) for the start of the scan. K 'NumberOfHours' specifies the duration of the scan. 'MinuteGranularity', if L greater than one, specifies that the simple mean of the data for that periodH of minutes is to be used as peak values (totals are raw!). This functionE relies on calling functions to ensure the time and range makes sense!  */   int GraphActivityDataScan  (  int StartAbsDay, int StartHour, int NumberOfHours, int MinuteGranularity, BOOL FindMinuteAverage, " unsigned int *PeakPeakRequestsPtr, unsigned int *PeakRequestPtr,  unsigned int *PeakBytePtr,$ unsigned long *QuadTotalRequestsPtr,  unsigned long *QuadTotalBytesPtr )  {     static long  Addx2 = 2;      int  cnt, idx, mcnt;     unsigned int  AbsDay,                  ByteCount, !                  NumberOfMinutes,                   PeakBytes, "                  PeakPeakRequests,                  PeakRequests,                  RequestCount,                  RequestPeak,                   RequestValue;"    unsigned long  QuadScratch [2];      /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, ;                  "GraphActivityDataScan() !UL !UL !UL !UL", K                  StartAbsDay, StartHour, NumberOfHours, MinuteGranularity);   *    if (!ActivityTotalMinutes) return (-1);  M    if (NumberOfHours <= 0 || NumberOfHours > ACTIVITY_DAYS * 24) return (-1);   K    /* ensure any days' data between the last request and now are cleared */     GraphActivityClearDay ();  5    NumberOfMinutes = NumberOfHours * MINUTES_IN_HOUR;   7    idx = GraphActivityDataIdx (StartAbsDay, StartHour);   3    PeakRequests = PeakBytes = PeakPeakRequests = 0; ;    if (QuadTotalBytesPtr) memset (QuadTotalBytesPtr, 0, 8); A    if (QuadTotalRequestsPtr) memset (QuadTotalRequestsPtr, 0, 8);   /    InstanceMutexLock (INSTANCE_MUTEX_ACTIVITY);   D    for (mcnt = 0; mcnt < NumberOfMinutes; mcnt += MinuteGranularity)    {/       if (idx >= ActivityTotalMinutes) idx = 0; L       if (WATCH_MODULE(WATCH_MOD__OTHER) && WATCH_MODULE(WATCH_MOD__DETAIL))I          WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!UL !UL", mcnt, idx);   !       if (MinuteGranularity == 1)        { 7          if (QuadTotalBytesPtr && QuadTotalRequestsPtr) 
          {C             if (QuadScratch[0] = ActivityGblSecPtr->ByteCount[idx]) 
             { "                QuadScratch[1] = 0;9                lib$addx (&QuadScratch, QuadTotalBytesPtr, 4                          QuadTotalBytesPtr, &Addx2);
             }               if (QuadScratch[0] =E                 ActivityGblSecPtr->RequestCount[idx] & ACTIVITY_MASK) 
             { "                QuadScratch[1] = 0;<                lib$addx (&QuadScratch, QuadTotalRequestsPtr,7                          QuadTotalRequestsPtr, &Addx2); 
             } 
          }7          ByteCount = ActivityGblSecPtr->ByteCount[idx]; M          RequestCount = ActivityGblSecPtr->RequestCount[idx] & ACTIVITY_MASK; ;          RequestPeak = ActivityGblSecPtr->RequestPeak[idx];           idx++;        } 
       else       { <          /* find the peak or average of the minute counts */4          RequestCount = ByteCount = RequestPeak = 0;6          for (cnt = 0; cnt < MinuteGranularity; cnt++)
          {:             if (QuadTotalBytesPtr && QuadTotalRequestsPtr)
             { F                if (QuadScratch[0] = ActivityGblSecPtr->ByteCount[idx])                {%                   QuadScratch[1] = 0; <                   lib$addx (&QuadScratch, QuadTotalBytesPtr,7                             QuadTotalBytesPtr, &Addx2);                 }#                if (QuadScratch[0] = H                    ActivityGblSecPtr->RequestCount[idx] & ACTIVITY_MASK)                {%                   QuadScratch[1] = 0; ?                   lib$addx (&QuadScratch, QuadTotalRequestsPtr, :                             QuadTotalRequestsPtr, &Addx2);                }
             } "             if (FindMinuteAverage)
             { >                ByteCount += ActivityGblSecPtr->ByteCount[idx];T                RequestCount += ActivityGblSecPtr->RequestCount[idx] & ACTIVITY_MASK;
             }              else
             { A                if (ActivityGblSecPtr->ByteCount[idx] > ByteCount) @                   ByteCount = ActivityGblSecPtr->ByteCount[idx];C                RequestValue = ActivityGblSecPtr->RequestCount[idx]; J                RequestValue = (unsigned long)RequestValue & ACTIVITY_MASK;L                if (RequestValue > RequestCount) RequestCount = RequestValue;
             } B             if (ActivityGblSecPtr->RequestPeak[idx] > RequestPeak)A                RequestPeak = ActivityGblSecPtr->RequestPeak[idx];              idx++;
          }          if (FindMinuteAverage) 
          {+             ByteCount /= MinuteGranularity; .             RequestCount /= MinuteGranularity;
          }O          if (WATCH_MODULE(WATCH_MOD__OTHER) && WATCH_MODULE(WATCH_MOD__DETAIL)) 5             WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, ;                        "!UL !UL", ByteCount, RequestCount);        }   7       if (ByteCount > PeakBytes) PeakBytes = ByteCount; C       if (RequestCount > PeakRequests) PeakRequests = RequestCount; I       if (RequestPeak > PeakPeakRequests) PeakPeakRequests = RequestPeak;     }  1    InstanceMutexUnLock (INSTANCE_MUTEX_ACTIVITY);   &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, K                  "!UL !UL !UL", PeakRequests, PeakBytes, PeakPeakRequests);       *PeakBytePtr = PeakBytes;"    *PeakRequestPtr = PeakRequests;+    *PeakPeakRequestsPtr = PeakPeakRequests;       return (NumberOfMinutes); }   O /*****************************************************************************/  /*I Round the request and byte maxima up to the next whole digit in the range  (e.g. 8745 to 9000, 320 to 400)  */   GraphActivityMaxima  (  unsigned int *PeakRequestPtr,  unsigned int *MaxRequestPtr, unsigned int *MaxBytePtr )  {     unsigned int  MaxBytes,                  MaxRequests,                   PeakRequests;      /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, O                  "GraphActivityMaxima() !UL !UL", *MaxRequestPtr, *MaxBytePtr);   "    PeakRequests = *PeakRequestPtr;     MaxRequests = *MaxRequestPtr;    MaxBytes = *MaxBytePtr;      if (PeakRequests < 10)        PeakRequests = 10;    else     if (PeakRequests < 100)5       PeakRequests = ((PeakRequests / 10) * 10) + 10;     else     if (PeakRequests < 1000) 8       PeakRequests = ((PeakRequests / 100) * 100) + 100;    else     if (PeakRequests < 10000);       PeakRequests = ((PeakRequests / 1000) * 1000) + 1000;       if (MaxRequests < 10)       MaxRequests = 10;     else     if (MaxRequests < 100) 3       MaxRequests = ((MaxRequests / 10) * 10) + 10;     else     if (MaxRequests < 1000)6       MaxRequests = ((MaxRequests / 100) * 100) + 100;    else     if (MaxRequests < 10000) 9       MaxRequests = ((MaxRequests / 1000) * 1000) + 1000;     else     if (MaxRequests < 100000)<       MaxRequests = ((MaxRequests / 10000) * 10000) + 10000;    else     if (MaxRequests < 1000000) ?       MaxRequests = ((MaxRequests / 100000) * 100000) + 100000;       if (MaxBytes < 10)        MaxBytes = 10;    else     if (MaxBytes < 100)-       MaxBytes = ((MaxBytes / 10) * 10) + 10;     else     if (MaxBytes < 1000) 0       MaxBytes = ((MaxBytes / 100) * 100) + 100;    else     if (MaxBytes < 10000)3       MaxBytes = ((MaxBytes / 1000) * 1000) + 1000;     else     if (MaxBytes < 100000) 6       MaxBytes = ((MaxBytes / 10000) * 10000) + 10000;    else     if (MaxBytes < 1000000)9       MaxBytes = ((MaxBytes / 100000) * 100000) + 100000;     else     if (MaxBytes < 10000000) <       MaxBytes = ((MaxBytes / 1000000) * 1000000) + 1000000;    else     if (MaxBytes < 100000000)?       MaxBytes = ((MaxBytes / 10000000) * 10000000) + 10000000;     else     if (MaxBytes < 1000000000) B       MaxBytes = ((MaxBytes / 100000000) * 100000000) + 100000000;      *MaxBytePtr = MaxBytes;     *MaxRequestPtr = MaxRequests;"    *PeakRequestPtr = PeakRequests; }   O /*****************************************************************************/  /*N Set the offset binary time to the base binary time plus or minus the number of minutes specified. */   int GraphActivityOffsetTime  (  int NumberOfMinutes, unsigned long *BaseBinTimePtr, unsigned long *OffsetBinTimePtr  )  { $    static unsigned long  Addend = 0,/                          OneSecond = -10000000;       int  status;     unsigned long  Minutes,                   Seconds;#    unsigned long  DeltaBinTime [2];       /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, C                  "GraphActivityOffsetTime() !SL", NumberOfMinutes);       if (NumberOfMinutes >= 0)        Minutes = NumberOfMinutes;    else %       Minutes = NumberOfMinutes * -1;     if (Minutes) *       Seconds = Minutes * MINUTES_IN_HOUR;    else        Seconds = 1;  D    status = lib$emul (&Seconds, &OneSecond, &Addend, &DeltaBinTime);C    if (VMSnok (status)) ErrorNoticed (status, "lib$emul()", FI_LI);     if (NumberOfMinutes >= 0)    {O       status = lib$add_times (BaseBinTimePtr, &DeltaBinTime, OffsetBinTimePtr); K       if (VMSnok (status)) ErrorNoticed (status, "lib$add_times()", FI_LI);        return (status);    }    else     {O       status = lib$sub_times (BaseBinTimePtr, &DeltaBinTime, OffsetBinTimePtr); K       if (VMSnok (status)) ErrorNoticed (status, "lib$sub_times()", FI_LI);        return (status);    } }   O /*****************************************************************************/  /*L Generate the HTML activity report page.  The supplied query string specifiesE the END TIME for the the display, NOT THE START.  The period actually N specifies for what duration prior to the specified end time the display should be!   G The JavaScript code activates when a duration-only request is made. The M JavaScript provides an automatic update of the activity report at a frequency L appropriate to the period of the report. If the browser is not in focus thenF the update is not made (at least that's how the script is designed andJ Navigator 3.0 behaves, MSIE 3.02 has still a ways to go :^), it is deferedO until it is brought back into focus. This saves "background" updates that would O essentially be wasted processing and bandwidth. JavaScript 1.1 is required, and O the script is only enabled for versions of Navigator and MSIE that are known to M support the required functionality (primarily the "location.replace" method). M JavaScript may be completely disabled using the JAVASCRIPT_ENABLED define and  recompiling.  L The "uniquifier" performs two tasks.  First, although the images and reportsK are pre-expired MSIE (3.02) continues to use images from the cache over and I again!  Second, it prevents a browser doing a JavaSciprt automatic update A using a cached report or image if the server becomes unavailable.  */     GraphActivityReport  (  REQUEST_STRUCT  *rqptr,  REQUEST_AST NextTaskFunction )  {     static char *MonthName [] =5       { "", "JAN", "FEB", "MAR", "APR", "MAY", "JUN", 7             "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };    char  UpdateJavaScript [] = $ "<SCRIPT LANGUAGE=\"JavaScript\">\n\ <!--\n\  \  var activityUrl = null;\n\ var canDo = false;\n\  var errorOccured = false;\n\ var needsUpdating = false;\n\  var windowInFocus = true;\n\ \  function updatePage()\n\ {\n\    if (windowInFocus)\n\'       location.replace(activityUrl);\n\ 
    else\n\       needsUpdating = true;\n\ }\n\ \  function windowFocus()\n\  {\n\Q    if (canDo && needsUpdating && !errorOccured) location.replace(activityUrl);\n\     windowInFocus = true;\n\  }\n\ \ . function startUpdatePage(Url,updateSeconds)\n\ {\n\    activityUrl = Url;\n\;    if (navigator.appName.substring(0,8) == \"Netscape\")\n\     {\n\ 5        version = parseFloat(navigator.appVersion);\n\ +        if (version >= 3.0) canDo = true;\n\     }\n\ 
    else\n\=    if ((idx = navigator.appVersion.indexOf(\"MSIE\")) > 0)\n\     {\n\        version = parseFloat(\F navigator.appVersion.substring(idx+5,navigator.appVersion.length));\n\+       if (version >= 3.02) canDo = true;\n\     }\n\ R    if (canDo && !errorOccured) setTimeout(\"updatePage()\",updateSeconds*1000);\n\ }\n\ \  function suppressError()\n\  {\n\    errorOccured = true;\n\    return true;\n\ }\n\ \  //-->\n\
 </SCRIPT>\n";   (    static char  OnLoadJavaScriptFao [] =1 " ONLOAD=\"startUpdatePage(\'!AZ?!UL!AZ\',!UL)\"\   ONERROR=\"suppressError()\"\   ONFOCUS=\"windowFocus()\"\ "  ONBLUR=\"windowInFocus = false\"\ \0";       static char  ResponseFao [] =
 "<HTML>\n\	 <HEAD>\n\  !AZ\ !AZ\/ <TITLE>HTTPd !AZ ... Server Activity</TITLE>\n\ 
 </HEAD>\n\ <BODY!AZ!AZ\n\" <H2><NOBR>HTTPd !AZ</NOBR></H2>\n\ <H3>Server Activity!&@</H3>\n\ !20&W\n\ \ 2 <P><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\ \  <TR>\  <TD ALIGN=right>!UL</TD>\  <TD>&nbsp;</TD>\! <TD ALIGN=center COLSPAN=3></TD>\  <TD>&nbsp;</TD>\ <TD ALIGN=left>!UL!AZ</TD>\  </TR>\n\ \  <TR>\  <TD ALIGN=right>!AZ</TD>\  <TD>&nbsp;</TD>\ <TD COLSPAN=3>\ = <IMG WIDTH=!UL HEIGHT=!UL BORDER=0 ALT=\"[activity graph]\" \ ; USEMAP=\"#1\" SRC=\"!AZ?!4ZL!2ZL!2ZL!2ZL+!UL+!UL+!UL!AZ\">\  </TD>\ <TD>&nbsp;</TD>\ <TD ALIGN=left>!AZ</TD>\ </TR>\n\ \  <TR>\  <TD ALIGN=right>!UL</TD>\  <TD>&nbsp;</TD>\G <TD ALIGN=left>&nbsp;&nbsp;<FONT SIZE=-2>!UL-!AZ !2ZL:!2ZL</FONT></TD>\  <TD ALIGN=center></TD>\ H <TD ALIGN=right><FONT SIZE=-2>!UL-!AZ !2ZL:!2ZL</FONT>&nbsp;&nbsp;</TD>\ <TD>&nbsp;</TD>\ <TD ALIGN=left>!UL</TD>\ </TR>\n\ \  </TABLE>\n\  \ 3 <P><TABLE CELLPADDING=3 CELLPSPACING=1 BORDER=0>\n\ B <TR><TH ALIGN=right>Period:</TH><TD>&nbsp;!AZ &nbsp;(!UL hour!%s)\; <TR><TH ALIGN=right>Requests:</TH><TD>&nbsp;!&,@SQ total; \ . &nbsp;!&,UL max; &nbsp;!&,UL peak</TD></TR>\n\8 <TR><TH ALIGN=right>Bytes:</TH><TD>&nbsp;!&,@SQ total; \ &nbsp;!&,UL max</TD></TR>\n\ <TR><TH></TH>\K <TD ALIGN=left>&nbsp;<FONT SIZE=-2>(Data available from !17&W)</FONT></TD>\  </TR>\n\ </TABLE>\n\  <MAP NAME=\"1\">\n";      static char  AreaFao [] =2 "<AREA SHAPE=\"rect\" COORDS=\"!UL,!UL,!UL,!UL\" \) HREF=\"!AZ?!4ZL!2ZL!2ZL!2ZL+!UL\"!AZ>\n";       static char  EndPageFao [] = 
 "</MAP>\n\
 </BODY>\n\ </HTML>\n";   6    static char  MultipleDaysFao [] = "!17&W to !17&W";;    static char  UniquifierFao [] = "+!2ZL!2ZL!2ZL!2ZL!2ZL"; :    static char  WithinOneDayFao [] = "!17&W to !2ZL:!2ZL";      BOOL  FindMinuteAverage,           JavaScriptEnabled,           HourSupplied;    int  status,          AdminInstanceCount,          AtX,         Bytes,         ColumnWidth,         Count,         Day,         GraphHeight,         GraphWidth, 
         Hour,          IncrementMinutes,          JavaScriptUniquifier,          MapSections,         MinuteGranularity,         Minutes,         Month,         NodeInstanceCount,         NumberOfDays,          NumberOfHours,         NumberOfMinutes,         PeriodHours,         StartHour,         UpdateSeconds,
         Year;     unsigned short  Length;&    unsigned short  CurrentNumTime [7],"                    EndNumTime [7],                    NumTime [7], $                    StartNumTime [7];    unsigned long  AbsDay,                     CurrentAbsDay,                    CurrentMinute,                    CurrentSecond,                   EndMinute,                   EndSecond,                   MaxBytes,                    MaxRequests,                   MaxPeak,                   Minute, '                   TenmSecSinceMidnight,                    PeakBytes,                   PeakRequests, #                   PeakPeakRequests,                    StartAbsDay,                   Second;     unsigned long  *vecptr;!    unsigned long  FaoVector [64];     unsigned long  BinTime [2],%                   CurrentBinTime [2], !                   EndBinTime [2], #                   StartBinTime [2], +                   EndThisPeriodBinTime [2], %                   QuadTotalBytes [2], (                   QuadTotalRequests [2];    char  *cptr,           *BytesPtr,           *EndPtr,           *HoursPtr,           *NodeInstancePtr,          *StartPtr;     char  DeltaTime [32],           OnLoadJavaScript [256],          Period [128],          Uniquifier [16]; )    $DESCRIPTOR (DeltaTimeDsc, DeltaTime); #    $DESCRIPTOR (PeriodDsc, Period);       /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, @                  "GraphActivityReport() !&A", NextTaskFunction);      if (!ActivityTotalMinutes)     {)       rqptr->rqResponse.HttpStatus = 500; 5       ErrorGeneral (rqptr, ErrorGraphNotInit, FI_LI); *       SysDclAst (NextTaskFunction, rqptr);
       return;     }      JavaScriptEnabled = false;       /**************************/     /* parse the query string */     /**************************/       HourSupplied = false;H    Year = Month = Day = Hour = NumberOfHours = JavaScriptUniquifier = 0;)    if (rqptr->rqHeader.QueryStringPtr[0])     {<       if (isdigit(*(cptr = rqptr->rqHeader.QueryStringPtr)))       { +          /* "keyword"-based query string */ '          while (isdigit(*cptr)) cptr++; 8          if (cptr <= rqptr->rqHeader.QueryStringPtr + 3)
          {D             /* assume just a duration (and possibly a uniquifier) */<             sscanf (rqptr->rqHeader.QueryStringPtr, "%u+%u",;                     &NumberOfHours, &JavaScriptUniquifier);   D             /* enable JavaScript for duration-only based requests */=             if (JAVASCRIPT_ENABLED) JavaScriptEnabled = true; 
          }
          else J          if (sscanf (rqptr->rqHeader.QueryStringPtr, "%4u%2u%2u%2u+%u+%u",@                      &Year, &Month, &Day, &Hour, &NumberOfHours,0                      &JavaScriptUniquifier) < 5)
          {/             rqptr->rqResponse.HttpStatus = 400; 9             ErrorGeneral (rqptr, ErrorGraphQuery, FI_LI); 0             SysDclAst (NextTaskFunction, rqptr);             return; 
          }
          else               HourSupplied = true;       } 
       else       { (          /* "form"-based query string */          while (*cptr)
          {)             if (strsame (cptr, "yr=", 3)) #                Year = atoi(cptr+3);              else)             if (strsame (cptr, "mn=", 3)) $                Month = atoi(cptr+3);             else)             if (strsame (cptr, "dy=", 3)) "                Day = atoi(cptr+3);             else)             if (strsame (cptr, "hr=", 3)) 
             { #                Hour = atoi(cptr+3); #                HourSupplied = true; 
             }              else)             if (strsame (cptr, "du=", 3)) ,                NumberOfHours = atoi(cptr+3);             else
             { 2                rqptr->rqResponse.HttpStatus = 400;<                ErrorGeneral (rqptr, ErrorGraphQuery, FI_LI);3                SysDclAst (NextTaskFunction, rqptr);                 return;
             } 1             while (*cptr && *cptr != '&') cptr++;              if (*cptr) cptr++;
          }  >          /* disable javascript for specific-period requests */#          JavaScriptEnabled = false;        }     }  &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, 3                  "!UL/!UL/!UL:!UL !UL !UL !UL !UL", 7                  Year, Month, Day, Hour, NumberOfHours, 6                  PeakRequests, MaxRequests, MaxBytes);      /***********/    /* process */    /***********/      FindMinuteAverage = false;   )    GraphWidth = ACTIVITY_GRAPH_WIDTH + 2; +    GraphHeight = ACTIVITY_GRAPH_HEIGHT + 2;        sys$gettim (&CurrentBinTime);1    sys$numtim (&CurrentNumTime, &CurrentBinTime); 0    lib$day (&CurrentAbsDay, &CurrentBinTime, 0);  6    /* defaults for any time components not supplied */'    if (!Year) Year = CurrentNumTime[0]; )    if (!Month) Month = CurrentNumTime[1]; %    if (!Day) Day = CurrentNumTime[2]; 8    if (!Hour && !HourSupplied) Hour = CurrentNumTime[3];)    if (!NumberOfHours) NumberOfHours = 1;   G    /* make it a multiple of 4 (which divides the graph up nicely :^) */ D    if (NumberOfHours > 2) while (NumberOfHours % 4) NumberOfHours++;5    NumberOfMinutes = NumberOfHours * MINUTES_IN_HOUR; &    if (WATCH_MODULE(WATCH_MOD__OTHER))H       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!UL", NumberOfMinutes);      EndNumTime[0] = Year;    EndNumTime[1] = Month;     EndNumTime[2] = Day;     EndNumTime[3] = Hour;+    /* always ends after the 59th minute! */     EndNumTime[4] = 59;%    EndNumTime[5] = EndNumTime[6] = 0;   C    if (VMSnok (status = lib$cvt_vectim (&EndNumTime, &EndBinTime)))     {)       rqptr->rqResponse.HttpStatus = 400; 4       ErrorGeneral (rqptr, ErrorGraphPeriod, FI_LI);*       SysDclAst (NextTaskFunction, rqptr);
       return;     }  H    /* get the start time as the number of minutes before the end time */    if (VMSnok (status = 5        GraphActivityOffsetTime (-(NumberOfMinutes-1), =                                 &EndBinTime, &StartBinTime)))     {)       rqptr->rqResponse.HttpStatus = 400; 4       ErrorGeneral (rqptr, ErrorGraphPeriod, FI_LI);*       SysDclAst (NextTaskFunction, rqptr);
       return;     }  B    if (VMSnok (status = lib$day (&StartAbsDay, &StartBinTime, 0)))    {)       rqptr->rqResponse.HttpStatus = 400; 4       ErrorGeneral (rqptr, ErrorGraphPeriod, FI_LI);*       SysDclAst (NextTaskFunction, rqptr);
       return;     }  -    sys$numtim (&StartNumTime, &StartBinTime);     StartHour = StartNumTime[3];   &    if (WATCH_MODULE(WATCH_MOD__OTHER))B       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!UL !UL !UL !UL",-                  CurrentAbsDay,  StartAbsDay, /                  CurrentNumTime[3], StartHour);   :    if (CurrentAbsDay - StartAbsDay > ActivityNumberOfDays)    {)       rqptr->rqResponse.HttpStatus = 400; 5       ErrorGeneral (rqptr, ErrorGraphHistory, FI_LI); *       SysDclAst (NextTaskFunction, rqptr);
       return;     }  %    if (StartAbsDay > CurrentAbsDay || G        (StartAbsDay == CurrentAbsDay && StartHour > CurrentNumTime[3]))     {)       rqptr->rqResponse.HttpStatus = 400; 4       ErrorGeneral (rqptr, ErrorGraphFuture, FI_LI);*       SysDclAst (NextTaskFunction, rqptr);
       return;     }      /***********************/    /* make some estimates */    /***********************/      /* width of the bar graph */ 8    ColumnWidth = (GraphWidth-2) / (NumberOfMinutes * 2);%    if (!ColumnWidth) ColumnWidth = 1;   M    /* calculate simple mean for this number of minutes when duration large */     MinuteGranularity =L       (int)(1.0 / ((float)(GraphWidth-2) / ((float)NumberOfMinutes * 2.0)));1    if (!MinuteGranularity) MinuteGranularity = 1;   &    if (WATCH_MODULE(WATCH_MOD__OTHER)):       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!UL !UL",1                  ColumnWidth, MinuteGranularity);   @    GraphActivityDataScan (StartAbsDay, StartHour, NumberOfHours,?                           MinuteGranularity, FindMinuteAverage, G                           &PeakPeakRequests, &PeakRequests, &PeakBytes, ?                           &QuadTotalRequests, &QuadTotalBytes);       MaxBytes = PeakBytes;    MaxRequests = PeakRequests;    MaxPeak = PeakPeakRequests;;    GraphActivityMaxima (&MaxPeak, &MaxRequests, &MaxBytes);       if (MaxBytes < 1000)     {       Bytes = MaxBytes;        BytesPtr = "";    }    else     if (MaxBytes < 1000000)    {       Bytes = MaxBytes / 1000;       BytesPtr = " K";    }    else     {!       Bytes = MaxBytes / 1000000;        BytesPtr = " M";    }  *    if (StartNumTime[0] != EndNumTime[0] ||*        StartNumTime[1] != EndNumTime[1] ||(        StartNumTime[2] != EndNumTime[2])7       status = WriteFao (Period, sizeof(Period), NULL,  F                          MultipleDaysFao, &StartBinTime, &EndBinTime);    else 7       status = WriteFao (Period, sizeof(Period), NULL,  8                          WithinOneDayFao, &StartBinTime,7                          EndNumTime[3], EndNumTime[4]); C    if (VMSnok (status)) ErrorNoticed (status, "WriteFao()", FI_LI);       /**********************/     /* generate HTML page */     /**********************/       if (NumberOfHours <= 4)    {.       UpdateSeconds = 60 - CurrentNumTime[5]; 2       if (UpdateSeconds < 45) UpdateSeconds += 60;    }    else     if (NumberOfHours <= 8)/       UpdateSeconds = 120 - CurrentNumTime[5];      else     if (NumberOfHours <= 24) /       UpdateSeconds = 300 - CurrentNumTime[5];      else 0       UpdateSeconds = 3600 - CurrentNumTime[5]; *    /* six seconds before the new minute */    UpdateSeconds -= 5;      vecptr = FaoVector;!    *vecptr++ = CurrentNumTime[1]; !    *vecptr++ = CurrentNumTime[2]; !    *vecptr++ = CurrentNumTime[3]; !    *vecptr++ = CurrentNumTime[4]; !    *vecptr++ = CurrentNumTime[5]; <    status = WriteFaol (Uniquifier, sizeof(Uniquifier), NULL,2                        UniquifierFao, &FaoVector);D    if (VMSnok (status)) ErrorNoticed (status, "WriteFaol()", FI_LI);      if (JavaScriptEnabled)     {       vecptr = FaoVector; (       *vecptr++ = ADMIN_REPORT_ACTIVITY;        *vecptr++ = NumberOfHours;       *vecptr++ = Uniquifier;         *vecptr++ = UpdateSeconds;  K       status = WriteFaol (OnLoadJavaScript, sizeof(OnLoadJavaScript), NULL, ;                           OnLoadJavaScriptFao, &FaoVector); 5       if (VMSnok (status) || status == SS$_BUFFEROVF)        { 5          ErrorNoticed (status, "WriteFaol()", FI_LI); 8          rqptr->rqResponse.ErrorTextPtr = "WriteFaol()";/          ErrorVmsStatus (rqptr, status, FI_LI); -          SysDclAst (NextTaskFunction, rqptr);           return;       }     }  P    NodeInstanceCount = InstanceLockList (INSTANCE_NODE, "\n", &NodeInstancePtr);H    AdminInstanceCount = AdminMenuInstanceCount (rqptr, NodeInstancePtr);  3    rqptr->rqResponse.PreExpired = PRE_EXPIRE_ADMIN; $    RESPONSE_HEADER_200_HTML (rqptr);      vecptr = FaoVector;  *    *vecptr++ = HtmlMetaInfo (rqptr, NULL);    if (JavaScriptEnabled) #       *vecptr++ = UpdateJavaScript;     else        *vecptr++ = "";     *vecptr++ = ServerHostPort;    if (JavaScriptEnabled) #       *vecptr++ = OnLoadJavaScript;     else        *vecptr++ = ""; 2    /* bit of a kludge ;^) skip over the "<BODY" */0    *vecptr++ = Config.cfServer.AdminBodyTag + 5;    *vecptr++ = ServerHostPort;    if (InstanceNodeCurrent > 1)     {*       if (rqptr->ServicePtr->AdminService)*          *vecptr++ = " &nbsp;-&nbsp; !AZ";
       else*          *vecptr++ = "&nbsp;&nbsp; (!AZ)";&       *vecptr++ = HttpdProcess.PrcNam;    }    else        *vecptr++ = "";   '    *vecptr++ = &rqptr->rqTime.Vms64bit;       *vecptr++ = MaxRequests;     *vecptr++ = Bytes;     *vecptr++ = BytesPtr;    *vecptr++ =- "<FONT COLOR=\"#0000ff\">Requests</FONT><BR>\ 2 <FONT SIZE=-1 COLOR=\"#ff0000\">(mean)</FONT><BR>\- <FONT SIZE=-3>per-minute</FONT>";                 *vecptr++ = GraphWidth;    *vecptr++ = GraphHeight; &    *vecptr++ = ADMIN_GRAPHIC_ACTIVITY;    *vecptr++ = Year;    *vecptr++ = Month;     *vecptr++ = Day;     *vecptr++ = Hour;    *vecptr++ = NumberOfHours;     *vecptr++ = MaxRequests;     *vecptr++ = MaxBytes;    *vecptr++ = Uniquifier;    *vecptr++ =* "<FONT COLOR=\"#00bbbb\">Bytes</FONT><BR>\2 <FONT SIZE=-1 COLOR=\"#ff66ff\">(mean)</FONT><BR>\! <FONT SIZE=-3>per-minute</FONT>";     *vecptr++ = 0;       *vecptr++ = StartNumTime[2]; *    *vecptr++ = MonthName[StartNumTime[1]];    *vecptr++ = StartNumTime[3];     *vecptr++ = StartNumTime[4];       *vecptr++ = EndNumTime[2]; (    *vecptr++ = MonthName[EndNumTime[1]];    *vecptr++ = EndNumTime[3];     *vecptr++ = EndNumTime[4];       *vecptr++ = 0;       *vecptr++ = Period;    *vecptr++ = NumberOfHours; "    *vecptr++ = &QuadTotalRequests;    *vecptr++ = PeakRequests;     *vecptr++ = PeakPeakRequests;    *vecptr++ = &QuadTotalBytes;     *vecptr++ = PeakBytes;   0    *vecptr++ = &ActivityGblSecPtr->StartBinTime;  :    status = NetWriteFaol (rqptr, ResponseFao, &FaoVector);G    if (VMSnok (status)) ErrorNoticed (status, "NetWriteFaol()", FI_LI);       /*************************/    /* image map coordinates */    /*************************/  %    NumberOfDays = NumberOfHours / 24;     if (NumberOfDays > 1)    {!       MapSections = NumberOfDays; (       IncrementMinutes = MINUTES_IN_DAY;    }    else     {"       MapSections = NumberOfHours;)       IncrementMinutes = MINUTES_IN_HOUR;     }    Minute = 0;      if (NumberOfHours > 1)     {#       /***************************/ #       /* reduce period map areas */ #       /***************************/          switch (NumberOfHours)       { -          case 1 : { PeriodHours = 1; break; } -          case 2 : { PeriodHours = 1; break; } -          case 4 : { PeriodHours = 2; break; } .          case 12 : { PeriodHours = 4; break; }/          case 24 : { PeriodHours = 12; break; } /          case 72 : { PeriodHours = 24; break; } 0          case 168 : { PeriodHours = 72; break; }1          case 672 : { PeriodHours = 168; break; } 3          default : PeriodHours = NumberOfHours / 2;        } (       if (!PeriodHours) PeriodHours = 1;         if (VMSnok (status =2           GraphActivityOffsetTime (PeriodHours*60,L                                    &CurrentBinTime, &EndThisPeriodBinTime)))       { /          ErrorVmsStatus (rqptr, status, FI_LI); -          SysDclAst (NextTaskFunction, rqptr);           return;       }          Count = 0;!       while (Count < MapSections)        { L          AtX = (int)((float)Count * (float)GraphWidth / (float)MapSections);          Count++; $          Minute += IncrementMinutes;  9          /* 'BinTime' will contain the period end time */           if (VMSnok (status = J              GraphActivityOffsetTime (Minute-1, &StartBinTime, &BinTime)))
          {2             ErrorVmsStatus (rqptr, status, FI_LI);0             SysDclAst (NextTaskFunction, rqptr);             return; 
          }            /* H             If this period end time is later than server start time, andI             the end time is earlier than the end of this period, then ...           */ S          if (CompareVmsBinTimes (&BinTime, &ActivityGblSecPtr->StartBinTime) > 0 && M              CompareVmsBinTimes (&CurrentBinTime, &EndThisPeriodBinTime) < 0)           {              ,             sys$numtim (&NumTime, &BinTime);               vecptr = FaoVector;              *vecptr++ = AtX;(             *vecptr++ = GraphHeight / 2;9             *vecptr++ = AtX + (GraphWidth / MapSections); $             *vecptr++ = GraphHeight;.             *vecptr++ = ADMIN_REPORT_ACTIVITY;#             *vecptr++ = NumTime[0]; #             *vecptr++ = NumTime[1]; #             *vecptr++ = NumTime[2]; #             *vecptr++ = NumTime[3]; $             *vecptr++ = PeriodHours;D             /* enable JavaScript for duration-only based requests *//             if (JAVASCRIPT_ONMOUSEOVER_ENABLED) L                *vecptr++ = GraphActivityOnMouseOver (&BinTime, PeriodHours);             else                *vecptr++ = "";  ?             status = NetWriteFaol (rqptr, AreaFao, &FaoVector); P             if (VMSnok (status)) ErrorNoticed (status, "NetWriteFaol()", FI_LI);
          }       }     }      /************************/     /* less recent map area */     /************************/   P    if (CompareVmsBinTimes (&StartBinTime, &ActivityGblSecPtr->StartBinTime) > 0)    {       if (VMSnok (status =C          GraphActivityOffsetTime (-(NumberOfHours*MINUTES_IN_HOUR), :                                   &EndBinTime, &BinTime)))       { /          ErrorVmsStatus (rqptr, status, FI_LI); -          SysDclAst (NextTaskFunction, rqptr);           return;       } &       sys$numtim (&NumTime, &BinTime);         vecptr = FaoVector;        *vecptr++ = 0;       *vecptr++ = 0;!       *vecptr++ = GraphWidth / 4; "       *vecptr++ = GraphHeight / 2;(       *vecptr++ = ADMIN_REPORT_ACTIVITY;       *vecptr++ = NumTime[0];        *vecptr++ = NumTime[1];        *vecptr++ = NumTime[2];        *vecptr++ = NumTime[3];         *vecptr++ = NumberOfHours;)       if (JAVASCRIPT_ONMOUSEOVER_ENABLED) H          *vecptr++ = GraphActivityOnMouseOver (&BinTime, NumberOfHours);
       else          *vecptr++ = "";  9       status = NetWriteFaol (rqptr, AreaFao, &FaoVector); J       if (VMSnok (status)) ErrorNoticed (status, "NetWriteFaol()", FI_LI);    }  +    if (NumberOfDays < ActivityNumberOfDays)     {$       /****************************/$       /* increase period map area */$       /****************************/         switch (NumberOfHours)       { -          case 1 : { PeriodHours = 2; break; } -          case 2 : { PeriodHours = 4; break; } .          case 4 : { PeriodHours = 12; break; }/          case 12 : { PeriodHours = 24; break; } /          case 24 : { PeriodHours = 72; break; } 0          case 72 : { PeriodHours = 168; break; }1          case 168 : { PeriodHours = 672; break; } 3          default : PeriodHours = NumberOfHours * 2;        } 2       if (PeriodHours > ActivityNumberOfDays * 24)1          PeriodHours = ActivityNumberOfDays * 24;          vecptr = FaoVector; !       *vecptr++ = GraphWidth / 4;        *vecptr++ = 0;2       *vecptr++ = GraphWidth / 2 + GraphWidth / 4;"       *vecptr++ = GraphHeight / 2;(       *vecptr++ = ADMIN_REPORT_ACTIVITY;        *vecptr++ = EndNumTime[0];        *vecptr++ = EndNumTime[1];        *vecptr++ = EndNumTime[2];        *vecptr++ = EndNumTime[3];       *vecptr++ = PeriodHours;)       if (JAVASCRIPT_ONMOUSEOVER_ENABLED) I          *vecptr++ = GraphActivityOnMouseOver (&EndBinTime, PeriodHours); 
       else          *vecptr++ = "";  9       status = NetWriteFaol (rqptr, AreaFao, &FaoVector); J       if (VMSnok (status)) ErrorNoticed (status, "NetWriteFaol()", FI_LI);    }      /************************/     /* more recent map area */     /************************/   =    if (CompareVmsBinTimes (&CurrentBinTime, &EndBinTime) > 0)     {       if (VMSnok (status =@          GraphActivityOffsetTime (NumberOfHours*MINUTES_IN_HOUR,:                                   &EndBinTime, &BinTime)))       { /          ErrorVmsStatus (rqptr, status, FI_LI); -          SysDclAst (NextTaskFunction, rqptr);           return;       } &       sys$numtim (&NumTime, &BinTime);         vecptr = FaoVector; 2       *vecptr++ = GraphWidth / 2 + GraphWidth / 4;       *vecptr++ = 0;       *vecptr++ = GraphWidth; "       *vecptr++ = GraphHeight / 2;(       *vecptr++ = ADMIN_REPORT_ACTIVITY;       *vecptr++ = NumTime[0];        *vecptr++ = NumTime[1];        *vecptr++ = NumTime[2];        *vecptr++ = NumTime[3];         *vecptr++ = NumberOfHours;)       if (JAVASCRIPT_ONMOUSEOVER_ENABLED) H          *vecptr++ = GraphActivityOnMouseOver (&BinTime, NumberOfHours);
       else          *vecptr++ = "";  9       status = NetWriteFaol (rqptr, AreaFao, &FaoVector); J       if (VMSnok (status)) ErrorNoticed (status, "NetWriteFaol()", FI_LI);    }      /************/     /* end page */     /************/   3    status = NetWriteFaol (rqptr, EndPageFao, NULL); G    if (VMSnok (status)) ErrorNoticed (status, "NetWriteFaol()", FI_LI);   '    SysDclAst (NextTaskFunction, rqptr);  }   O /*****************************************************************************/  /* */   char* GraphActivityOnMouseOver (  unsigned long *EndBinTimePtr,  int NumberOfHours  )  { $    static char  OnMouseOverFao [] = C " ONMOUSEOVER=\"window.status=\'!17%D  to  !17%D  (!UL hour!%s)\';\   return true\"\ 4  ONMOUSEOUT=\"window.status=\'\'\; return true\"\0",$                OnMouseOverError [] =9 " ONMOUSEOVER=\"window.status=\'*ERROR*\'; return true\"\ 1  ONMOUSEOUT=\"window.status=\'\'\ return true\"";   "    static char  OnMouseOver [256];      int  status;     unsigned long  *vecptr;#    unsigned long  StartBinTime [2];      unsigned long  FaoVector [8];      /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))/       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, B                  "GraphActivityOnMouseOver() !SL", NumberOfHours);      if (VMSnok (status = C        GraphActivityOffsetTime (-(NumberOfHours*MINUTES_IN_HOUR-1), ?                                 EndBinTimePtr, &StartBinTime)))         return (OnMouseOverError);      vecptr = FaoVector;    *vecptr++ = &StartBinTime;     *vecptr++ = EndBinTimePtr;     *vecptr++ = NumberOfHours; >    status = WriteFaol (OnMouseOver, sizeof(OnMouseOver), NULL,3                        OnMouseOverFao, &FaoVector); 2    if (VMSnok (status) || status == SS$_BUFFEROVF)    {G       if (VMSnok (status)) ErrorNoticed (status, "WriteFaol()", FI_LI);         return (OnMouseOverError);    }  I    if (WATCH_MODULE(WATCH_MOD__OTHER) && WATCH_MODULE(WATCH_MOD__DETAIL)) D       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!AZ", OnMouseOver);    return (OnMouseOver); }   O /*****************************************************************************/  /*I Generate the activity graph GIF.  An <IMG...> tag in the HTML report page & results in this function begin called. */   GraphActivityPlotBegin (  REQUEST_STRUCT  *rqptr,  REQUEST_AST NextTaskFunction )  { ?    static $DESCRIPTOR (DeltaTimeFaoDsc, "!UL !2ZL:!2ZL:00.00");       BOOL  EventStartup,          EventExit,           EventExitError,          EventDelPrc,           FindMinuteAverage,           HourSupplied;    int  cnt, idx, mcnt,          status,          AbsDay,          AtX,         AxisBytes,         AxisRequests,          ByteCount,         ByteHeight,          ByteMean,          ByteTotal,         ColourAxis,          ColourByte,          ColourByteMean,          ColourNoData,          ColourRequest,         ColourRequestMean,         ColourRequestPeak,         ColourDelPrc,          ColourExit,          ColourExitError,         ColourStartup,         ColumnWidth,         CurrentMinute,         Day,         DisplayMean,         GraphHeight,         GraphWidth, 
         Hour,          MinuteGranularity,         Month,         NumberOfHours,         NumberOfDays,          NumberOfMinutes,         PeakHeight,          PrevAtX,         PrevByteMean,          PrevRequestMean,         RequestCount,          RequestHeight,         RequestMean,         RequestTotal,          RequestValue,          SampleCount,         StartHour,
         Year; !    unsigned long  AbsActivityDay,                     CurrentAbsDay,                   DeltaDays,                   DeltaHours,                    DeltaMinutes,                    EndMinute,                   EndSecond,                   MaxBytes,                    MaxRequests,                   MaxPeak,                   RequestPeak,                   PeakBytes,                   PeakRequests, #                   PeakPeakRequests,                    StartAbsDay,                   StartMinute,                   StartSecond,                   Minute; !    unsigned long  FaoVector [32];     unsigned long  BinTime [2],%                   CurrentBinTime [2], !                   EndBinTime [2], #                   StartBinTime [2]; &    unsigned short  CurrentNumTime [7],"                    EndNumTime [7],                    NumTime [7], $                    StartNumTime [7];    float  ByteFactor,            RequestFactor;    char  *cptr;     char  DeltaTime [32];    GRAPH_STRUCT *grptr;     GRAPH_TASK  *tkptr;)    $DESCRIPTOR (DeltaTimeDsc, DeltaTime);       /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))L       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "GraphActivityPlotBegin()");      if (!ActivityTotalMinutes)     {)       rqptr->rqResponse.HttpStatus = 500; 5       ErrorGeneral (rqptr, ErrorGraphNotInit, FI_LI); *       SysDclAst (NextTaskFunction, rqptr);
       return;     }      /**************************/     /* parse the query string */     /**************************/       HourSupplied = false;J    Year = Month = Day = Hour = NumberOfHours = MaxRequests = MaxBytes = 0;)    if (rqptr->rqHeader.QueryStringPtr[0])     {,       cptr = rqptr->rqHeader.QueryStringPtr;       if (isdigit(*cptr))        { +          /* "keyword"-based query string */            if (strlen (cptr) <= 3)
          {:             /* assume just a duration has been supplied */'             NumberOfHours = atoi(cptr); 
          }
          else 3          if (sscanf (cptr, "%4u%2u%2u%2u+%u+%u+%u", @                      &Year, &Month, &Day, &Hour, &NumberOfHours,3                      &MaxRequests, &MaxBytes) != 7) 
          {/             rqptr->rqResponse.HttpStatus = 400; 9             ErrorGeneral (rqptr, ErrorGraphQuery, FI_LI); 0             SysDclAst (NextTaskFunction, rqptr);             return; 
          }
          else               HourSupplied = true;       } 
       else       { (          /* "form"-based query string */          while (*cptr)
          {)             if (strsame (cptr, "yr=", 3)) #                Year = atoi(cptr+3);              else)             if (strsame (cptr, "mn=", 3)) $                Month = atoi(cptr+3);             else)             if (strsame (cptr, "dy=", 3)) "                Day = atoi(cptr+3);             else)             if (strsame (cptr, "hr=", 3)) 
             { #                Hour = atoi(cptr+3); #                HourSupplied = true; 
             }              else)             if (strsame (cptr, "du=", 3)) 5                sscanf (cptr+3, "%u", &NumberOfHours);              else)             if (strsame (cptr, "mr=", 3)) 3                sscanf (cptr+3, "%u", &MaxRequests);              else)             if (strsame (cptr, "mb=", 3)) 0                sscanf (cptr+3, "%u", &MaxBytes);             else
             { 2                rqptr->rqResponse.HttpStatus = 400;<                ErrorGeneral (rqptr, ErrorGraphQuery, FI_LI);3                SysDclAst (NextTaskFunction, rqptr);                 return;
             } 1             while (*cptr && *cptr != '&') cptr++;              if (*cptr) cptr++;
          }       }     }  &    if (WATCH_MODULE(WATCH_MOD__OTHER))N       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!UL/!UL/!UL:!UL !UL !UL !UL",O                  Year, Month, Day, Hour, NumberOfHours, MaxRequests, MaxBytes);       /**************************/     /* create graph structure */     /**************************/   ?    /* set up the task structure (only ever one per request!) */      rqptr->GraphTaskPtr = tkptr =9       (GRAPH_TASK*)VmGetHeap (rqptr, sizeof(GRAPH_TASK)); .    tkptr->NextTaskFunction = NextTaskFunction;  5    /* allocate heap memory for the graph structure */ *    grptr = rqptr->GraphTaskPtr->GraphPtr =>        (GRAPH_STRUCT*)VmGetHeap (rqptr, sizeof(GRAPH_STRUCT));      /***********/    /* process */    /***********/      FindMinuteAverage = false;   )    GraphWidth = ACTIVITY_GRAPH_WIDTH + 2; +    GraphHeight = ACTIVITY_GRAPH_HEIGHT + 2;       ColourAxis= COLOUR_BLACK;    ColourByte = COLOUR_CYAN;    ColourNoData = COLOUR_GREY;    ColourRequest = COLOUR_BLUE; #    ColourByteMean = COLOUR_MAGENTA; "    ColourRequestMean = COLOUR_RED;$    ColourRequestPeak = COLOUR_WHITE;      ColourDelPrc = COLOUR_BLACK;     ColourExit = COLOUR_GREY;     ColourExitError = COLOUR_RED;     ColourStartup = COLOUR_GREEN;       sys$gettim (&CurrentBinTime);1    sys$numtim (&CurrentNumTime, &CurrentBinTime); 0    lib$day (&CurrentAbsDay, &CurrentBinTime, 0);  6    /* defaults for any time components not supplied */'    if (!Year) Year = CurrentNumTime[0]; )    if (!Month) Month = CurrentNumTime[1]; %    if (!Day) Day = CurrentNumTime[2]; 8    if (!Hour && !HourSupplied) Hour = CurrentNumTime[3];)    if (!NumberOfHours) NumberOfHours = 1;   G    /* make it a multiple of 4 (which divides the graph up nicely :^) */     if (NumberOfHours > 2) 0       while (NumberOfHours % 4) NumberOfHours++;5    NumberOfMinutes = NumberOfHours * MINUTES_IN_HOUR;       EndNumTime[0] = Year;    EndNumTime[1] = Month;     EndNumTime[2] = Day;     EndNumTime[3] = Hour;+    /* always ends after the 59th minute! */     EndNumTime[4] = 59;%    EndNumTime[5] = EndNumTime[6] = 0;   C    if (VMSnok (status = lib$cvt_vectim (&EndNumTime, &EndBinTime)))     {)       rqptr->rqResponse.HttpStatus = 400; 4       ErrorGeneral (rqptr, ErrorGraphPeriod, FI_LI);*       SysDclAst (NextTaskFunction, rqptr);
       return;     }  H    /* get the start time as the number of minutes before the end time */    if (VMSnok (status = 5        GraphActivityOffsetTime (-(NumberOfMinutes-1), =                                 &EndBinTime, &StartBinTime)))     {)       rqptr->rqResponse.HttpStatus = 400; 4       ErrorGeneral (rqptr, ErrorGraphPeriod, FI_LI);*       SysDclAst (NextTaskFunction, rqptr);
       return;     }  B    if (VMSnok (status = lib$day (&StartAbsDay, &StartBinTime, 0)))    {)       rqptr->rqResponse.HttpStatus = 400; 4       ErrorGeneral (rqptr, ErrorGraphPeriod, FI_LI);*       SysDclAst (NextTaskFunction, rqptr);
       return;     }  !    /* calculate the start time */ <    AbsDay = (StartAbsDay - ActivityGblSecPtr->StartAbsDay) %!             ActivityNumberOfDays; -    sys$numtim (&StartNumTime, &StartBinTime);     StartHour = StartNumTime[3]; &    if (WATCH_MODULE(WATCH_MOD__OTHER))B       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!UL !UL !UL !UL",-                  CurrentAbsDay,  StartAbsDay, /                  CurrentNumTime[3], StartHour);   :    if (CurrentAbsDay - StartAbsDay > ActivityNumberOfDays)    {)       rqptr->rqResponse.HttpStatus = 400; 5       ErrorGeneral (rqptr, ErrorGraphHistory, FI_LI); *       SysDclAst (NextTaskFunction, rqptr);
       return;     }  %    if (StartAbsDay > CurrentAbsDay || G        (StartAbsDay == CurrentAbsDay && StartHour > CurrentNumTime[3]))     {)       rqptr->rqResponse.HttpStatus = 400; 4       ErrorGeneral (rqptr, ErrorGraphFuture, FI_LI);*       SysDclAst (NextTaskFunction, rqptr);
       return;     }      /***********************/    /* make some estimates */    /***********************/      /* width of the bar graph */ 8    ColumnWidth = (GraphWidth-2) / (NumberOfMinutes * 2);%    if (!ColumnWidth) ColumnWidth = 1;   M    /* calculate simple mean for this number of minutes when duration large */     MinuteGranularity =L       (int)(1.0 / ((float)(GraphWidth-2) / ((float)NumberOfMinutes * 2.0)));1    if (!MinuteGranularity) MinuteGranularity = 1; &    if (WATCH_MODULE(WATCH_MOD__OTHER)):       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!UL !UL",1                  ColumnWidth, MinuteGranularity);   !    if (!MaxRequests || !MaxBytes)     {J       /* image is not being requested by the report, don't barf, fudge! */C       GraphActivityDataScan (StartAbsDay, StartHour, NumberOfHours, B                              MinuteGranularity, FindMinuteAverage,>                              &PeakPeakRequests, &PeakRequests,5                              &PeakBytes, NULL, NULL);        MaxBytes = PeakBytes; !       MaxRequests = PeakRequests; !       MaxPeak = PeakPeakRequests; >       GraphActivityMaxima (&MaxPeak, &MaxRequests, &MaxBytes);    }  7    /* ratio for calculating request bar graph height */     if (MaxRequests) B       RequestFactor = (float)(GraphHeight-2) / (float)MaxRequests;    else        RequestFactor = 1.0;  4    /* ratio for calculating byte bar graph height */    if (MaxBytes)<       ByteFactor = (float)(GraphHeight-2) / (float)MaxBytes;    else        ByteFactor = 1.0; &    if (WATCH_MODULE(WATCH_MOD__OTHER))    {       char  String [32];;       sprintf (String, "%f %f", RequestFactor, ByteFactor); ?       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!AZ", String);     }      /**************/     /* plot graph */     /**************/   <    if (GraphNew (rqptr, grptr, GraphWidth, GraphHeight, 7))     {#       GraphActivityPlotEnd (rqptr); 
       return;     }  L    StartMinute = StartAbsDay * MINUTES_IN_DAY + StartHour * MINUTES_IN_HOUR;A    EndMinute = StartMinute + NumberOfHours * MINUTES_IN_HOUR - 1; 3    CurrentMinute = CurrentAbsDay * MINUTES_IN_DAY + 8                    CurrentNumTime[3] * MINUTES_IN_HOUR +%                    CurrentNumTime[4]; &    if (WATCH_MODULE(WATCH_MOD__OTHER))>       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "!UL !UL !UL",8                  StartMinute, EndMinute, CurrentMinute);  <    ByteTotal = DisplayMean = RequestTotal = SampleCount = 0;    AtX = 1;     Minute = StartMinute;7    idx = GraphActivityDataIdx (StartAbsDay, StartHour);   /    InstanceMutexLock (INSTANCE_MUTEX_ACTIVITY);       while (Minute <= EndMinute)    {/       if (idx >= ActivityTotalMinutes) idx = 0;   2       if (Minute < ActivityGblSecPtr->StartMinute)       { F          GraphDrawBlock (grptr, AtX, 1, AtX+ColumnWidth+ColumnWidth-1,6                          GraphHeight-1, ColourNoData);          PrevAtX = AtX; *          AtX += ColumnWidth + ColumnWidth;"          idx += MinuteGranularity;%          Minute += MinuteGranularity;           continue;       }   (       if (Minute > CurrentMinute) break;  "       Minute += MinuteGranularity;F       EventDelPrc = EventExit = EventExitError = EventStartup = false;  !       if (MinuteGranularity == 1)        { 7          ByteCount = ActivityGblSecPtr->ByteCount[idx]; =          RequestValue = ActivityGblSecPtr->RequestCount[idx]; ;          RequestPeak = ActivityGblSecPtr->RequestPeak[idx]; D          RequestCount = (unsigned long)RequestValue & ACTIVITY_MASK;@          if (RequestValue & ACTIVITY_DELPRC) EventDelPrc = true;<          if (RequestValue & ACTIVITY_EXIT) EventExit = true;G          if (RequestValue & ACTIVITY_EXIT_ERROR) EventExitError = true; B          if (RequestValue & ACTIVITY_STARTUP) EventStartup = true;          idx++;        } 
       else       if (FindMinuteAverage)       { 4          /* find the average of the minute counts */4          ByteCount = RequestCount = RequestPeak = 0;6          for (cnt = 0; cnt < MinuteGranularity; cnt++)
          {;             ByteCount += ActivityGblSecPtr->ByteCount[idx]; @             RequestValue = ActivityGblSecPtr->RequestCount[idx];H             RequestCount += (unsigned long)RequestValue & ACTIVITY_MASK;C             if (RequestValue & ACTIVITY_DELPRC) EventDelPrc = true; ?             if (RequestValue & ACTIVITY_EXIT) EventExit = true; J             if (RequestValue & ACTIVITY_EXIT_ERROR) EventExitError = true;E             if (RequestValue & ACTIVITY_STARTUP) EventStartup = true; B             if (ActivityGblSecPtr->RequestPeak[idx] > RequestPeak)A                RequestPeak = ActivityGblSecPtr->RequestPeak[idx];              idx++;
          }+          RequestCount /= MinuteGranularity; (          ByteCount /= MinuteGranularity;       } 
       else       { 1          /* find the peak of the minute counts */ 4          ByteCount = RequestCount = RequestPeak = 0;6          for (cnt = 0; cnt < MinuteGranularity; cnt++)
          {>             if (ActivityGblSecPtr->ByteCount[idx] > ByteCount)=                ByteCount = ActivityGblSecPtr->ByteCount[idx]; @             RequestValue = ActivityGblSecPtr->RequestCount[idx];C             if (RequestValue & ACTIVITY_DELPRC) EventDelPrc = true; ?             if (RequestValue & ACTIVITY_EXIT) EventExit = true; J             if (RequestValue & ACTIVITY_EXIT_ERROR) EventExitError = true;E             if (RequestValue & ACTIVITY_STARTUP) EventStartup = true; G             RequestValue = (unsigned long)RequestValue & ACTIVITY_MASK; I             if (RequestValue > RequestCount) RequestCount = RequestValue; B             if (ActivityGblSecPtr->RequestPeak[idx] > RequestPeak)A                RequestPeak = ActivityGblSecPtr->RequestPeak[idx];              idx++;
          }       }   #       RequestTotal += RequestCount;        ByteTotal += ByteCount;          /* calculate means */        SampleCount++;O       RequestMean = (int)((float)(RequestTotal / SampleCount) * RequestFactor); F       ByteMean = (int)((float)(ByteTotal / SampleCount) * ByteFactor);  *       /* limit the range (just in case) */?       if (RequestPeak > MaxRequests) RequestPeak = MaxRequests; A       if (RequestCount > MaxRequests) RequestCount = MaxRequests; 5       if (ByteCount > MaxBytes) ByteCount = MaxBytes;   =       PeakHeight = (int)((float)RequestPeak * RequestFactor); A       RequestHeight = (int)((float)RequestCount * RequestFactor); 8       ByteHeight = (int)((float)ByteCount * ByteFactor);  L       if (WATCH_MODULE(WATCH_MOD__OTHER) && WATCH_MODULE(WATCH_MOD__DETAIL))2          WatchThis (NULL, FI_LI, WATCH_MOD__OTHER,2                     "!UL !UL !UL !UL !UL !UL !UL",,                     RequestTotal, ByteTotal,:                     PeakHeight, RequestHeight, ByteHeight,+                     RequestMean, ByteMean);   P       /* display order; error exit, then shutdown, then restart, then startup */       if (EventExitError) ,          GraphDrawBlock (grptr, AtX, 1, AtX,9                          GraphHeight-1, ColourExitError); 
       else       if (EventDelPrc),          GraphDrawBlock (grptr, AtX, 1, AtX,6                          GraphHeight-1, ColourDelPrc);
       else       if (EventExit),          GraphDrawBlock (grptr, AtX, 1, AtX,4                          GraphHeight-1, ColourExit);         if (EventStartup) D          GraphDrawBlock (grptr, AtX+ColumnWidth, 1, AtX+ColumnWidth,7                          GraphHeight-1, ColourStartup);   7       GraphDrawBlock (grptr, AtX, 1, AtX+ColumnWidth-1, 4                       RequestHeight, ColourRequest);  %       if (PeakHeight < RequestHeight) /          GraphDrawLine (grptr, AtX, PeakHeight, K                         AtX+ColumnWidth, PeakHeight, ColourRequestPeak, 1);          if (DisplayMean)D          GraphDrawLine (grptr, PrevAtX+ColumnWidth, PrevRequestMean,L                         AtX+ColumnWidth, RequestMean, ColourRequestMean, 1);             0       GraphDrawBlock (grptr, AtX+ColumnWidth, 1,4                       AtX+ColumnWidth+ColumnWidth-1,.                       ByteHeight, ColourByte);         if (DisplayMean++)M          GraphDrawLine (grptr, PrevAtX+ColumnWidth+ColumnWidth, PrevByteMean, >                         AtX+ColumnWidth+ColumnWidth, ByteMean,+                         ColourByteMean, 1);   $       PrevRequestMean = RequestMean;       PrevByteMean = ByteMean;       PrevAtX = AtX;'       AtX += ColumnWidth + ColumnWidth;     }  1    InstanceMutexUnLock (INSTANCE_MUTEX_ACTIVITY);       if (Minute >= CurrentMinute) P       GraphDrawBlock (grptr, AtX, 1, GraphWidth-1, GraphHeight-1, ColourNoData);      /****************/     /* finish graph */     /****************/       if (MaxBytes < 10)        AxisBytes = MaxBytes;     else     if (MaxBytes < 100)        AxisBytes = MaxBytes / 10;    else     if (MaxBytes < 1000) !       AxisBytes = MaxBytes / 100;     else     if (MaxBytes < 10000)"       AxisBytes = MaxBytes / 1000;    else     if (MaxBytes < 100000) #       AxisBytes = MaxBytes / 10000;     else     if (MaxBytes < 1000000)$       AxisBytes = MaxBytes / 100000;    else     if (MaxBytes < 10000000) %       AxisBytes = MaxBytes / 1000000;     else     if (MaxBytes < 100000000)&       AxisBytes = MaxBytes / 10000000;    else '       AxisBytes = MaxBytes / 100000000;       if (MaxRequests < 10)!       AxisRequests = MaxRequests;     else     if (MaxRequests < 100) &       AxisRequests = MaxRequests / 10;    else     if (MaxRequests < 1000)'       AxisRequests = MaxRequests / 100;     else     if (MaxRequests < 10000) (       AxisRequests = MaxRequests / 1000;    else     if (MaxRequests < 100000))       AxisRequests = MaxRequests / 10000;     else     if (MaxRequests < 1000000) *       AxisRequests = MaxRequests / 100000;    else +       AxisRequests = MaxRequests / 1000000;       if (AxisRequests <= 2) 2       GraphGraduateYAxis (grptr, GRAPH_YAXIS_LEFT,:                           AxisRequests*10, 4, ColourAxis);O    GraphGraduateYAxis (grptr, GRAPH_YAXIS_LEFT, AxisRequests*2, 7, ColourAxis); N    GraphGraduateYAxis (grptr, GRAPH_YAXIS_LEFT, AxisRequests, 10, ColourAxis);      if (AxisBytes <= 2)3       GraphGraduateYAxis (grptr, GRAPH_YAXIS_RIGHT, 7                           AxisBytes*10, 4, ColourAxis); M    GraphGraduateYAxis (grptr, GRAPH_YAXIS_RIGHT, AxisBytes*2, 7, ColourAxis); L    GraphGraduateYAxis (grptr, GRAPH_YAXIS_RIGHT, AxisBytes, 10, ColourAxis);      if (NumberOfHours == 1)    {H       GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM, 60, 4, ColourAxis);H       GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM, 12, 7, ColourAxis);H       GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM, 2, 10, ColourAxis);E       GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP, 60, 4, ColourAxis); E       GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP, 12, 7, ColourAxis); E       GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP, 2, 10, ColourAxis);     }    else     if (NumberOfHours < 24)    {       if (NumberOfHours <= 8)        { 7          GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM, >                              NumberOfHours*12, 4, ColourAxis);4          GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP,>                              NumberOfHours*12, 4, ColourAxis);       } 4       GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM,:                           NumberOfHours*2, 7, ColourAxis);4       GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM,9                           NumberOfHours, 10, ColourAxis); 1       GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP, :                           NumberOfHours*2, 7, ColourAxis);1       GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP, 9                           NumberOfHours, 10, ColourAxis);     }    else     {(       NumberOfDays = NumberOfHours / 24;       if (NumberOfDays <= 3)       { 7          GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM, =                              NumberOfDays*24, 4, ColourAxis); 4          GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP,=                              NumberOfDays*24, 4, ColourAxis);        } 4       GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM,9                           NumberOfDays*4, 6, ColourAxis); 4       GraphGraduateXAxis (grptr, GRAPH_XAXIS_BOTTOM,7                           NumberOfDays, 8, ColourAxis); 1       GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP, 9                           NumberOfDays*4, 6, ColourAxis); 1       GraphGraduateXAxis (grptr, GRAPH_XAXIS_TOP, 7                           NumberOfDays, 8, ColourAxis);     }  *    GraphDrawBorder (grptr, ColourAxis, 1);  "    GraphActivityGifStream (rqptr); }   O /*****************************************************************************/  /* */  , GraphActivityPlotEnd (REQUEST_STRUCT *rqptr)   {     int  status;       /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))J       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "GraphActivityPlotEnd()");  <    SysDclAst (rqptr->GraphTaskPtr->NextTaskFunction, rqptr); }   O /*****************************************************************************/  /*M Convert the image pointed to by grptr->GraphPlotPtr of grptr->PixelCount size + into a GIF image and send it to the client.  */    . GraphActivityGifStream (REQUEST_STRUCT *rqptr)   {     GRAPH_STRUCT  *grptr;      /*********/    /* begin */    /*********/  &    if (WATCH_MODULE(WATCH_MOD__OTHER))L       WatchThis (NULL, FI_LI, WATCH_MOD__OTHER, "GraphActivityGifStream()");  :    /* get the pointer to this request's graph structure */)    grptr = rqptr->GraphTaskPtr->GraphPtr;   C    /* we can usually count on heaps of compression using LZW :^) */ L    grptr->GifBufferLength = (grptr->PixelCount / GIF_EXPECTED_COMPRESSION) +)                             GIF_OVERHEAD;   /    /* allocate heap memory for the GIF image */ C    grptr->GifBufferPtr = VmGetHeap (rqptr, grptr->GifBufferLength);   >    /* set marker so we don't over run the end of the buffer */I    grptr->GifBufferEndPtr = grptr->GifBufferPtr + grptr->GifBufferLength;       if (GraphGifImage (grptr))     {)       rqptr->rqResponse.HttpStatus = 500; 7       ErrorGeneral (rqptr, grptr->ErrorTextPtr, FI_LI); 
       return;     }      /*******************/    /* write to client */    /*******************/  &    rqptr->rqResponse.HttpStatus = 200;'    rqptr->rqResponse.PreExpired = true; D    ResponseHeader (rqptr, 200, "image/gif", grptr->GifContentLength,-                rqptr->rqTime.Vms64bit, NULL);   )    NetWrite (rqptr, GraphActivityPlotEnd, ;              grptr->GifBufferPtr, grptr->GifContentLength);  }   O /*****************************************************************************/  /*L Allocate memory for a graphic of the specified size, then set all the pixels to the specified colour. */   char* GraphNew (  REQUEST_STRUCT *rqptr, GRAPH_STRUCT *grptr,
 int Width, int Height, 
 int Colour )  {     /*********/    /* begin */    /*********/      if (GraphDebug)E       fprintf (stdout, "GraphNew() %dx%d %d", Width, Height, Colour);   2    if (Width <= 0 || Width >= GraphicMaximumWidth)=       return (grptr->ErrorTextPtr = "Graph: width problem."); 5    if (Height <= 0 || Height >= GraphicMaximumHeight) >       return (grptr->ErrorTextPtr = "Graph: height problem.");      /* some initializations */     grptr->PreExpired = true;-    grptr->BitsPerPixel = GraphicBitsPerPixel; 1    grptr->GifColourBg = grptr->ColourBg = Colour;     grptr->ColourFg = 0;     grptr->ColourTr = -1;    grptr->Width = Width;    grptr->Height = Height;4    grptr->PixelCount = grptr->Width * grptr->Height;K    if (GraphDebug) fprintf (stdout, "PixelCount: %d\n", grptr->PixelCount);   5    /* allocate heap memory for the graph structure */ ?    grptr->PlotBufferPtr = VmGetHeap (rqptr, grptr->PixelCount);   0    /* set all the pixels to background colour */<    memset (grptr->PlotBufferPtr, Colour, grptr->PixelCount);      return (0); }   O /*****************************************************************************/  /*: Set all the pixels in the graphic to the specified colour. */   char* GraphSetBackground (  GRAPH_STRUCT *grptr,
 int Colour )  {     /*********/    /* begin */    /*********/  I    if (GraphDebug) fprintf (stdout, "GraphSetBackground() %d\n", Colour);   <    memset (grptr->PlotBufferPtr, Colour, grptr->PixelCount);    return (0); }   O /*****************************************************************************/  /*I The basic point drawing/plotting function.  Draws a point at (x,y) in the L specified colour.  Width specifies the size of the point, 1 being one pixel,M 2 being 2x2 pixels, 3 being 3x3 pixels, etc.  Points with widths greater than B 1 begin at the specified (x,y) and grow in the x and y directions. */   char* GraphDrawPoint (  GRAPH_STRUCT *grptr, int atx, int aty, int Colour, 	 int Width  )  {     /*********/    /* begin */    /*********/  J    if (GraphDebug) fprintf (stdout, "GraphDrawPoint() %d,%d\n", atx, aty);  +    if (Width <= 0 || Width >= grptr->Width) C       return (grptr->ErrorTextPtr = "Graph: point width problem."); I    if (atx < 0 || atx >= grptr->Width || aty < 0 || aty >= grptr->Height) A       return (grptr->ErrorTextPtr = "Graph: point X,Y problem.");       if (Width == 1)    {D       *(grptr->PlotBufferPtr + (aty * grptr->Width) + atx) = Colour;       return (0);     }    else     {       int  x, y, tox, toy;  F       if ((tox = atx + Width) >= grptr->Width) tox = grptr->Width - 1;H       if ((toy = aty + Width) >= grptr->Height) tox = grptr->Height - 1;!       for (x = atx; x < tox; x++) $          for (y = aty; y < toy; y++)F             *(grptr->PlotBufferPtr + (y * grptr->Width) + x) = Colour;       return (0);     } }   O /*****************************************************************************/  /*I Draws a straight line from (x1,y1) to (x2,y2) of the specified colour and L width. For efficiency plots its own points without calling GraphDrawPoint(). */   char* GraphDrawLine  (  GRAPH_STRUCT *grptr, int x1,  int y1,  int x2,  int y2,  int Colour, 	 int Width  )  {     BOOL  SlopePos;    int  thy, x, xinc, y, yinc;    float  Slope, yf;      /*********/    /* begin */    /*********/      if (GraphDebug)=       fprintf (stdout, "GraphDrawLine() %d,%d %d,%d %d %d\n", &                x1, y1, x2, y2, Colour,
       Width);   +    if (Width <= 0 || Width >= grptr->Width) B       return (grptr->ErrorTextPtr = "Graph: line width problem.");E    if (x1 < 0 || x1 >= grptr->Width || y1 < 0 || y1 >= grptr->Height) B       return (grptr->ErrorTextPtr = "Graph: line X1,Y1 problem.");E    if (x2 < 0 || x2 >= grptr->Width || y2 < 0 || y2 >= grptr->Height) B       return (grptr->ErrorTextPtr = "Graph: line X2,Y2 problem.");      if (x1 > x2)     {
       x = x1;        x1 = x2;
       x2 = x; 
       y = y1;        y1 = y2;
       y2 = y;     }      if (x2 - x1)     {       xinc = 1; 1       Slope = (float)(y2 -y1) / (float)(x2 - x1);     }    else     {       xinc = 0;        if (y2 > y1)          Slope = 1.0; 
       else          Slope = -1.0;    }    if (Slope >= 0.0)    {       SlopePos = true;      yinc = 1;    }    else     {       SlopePos = false;        yinc = -1;    }      yf = (float)(y = thy = y1);
    x = x1;G    while (x <= x2 && ((SlopePos && y <= y2) || (!SlopePos && y >= y2)))     {K       if (GraphDebug) fprintf (stdout, "%d,%d (%f %f)\n", x, y, yf, Slope);   ?       while ((SlopePos && thy <= y) || (!SlopePos && thy >= y))        {           /* plot the point */           if (Width == 1)H             *(grptr->PlotBufferPtr + (thy * grptr->Width) + x) = Colour;
          else 
          {"             int  xx, yy, tox, toy;  J             if ((tox = x + Width) >= grptr->Width) tox = grptr->Width - 1;N             if ((toy = thy + Width) >= grptr->Height) toy = grptr->Height - 1;(             for (xx = x; xx < tox; xx++)-                for (yy = thy; yy < toy; yy++) N                   *(grptr->PlotBufferPtr + (yy * grptr->Width) + xx) = Colour;
          }          thy += yinc;        }          thy -= yinc;       x += xinc;!       y = (int)(yf = yf + Slope);     }      return (0); }   O /*****************************************************************************/  /*L Draw a rectangle with opposite corners defined by (x1,y1) and (x2,y2) of the specified colour and width.  */   char* GraphDrawRect  (  GRAPH_STRUCT *grptr, int x1,  int y1,  int x2,  int y2,  int Colour, 	 int Width  )  { 
    int  x, y;       /*********/    /* begin */    /*********/      if (GraphDebug):       fprintf (stdout, "GraphDrawRect() %d,%d %d,%d %d\n",'                x1, y1, x2, y2, Colour);   +    if (Width <= 0 || Width >= grptr->Width) G       return (grptr->ErrorTextPtr = "Graph: rectangle width problem."); E    if (x1 < 0 || x1 >= grptr->Width || y1 < 0 || y1 >= grptr->Height) G       return (grptr->ErrorTextPtr = "Graph: rectangle X1,Y1 problem."); E    if (x2 < 0 || x2 >= grptr->Width || y2 < 0 || y2 >= grptr->Height) G       return (grptr->ErrorTextPtr = "Graph: rectangle X2,Y2 problem.");   8    GraphDrawLine (grptr, x1, y1, x1, y2, Colour, Width);8    GraphDrawLine (grptr, x1, y2, x2, y2, Colour, Width);8    GraphDrawLine (grptr, x2, y2, x2, y1, Colour, Width);8    GraphDrawLine (grptr, x2, y1, x1, y1, Colour, Width);      return (0); }   O /*****************************************************************************/  /*L Draw a rectangle with opposite corners defined by (x1,y1) and (x2,y2) filled with the specified colour. */   char* GraphDrawBlock (  GRAPH_STRUCT *grptr, int x1,  int y1,  int x2,  int y2, 
 int Colour )  { 
    int  x, y;       /*********/    /* begin */    /*********/      if (GraphDebug);       fprintf (stdout, "GraphDrawBlock() %d,%d %d,%d %d\n", '                x1, y1, x2, y2, Colour);   E    if (x1 < 0 || x1 >= grptr->Width || y1 < 0 || y1 >= grptr->Height) C       return (grptr->ErrorTextPtr = "Graph: block X1,Y1 problem."); E    if (x2 < 0 || x2 >= grptr->Width || y2 < 0 || y2 >= grptr->Height) C       return (grptr->ErrorTextPtr = "Graph: block X2,Y2 problem.");       if (x1 > x2)     {
       x = x1;        x1 = x2;
       x2 = x;     }    if (y1 > y2)     {
       y = y1;        y1 = y2;
       y2 = y;     }      for (x = x1; x <= x2; x++) 5       GraphDrawLine (grptr, x, y1, x, y2, Colour, 1);       return (0); }   O /*****************************************************************************/  /*7 Draw graduations along either the top or bottom X axis.  */   char* GraphGraduateXAxis (  GRAPH_STRUCT *grptr, int TopOrBottom, int Graduations, int Length, 
 int Colour )  {     int  x, FromY, ToY;    float  gr, xf;       /*********/    /* begin */    /*********/      if (GraphDebug)9       fprintf (stdout, "GraphGraduateXAxis() %d %d %d\n", 1                TopOrBottom, Graduations, Colour);        if (!Graduations) return (0);  )    if (TopOrBottom == GRAPH_XAXIS_BOTTOM)     {       FromY = 0;       ToY = Length - 1;     }    else     {%       FromY = grptr->Height - Length;        ToY = grptr->Height - 1;    }    xf = 0.0;;    gr = (float)grptr->Width / ((float)Graduations + 0.001); 8    for (x = 0; x < grptr->Width; x = (int)(xf += gr))   :       GraphDrawLine (grptr, x, FromY, x, ToY, Colour, 1);       return (0); }   O /*****************************************************************************/  /*7 Draw graduations along either the left or right Y axis.  */   char* GraphGraduateYAxis (  GRAPH_STRUCT *grptr, int LeftOrRight, int Graduations, int Length, 
 int Colour )  {     int  y, FromX, ToX;    float  gr, yf;       /*********/    /* begin */    /*********/      if (GraphDebug)9       fprintf (stdout, "GraphGraduateYAxis() %d %d %d\n", 1                LeftOrRight, Graduations, Colour);        if (!Graduations) return (0);  '    if (LeftOrRight == GRAPH_YAXIS_LEFT)     {       FromX = 0;       ToX = Length - 1;     }    else     {$       FromX = grptr->Width - Length;       ToX = grptr->Width - 1;     }    yf = 0.0;2    gr = (float)grptr->Height / (float)Graduations;9    for (y = 0; y < grptr->Height; y = (int)(yf += gr))    :       GraphDrawLine (grptr, FromX, y, ToX, y, Colour, 1);       return (0); }   O /*****************************************************************************/  /*K Place a border of the specified colour and width around the entire graphic.  */   char* GraphDrawBorder  (  GRAPH_STRUCT *grptr, int Colour, 	 int Width  )  {     int  x, y, cnt;    unsigned char  *bptr;      /*********/    /* begin */    /*********/  P    if (GraphDebug) fprintf (stdout, "GraphDrawBorder() %d %d\n", Colour, Width);  E    if (Width <= 0 || Width >= grptr->Width || Width >= grptr->Height) D       return (grptr->ErrorTextPtr = "Graph: border width problem.");  $    for (cnt = 0; cnt < Width; cnt++)    {9       bptr = grptr->PlotBufferPtr + (cnt * grptr->Width); :       for (x = 0; x < grptr->Width; x++) *bptr++ = Colour;    }     for (cnt = Width; cnt; cnt--)    {I       bptr = grptr->PlotBufferPtr + (grptr->Height - cnt) * grptr->Width; :       for (x = 0; x < grptr->Width; x++) *bptr++ = Colour;    }$    for (cnt = 0; cnt < Width; cnt++)    {(       bptr = grptr->PlotBufferPtr + cnt;)       for (y = 0; y < grptr->Height; y++) .         *(bptr + (y * grptr->Width)) = Colour;    }     for (cnt = Width; cnt; cnt--)    {7       bptr = grptr->PlotBufferPtr + grptr->Width - cnt; )       for (y = 0; y < grptr->Height; y++) .         *(bptr + (y * grptr->Width)) = Colour;    }      return (0); }   O /*****************************************************************************/  /*& Convert a pixmap image to a GIF image.  K The code in these functions is implemented in accordance with Compuserve's  M Graphic Interchange Format Programming Reference specification, version 89a,   31st July 1990.   L The LZW compression employed by the GIF algorithm is implemented using code L derived from the PBM suite.  Two functions, slightly modified and definitelyK reformatted, are employed, GraphCompress() ... formally called 'compgif()', E and GraphPackBits() ...  formally called 'pack_bits()'.  The original I commentary and copyright notice remains as per the code author's request.  */    ) char* GraphGifImage (GRAPH_STRUCT *grptr)    {     int  idx,
         Byte,          LeftOffset,          TopOffset,         Resolution,          ColorMapSize,          InitCodeSize;     char  *cptr;     unsigned char  *gifptr;      /*********/    /* begin */    /*********/  9    if (GraphDebug) fprintf (stdout, "GraphGifImage()\n");       grptr->GifContentLength = 0;   -    /* initialize non-reentrant functions() */     GraphPackBits (NULL);    GraphNextPixel (NULL);   +    ColorMapSize = 1 << grptr->BitsPerPixel;     LeftOffset = TopOffset = 0;$    Resolution = grptr->BitsPerPixel;      /* the initial code size */     if (grptr->BitsPerPixel <= 1)       InitCodeSize = 2;     else )       InitCodeSize = grptr->BitsPerPixel;       /**************************/     /* GIF Data Stream header */     /**************************/        gifptr = grptr->GifBufferPtr;       memcpy (gifptr, "GIF89a", 6);    gifptr += 6;   "    /*****************************/"    /* Logical Screen Descriptor */"    /*****************************/  +    /* width and height of logical screen */ #    *gifptr++ = grptr->Width & 0xff; *    *gifptr++ = (grptr->Width >> 8) & 0xff;$    *gifptr++ = grptr->Height & 0xff;+    *gifptr++ = (grptr->Height >> 8) & 0xff;   3    /* indicate that there is a global colour map */     Byte = 0x80;     /* OR in the resolution */ !    Byte |= (Resolution - 1) << 5; !    /* OR in the Bits per Pixel */ %    Byte |= (grptr->BitsPerPixel - 1);     /* buffer it */    *gifptr++ = Byte;      /* background colour */"    *gifptr++ = grptr->GifColourBg;      /* pixel aspect ratio */     *gifptr++ = 0;       /***********************/    /* Global Colour Table */    /***********************/  +    for (idx = 0; idx < ColorMapSize; idx++)     {%       *gifptr++ = GraphicRgbRed[idx]; '       *gifptr++ = GraphicRgbGreen[idx]; &       *gifptr++ = GraphicRgbBlue[idx];    }  -    /****************************************/ -    /* Graphic Control Extension descriptor */ -    /****************************************/       if (grptr->ColourTr >= 0)    {:       /* extension introducer and graphic control label */       *gifptr++ = 0x21;        *gifptr++ = 0xf9; 2       /* fixed size of the following data block */       *gifptr++ = 0x04; *       /* Transparency Index is provided */       *gifptr++ = 0x01;        /* no data in these */       *gifptr++ = 0x00;        *gifptr++ = 0x00; K       /* Transparent Color Index value, background SHOULD BE TRANSPARENT */ "       *gifptr++ = grptr->ColourTr;       /* block terminator */       *gifptr++ = 0x00;     }      /********************/     /* image descriptor */     /********************/   !    /* write an image separator */     *gifptr++ = 0x2c;  0    /* location of image within logical screen */!    *gifptr++ = LeftOffset & 0xff; (    *gifptr++ = (LeftOffset >> 8) & 0xff;     *gifptr++ = TopOffset & 0xff;'    *gifptr++ = (TopOffset >> 8) & 0xff;   8    /* width and height of image within logical screen */#    *gifptr++ = grptr->Width & 0xff; *    *gifptr++ = (grptr->Width >> 8) & 0xff;$    *gifptr++ = grptr->Height & 0xff;+    *gifptr++ = (grptr->Height >> 8) & 0xff;   I    /* no local color table, image is not interlaced, not ordered, etc. */     *gifptr++ = 0x00;      /**************************/     /* table-based image data */     /**************************/   (    /* write out the initial code size */    *gifptr++ = InitCodeSize;  C    /* LZW compress the data using PBM-derived algorithm and code */ P    if (GraphDebug) fprintf (stdout, "%d bytes\n", gifptr - grptr->GifBufferPtr);    grptr->GifPtr = gifptr;6    if (cptr = GraphCompress (grptr, InitCodeSize + 1))       return (cptr);    if (GraphDebug)J       fprintf (stdout, "%d bytes\n", grptr->GifPtr - grptr->GifBufferPtr);  -    /****************************************/ -    /* end of image data and GIF terminator */ -    /****************************************/   K    /* write out a zero-length packet (to end the series), and terminator */ D    if (grptr->GifPtr < grptr->GifBufferEndPtr) *grptr->GifPtr++ = 0;F    if (grptr->GifPtr < grptr->GifBufferEndPtr) *grptr->GifPtr++ = ';';  /    if (grptr->GifPtr >= grptr->GifBufferEndPtr) -       return("GIF: image buffer too small.");   A    grptr->GifContentLength = grptr->GifPtr - grptr->GifBufferPtr;       return (0); }   O /*****************************************************************************/  /*J Get a series of pixels from the bitmap.  It is done in such a way that theN origin (0,0) is in the bottom, left hand corner, although the memory origin is
 at byte zero.  */    ( int GraphNextPixel (GRAPH_STRUCT *grptr)   {     static int  CountX,                CountY;#    static unsigned char  *PixelPtr;       /*********/    /* begin */    /*********/  @    /* if (GraphDebug) fprintf (stdout, "GraphNextPixel()\n"); */      if (!grptr)    {       /* initialize */       CountX = 0;        CountY = -1;       return (0);     }      if (!CountX--)     {-       if (CountY < 0) CountY = grptr->Height; "       if (!CountY--) return (EOF);        CountX = grptr->Width - 1;@       PixelPtr = grptr->PlotBufferPtr + (CountY * grptr->Width);    }      return (*PixelPtr++); }   N /****************************************************************************/ /*I  * This software is copyrighted as noted below.  It may be freely copied, F  * modified, and redistributed, provided that the copyright notice is   * preserved on all copies.   *  H  * There is no warranty or other guarantee of fitness for this software,C  * it is provided solely "as is".  Bug reports or fixes may be sent ?  * to the author, who may or may not act on them as he desires.   *K  * You may not include this software in a program or other software product L  * without supplying the source, or without informing the end-user that the +  * source is available for no extra charge.   *F  * If you modify this software, you should include a notice giving theL  * name of the person performing the modification, the date of modification,(  * and the reason for such modification.  */    /*  compgif.c */ /*  *C  * GIF Image compression - LZW algorithm implemented with Tree type %  *                         structure. 7  *                         Written by Bailey Brown, Jr. 3  *                         last change May 24, 1990 *  *                         file: compgif.c  *G  *  You may use or modify this code as you wish, as long as you mention "  *  my name in your documentation.  *'  *                  - Bailey Brown, Jr.   *  */   5 #define MAXIMUMCODE 4095   /* 2**maximum_code_size */ 6 #define BLOCKSIZE 256   /* max block byte count + 1 */ #define NULLPREFIX -1    typedef struct str_table_entry {     int code;    int prefix;    int suffix; }  strTableEntry;    typedef struct str_table_node  {     strTableEntry entry;     struct str_table_node *left;      struct str_table_node *right;#    struct str_table_node *children; - } strTableNode, *strTableNodePtr, **strTable;    /*E  ******************************************************************** E  * compgif() recieves pointers to an input function and an output   * E  * stream, and the code size as parameters and outputs successive   * E  * blocks of LZW compressed gif data.  The calling routine should   * E  * have aready written the GIF file header out to the output file.  * E  * It assumes that there will be no more than 8 bits/pixel and that * E  * each data item comes from successive bytes returned by infun.    * E  ********************************************************************   */    char* GraphCompress  (  GRAPH_STRUCT *grptr,
 int code_size  )  { 3    strTable heap; /* our very own memory manager */     int heap_index;&    int clear_code, end_code, cur_code;3    int i, found, num_colors, prefix, compress_size; +    int cur_char, end_of_data, bits_per_pix;     strTableNodePtr cur_node;D    strTable root;  /* root of string table for LZW compression is */M                    /* an array of 2**bits_per_pix pointers to atomic nodes */       /*********/    /* begin */    /*********/  9    if (GraphDebug) fprintf (stdout, "GraphCompress()\n");       heap_index = 0;?    heap = (strTable)VmGet(sizeof(strTableNodePtr)*MAXIMUMCODE); 3    if (!heap) return("GIF: VmGet() failure, heap");   "    for (i=0; i < MAXIMUMCODE; i++)    {=       heap[i] = (strTableNodePtr)VmGet(sizeof(strTableNode)); >       if (!heap[i]) return("GIF: VmGet() failure, heap[idx]");    }       bits_per_pix = code_size - 1;    compress_size = code_size; "    num_colors = 1<<(bits_per_pix);    clear_code = num_colors;     end_code = clear_code + 1;     cur_code = end_code + 1;     prefix = NULLPREFIX; >    root = (strTable)VmGet(sizeof(strTableNodePtr)*num_colors);3    if (!root) return("GIF: VmGet() failure, root");       for(i=0; i<num_colors; i++)    {#       root[i] = heap[heap_index++];        root[i]->entry.code = i;)       root[i]->entry.prefix = NULLPREFIX;         root[i]->entry.suffix = i;       root[i]->left = NULL;        root[i]->right = NULL;       root[i]->children = NULL;     }  !    /* initialize  output block */ +    GraphPackBits(grptr, compress_size, -1); 3    GraphPackBits(grptr, compress_size, clear_code);     end_of_data = 0;   1    if ((cur_char = GraphNextPixel(grptr)) == EOF) ,       return("GIF: premature end of data.");      while (!end_of_data)     {       prefix = cur_char;       cur_node = root[prefix];       found = 1;3       if((cur_char = GraphNextPixel(grptr)) == EOF)        {           end_of_data = 1;           break;        }   (       while(cur_node->children && found)       { '          cur_node = cur_node->children; 2          while(cur_node->entry.suffix != cur_char)
          {2             if (cur_char < cur_node->entry.suffix)
             { "                if (cur_node->left),                   cur_node = cur_node->left;                else                 {6                   cur_node->left = heap[heap_index++];,                   cur_node = cur_node->left;#                   found = 0; break;                 }
             }              else
             { #                if (cur_node->right) -                   cur_node = cur_node->right;                 else                 {7                   cur_node->right = heap[heap_index++]; -                   cur_node = cur_node->right; #                   found = 0; break;                 }
             } 
          }          if (found) 
          {*             prefix = cur_node->entry.code;9             if((cur_char = GraphNextPixel(grptr)) == EOF) 
             {                 end_of_data = 1;                 break; 
             } 
          }       }          if (end_of_data) break;          if (found)       { 1          cur_node->children = heap[heap_index++]; '          cur_node = cur_node->children;        }           cur_node->children = NULL;       cur_node->left = NULL;       cur_node->right = NULL; &       cur_node->entry.code = cur_code;&       cur_node->entry.prefix = prefix;(       cur_node->entry.suffix = cur_char;2       GraphPackBits(grptr, compress_size, prefix);  .       if (cur_code > ((1<<(compress_size))-1))          compress_size++; !       if (cur_code < MAXIMUMCODE)           cur_code++;
       else       { B          heap_index = num_colors;  /* reinitialize string table */B          for (i=0; i < num_colors; i++ ) root[i]->children = NULL;9          GraphPackBits(grptr, compress_size, clear_code); *          compress_size = bits_per_pix + 1;!          cur_code = end_code + 1;        }     }  /    GraphPackBits(grptr, compress_size, prefix); 1    GraphPackBits(grptr, compress_size, end_code); +    GraphPackBits(grptr, compress_size, -1);   :    for (i=0; i < MAXIMUMCODE; i++) VmFree(heap[i], FI_LI);    VmFree(heap, FI_LI);     VmFree(root, FI_LI);       return (0); }   N /****************************************************************************/ /*I  ************************************************************************ I  * pack_bits() packs the bits of the codes generated by gifenc() into   * I  * a 1..256 byte output block.  The first byte of the block is the      * I  * number 0..255 of data bytes in the block.  To flush or initialize    * I  * the block, pass a negative argument.                                 * I  ************************************************************************   */    int GraphPackBits  (  GRAPH_STRUCT *grptr, int compress_size,
 int prefix )  {     static int cur_bit = 8;1    static unsigned char block[BLOCKSIZE] = { 0 };     int i, left_over_bits;       /*********/    /* begin */    /*********/   /*    if (GraphDebug)8           fprintf (stdout, "GraphPackBits() %d %d %d\n",1                    grptr, compress_size, prefix);  */      if (!grptr)    {       /* initialize */       cur_bit = 8;       block[0] = 0;        return(1);    }  C    /* if we are about to excede the bounds of block or if the flush 0       code (code_bis < 0) we output the block */  B    if((cur_bit + compress_size > (BLOCKSIZE-1)*8) || (prefix < 0))    {3        /* handle case of data overlapping blocks */ -        if ((left_over_bits = (((cur_bit>>3) + 9                ((cur_bit & 7) != 0))<<3) - cur_bit) != 0)         {-            for (i=0; i < left_over_bits; i++)             {#                if (prefix & (1<<i)) @                   block[cur_bit>>3] |= (char)(1<<(cur_bit & 7));8                /* note n>>3 == n/8 and n & 7 == n % 8 */                cur_bit++;             }        }  '        compress_size -= left_over_bits; '        prefix = prefix>>left_over_bits; 4        block[0] = (unsigned char)((cur_bit>>3) - 1);          if (block[0])          {G           /** if (GraphDebug) fprintf (stdout, "%d\n", block[0]+1); **/ E           if (grptr->GifPtr + (block[0]+1) >= grptr->GifBufferEndPtr) 4              grptr->GifPtr = grptr->GifBufferEndPtr;           else           { 7              memcpy (grptr->GifPtr, block, block[0]+1); 8              grptr->GifPtr = grptr->GifPtr + block[0]+1;           }         }  $        memset (block, 0, BLOCKSIZE);        cur_bit = 8;     }      if (prefix >= 0)     {(        for (i=0; i < compress_size; i++)        {           if (prefix & (1<<i))A           block[cur_bit>>3] |= (unsigned char)(1<<(cur_bit & 7)); 3           /* note n>>3 == n/8 and n & 7 == n % 8 */            cur_bit++;        }    }      return (1); }   O /*****************************************************************************/ 