/*****************************************************************************/
/*
                                   Graph.h
*/
/*****************************************************************************/

#ifndef GRAPH_H_LOADED
#define GRAPH_H_LOADED 1

#include "wasd.h"

/* must correspond to the colours in GraphicRgbRed[], Blue[], Green[] */
#define COLOUR_BLACK 0
#define COLOUR_RED 1
#define COLOUR_GREEN 2
#define COLOUR_BLUE 3
#define COLOUR_YELLOW 4
#define COLOUR_MAGENTA 5
#define COLOUR_CYAN 6
#define COLOUR_WHITE 7
#define COLOUR_GREY 8
#define COLOUR_DRED 9
#define COLOUR_DGREEN 10
#define COLOUR_DBLUE 11
#define COLOUR_DYELLOW 12
#define COLOUR_DMAGENTA 13
#define COLOUR_DCYAN 14
#define COLOUR_DWHITE 15

/* minimum expected compression ratio from LZW algorithm in GIF processor */
#define GIF_EXPECTED_COMPRESSION 8
#define GIF_OVERHEAD 128

#define GRAPH_XAXIS_TOP 1
#define GRAPH_XAXIS_BOTTOM 2
#define GRAPH_YAXIS_LEFT 1
#define GRAPH_YAXIS_RIGHT 2

#define ACTIVITY_DAYS 28
#define MINUTES_IN_DAY 1440
#define MINUTES_IN_HOUR 60

#define ACTIVITY_MASK       0x0fffffff
#define ACTIVITY_STARTUP    0x80000000
#define ACTIVITY_EXIT       0x40000000
#define ACTIVITY_EXIT_ERROR 0x20000000
#define ACTIVITY_DELPRC     0x10000000

/**************/
/* structures */
/**************/

typedef struct GraphStruct GRAPH_STRUCT;

struct GraphStruct
{
   BOOL  PreExpired;

   int  BitsPerPixel,
        ColourBg,
        ColourFg,
        ColourTr,
        GifBufferLength,
        GifContentLength,
        GifColourBg,
        Height,
        PixelCount,
        Width,
        WidthFg;

   char  *ErrorTextPtr;

   unsigned char  *GifBufferPtr,
                  *GifBufferEndPtr,
                  *GifPtr,
                  *PlotBufferPtr;
};

typedef struct GraphTaskStruct GRAPH_TASK;

struct GraphTaskStruct
{
   /* the structure in actually defined in Graph.c */
   void  *GraphPtr;

   /* pointer a request using this graph structure */
   REQUEST_STRUCT  *rqptr;

   /* pointer to function, used for specifying the next task */
   REQUEST_AST NextTaskFunction;
};

typedef struct ActivityGblSecStruct ACTIVITY_GBLSEC;

struct ActivityGblSecStruct
{
   unsigned long  GblSecVersion;

   unsigned long  ClearAbsDay,
                  StartAbsDay,
                  StartMinute;
   unsigned long  StartBinTime [2];

   /* plus one day to provide 'elbow room' */
   unsigned long  ByteCount [(ACTIVITY_DAYS+1) * MINUTES_IN_DAY],
                  RequestCount [(ACTIVITY_DAYS+1) * MINUTES_IN_DAY];
   unsigned short  RequestPeak [(ACTIVITY_DAYS+1) * MINUTES_IN_DAY];
};

/***********************/
/* function prototypes */
/***********************/

unsigned long GraphActivityDataIdx (unsigned long, unsigned long);
int GraphActivityDataScan (int, int, int, int, BOOL,
                           unsigned int*,
                           unsigned int*, unsigned int*,
                           unsigned long*, unsigned long*);
int GraphActivityEvent (unsigned long);
int GraphActivityGifStream (REQUEST_STRUCT*);
int GraphActivityGblSecInit ();
int GraphActivityIncrement (REQUEST_STRUCT*);
int GraphActivityMaxima (unsigned int*, unsigned int*, unsigned int*);
int GraphActivityOffsetTime (int, unsigned long*, unsigned long*);
char* GraphActivityOnMouseOver (unsigned long*, int);
int GraphActivityPlotBegin (REQUEST_STRUCT*, REQUEST_AST);
int GraphActivityPlotEnd (REQUEST_STRUCT*);
int GraphActivityReport (REQUEST_STRUCT*, REQUEST_AST);

char* GraphCompress (GRAPH_STRUCT*, int);
char* GraphDrawBlock (GRAPH_STRUCT*, int, int, int, int, int);
char* GraphDrawBorder (GRAPH_STRUCT*, int, int);
char* GraphDrawLine (GRAPH_STRUCT*, int, int, int, int, int, int);
char* GraphDrawPoint (GRAPH_STRUCT*, int, int, int, int);
char* GraphDrawRect (GRAPH_STRUCT*, int, int, int, int, int, int);
char* GraphGifImage (GRAPH_STRUCT*);
char* GraphGraduateXAxis (GRAPH_STRUCT*, int, int, int, int);
char* GraphGraduateYAxis (GRAPH_STRUCT*, int, int, int, int);
char* GraphNew (REQUEST_STRUCT*, GRAPH_STRUCT*, int, int, int);

#endif /* GRAPH_H_LOADED */

/*****************************************************************************/
