/*****************************************************************************/
/*
                                  HTAdmin.h

Function prototypes for HTAdmin module.

*/
/*****************************************************************************/

#ifndef HTADMIN_H_LOADED
#define HTADMIN_H_LOADED 1

#include "wasd.h"

/**********/
/* macros */
/**********/

#define INTERNAL_PASSWORD_CHANGE  "/httpd/-/change/"

/**************/
/* structures */
/**************/

typedef struct HTAdminTaskStruct HTADMIN_TASK;

struct HTAdminTaskStruct
{
   struct HTAdminTaskStruct  *HTAdminTaskPtr;

   BOOL  /* */
         BriefList,
         /* administering an HTL list */
         HtListAdmin,
         /* use database(s) located by the service directory */
         UseServiceDirectory;

   int  /* */
        FileCount,
        /* */
        FileNameLength,
        /* */
        RecordCount,
        /* */
        UserCount,
        /* */
        UserListCount,
        /* */
        UserListLength;

   char  /* */
         AuthFileName [ODS_MAX_FILE_NAME_LENGTH+1],
         /* */
         AuthFileSpec [ODS_MAX_FILE_NAME_LENGTH+1];

   char  /* "title" on each page (HTA or HTL admin) */
         *AdminDescriptionPtr,
         /* buffer for this original call parameter */
         *DatabaseDir,
         /* */
         *UserListPtr;

   AUTH_HTAREC  AuthHtRecord;

   /* structures for file system access */
   ODS_STRUCT  FileOds,
               SearchOds;

   /* pointer to function, used for specifying the next task */
   REQUEST_AST NextTaskFunction;
};

/**************/
/* structures */
/**************/

HTAdminBegin (REQUEST_STRUCT*, REQUEST_AST);
char* HTAdminCanString (REQUEST_STRUCT*, unsigned long, BOOL);
HTAdminChangePassword (REQUEST_STRUCT*, char*, char*, char*);
HTAdminChangePasswordForm (REQUEST_STRUCT*);
HTAdminDatabaseBegin (REQUEST_STRUCT*);
HTAdminDatabaseCreateForm (REQUEST_STRUCT*, char*);
HTAdminDatabaseDeleteForm (REQUEST_STRUCT*, char*);
HTAdminDatabaseEnd (REQUEST_STRUCT*);
HTAdminDatabaseSearch (REQUEST_STRUCT*);
HTAdminDatabaseSearchAst (struct FAB*); 
HTAdminDatabaseUsersBegin (REQUEST_STRUCT*, char*);
HTAdminDatabaseUsersEnd (REQUEST_STRUCT*);
HTAdminDatabaseUsersList (REQUEST_STRUCT*);
HTAdminDatabaseUsersNext (REQUEST_STRUCT*);
HTAdminDatabaseUsersNextAst (struct RAB*); 
HTAdminEnd (REQUEST_STRUCT*);
HTAdminListUsersBegin (REQUEST_STRUCT*, char*);
HTAdminListUsersEnd (REQUEST_STRUCT*);
HTAdminListUsersList (REQUEST_STRUCT*);
HTAdminListUsersListSort (REQUEST_STRUCT*);
HTAdminListUsersNext (REQUEST_STRUCT*);
HTAdminListUsersNextAst (struct RAB*); 
HTAdminModifyUser (REQUEST_STRUCT*, BOOL, char*, char*, char*,
                   char*, char*, char*, char*, char*, char*, char*, char*);
HTAdminModifyUserForm (REQUEST_STRUCT*, BOOL, char*, char*);
HTAdminPurgeCacheEntry (REQUEST_STRUCT*);
HTAdminUserDelete (REQUEST_STRUCT*, char*, char*);
HTAdminUserDeleteForm (REQUEST_STRUCT*, char*, char*);
HTAdminUserView (REQUEST_STRUCT*, char*, char*);

#endif /* HTADMIN_H_LOADED */

/*****************************************************************************/

