/*****************************************************************************/
/*
                               Instance.h

*/
/*****************************************************************************/

#ifndef INSTANCE_H_LOADED
#define INSTANCE_H_LOADED 1

#include "wasd.h"

/* these must be sequential from 1 to whatever (used as array indices) */
#define INSTANCE_CLUSTER            0x01  /* join cluster instance */
#define INSTANCE_CLUSTER_DO         0x02  /* distributes cluster directive */
#define INSTANCE_CLUSTER_CONTROL    0x03  /* locks command directive */
#define INSTANCE_CLUSTER_PROXYMAINT 0x04  /* locks proxy cache maintainance */
#define INSTANCE_CLUSTER_LOCK_COUNT    4  /* DON'T FORGET TO ADJUST! */
#define INSTANCE_NODE               0x05  /* join node instance */
#define INSTANCE_NODE_DO            0x06  /* distributes node directive */
#define INSTANCE_NODE_WATCH         0x07  /* WATCH is in use */
#define INSTANCE_NODE_SINGLE        0x08  /* starting config of one instance */
#define INSTANCE_NODE_JOINING       0x09  /* instance is joining the node */
#define INSTANCE_NODE_READY         0x0a  /* instance is ready for requests */
#define INSTANCE_NODE_SUPERVISOR    0x0b  /* delegates per-node supervisor */
#define INSTANCE_NODE_SOCKET        0x0c  /* lock socket allocation */
#define INSTANCE_NODE_LOCK_COUNT       8  /* DITTO! */
                                          /* AND ADJUST CODES BELOW!! */
#define INSTANCE_LOCK_CODES 0x00, \
        0x01,0x02,0x03,0x04, \
        0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c

#define INSTANCE_LOCK_USES "", \
        "cluster", "do", "control", "proxy-maint", \
        "node", "do", "watch", "single", "join", "ready", "super", "socket"

#define INSTANCE_LOCK_COUNT INSTANCE_CLUSTER_LOCK_COUNT + \
                            INSTANCE_NODE_LOCK_COUNT

/* must remain below INSTANCE_LOCK_PRINTABLE */
#define INSTANCE_NODE_SOCKIP4       0x14  /* distributes IPv4 socket BG: */
#define INSTANCE_NODE_SOCKIP6       0x16  /* distributes IPv6 socket BG: */

#define INSTANCE_LOCK_PRINTABLE     0x20  /* (space) */

#define INSTANCE_MUTEX_HTTPD           1  /* main global section */
#define INSTANCE_MUTEX_ACTIVITY        2  /* actvitity stats global section */
#define INSTANCE_MUTEX_AUTH_CACHE      3  /* authorization cache */
#define INSTANCE_MUTEX_PROXY_VERIFY    4  /* proxy verify records */
#define INSTANCE_MUTEX_SSL_CACHE       5  /* SSL session cache */
#define INSTANCE_MUTEX_COUNT           5  /* DON'T FORGET TO ADJUST! */
#define INSTANCE_MUTEX_DESCR \
   { NULL, "MUTEX_HTTPD", "MUTEX_ACTIVITY", \
     "MUTEX_AUTH_CACHE", "MUTEX_PROXY_VERIFY", \
     "MUTEX_SSL_CACHE" }                 /* ditto!! */

/* maximum number of processes */
#define INSTANCE_MAX 8

/* maximum number of sockets that can be shared between per-node instances */
#define INSTANCE_LOCK_SOCKET_MAX 64

/* maximum number of locks that can be $GETLKI()ed at the one time */
#define INSTANCE_REPORT_LOCK_MAX 256

/* minimum seconds between node supervisor polls */
#define INSTANCE_SUPERVISOR_POLL 15

/* maximum seconds before we commence a rolling restart */
#define INSTANCE_RESTART_SECONDS 3600

/* number of seconds we'll wait before considering it a lost cause */
#define INSTANCE_MUTEX_WAIT 300

/* a sentinal to indicate as many instances as CPUs should be created */
#define INSTANCE_PER_CPU -999

/* maximum /INSTANCE=<integer> allowed (4 bits) */
#define INSTANCE_GROUP_NUMBER_MAX 15

/*******************/
/* data structures */
/*******************/

#ifndef __VAX
#   pragma member_alignment __save
#   pragma member_alignment
#endif

typedef struct InstanceLockStruct INSTANCE_LOCK;

struct InstanceLockStruct
{
   BOOL  InUse;
   char  Name [32];
   struct dsc$descriptor_s  NameDsc;
   struct lksb  Lksb;
   CALL_BACK  AstFunction;
};

typedef struct InstanceSocketLockStruct INSTANCE_SOCKET_LOCK;

struct InstanceSocketLockStruct
{
   char  Name [32];
   struct lksb  Lksb;
};

#ifndef __VAX
#   pragma member_alignment __restore
#endif                

/***********************/
/* function prototypes */
/***********************/

InstanceExit ();
InstanceGblSecDecrLong (long*);
InstanceGblSecIncrLong (long*);
InstanceFinalInit ();
InstanceLock (int);
int InstanceLockControl ();
int InstanceLockInit ();
int InstanceLockList (int, char*, char**);
int InstanceLockNotifyNow (int, char*);
int InstanceLockNotifySet (int, CALL_BACK);
int InstanceLockNoWait (int);
InstanceLockNotifySetAst (int);
InstanceLockReport (REQUEST_STRUCT*, REQUEST_AST);
InstanceLockReportData (REQUEST_STRUCT*, unsigned long*);
InstanceMutexLock ();
InstanceMutexUnLock ();
InstanceNodeSupervisorAst (int);
InstanceNodeJoiningAst ();
char* InstanceParseLockName (char*);
InstanceProcessName ();
InstanceServerInit ();
int InstanceSocketAdmin (short);
int InstanceSocketForAdmin (char*, short*);
char* InstanceSocket (IPADDRESS*, short, char*);
BOOL InstanceSupervisor ();
int InstanceUnLock (int);
InstanceLockUnlockControl ();

#endif /* INSTANCE_H_LOADED */

/*****************************************************************************/

