/*****************************************************************************/
/*
                                  IsMap.h
*/
/*****************************************************************************/

#ifndef ISMAP_H_LOADED
#define ISMAP_H_LOADED 1

#include "wasd.h"

#define ISMAP_READ_BUFFER_SIZE 512

/* required by the NCSA mapping functions, used by this module */
#define MAXVERTS 100

/**************/
/* structures */
/**************/

typedef struct IsMapTaskStruct ISMAP_TASK;

struct IsMapTaskStruct
{
   int  /* character number currently being parsed (for error information) */
        IsMapCharNumber,
        /* line number in current line (for error information) */
        IsMapLineNumber;

   char  /* start of current line */
         *LinePtr,
         /* start of next line */
         *ParsePtr;

   double  /* keeps track of closest 'point x,y' (if any) */
           IsMapClosestPoint,
           /* stores the numeric equivalent of the browser x,y click point */
           IsMapClickCoord [2];

   FILE_CONTENT  *FileContentPtr;
};

/***********************/
/* function prototypes */
/***********************/

IsMapBegin (REQUEST_STRUCT*);
IsMapParseLine (REQUEST_STRUCT*);
IsMapExplainError (REQUEST_STRUCT*, char*, char*, int);
int pointinrect(double[2], double[MAXVERTS][2]);
int pointincircle(double[2], double[MAXVERTS][2]);
int pointinpoly(double[2], double[MAXVERTS][2]);

#endif /* ISMAP_H_LOADED */

/*****************************************************************************/
