/*****************************************************************************/
/*
                                  MapUrl.h
*/
/*****************************************************************************/

#ifndef MAPURL_H_LOADED
#define MAPURL_H_LOADED 1

#include "wasd.h"
#include "metacon.h"

#define MAPURL_RULE_EXEC      1
#define MAPURL_RULE_FAIL      2
#define MAPURL_RULE_MAP       3
#define MAPURL_RULE_PASS      4
#define MAPURL_RULE_REDIRECT  5
#define MAPURL_RULE_SCRIPT    6
#define MAPURL_RULE_SET       7
#define MAPURL_RULE_USER      8
#define MAPURL_RULE_UXEC      9
#define MAPURL_RULE_PROTECT  10

#define MAPURL_REPORT_MATCH_NOT         0
#define MAPURL_REPORT_MATCH_RULE        1
#define MAPURL_REPORT_MATCH_RULECOND    2
#define MAPURL_REPORT_MATCH_RULENOCOND  3
#define MAPURL_REPORT_MATCH_VIRT        4

#define MAPURL_PATH_ODS_0    -1
#define MAPURL_PATH_ODS_2     2
#define MAPURL_PATH_ODS_5     5
#define MAPURL_PATH_ODS_ADS  66 
#define MAPURL_PATH_ODS_PWK  77 
#define MAPURL_PATH_ODS_SMB  88 
#define MAPURL_PATH_ODS_SRI  99

#define MAPURL_PATH_ODS_SRI  99

#define MAPURL_DIR_STYLE_DEFAULT     -1
#define MAPURL_DIR_STYLE_NONE         0
#define MAPURL_DIR_STYLE_ORIGINAL     1  /* pre-v8.2 */
#define MAPURL_DIR_STYLE_ANCHOR       2  /* post-v8.2 */
#define MAPURL_DIR_STYLE_HTDIR        9  /* Alex Ivanov's HTdir, etc. */

#define MAPURL_PATH_ALERT_END   0x0001
#define MAPURL_PATH_ALERT_AUTH  0x0002
#define MAPURL_PATH_ALERT_MAP   0x0004
#define MAPURL_PATH_ALERT_DONE  0x8000  /* bit that is ORed into the flag */

/* used to mask the actual reason for denying access to a USER rule username */
#define MAPURL_USER_RULE_FORBIDDEN_MSG       "\0" "403 USER forbidden!"

/* put a brake on potentially runaway mapping restarts */
#define MAPURL_RESTART_MAX 5

#define MAPURL_NO_REVERSE_PATH "NO:[REVERSE.MAPPING.FOR.THIS]FILE.PATH!"

/*******************/
/* data structures */
/*******************/

#ifndef __VAX
#   pragma member_alignment __save
#   pragma member_alignment
#endif

typedef struct MapPathSetMetaStruct MAP_SET_META;

struct MapPathSetMetaStruct
{
   BOOL  AcceptLangWildcard,
         AcceptLangTypeVariant,
         NoAcceptLang,
         Alert,
         NoAlert,
         AuthAll,
         NoAuthAll,
         AuthMapped,
         NoAuthMapped,
         AuthOnce,
         NoAuthOnce,
         Cache,
         NoCache,
         CacheCGI,
         CacheNoCGI,
         CacheFile,
         CacheNoFile,
         CacheNet,
         CacheNoNet,
         CacheNPH,
         CacheNoNPH,
         CachePermanent,
         CacheNoPermanent,
         CacheQuery,
         CacheNoQuery,
         CacheScript,
         CacheNoScript,
         CacheSSI,
         CacheNoSSI,
         CacheSetting,
         CgiPlusInWriteof,
         CgiPlusInNoWriteof,
         DefaultSearch,
         NoDefaultSearch,
         DirAccess,
         DirAccessSelective,
         DirNoAccess,
         DirImpliedWildcard,
         DirNoImpliedWildcard,
         DirWildcard,
         DirNoWildcard,
         Expired,
         NoExpired,
         Extended,
         GetUai,
         NoGetUai,
         NoHtmlEquals,
         Log,
         NoLog,
         MapEllipsis,
         NoMapEllipsis,
         MapEmpty,
         MapNonEmpty,
         MapOnce,
         NoMapOnce,
         MapRestart,
         MapSetIgnore,
         MapSetNoIgnore,
         MapSetRequest,
         MapSetNoRequest,
         PrivSsi,
         NoPrivSsi,
         Profile,
         NoProfile,
         ProxyReverseVerify,
         NoProxyReverseVerify,
         ProxyUnknownRequestFields,
         NoProxyUnknownRequestFields,
         ReportBasic,
         ReportDetailed,
         ResponseHeaderBegin,
         ResponseHeaderFull,
         ResponseHeaderNone,
         ResponseHeaderNoAdd,
         ScriptFind,
         ScriptNoFind,
         ScriptPathFind,
         ScriptNoPathFind,
         ScriptQueryNone,
         ScriptNoQueryNone,
         ScriptQueryRelaxed,
         ScriptNoQueryRelaxed,
         StmLF,
         NoStmLF,
         WildcardEllipsis,
         NoWildcardEllipsis;

   int  AcceptLangLength,
        AuthRevalidateTimeout,
        AuthSysUafPwdExpUrlLength,
        CacheExpiresAfter,
        CacheGuardSeconds,
        CacheMaxKBytes,
        CgiPrefixLength,
        CharsetLength,
        ContentTypeLength,
        DirCharsetLength,
        DirStyle,
        HtmlBodyTagLength,
        HtmlFooterLength,
        HtmlFooterTagLength,
        HtmlHeaderLength,
        HtmlHeaderTagLength,
        HttpAcceptCharsetLength,
        HttpAcceptLangLength,
        IndexLength,
        MapRootLength,
        NotePadLength,
        PathOds,
        ProxyBindIpAddressLength,
        ProxyChainHostPortLength,
        ProxyChainPort,
        ProxyForwardedBy,
        ProxyReverseLocationLength,
        ProxyXForwardedFor,
        QueryStringLength,
        Report400as,
        Report403as,
        Report404as,
        ResponseHeaderAddLength,
        ScriptAsLength,
        ScriptCommandLength,
        ScriptBitBucketTimeout,
        ScriptCpuMax,
        ScriptDefaultLength,
        ScriptParamsLength,
        SsiExecLength,
        SSLCGIvar,
        ThrottleIndex,
        ThrottleBusy,
        ThrottleFrom,
        ThrottleResume,
        ThrottleTo,
        ThrottleTimeoutBusy,
        ThrottleTimeoutQueue,
        TimeoutKeepAlive,
        TimeoutNoProgress,
        TimeoutOutput;

   char  AcceptLangChar,
         RmsSubChar;

   char  *AcceptLangPtr,
         *AuthSysUafPwdExpUrlPtr,
         *CgiPrefixPtr,
         *CharsetPtr,
         *ContentTypePtr,
         *DirCharsetPtr,
         *HtmlBodyTagPtr,
         *HtmlFooterPtr,
         *HtmlFooterTagPtr,
         *HtmlHeaderPtr,
         *HtmlHeaderTagPtr,
         *HttpAcceptCharsetPtr,
         *HttpAcceptLangPtr,
         *IndexPtr,
         *MapRootPtr,
         *NotePadPtr,
         *ProxyBindIpAddressPtr,
         *ProxyChainHostPortPtr,
         *ProxyReverseLocationPtr,
         *QueryStringPtr,
         *ResponseHeaderAddPtr,
         *ScriptAsPtr,
         *ScriptCommandPtr,
         *ScriptDefaultPtr,
         *ScriptParamsPtr,
         *SsiExecPtr;

   IPADDRESS  ProxyBindIpAddress,
              ProxyChainIpAddress;

   char  CgiPlusInCC [4];
};

typedef struct MappingRuleMetaStruct MAP_RULE_META;

struct MappingRuleMetaStruct
{
   BOOL  IsCgiPlusScript,
         PathSet;

   int  MetaConNumber,
        ResultLength,
        ResultPathOds,
        RuleType;

   char  *ConditionalPtr,
         *ResultPtr,
         *TemplatePtr;

   /* storage for pre-compiled regular expression */
   regex_t  RegexPregTemplate;

   MAP_SET_META  mpPathSet;

   /* strings are stored straight after and pointed to by the above */
   char  Storage[];
};

typedef struct MappingMetaStruct MAPPING_META;

struct MappingMetaStruct
{
   int  ThrottleIndex,
        ThrottleTotal;
   REQUEST_STRUCT  *RequestPtr;
};

#define MAPURL_USER_NAME_SIZE    12
#define MAPURL_USER_DEFDEV_SIZE  31
#define MAPURL_USER_DEFDIR_SIZE  63
#define MAPURL_USER_PATH_SIZE MAPURL_USER_DEFDEV_SIZE + MAPURL_USER_DEFDIR_SIZE

typedef struct MapUrlUserCacheStruct MAP_URL_USER_ENTRY;

struct MapUrlUserCacheStruct
{
   LIST_ENTRY  UserCacheListEntry;
   int  HitCount,
        PathOds,
        ReuseCount;
   unsigned long  LastBinaryTime [2];
   char  UserName [MAPURL_USER_NAME_SIZE+1],
         UserPath [MAPURL_USER_PATH_SIZE+1];
};

#ifndef __VAX
#   pragma member_alignment __restore
#endif

/***********************/
/* function prototypes */
/***********************/

/* "quick and dirty" return path equivalent of VMS file specification */
#define MapVmsPath(vp,rp) \
        MapUrl_Map (NULL, 0, vp, 0, NULL, 0, NULL, 0, NULL, 0, NULL, rp)

/* (re)load the mappings */
#define MapUrl_Load() MapUrl_Map(NULL,0,NULL,0,NULL,0,NULL,0,NULL,0,NULL,NULL)

char* MapUrl_Map (char*, int, char*, int, char*, int, char*, int, char*, int,
                  int*, REQUEST_STRUCT*);
char* MapUrl__Map (char*, int, char*, int, char*, int, char*, int, char*, int,
                   int*, REQUEST_STRUCT*);
BOOL MapUrl_Conditional (REQUEST_STRUCT*, MAP_RULE_META*, REQUEST_PATHSET*);
int MapUrl_ConfigLoad (META_CONFIG**);
BOOL MapUrl_ConfigLoadCallBack (META_CONFIG*);
int MapUrl_ConfigUnload (META_CONFIG*);
MapUrl_ConfigUnloadLineData (void*);
char* MapUrl_ExplainPathSet (MAP_RULE_META*);
char* MapUrl_ReportMessage (struct MappingRuleListStruct*, char*, int);
int MapUrl_SetSeconds (struct MappingRuleListStruct*, char*, int);
MAP_RULE_META* MapUrl_ThrottleRule (int);
MapUrl_ConfigParseValue (char*);
int MapUrl_ElementsToVms (char*, int, char*, int, BOOL);
int MapUrl_AdsVmsToUrl (char*, char*, int, BOOL);
char* MapUrl_AdsFileType (char*);
int MapUrl_PwkVmsToUrl (char*, char*, int, BOOL);
char* MapUrl_SriFileType (char*);
int MapUrl_SriVmsToUrl (char*, char*, int, BOOL);
char MapUrl_SriDecode (char**, BOOL*);
int MapUrl_Ods2VmsToUrl (char*, char*, int, BOOL);
int MapUrl_Ods5VmsToUrl (char*, char*, int, BOOL);
int MapUrl_UrlToVms (char*, char*, int, char, BOOL, int);
int MapUrl_UrlToAdsVms (char*, char*, int, BOOL);
int MapUrl_UrlToPwkVms (char*, char*, int, BOOL);
int MapUrl_UrlToSriVms (char*, char*, int, BOOL);
int MapUrl_UrlToOds2Vms (char*, char*, int, BOOL, char);
int MapUrl_UrlToOds5Vms (char*, char*, int, BOOL);
int MapUrl_VirtualPath (char*, char*, char*, int);
int MapUrl_VmsToUrl (char*, char*, int, BOOL, int);
char *MapUrl_VmsUserName (REQUEST_STRUCT*, char*, int*);
char *MapUrl_VmsUserNameCache (REQUEST_STRUCT*, char*, char*, int*);
int MapUrl_VolumeOds (char*);
MapUrl_WatchRule (REQUEST_STRUCT*, MAP_RULE_META*, char*, int, int, BOOL);

#endif /* MAPURL_H_LOADED */

/*****************************************************************************/
