/*****************************************************************************/
/*
                                  Menu.h
*/
/*****************************************************************************/

#ifndef MENU_H_LOADED
#define MENU_H_LOADED 1

#include "wasd.h"

/**************/
/* structures */
/**************/

typedef struct MenuTaskStruct MENU_TASK;

struct MenuTaskStruct
{
   int  /* length of string pointed to by 'LinePtr' */
        LineLength,
        /* used to count consecutive blank lines */
        MenuBlankLineCount,
        /* used to count consecutive non-blank lines */
        MenuLineCount,
        /* used to track current section number */
        MenuSectionNumber;

   char  /* points to the start of the current line */
         *LinePtr,
         /* pointer to heap storage of dynamic record buffer */
         *MenuBufferPtr,
         /* used when parsing lines out of the file contents */
         *ParsePtr;

   char  /* space for file description */
         Description [256];

   /* structures for file system access */
   ODS_STRUCT  FileOds,
               SearchOds;

   /* pointer to function */
   REQUEST_AST  MenuAstFunction;

   /* structure for receiving the file's contents in-memory */
   FILE_CONTENT  *FileContentPtr;
};

/***********************/
/* function prototypes */
/***********************/

MenuBegin (REQUEST_STRUCT*);
MenuContents (REQUEST_STRUCT*);
MenuDescription (REQUEST_STRUCT*);
MenuEnd (REQUEST_STRUCT*);
MenuFileDescription (REQUEST_STRUCT*, REQUEST_AST, char*);
MenuFileDescriptionNext (REQUEST_STRUCT*);
MenuFileDescriptionOf (struct FAB*);
MenuFileDescriptionDone (REQUEST_STRUCT*);
MenuItems (REQUEST_STRUCT*);
MenuNextContents (REQUEST_STRUCT*);
MenuTitle (REQUEST_STRUCT*);
MenuSearchItem (REQUEST_STRUCT*, REQUEST_AST, char*, char*, char*);

#endif /* MENU_H_LOADED */

/*****************************************************************************/
