/*****************************************************************************/
/*
                                  msg.h

Defines a macro and number 1..n for all of the messages used in the server.
Also calculates the number of messages so created for sizing of data
structures, looping purposes, etc. In true C fashion this could break horribly
if the __BASE, __MAX and NUMBER_OF_GROUPS macros are not properly adjusted
when the number of defined messages is altered!  The __BASE number (and
pointer array index) is reserved for storing the group name in language one for
reporting purposes.

21-AUG-2003  MGD  add character set field
04-APR-2003  MGD  add 'LanguageList' field
26-JUN-2002  MGD  additional messages for v8.0
06-MAY-2000  MGD  additional messages for v7.0
23-DEC-1999  MGD  bugfix; MSG_PROXY_RESPONSE_HEADER
04-DEC-1999  MGD  additional messages for v6.1
05-MAY-1999  MGD  additional messages for v6.0 proxy
12-MAR-1998  MGD  additional messages for v5.0
25-OCT-1997  MGD  changes around MsgFor() when no request structure available
31-AUG-1997  MGD  added MSG_DIR_INDEX_OF and MSG_DIR_TREE_OF (an oversight)
09-AUG-1997  MGD  initial
*/
/*****************************************************************************/

#ifndef MSG_H_LOADED
#define MSG_H_LOADED 1

#include "wasd.h"

#define  MSG_AUTH__BASE                 0
#define  MSG_AUTH_REQUIRED              MSG_AUTH__BASE+1
#define  MSG_AUTH_ACCESS_DENIED         MSG_AUTH__BASE+2
#define  MSG_AUTH_FAILED                MSG_AUTH__BASE+3
#define  MSG_AUTH_SCHEME                MSG_AUTH__BASE+4
#define  MSG_AUTH_USER                  MSG_AUTH__BASE+5
#define  MSG_AUTH_DATABASE              MSG_AUTH__BASE+6
#define  MSG_AUTH_DATABASE_VMS          MSG_AUTH__BASE+7
#define  MSG_AUTH_USERNAME_LENGTH       MSG_AUTH__BASE+8
#define  MSG_AUTH_PASSWORD_LENGTH       MSG_AUTH__BASE+9
#define  MSG_AUTH_NO_LOGOUT             MSG_AUTH__BASE+10
#define  MSG_AUTH_AGENT_MAPPING         MSG_AUTH__BASE+11
#define  MSG_AUTH_AGENT_NOT_FOUND       MSG_AUTH__BASE+12
#define  MSG_AUTH_AGENT_RESPONSE        MSG_AUTH__BASE+13
#define  MSG_AUTH__MAX                  13

#define  MSG_DIR__BASE                  MSG_AUTH__BASE+MSG_AUTH__MAX+1
#define  MSG_DIR_COLUMN_HEADINGS        MSG_DIR__BASE+1
#define  MSG_DIR_PARENT                 MSG_DIR__BASE+2
#define  MSG_DIR_SUB                    MSG_DIR__BASE+3
#define  MSG_DIR_LAYOUT                 MSG_DIR__BASE+4
#define  MSG_DIR_INDEX_OF               MSG_DIR__BASE+5
#define  MSG_DIR_TREE_OF                MSG_DIR__BASE+6
#define  MSG_DIR__MAX                   6

#define  MSG_GENERAL__BASE              MSG_DIR__BASE+MSG_DIR__MAX+1
#define  MSG_GENERAL_SANITY             MSG_GENERAL__BASE+1
#define  MSG_GENERAL_INTERNAL           MSG_GENERAL__BASE+2
#define  MSG_GENERAL_OVERFLOW           MSG_GENERAL__BASE+3
#define  MSG_GENERAL_HEAP               MSG_GENERAL__BASE+4
#define  MSG_GENERAL_CALLOC             MSG_GENERAL__BASE+5
#define  MSG_GENERAL_REQUEST_CALLOC     MSG_GENERAL__BASE+6
#define  MSG_GENERAL_TOO_BUSY           MSG_GENERAL__BASE+7
#define  MSG_GENERAL_ACCESS_DENIED      MSG_GENERAL__BASE+8
#define  MSG_GENERAL_DISABLED           MSG_GENERAL__BASE+9
#define  MSG_GENERAL_NO_WILDCARD        MSG_GENERAL__BASE+10
#define  MSG_GENERAL_FILE               MSG_GENERAL__BASE+11
#define  MSG_GENERAL_DOCUMENT           MSG_GENERAL__BASE+12
#define  MSG_GENERAL_DIRECTORY          MSG_GENERAL__BASE+13
#define  MSG_GENERAL__MAX               13

#define  MSG_HTTP__BASE                 MSG_GENERAL__BASE+MSG_GENERAL__MAX+1
#define  MSG_HTTP_UNKNOWN               MSG_HTTP__BASE+1
#define  MSG_HTTP_100                   MSG_HTTP__BASE+2
#define  MSG_HTTP_101                   MSG_HTTP__BASE+3
#define  MSG_HTTP_200                   MSG_HTTP__BASE+4
#define  MSG_HTTP_201                   MSG_HTTP__BASE+5
#define  MSG_HTTP_202                   MSG_HTTP__BASE+6
#define  MSG_HTTP_203                   MSG_HTTP__BASE+7
#define  MSG_HTTP_204                   MSG_HTTP__BASE+8
#define  MSG_HTTP_205                   MSG_HTTP__BASE+9
#define  MSG_HTTP_206                   MSG_HTTP__BASE+10
#define  MSG_HTTP_300                   MSG_HTTP__BASE+11
#define  MSG_HTTP_301                   MSG_HTTP__BASE+12
#define  MSG_HTTP_302                   MSG_HTTP__BASE+13
#define  MSG_HTTP_303                   MSG_HTTP__BASE+14
#define  MSG_HTTP_304                   MSG_HTTP__BASE+15
#define  MSG_HTTP_305                   MSG_HTTP__BASE+16
#define  MSG_HTTP_400                   MSG_HTTP__BASE+17
#define  MSG_HTTP_401                   MSG_HTTP__BASE+18
#define  MSG_HTTP_402                   MSG_HTTP__BASE+19
#define  MSG_HTTP_403                   MSG_HTTP__BASE+20
#define  MSG_HTTP_404                   MSG_HTTP__BASE+21
#define  MSG_HTTP_405                   MSG_HTTP__BASE+22
#define  MSG_HTTP_406                   MSG_HTTP__BASE+23
#define  MSG_HTTP_407                   MSG_HTTP__BASE+24
#define  MSG_HTTP_408                   MSG_HTTP__BASE+25
#define  MSG_HTTP_409                   MSG_HTTP__BASE+26
#define  MSG_HTTP_410                   MSG_HTTP__BASE+27
#define  MSG_HTTP_411                   MSG_HTTP__BASE+28
#define  MSG_HTTP_412                   MSG_HTTP__BASE+29
#define  MSG_HTTP_413                   MSG_HTTP__BASE+30
#define  MSG_HTTP_414                   MSG_HTTP__BASE+31
#define  MSG_HTTP_415                   MSG_HTTP__BASE+32
#define  MSG_HTTP_500                   MSG_HTTP__BASE+33
#define  MSG_HTTP_501                   MSG_HTTP__BASE+34
#define  MSG_HTTP_502                   MSG_HTTP__BASE+35
#define  MSG_HTTP_503                   MSG_HTTP__BASE+36
#define  MSG_HTTP_504                   MSG_HTTP__BASE+37
#define  MSG_HTTP_505                   MSG_HTTP__BASE+38
#define  MSG_HTTP__MAX                  38

#define  MSG_HTADMIN__BASE              MSG_HTTP__BASE+MSG_HTTP__MAX+1
#define  MSG_HTADMIN_DATABASE           MSG_HTADMIN__BASE+1
#define  MSG_HTADMIN_PWD_INCORRECT      MSG_HTADMIN__BASE+2
#define  MSG_HTADMIN_PWD_INCOMPLETE     MSG_HTADMIN__BASE+3
#define  MSG_HTADMIN_PWD_VERIFY         MSG_HTADMIN__BASE+4
#define  MSG_HTADMIN_PWD_IDENTICAL      MSG_HTADMIN__BASE+5
#define  MSG_HTADMIN_PWD_ERROR          MSG_HTADMIN__BASE+6
#define  MSG_HTADMIN_PWD_NOT_FOUND      MSG_HTADMIN__BASE+7
#define  MSG_HTADMIN_PWD_DATABASE       MSG_HTADMIN__BASE+8
#define  MSG_HTADMIN_PWD_CHANGE         MSG_HTADMIN__BASE+9
#define  MSG_HTADMIN_PWD_BEEN_CHANGED   MSG_HTADMIN__BASE+10
#define  MSG_HTADMIN__MAX               10

#define  MSG_ISMAP__BASE                MSG_HTADMIN__BASE+MSG_HTADMIN__MAX+1
#define  MSG_ISMAP_CONFUSED             MSG_ISMAP__BASE+1
#define  MSG_ISMAP_COORDINATE           MSG_ISMAP__BASE+2
#define  MSG_ISMAP_DEFAULT              MSG_ISMAP__BASE+3
#define  MSG_ISMAP_INCOMPLETE           MSG_ISMAP__BASE+4
#define  MSG_ISMAP_INCORRECT            MSG_ISMAP__BASE+5
#define  MSG_ISMAP_LIMIT                MSG_ISMAP__BASE+6
#define  MSG_ISMAP_REGION               MSG_ISMAP__BASE+7
#define  MSG_ISMAP__MAX                 7

#define  MSG_MAPPING__BASE              MSG_ISMAP__BASE+MSG_ISMAP__MAX+1
#define  MSG_MAPPING_DENIED_NO_RULES    MSG_MAPPING__BASE+1
#define  MSG_MAPPING_DENIED_INTERNAL    MSG_MAPPING__BASE+2
#define  MSG_MAPPING_DENIED_RULE        MSG_MAPPING__BASE+3
#define  MSG_MAPPING_DENIED_DEFAULT     MSG_MAPPING__BASE+4
#define  MSG_MAPPING__MAX               4

#define  MSG_PROXY__BASE                MSG_MAPPING__BASE+MSG_MAPPING__MAX+1
#define  MSG_PROXY_NONE_CONFIGURED      MSG_PROXY__BASE+1
#define  MSG_PROXY_DISABLED             MSG_PROXY__BASE+2
#define  MSG_PROXY_NOT_SERVICE          MSG_PROXY__BASE+3
#define  MSG_PROXY_NOT_CONNECT          MSG_PROXY__BASE+4
#define  MSG_PROXY_REQUEST_SCHEME       MSG_PROXY__BASE+5
#define  MSG_PROXY_HOST_UNKNOWN         MSG_PROXY__BASE+6
#define  MSG_PROXY_CHAIN_REFUSED        MSG_PROXY__BASE+7
#define  MSG_PROXY_CONNECT_REFUSED      MSG_PROXY__BASE+8
#define  MSG_PROXY_CHAIN_UNREACHABLE    MSG_PROXY__BASE+9
#define  MSG_PROXY_HOST_UNREACHABLE     MSG_PROXY__BASE+10
#define  MSG_PROXY_CHAIN_FAILURE        MSG_PROXY__BASE+11
#define  MSG_PROXY_RESPONSE_ERROR       MSG_PROXY__BASE+12
#define  MSG_PROXY_HOST_DISCONNECTED    MSG_PROXY__BASE+13
#define  MSG_PROXY_RESPONSE_HEADER      MSG_PROXY__BASE+14
#define  MSG_PROXY_GATEWAY              MSG_PROXY__BASE+15
#define  MSG_PROXY_FTP_SERVER           MSG_PROXY__BASE+16
#define  MSG_PROXY_FTP_USERNAME_PWD     MSG_PROXY__BASE+17
#define  MSG_PROXY_FTP_INDEX_OF         MSG_PROXY__BASE+18
#define  MSG_PROXY_FTP_SERVER_REPLIED   MSG_PROXY__BASE+19
#define  MSG_PROXY_FTP_NO_FILENAME      MSG_PROXY__BASE+20
#define  MSG_PROXY__MAX                 20

#define  MSG_PUT__BASE                  MSG_PROXY__BASE+MSG_PROXY__MAX+1
#define  MSG_PUT_MULTIPART              MSG_PUT__BASE+1
#define  MSG_PUT_MULTIPART_FORMDATA     MSG_PUT__BASE+2
#define  MSG_PUT_MULTIPART_MIXED        MSG_PUT__BASE+3
#define  MSG_PUT_MULTIPART_FILENAME     MSG_PUT__BASE+4
#define  MSG_PUT_MULTIPART_FIELD        MSG_PUT__BASE+5
#define  MSG_PUT_MULTIPART_UPLOAD       MSG_PUT__BASE+6
#define  MSG_PUT_DIR_NAME               MSG_PUT__BASE+7
#define  MSG_PUT_DIR_EXISTS             MSG_PUT__BASE+8
#define  MSG_PUT_DELETE_NO_FILENAME     MSG_PUT__BASE+9
#define  MSG_PUT_CREATED                MSG_PUT__BASE+10
#define  MSG_PUT_SUPERCEDED             MSG_PUT__BASE+11
#define  MSG_PUT_DELETED                MSG_PUT__BASE+12
#define  MSG_PUT__MAX                   12

#define  MSG_REQUEST__BASE              MSG_PUT__BASE+MSG_PUT__MAX+1
#define  MSG_REQUEST_FORMAT             MSG_REQUEST__BASE+1
#define  MSG_REQUEST_METHOD             MSG_REQUEST__BASE+2
#define  MSG_REQUEST_BODY_READ          MSG_REQUEST__BASE+3
#define  MSG_REQUEST_BODY_MAX           MSG_REQUEST__BASE+4
#define  MSG_REQUEST_REDIRECTION        MSG_REQUEST__BASE+5
#define  MSG_REQUEST_URL_ENC            MSG_REQUEST__BASE+6
#define  MSG_REQUEST_URL_FORM           MSG_REQUEST__BASE+7
#define  MSG_REQUEST__MAX               7

#define  MSG_SCRIPT__BASE               MSG_REQUEST__BASE+MSG_REQUEST__MAX+1
#define  MSG_SCRIPT_NOT_FOUND           MSG_SCRIPT__BASE+1
#define  MSG_SCRIPT_HARD_LIMIT          MSG_SCRIPT__BASE+2
#define  MSG_SCRIPT_PRAGMA              MSG_SCRIPT__BASE+3
#define  MSG_SCRIPT_COOKIE              MSG_SCRIPT__BASE+4
#define  MSG_SCRIPT_IPC                 MSG_SCRIPT__BASE+5
#define  MSG_SCRIPT_SPAWN               MSG_SCRIPT__BASE+6
#define  MSG_SCRIPT_DCL_ENVIRONMENT     MSG_SCRIPT__BASE+7
#define  MSG_SCRIPT_CGIPLUS_VARIABLES   MSG_SCRIPT__BASE+8
#define  MSG_SCRIPT_RESPONSE_ERROR      MSG_SCRIPT__BASE+9
#define  MSG_SCRIPT__MAX                9

#define  MSG_SSI__BASE                  MSG_SCRIPT__BASE+MSG_SCRIPT__MAX+1
#define  MSG_SSI_ERROR                  MSG_SSI__BASE+1
#define  MSG_SSI_LINE                   MSG_SSI__BASE+2
#define  MSG_SSI_ACCESS_DISABLED        MSG_SSI__BASE+3
#define  MSG_SSI_STATEMENT              MSG_SSI__BASE+4
#define  MSG_SSI_STATEMENT_UNKNOWN      MSG_SSI__BASE+5
#define  MSG_SSI_TAG_UNKNOWN            MSG_SSI__BASE+6
#define  MSG_SSI_TAG_VALUE              MSG_SSI__BASE+7
#define  MSG_SSI_DCL_DISABLED           MSG_SSI__BASE+8
#define  MSG_SSI_DCL_UNSUPPORTED        MSG_SSI__BASE+9
#define  MSG_SSI_DCL_NOT_SYSTEM         MSG_SSI__BASE+10
#define  MSG_SSI_DCL_NOT_WORLD          MSG_SSI__BASE+11
#define  MSG_SSI_INCLUDE_NOT_TEXT       MSG_SSI__BASE+12
#define  MSG_SSI_INCLUDE_ACCESS         MSG_SSI__BASE+13
#define  MSG_SSI_DATE_TIME              MSG_SSI__BASE+14
#define  MSG_SSI_RECURSION              MSG_SSI__BASE+15
#define  MSG_SSI_VARIABLE               MSG_SSI__BASE+16
#define  MSG_SSI_VARIABLE_NOT_FOUND     MSG_SSI__BASE+17
#define  MSG_SSI_FLOW_CONTROL           MSG_SSI__BASE+18
#define  MSG_SSI__MAX                   18

#define  MSG_STATUS__BASE               MSG_SSI__BASE+MSG_SSI__MAX+1
#define  MSG_STATUS_SUCCESS             MSG_STATUS__BASE+1
#define  MSG_STATUS_ERROR               MSG_STATUS__BASE+2
#define  MSG_STATUS_DOC_NOT_FOUND       MSG_STATUS__BASE+3
#define  MSG_STATUS_FILE_NOT_FOUND      MSG_STATUS__BASE+4
#define  MSG_STATUS_DOC_PROTECTION      MSG_STATUS__BASE+5
#define  MSG_STATUS_FILE_PROTECTION     MSG_STATUS__BASE+6
#define  MSG_STATUS_NO_INFORMATION      MSG_STATUS__BASE+7
#define  MSG_STATUS_ADVISE_NOSUCHFILE   MSG_STATUS__BASE+8
#define  MSG_STATUS_ADVISE_PRV          MSG_STATUS__BASE+9
#define  MSG_STATUS_ADVISE_NOPRIV       MSG_STATUS__BASE+10
#define  MSG_STATUS_ADVISE_SYNTAX       MSG_STATUS__BASE+11
#define  MSG_STATUS_ADVISE_FLK          MSG_STATUS__BASE+12
#define  MSG_STATUS_ADVISE_CORRECT      MSG_STATUS__BASE+13
#define  MSG_STATUS_REPORT_FORMAT       MSG_STATUS__BASE+14
#define  MSG_STATUS_REPORT_FORMAT_SIG   MSG_STATUS__BASE+15
#define  MSG_STATUS_SIGNATURE           MSG_STATUS__BASE+16
#define  MSG_STATUS_INFO                MSG_STATUS__BASE+17
#define  MSG_STATUS__MAX                17

#define  MSG_UPD__BASE                  MSG_STATUS__BASE+MSG_STATUS__MAX+1
#define  MSG_UPD_FILENAME               MSG_UPD__BASE+1
#define  MSG_UPD_DIRECTORY              MSG_UPD__BASE+2
#define  MSG_UPD_QUERY_FIELD            MSG_UPD__BASE+3
#define  MSG_UPD_FILTER                 MSG_UPD__BASE+4
#define  MSG_UPD_SRC_FILENAME           MSG_UPD__BASE+5
#define  MSG_UPD_DST_FILENAME           MSG_UPD__BASE+6
#define  MSG_UPD_CUR_FILENAME           MSG_UPD__BASE+7
#define  MSG_UPD_NEW_FILENAME           MSG_UPD__BASE+8
#define  MSG_UPD_RENAME_SAME            MSG_UPD__BASE+9
#define  MSG_UPD_ACTION                 MSG_UPD__BASE+10
#define  MSG_UPD_NOT_TEXT_FILE          MSG_UPD__BASE+11
#define  MSG_UPD_PARENT_DIRECTORY       MSG_UPD__BASE+12
#define  MSG_UPD_NAVIGATE               MSG_UPD__BASE+13
#define  MSG_UPD_CREATE                 MSG_UPD__BASE+14
#define  MSG_UPD_DELETE                 MSG_UPD__BASE+15
#define  MSG_UPD_RENAME                 MSG_UPD__BASE+16
#define  MSG_UPD_COPY                   MSG_UPD__BASE+17
#define  MSG_UPD_EDIT                   MSG_UPD__BASE+18
#define  MSG_UPD_PROTECTION_LIST        MSG_UPD__BASE+19
#define  MSG_UPD_PROTECTION             MSG_UPD__BASE+20
#define  MSG_UPD_RENAMED                MSG_UPD__BASE+21
#define  MSG_UPD__MAX                   21

/*
#define  MSG_?__BASE                    MSG_!__BASE+MSG_!__MAX+1
#define  MSG_?_                         MSG_?__BASE+
#define  MSG_?__MAX                     0
*/

#define NUMBER_OF_GROUPS 14

#define  MSG_TOTAL  MSG_AUTH__MAX + \
                    MSG_DIR__MAX + \
                    MSG_GENERAL__MAX + \
                    MSG_HTADMIN__MAX + \
                    MSG_HTTP__MAX + \
                    MSG_ISMAP__MAX + \
                    MSG_MAPPING__MAX + \
                    MSG_PROXY__MAX + \
                    MSG_PUT__MAX + \
                    MSG_REQUEST__MAX + \
                    MSG_SCRIPT__MAX + \
                    MSG_SSI__MAX + \
                    MSG_STATUS__MAX + \
                    MSG_UPD__MAX

#define MSG_RANGE MSG_TOTAL+NUMBER_OF_GROUPS

#define MAX_LANGUAGES 4

/**************/
/* structures */
/**************/

typedef struct MsgStruct MSG_STRUCT;

struct MsgStruct
{
   int  LanguageNumber;
   char  LanguageList [128],
         LanguageName [16];
   char  *CharsetPtr,
         *HostListPtr;
   char  *TextPtr [MSG_RANGE+1];
};

typedef struct MsgMetaStruct MSG_META;

struct MsgMetaStruct
{
   BOOL  CheckedLanguages,
         IncludeFileDetected,
         VersionChecked;
   int  LanguageCount,
        LanguageDefault,
        LanguageNumber,
        LineNumber,
        MessageBase,
        MessageCount,
        MessageMax;
   MSG_STRUCT  *Msgs[MAX_LANGUAGES+1];
};

char* MsgCreate (char*);
char* MsgFor (REQUEST_STRUCT*, int);

/***********************/
/* function prototypes */
/***********************/

int MsgConfigLoad (META_CONFIG**);
BOOL MsgConfigLoadCallback (META_CONFIG*);
MsgConfigUnload (META_CONFIG*);
MsgConfigReport (REQUEST_STRUCT*, REQUEST_AST, BOOL);
MsgConfigReportNow (REQUEST_STRUCT*, META_CONFIG*);
MsgConfigRevise (REQUEST_STRUCT*, REQUEST_AST, BOOL);
MsgConfigReviseNow (REQUEST_STRUCT*, META_CONFIG*);
MsgUnLoad (MSG_META*);

#endif /* MSG_H_LOADED */

/*****************************************************************************/
                                                                                                                                        