/*****************************************************************************/
/*
                                   Net.h
*/
/*****************************************************************************/

#ifndef NET_H_LOADED
#define NET_H_LOADED 1

#include "wasd.h"

/* output character encoding */
#define NET_WRITE_BUFFERED_NONE     0
#define NET_WRITE_BUFFERED_HTMLESC  1
#define NET_WRITE_BUFFERED_URLENC   2

/* retry failed NetAccept() sys$assign()s for this many seconds */
#define NET_ACCEPT_NOIOCHAN_MAX 600

/**************/
/* structures */
/**************/

struct NetTestStruct
{
   unsigned short  Channel;
   IO_SB  IOsb;
   char  Buffer [1024];
};

/***********************/
/* function prototypes */
/***********************/

/* forward reference required */
typedef struct ServiceStruct SERVICE_STRUCT;
NetAccept (SERVICE_STRUCT*);

NetAcceptAst (REQUEST_STRUCT*);
NetAcceptProcess (REQUEST_STRUCT*);
BOOL NetAcceptSupervisor ();
NetCreateService ();
NetDirectResponse (REQUEST_STRUCT*, int);
NetDirectResponseAst (REQUEST_STRUCT*);
NetDirectResponseTimeoutAst (REQUEST_STRUCT*);
char* NetGetBgDevice (unsigned short, char*, int);
int RefGetRefCnt (unsigned short);
NetGetServerHostName ();
int NetGetRefCnt (unsigned short);
NetHostNameLookup (META_CONFIG*, char*, int, char*, char*, char*, IPADDRESS*, int*);
unsigned long NetHostPortHash (char*, char*);
NetListen ();
NetParseHostString (char*, char*, int, int*);
NetResponseHeaderAst (REQUEST_STRUCT*);
NetServerShutdown (unsigned short);
char* NetServiceNextHostPort (unsigned long*);
int NetServiceReportConfig (REQUEST_STRUCT*, struct ConfigStruct*);
int NetServiceReportStats (REQUEST_STRUCT*);
NetServiceZeroAccounting ();
NetSetService ();
NetCloseSocket (REQUEST_STRUCT*);
int NetRead (REQUEST_STRUCT*, REQUEST_AST, char*, int);
int NetReadRaw (REQUEST_STRUCT*, REQUEST_AST, char*, int);
NetReadRawAst (REQUEST_STRUCT*);

int NetWrite (REQUEST_STRUCT*, REQUEST_AST, char*, int);
int NetWriteBuffered (REQUEST_STRUCT*, REQUEST_AST, char*, int);
int NetWriteBufferedNow (REQUEST_STRUCT*);
int NetWriteRaw (REQUEST_STRUCT*, REQUEST_AST, char*, int);
NetWriteRawAst (REQUEST_STRUCT*);

/* testing purpose only! */
NetTestRequest (unsigned short);
NetTestReadAst (struct NetTestStruct*);
NetTestWriteAst (struct NetTestStruct*);

/* vector print to network buffer */
#define NetWriteFaol(rq,fs,vp) WriteFormatted(rq,NULL,0,NULL,fs,vp)
/* for naming consistency */
#define NetWriteFao WriteFaoNet

/* definition to flush the buffer only if there is more than a buffer-full */
#define NetWritePartFlush(rq,ast) NetWriteBuffered(rq,ast,NULL,-1)

/* to flush buffered contents completely */
#define NetWriteFullFlush(rq,ast) NetWriteBuffered(rq,ast,NULL,0)

/* initialize the buffer */
#define NetWriteInit(rq) NetWriteBuffered(rq,NULL,NULL,0)

#endif /* NET_H_LOADED */

/*****************************************************************************/

