/*****************************************************************************/
/*
                               ODSstruct.h


VERSION HISTORY
---------------
23-DEC-1999  MGD  initial; provide support for ODS-2 and ODS-5
*/
/*****************************************************************************/

#ifndef ODSSTRUCT_H_LOADED
#define ODSSTRUCT_H_LOADED 1

/* VMS related header files */
#include <descrip.h>
#include <rms.h>
#include <rmsdef.h>
#include <atrdef.h>
#include <fibdef.h>

/* application header files */
#include "enamel.h"

#ifndef __VAX
#  ifndef NO_ODS_EXTENDED
#     define ODS_EXTENDED 1
      /* this is smaller than the technical maximum, but still quite large! */
#     define ODS_MAX_FILE_NAME_LENGTH 511
#     define ODS_MAX_FILESYS_NAME_LENGTH 264
#  endif
#endif
#define ODS2_MAX_FILE_NAME_LENGTH 255
#ifndef ODS_MAX_FILE_NAME_LENGTH
#  define ODS_MAX_FILE_NAME_LENGTH ODS2_MAX_FILE_NAME_LENGTH
#endif
#if ODS_MAX_FILE_NAME_LENGTH < ODS2_MAX_FILE_NAME_LENGTH
#  define ODS_MAX_FILE_NAME_LENGTH ODS2_MAX_FILE_NAME_LENGTH
#endif

#ifndef __VAX
#   pragma __member_alignment __save
#   pragma nomember_alignment
#endif

/* I/O User's Reference Manual, ACP Subfunctions, "Read/Write Attributes" */

typedef struct AcpQioAscDates ACPQIO_ASC_DATES;

struct AcpQioAscDates
{
   unsigned short  RevisionCount;
   unsigned char  OfNoInterest [33];
};

/* I/O User's Reference Manual, ACP Subfunctions, "Read/Write Attributes" */

#define FAT$C_UNDEFINED 0
#define FAT$C_FIXED 1
#define FAT$C_VARIABLE 2
#define FAT$C_VFC 3
#define FAT$C_STREAM 4
#define FAT$C_STMLF 5
#define FAT$C_STMCR 6
#define FAT$M_NOSPAN 8
#define FAT$M_MSBRCW 16

typedef struct AcpQioRecordAttributes ACPQIO_RECORD_ATTRIBUTES;

struct AcpQioRecordAttributes
{
   unsigned char  fat$b_rtype;
   unsigned char  fat$b_rattrib;
   unsigned short  fat$w_rsize;
   unsigned long  fat$l_hiblk;
   unsigned long  fat$l_efblk;
   unsigned short  fat$w_ffbyte;
   unsigned char  fat$b_bktsize;
   unsigned char  fat$b_vfcsize;
   unsigned short  fat$w_maxrec;
   unsigned short  fat$w_defext;
   unsigned short  fat$w_gbc;
   unsigned char   fat$reserved [6];
   unsigned short  fat$w_unused;
   unsigned short  fat$w_versions;
};

typedef struct FileQioStruct FILE_QIO;

struct FileQioStruct
{
   BOOL  EndOfFile;
   int  AdjustBuffer,
        AllocatedVbn,
        BlockNumber,
        BufferCount,
        BufferSize,
        EndOfFileVbn,
        FirstFreeByte,
        SizeInBytes;
   unsigned short  AcpChannel,
                   AtrFpro,
                   QioChannel,
                   RecordCount,
                   RecordSize;
   unsigned long  AtrUic;
   unsigned long  CdtBinTime [2],
                  RdtBinTime [2];
   char  *BufferPtr;
   ACPQIO_RECORD_ATTRIBUTES  RecAttr;
   ATRDEF  FileAtr [6];
   struct dsc$descriptor  FibDsc,
                          FileNameDsc;
   IO_SB  IOsb;

#ifdef ODS_EXTENDED
   /* only use the local ENAMEL.H FIB definition when necessary */
#  ifdef ENAMEL_FIBDEF
      struct enamel_fibdef  Fib;
#  else
      FIBDEF  Fib;
#  endif
#else /* ODS_EXTENDED */
   struct fibdef  Fib;
#endif /* ODS_EXTENDED */
};

#ifndef __VAX
#   pragma member_alignment
#endif

typedef struct OdsStruct ODS_STRUCT;

struct OdsStruct
{
   BOOL  DeleteOnClose,
         NamlInUse,
         ParseInUse;

   int  DataLength,
        DataLineLength,
        DataLineNumber,
        DataLineSize,
        ExpFileNameLength,
        NamDeviceLength,
        NamDirectoryLength,
        NamFileSysNameLength,
        NamNameLength,
        NamNodeLength,
        NamTypeLength,
        NamVersionLength,
        ResFileNameLength;

   unsigned long   Nam_fnb;

   char  *DataPtr,
         *DataLinePtr,
         *DataParsePtr,
         *NamDevicePtr,
         *NamDirectoryPtr,
         *NamFileSysNamePtr,
         *NamNamePtr,
         *NamNodePtr,
         *NamTypePtr,
         *NamVersionPtr;

   char  ExpFileName [ODS_MAX_FILE_NAME_LENGTH+1],
         ResFileName [ODS_MAX_FILE_NAME_LENGTH+1];

#ifdef ODS_EXTENDED
   char  SysFileName [ODS_MAX_FILESYS_NAME_LENGTH+1];
#endif

   GENERAL_AST AstFunction;
   unsigned long AstParam;

   struct FAB  Fab;
#  ifdef ODS_EXTENDED
      variant_union {
         struct NAM  Nam;
         struct NAML Naml;
      } Overlay1;
#  else /* ODS_EXTENDED */
      struct NAM  Nam;
#  endif /* ODS_EXTENDED */
   struct RAB  Rab;
   struct XABDAT  XabDat;
   struct XABFHC  XabFhc;
   struct XABPRO  XabPro;

   FILE_QIO  FileQio;
};

#ifndef __VAX
#   pragma __member_alignment __restore
#endif

#endif /* ODSSTRUCT_H_LOADED */

/****************************************************************************/

