/*****************************************************************************
/*
                                Persona.h
*/
/*****************************************************************************/

#ifndef PERSONA_H_LOADED
#define PERSONA_H_LOADED 1

#include "wasd.h"

#define PERSONA_RIGHTS_MAX 256

/**********/
/* macros */
/**********/

/* not defined for VMS 6.1 (at least) */
#ifndef SS$_INVUSER
#  define SS$_INVUSER 10092
#endif

/*******************/
/* data structures */
/*******************/

#ifndef __VAX
#   pragma member_alignment __save
#   pragma member_alignment
#endif

#define PERSONA_USER_NAME_SIZE 12

typedef struct PersonaCacheStruct PERSONA_ENTRY;

struct PersonaCacheStruct
{
   LIST_ENTRY  PersonaCacheListEntry;
   int  HitCount,
        PersonaHandle,
        ReuseCount;
   unsigned long  LastBinaryTime [2];
   char  UserName [PERSONA_USER_NAME_SIZE+1];
};

#ifndef __VAX
#   pragma member_alignment __restore
#endif

/***********************/
/* function prototypes */
/***********************/

int PersonaAllowed (REQUEST_STRUCT*, char*);
int PersonaAllowedUai (REQUEST_STRUCT*, char*);
int PersonaAssume (char*);
int PersonaCache (char*, int);
int PersonaInit ();
int PersonaStub (...);

#endif /* PERSONA_H_LOADED */

/*****************************************************************************/

