/*****************************************************************************/
/*
                                 Proxy.h

08-AUG-1998  MGD  initial
*/
/*****************************************************************************/

#ifndef PROXY_H_LOADED
#define PROXY_H_LOADED 1

#include "proxystruct.h"

/* proxy scheme */
#define PROXY_SCHEME_CONNECT     1
#define PROXY_SCHEME_HTTP        2
#define PROXY_SCHEME_HTTPSSL     3
#define PROXY_SCHEME_FTP         4

/* controlling the HTTP->SSL proxy gateway */
#define PROXY_HTTPSSL_NONE        0
#define PROXY_HTTPSSL_443       443
#define PROXY_HTTPSSL_ALL        -1

/*#   define PROXY_ERROR_HOST_UNKNOWN       0x000182b2*/
    /* this is an SS$_ENDOFFILE */
#define PROXY_ERROR_HOST_UNKNOWN       0x00000870
#define PROXY_ERROR_CONNECT_REFUSED    0x00000294
#define PROXY_ERROR_HOST_UNREACHABLE   0x00002094
#define PROXY_ERROR_HOST_DISCONNECTED  0x0000207c
#define PROXY_ERROR_HOST_TIMEOUT       0x0000022c

#define PROXY_HOST_CACHE_PURGE_DEFAULT 24

#define PROXY_CONTENT_MAX 4096

/* any FTP proxy specific behaviour that needs to be specially accomodated */
#define PROXY_FTP_SPECIFIC_NONE     0x0
#define PROXY_FTP_SPECIFIC_MADGOAT  0x1

#define PROXY_FORWARDED_DISABLED      0
#define PROXY_FORWARDED_BY            1
#define PROXY_FORWARDED_FOR           2
#define PROXY_FORWARDED_ADDRESS       3
#define PROXY_FORWARDED_NONE          4  /* used by mapping rules */

#define PROXY_XFORWARDEDFOR_DISABLED  0
#define PROXY_XFORWARDEDFOR_ENABLED   1
#define PROXY_XFORWARDEDFOR_ADDRESS   2
#define PROXY_XFORWARDEDFOR_UNKNOWN   3
#define PROXY_XFORWARDEDFOR_NONE      4  /* used by mapping rules */

/***********************/
/* function prototypes */
/***********************/

ProxyCloseSocket (PROXY_TASK*);
ProxyEnd (PROXY_TASK*);
ProxyEndClientShutdownAst (REQUEST_STRUCT*);
ProxyEndProxyShutdownAst (PROXY_TASK*);
int ProxyHostConnect (PROXY_TASK*);
ProxyHostConnectAst (PROXY_TASK*);
ProxyHttpConnectNetReadAst (REQUEST_STRUCT*);
ProxyHttpConnectNetWriteAst (REQUEST_STRUCT*);
ProxyHttpConnectParse (REQUEST_STRUCT*);
ProxyHttpConnectProxyReadAst (PROXY_TASK*);
ProxyHttpConnectProxyWriteAst (PROXY_TASK*);
ProxyWriteRequestAst (PROXY_TASK*);
ProxyReadResponseAst (PROXY_TASK*);
ProxyReadResponseCacheWrite (PROXY_TASK*);
ProxyReadResponseCacheWriteAst (PROXY_TASK*);
ProxyRequestParse (REQUEST_STRUCT*);
ProxyResolveHost (PROXY_TASK*);
ProxyResolveHostLookup (PROXY_TASK*);
ProxyResponseNetWrite (PROXY_TASK*);
ProxyResponseNetWriteAst (REQUEST_STRUCT*);
ProxyReadCacheFailed (PROXY_TASK*);
ProxyRebuildLocation (PROXY_TASK*);
int ProxyRequestBegin (REQUEST_STRUCT*);
int ProxyRequestParse (REQUEST_STRUCT*);
ProxyReadRaw (PROXY_TASK*, PROXY_AST, char*, int);
ProxyReadRawAst (PROXY_TASK*);
ProxyResponseNetWriteAst (REQUEST_STRUCT*);
ProxyWriteRaw (PROXY_TASK*, PROXY_AST, char*, int);
ProxyWriteRawAst (PROXY_TASK*);
ProxyWriteRequestBody (REQUEST_STRUCT*);
ProxyWriteRequestBodyAst (PROXY_TASK*);

#endif /* PROXY_H_LOADED */

/*****************************************************************************/

