/****************************************************************************/
/*
                             ProxyCache.h


08-AUG-1998  MGD  initial
*/
/****************************************************************************/

#ifndef PROXYCACHE_H_LOADED
#define PROXYCACHE_H_LOADED 1

#include "proxystruct.h"

#define PROXY_CACHE_DEVICE  "HT_CACHE_ROOT:"
#define PROXY_CACHE_ROOT    PROXY_CACHE_DEVICE "["
#define PROXY_CACHE_SPEC    PROXY_CACHE_ROOT "000000...]*.HTC;*"

/* 256 top-level directories (original organization) */
#define PROXY_CACHE_DIR_ORG_FLAT256     256
/* 64 top-level directories each with 64 subdirectories */
#define PROXY_CACHE_DIR_ORG_64X64  6464

/* function prototypes */
int ProxyCacheAgeSeconds (unsigned long*, unsigned long*);
int ProxyCacheAgeHours (unsigned long*, unsigned long*);
ProxyCacheCloseAst_NetWrite (struct FAB*);
ProxyCacheCloseAst_ProxyEnd (struct FAB*);
ProxyCacheEnd (PROXY_TASK*);
ProxyCacheInit (BOOL);
ProxyCacheInitPurgeList ();
ProxyCacheLoadBegin (PROXY_TASK*);
ProxyCacheLoadConnect (struct FAB*);
ProxyCacheLoadWrite (PROXY_TASK*);
ProxyCacheLoadWriteAst (struct RAB*);
BOOL ProxyCachePurgeLimit (int, int);
ProxyCacheInitReloadList ();
BOOL ProxyCacheReloadLimit (int, int);
int ProxyCacheReloadAge (unsigned long, unsigned long);
ProxyCacheReadAcpInfo (struct FAB*);
ProxyCacheReadAccessAst (PROXY_TASK*);
ProxyCacheReadAcpInfoAst (PROXY_TASK*);
ProxyCacheReadNext (REQUEST_STRUCT*);
ProxyCacheReadNextAst (PROXY_TASK*);
ProxyCacheSetLastAccessed (PROXY_CACHE_FILE_QIO*,
                           unsigned long*, unsigned long*);
ProxyCacheSetLastAccessed2 (PROXY_CACHE_FILE_QIO*);
ProxyCacheSetLastAccessedAst (PROXY_CACHE_FILE_QIO*);

#endif /* PROXYCACHE_H_LOADED */

/****************************************************************************/
