/*****************************************************************************/
/*
                                 ProxyFTP.h

26-JAN-2002  MGD  initial
*/
/*****************************************************************************/

#ifndef PROXYFTP_H_LOADED
#define PROXYFTP_H_LOADED 1

#include "proxystruct.h"

#define PROXY_FTP_COMMAND_SIZE 256
#define PROXY_FTP_RESPONSE_SIZE 256

#define PROXY_FTP_STATE_NONE          0
#define PROXY_FTP_STATE_USER          1
#define PROXY_FTP_STATE_USER_DONE     2
#define PROXY_FTP_STATE_PASS_DONE     3
#define PROXY_FTP_STATE_SYST_DONE     4
#define PROXY_FTP_STATE_PWD_DONE      5
#define PROXY_FTP_STATE_CWD_DONE      6
#define PROXY_FTP_STATE_PASV_DONE     7
#define PROXY_FTP_STATE_LIST          8
#define PROXY_FTP_STATE_LIST_RECEIVE  9
#define PROXY_FTP_STATE_LIST_CHECK   10
#define PROXY_FTP_STATE_LIST_PROCESS 11
#define PROXY_FTP_STATE_RETR         12
#define PROXY_FTP_STATE_RETR_MODE    13
#define PROXY_FTP_STATE_RETR_FILE    14
#define PROXY_FTP_STATE_RETR_DONE    15
#define PROXY_FTP_STATE_STOR         16
#define PROXY_FTP_STATE_STOR_TYPE    17
#define PROXY_FTP_STATE_STOR_FILE    18
#define PROXY_FTP_STATE_STOR_CHECK   19
#define PROXY_FTP_STATE_STOR_DONE    20
#define PROXY_FTP_STATE_DELE         21
#define PROXY_FTP_STATE_DELE_DONE    22
#define PROXY_FTP_STATE_ABORT        97
#define PROXY_FTP_STATE_QUIT         98
#define PROXY_FTP_STATE_QUIT_DONE    99

#define PROXY_FTP_FILE_SYSTEM_NONE    0
#define PROXY_FTP_FILE_SYSTEM_DOS     1
#define PROXY_FTP_FILE_SYSTEM_UNIX    2
#define PROXY_FTP_FILE_SYSTEM_VMS     3
#define PROXY_FTP_FILE_SYSTEM_UNKNOWN 9

/* allocate more memory when the space gets below this */
#define PROXY_FTP_LIST_LOW_BUFFER      512
#define PROXY_FTP_RESPONSE_LOW_BUFFER  512

/***********************/
/* function prototypes */
/***********************/

ProxyFtpBegin (PROXY_TASK*);
ProxyFtpCommand (PROXY_TASK*, BOOL, char*, ...);
ProxyFtpCommandAst (PROXY_TASK*);
ProxyFtpCommandResponseAst (PROXY_TASK*);
ProxyFtpCwd (PROXY_TASK*);
ProxyFtpDataCloseSocket (PROXY_TASK *tkptr);
ProxyFtpDataConnect (PROXY_TASK *tkptr);
ProxyFtpDataConnectAst (PROXY_TASK *tkptr);
ProxyFtpDataReadRaw (PROXY_TASK*, PROXY_AST, char*, int);
ProxyFtpDataReadRawAst (PROXY_TASK*);
ProxyFtpDataWriteRaw (PROXY_TASK*, PROXY_AST, char*, int);
ProxyFtpDataWriteRawAst (PROXY_TASK*);
ProxyFtpDelete (PROXY_TASK*);
char* ProxyFtpInQueryString (char*, char*);
BOOL ProxyFtpFilePath (PROXY_TASK*);
int ProxyFtpHttpStatus (PROXY_TASK*);
int ProxyFtpIndexOf (PROXY_TASK*, char*);
ProxyFtpLifeCycle (PROXY_TASK*);
ProxyFtpListReceive (PROXY_TASK*);
ProxyFtpListProcess (PROXY_TASK*);
ProxyFtpListProcessDOS (PROXY_TASK*);
ProxyFtpListProcessVMS (PROXY_TASK*);
ProxyFtpListProcessUnix (PROXY_TASK*);
ProxyFtpListOutput (PROXY_TASK*);
ProxyFtpListWriteAst (REQUEST_STRUCT*);
BOOL ProxyFtpPasvData (PROXY_TASK*);
ProxyFtpRemoteFileSystem (PROXY_TASK*);
ProxyFtpResponse (PROXY_TASK*);
ProxyFtpResponseAst (PROXY_TASK*);
ProxyFtpResponseInvalid (PROXY_TASK*);
ProxyFtpRetrieve (PROXY_TASK*);
ProxyFtpRetrieveAst (PROXY_TASK*);
ProxyFtpRetrieveWriteAst (REQUEST_STRUCT*);
ProxyFtpStore (PROXY_TASK*);
ProxyFtpStoreAst (PROXY_TASK*);
ProxyFtpStoreBodyReadAst (REQUEST_STRUCT*);
ProxyFtpStoreBodyReadBegin (PROXY_TASK*);
ProxyFtpStoreForm (REQUEST_STRUCT*);

#endif /* PROXYFTP_H_LOADED */

/*****************************************************************************/

