/****************************************************************************/
/*
                              ProxyMaint.h

08-AUG-1998  MGD  initial
*/
/****************************************************************************/

#ifndef PROXYMAINT_H_LOADED
#define PROXYMAINT_H_LOADED 1

#include "proxystruct.h"

#define PROXY_MAINT_DEVICE_MBYTES(Blocks) (Blocks >> 11)
#define PROXY_MAINT_DEVICE_PERCENT_FREE(Total,Free) \
        ((int)((float)Free*100.0/(float)Total))
#define PROXY_MAINT_DEVICE_PERCENT_USED(Total,Free) \
        (100-(int)((float)Free*100.0/(float)Total))

#define PROXY_MAINT_SCAN_NONE        0
#define PROXY_MAINT_SCAN_STATISTICS  1
#define PROXY_MAINT_SCAN_REACTIVE    2
#define PROXY_MAINT_SCAN_ROUTINE     3
#define PROXY_MAINT_SCAN_BCKGRND     4
#define PROXY_MAINT_SCAN_STOP        5

/* status entry every so many files when scanning/purging */
#define PROXY_MAINT_SCAN_MONITOR_FILES 250

/* function prototypes */

ProxyMaintAcpInfoAst ();
ProxyMaintAdjust (REQUEST_STRUCT*, REQUEST_AST);
BOOL ProxyMaintBackgroundTimer ();
ProxyMaintCli ();
ProxyMaintControl (REQUEST_STRUCT*, REQUEST_AST);
ProxyMaintDeleteAst ();
BOOL ProxyMaintDeviceFreeSpace (int);
int ProxyMaintDeviceStats (char**, int*, int*, int*, int*);
ProxyMaintInit ();
ProxyMaintPrintDeviceStats ();
ProxyMaintStatisticsReport (REQUEST_STRUCT*, char*);
int ProxyMaintScanBegin (int);
ProxyMaintScanNow ();
ProxyMaintScanEnd ();
ProxyMaintScanParseAst (struct FAB*);
ProxyMaintScanSearch ();
ProxyMaintScanSearchAst (struct FAB*);
ProxyMaintSupervisor ();

#endif /* PROXYMAINT_H_LOADED */

/****************************************************************************/
