/*****************************************************************************/
/*
                                ProxyStruct.h

08-AUG-1998  MGD  initial
*/
/*****************************************************************************/

#ifndef PROXYSTRUCT_H_LOADED
#define PROXYSTRUCT_H_LOADED 1

#include <atrdef.h>
#include <fibdef.h>

#include "enamel.h"
#include "auth.h"
#include "config.h"
#include "net.h"
#include "odsstruct.h"

#ifndef __VAX
#   pragma nomember_alignment
#endif

/* forward references */
typedef struct RequestStruct REQUEST_STRUCT;
typedef struct ServiceStruct SERVICE_STRUCT;

/********************/
/* proxy accounting */
/********************/

#ifndef __VAX
#   pragma member_alignment __save
#   pragma member_alignment
#endif

#define PROXY_ACCOUNTING_STATUS_STRING_SIZE 128

typedef struct ProxyAccountingStruct PROXY_ACCOUNTING_STRUCT;

struct ProxyAccountingStruct
{
BOOL  CacheEnabled,
      FreeSpaceAvailable,
      ServingEnabled;

int  CacheReadCount,
     CacheRead304Count,
     CacheWriteCount,
     ConnectIpv4Count,
     ConnectIpv6Count,
     FtpCount,
     FtpDeleCount,
     FtpDosCount,
     FtpListCount,
     FtpLoginFailCount,
     FtpRetrCount,
     FtpStorCount,
     FtpUnixCount,
     FtpUnknownCount,
     FtpVmsCount,
     GwayHttpHttpCount,
     GwayHttpHttpsCount,
     GwayHttpFtpCount,
     GwayHttpsHttpCount,
     GwayHttpsHttpsCount,
     GwayHttpsFtpCount,
     GwayIpv4Ipv4Count,
     GwayIpv4Ipv6Count,
     GwayIpv6Ipv4Count,
     GwayIpv6Ipv6Count,
     MethodConnectCount,
     MethodDeleteCount,
     MethodGetCount,
     MethodHeadCount,
     MethodPostCount,
     MethodPutCount,
     PrevFileCount,
     RequestNotCacheableCount,
     ResponseNotCacheableCount,
     Verify200Count,
     Verify403Count,
     Verify404Count,
     VerifyCurrentCount,
     VerifyFindRecordCount,
     VerifyFullCount,
     VerifySetRecordCount;

unsigned long  /* count of bytes received from proxied server */
               QuadBytesCacheRx [2],
               /* count of bytes sent to proxied server */
               QuadBytesCacheTx [2],
               /* bytes received from proxied server - not cacheable */
               QuadBytesNotCacheableRx [2],
               /* bytes sent to proxied server - not cacheable */
               QuadBytesNotCacheableTx [2],
               /* count of bytes in cache-serviced request header */
               QuadBytesRawRx [2],
               /* count of bytes in cache-serviced response */
               QuadBytesRawTx [2];

char  StatusString [PROXY_ACCOUNTING_STATUS_STRING_SIZE];
};

#ifndef __VAX
#   pragma member_alignment __restore
#endif

/**************************/
/* proxy cache structures */
/**************************/

/* i.e. originated and works with any after v6.0.0 */
#define PROXY_CACHE_FILE_VERSION 0x60000

typedef struct ProxyCacheDescrStruct PROXY_CACHE_DESCR;

struct ProxyCacheDescrStruct
{
   int  CacheVersion,
        UrlLength,
        HeaderLength;
};

typedef struct ProxyCacheFileQioStruct PROXY_CACHE_FILE_QIO;

struct ProxyCacheFileQioStruct
{
   BOOL  EndOfFile;
   int  AdjustBuffer,
        AllocatedVbn,
        BlockNumber,
        BufferCount,
        BufferSize,
        EndOfFileVbn,
        FirstFreeByte,
        SizeInBytes;
   unsigned short  AcpChannel,
                   QioChannel;
   unsigned long  BdtBinTime [2],
                  CdtBinTime [2],
                  EdtBinTime [2],
                  RdtBinTime [2];
   char  *BufferPtr;
   char  FileName [40];
   ACPQIO_ASC_DATES  AscDates;
   ACPQIO_RECORD_ATTRIBUTES  RecAttr;
   ATRDEF  FileAtr [6];
   struct dsc$descriptor  FibDsc,
                          FileNameDsc;
   IO_SB  IOsb;

#ifdef ODS_EXTENDED
   /* only use the local ENAMEL.H FIB definition when necessary */
#  ifdef ENAMEL_FIBDEF
      struct enamel_fibdef  Fib;
#  else
      FIBDEF  Fib;
#  endif
#else /* ODS_EXTENDED */
   FIBDEF  Fib;
#endif /* ODS_EXTENDED */
};

/*****************************************/
/* reverse proxy verification structures */
/*****************************************/

#define PROXY_VERIFY_MAX_AUTH_LENGTH 96

typedef struct ProxyVerifyRecord PROXYVERIFY_RECORD;

struct ProxyVerifyRecord
{
   int  AuthorizationStringLength,
        VerifyAttemptCount;
   unsigned long  SourceRealm;
   char  AuthorizationString [PROXY_VERIFY_MAX_AUTH_LENGTH+1],
         HttpdPrcNam [15+1],
         RealmName [AUTH_MAX_REALM_GROUP_LENGTH+1],
         RemoteUser [AUTH_MAX_USERNAME_LENGTH+1];
};

typedef struct ProxyVerifyGblSecStruct PROXYVERIFY_GBLSEC;

struct ProxyVerifyGblSecStruct
{
   unsigned long  GblSecVersion,
                  GblSecLength;

   int  RecordCount;
   unsigned long  SinceBinTime [2];

    /* verify records are stored from this point onwards */
   char  RecordPool [];
};

/************************/
/* proxy task structure */
/************************/

#ifndef __VAX
#   pragma member_alignment __save
#   pragma member_alignment
#endif

typedef struct ProxyTaskStruct PROXY_TASK;

struct ProxyTaskStruct
{
   BOOL  WatchItem,
         FtpDirList,
         FtpHasVersion,
         FtpListAlt,
         FtpListHide,
         FtpListRaw,
         FtpStorDone,
         FtpTypeDone,
         NotCacheable,
         ParseInUse,
         ProxyCacheBeyondHeader,
         ProxyCacheFileExisted,
         ProxyCacheSuitable,
         ResponseContentRange,
         ResponseContentTypeMultipart,
         ResponsePragmaNoCache,
         ResponseSetCookie,
         ProxySslHttpRequest,
         RequestPragmaNoCache;

   int  ChainIpPort,
        ConnectPort,
        Ftp230Length,
        FtpCommandCount,
        FtpCommandSize,
        FtpFilePathLength,
        FtpFileSystem,
        FtpResponseClass,
        FtpResponseCode,
        FtpResponseCount,
        FtpResponseLineCount,
        FtpResponseRemaining,
        FtpResponseSize,
        FtpSpecific,
        FtpState,
        HttpMethod,
        ProxyCacheFileNameLength,
        ProxyCacheFileSizeInBytes,
        ProxyCacheLastModifiedHours,
        ProxyCacheReadBytes,
        ProxyLookupRetryCount,
        ProxyRequestNumber,
        QueuedBodyRead,
        RebuiltRequestLength,
        RequestHostPortLength,
        RequestHttpMethod,
        RequestHttpVersion,
        RequestPort,
        RequestScheme,
        ResponseBodyLength,
        ResponseBufferCount,
        ResponseBufferCacheCount,
        ResponseBufferNetCount,
        ResponseBufferRemaining,
        ResponseBufferSize,
        ResponseBytes,
        ResponseConsecutiveNewLineCount,
        ResponseContentLength,
        ResponseHeaderLength,
        ResponseHttpVersion,
        ResponseStatusCode;

   unsigned short  FtpDataIpPort;

   unsigned long  BytesRawRx,
                  BytesRawTx,
                  RequestHostIpAddress32bit;

   unsigned long  ProxyCacheFileCdt [2],
                  ResponseExpiresBinaryTime [2],
                  ResponseLastModifiedBinaryTime [2];

   char  *ChainHostPortPtr,
         *ConnectHostPortPtr,
         *Ftp230Ptr,
         *FtpCommandPtr,
         *FtpContentTypePtr,
         *FtpFileSystemPtr,
         *FtpFilePathPtr,
         *FtpNextResponsePtr,
         *FtpResponsePtr,
         *FtpResponseCurrentPtr,
         *FtpWildPtr,
         *RebuiltRequestPtr,
         *ResponseBufferPtr,
         *ResponseBufferCachePtr,
         *ResponseBufferCurrentPtr,
         *ResponseBufferNetPtr,
         *RequestHttpCookiePtr,
         *RequestHttpMethodNamePtr,
         *ResponseHeaderPtr,
         *RequestUriPtr,
         *RequestUriQueryStringPtr;

   char  ChainHostPort [TCPIP_HOSTNAME_MAX+1+8],
         ProxyCacheDirectoryName [64],
         ProxyCacheMd5HexDigest [33],
         RequestHostName [TCPIP_HOSTNAME_MAX+1],
         RequestHostPort [TCPIP_HOSTNAME_MAX+1+8],
         RequestPortString [16],
         RequestSchemeName [16],
         ResponseExpires [32],
         ResponseHttpProtocol [16],
         ResponseLastModified [48],
         ResponseStatusCodeString [16],
         ResponseStatusDescription [64],
         UrlPassword [32],
         UrlUserName [32];

   /* the cache and FTP storage are not required at the same time */
   variant_union {
      char  ExpandedFileName [256]; 
      char  FtpCWD [256]; 
   } Overlay1;
   variant_union {
      char  ProxyCacheFileName [128];
      char  FtpSYST [128];
   } Overlay2;

   IPADDRESS  BindIpAddress,
              ChainIpAddress,
              ConnectIpAddress,
              FtpDataBindIpAddress,
              FtpDataIpAddress,
              RequestHostIpAddress;

   /* pointer to service struct */
   SERVICE_STRUCT  *ServicePtr;

   /* pointer to associated request (if any) */
   REQUEST_STRUCT  *RequestPtr;

   /* structure is used to get/set file characteristics */
   PROXY_CACHE_FILE_QIO  CacheFileQio;

   /* pointer to structure holding reverse-proxy verification data */
   PROXYVERIFY_RECORD  *VerifyRecordPtr;

   /* RMS structures */
   struct FAB  LoadFab;
   struct RAB  LoadRab;
   struct FAB  ParseFab;
   struct NAM  ParseNam;
   struct XABDAT  LoadXabDat;
   struct XABPRO  LoadXabPro;

   unsigned short  ProxyChannel,
                   FtpDataChannel;

   /* network read and write buffer */
   char  *FtpDataReadRawDataPtr,
         *FtpDataWriteRawDataPtr,
         *ProxyReadRawDataPtr,
         *ProxyWriteRawDataPtr;
   int  FtpDataReadRawDataSize,
        FtpDataWriteRawDataCount,
        ProxyReadRawDataSize,
        ProxyWriteRawDataCount;

   /* AST function pointers */
   PROXY_AST  FtpAstFunction;
   REQUEST_AST  FtpDataReadRawAstFunction;
   REQUEST_AST  FtpDataWriteRawAstFunction;
   REQUEST_AST  ProxyReadRawAstFunction;
   REQUEST_AST  ProxyWriteRawAstFunction;

   /* I/O status blocks */
   IO_SB  FtpDataConnectIOsb,
          FtpDataReadIOsb,
          FtpDataWriteIOsb,
          ProxyConnectIOsb,
          ProxyReadIOsb,
          ProxyWriteIOsb;

   SOCKADDRESS  FtpDataSocketName,
                FtpDataBindSocketName,
                ProxySocketName,
                ProxyBindSocketName;

   TCPIP_HOST_LOOKUP  HostLookup;

   VMS_ITEM_LIST2  FtpDataBindSocketNameItem,
                   FtpDataSocketNameItem, 
                   ProxyBindSocketNameItem,
                   ProxySocketNameItem;

   /* make it easy on ourselves, make the SSL structure pointer typeless! */
   void  *SesolaPtr;
};

#ifndef __VAX
#   pragma member_alignment __restore
#endif

#endif /* PROXYSTRUCT_H_LOADED */

/*****************************************************************************/

