/*****************************************************************************/
/*
                                  Put.h
*/
/*****************************************************************************/

#ifndef PUT_H_LOADED
#define PUT_H_LOADED 1

#include "wasd.h"

/**************/
/* structures */
/**************/

typedef struct PutTaskStruct PUT_TASK;

struct PutTaskStruct
{
   BOOL  /* a file has been created and is currently with this request */
         FileOpen,
         /* document posted is "text/..." */
         ContentTypeText,
         /* file is to be deleted with request rundown */
         PreviewOnly;

   int  /* length of file contents pointed to in buffer */
        ContentFileLength,
        /* just notes the size of the file for reporting */
        FileSizeBytes,
        /* length of file name */
        FileNameLength,
        /* length of server specified directory */
        SpecifiedDirectoryLength;

   unsigned long  /* when creating files and directories */
                  ProtectionMask;

   char  /* points to start of file contents in buffer */
         *ContentFilePtr,
         /* used as pointer into buffer */
         *FileContentPtr,
         /* used as pointer into buffer */
         *FileContentTypePtr;

   char  /* buffer file name */
         FileName [ODS_MAX_FILE_NAME_LENGTH+1],
         /* file is to be put into this server-specified directory */
         SpecifiedDirectory [ODS_MAX_FILE_NAME_LENGTH+1];

   /* structure for file system access */
   ODS_STRUCT  FileOds,
               SearchOds;

   REQUEST_AST  /* function used for specifying AST function following */
                NextFunction,
                /* function used for specifying the next task */
                NextTaskFunction,
                /* function used for specifying AST function following */
                WriteFileNextFunction;
};

/***********************/
/* function prototypes */
/***********************/

PutBegin (REQUEST_STRUCT*, REQUEST_AST, char*);
int PutChangeFileAttributes (REQUEST_STRUCT*);
int PutCheckAccess (char*);
PutCreateDirectory (REQUEST_STRUCT*);
PutDelete (REQUEST_STRUCT*);
PutEnd (REQUEST_STRUCT*);
PutWriteFile (REQUEST_STRUCT*);
PutWriteFileAst (struct RAB*); 
PutWriteFileOpen (REQUEST_STRUCT*);
PutWriteFileClose (REQUEST_STRUCT*);
int PutText (REQUEST_STRUCT*);

#endif /* PUT_H_LOADED */

/*****************************************************************************/

