/*****************************************************************************/
/*
                               Response.h

*/
/*****************************************************************************/

#ifndef RESPONSE_H_LOADED
#define RESPONSE_H_LOADED 1

#include "wasd.h"

/* these macros generate an HTML/PLAIN content-type, success header */
#define RESPONSE_HEADER_200_HTML(rqptr) \
        ResponseHeader (rqptr, 200, "text/html", -1, NULL, NULL)
#define RESPONSE_HEADER_200_PLAIN(rqptr) \
        ResponseHeader (rqptr, 200, "text/plain", -1, NULL, NULL)

/*******************/
/* data structures */
/*******************/

#ifndef __VAX
#   pragma member_alignment __save
#   pragma member_alignment
#endif

typedef struct ResponseCharsetStruct RESPONSE_CHARSET;

struct ResponseCharsetStruct
{
   struct  ListEntryStruct  ListEntry;

   int  NcsCfFactor;
   unsigned long  NcsCf;

   char  *AccCharsetPtr,
         *DocCharsetPtr,
         *NcsCfNamePtr;

   char  Storage [];
};

#ifndef __VAX
#   pragma member_alignment __restore
#endif                

/***********************/
/* function prototypes */
/***********************/

ResponseCharsetConfig (META_CONFIG*);
int ResponseCharsetConvert (REQUEST_STRUCT*, char**, int*);
char* ResponseCharsetConvertBegin (REQUEST_STRUCT*, char*);

ResponseEcho (REQUEST_STRUCT*);
ResponseEchoBody (REQUEST_STRUCT*);
ResponseHeader (REQUEST_STRUCT*, int, char*, int, unsigned long*, char*);
ResponseHeaderAppend (REQUEST_STRUCT*, char*, int);
ResponseHeaderChallenge (REQUEST_STRUCT*);
ResponseHiss (REQUEST_STRUCT*);
ResponseWhere (REQUEST_STRUCT*, char*);

#endif /* RESPONSE_H_LOADED */

/*****************************************************************************/

