/*****************************************************************************/
/*
                                Service.h

Function prototypes for service configuration module.

*/
/*****************************************************************************/

#ifndef SERVICE_H_LOADED
#define SERVICE_H_LOADED 1

#include "wasd.h"

#define SERVICE_ERROR_REPORT_PATH_CODES_MAX 16

/**************/
/* structures */
/**************/

typedef struct ServiceStruct SERVICE_STRUCT;

struct ServiceStruct
{
   SERVICE_STRUCT  *NextPtr;

   BOOL  AdminService,
         ConnectService,
         GenericService,
         LogFileError,
         LogFileOpen,
         NoLog,
         LocalAuthRequired,
         ProxyAuthRequired,
         ProxyFileCacheEnabled,
         ProxyService,
         ProxyTrack,
         SSLclientEnabled,
         ServiceErrorReportPath,
         SetNoTrack,
         SetProxyTrack,
         TrackEnabled;

   int  AcceptQueued,
        AdminPort,
        ConnectCount,
        ErrorReportPathLength,
        ErrorReportPathCodesCount,
        ListenBacklog,
        LogFileNameLength,
        ProxyChainHostNameLength,
        ProxyChainPort,
        ReadErrorCount,
        RequestScheme,
        ServerBindStatus,
        ServerHostNameLength,
        ServerHostPortLength,
        ServerPort,
        WriteErrorCount;

   int  ErrorReportPathCodes [SERVICE_ERROR_REPORT_PATH_CODES_MAX];

   unsigned long  QuadBytesRawRx [2],
                  QuadBytesRawTx [2];

   char  *ErrorReportPathCodesPtr,
         *RequestSchemeNamePtr;

   char  BgDevName [64],
         BindIpAddressString [TCPIP_ADDRESS_STRING_MAX+1],
         BodyTag [256],
         ErrorReportPath [128],
         LogFileName [256],
         LogHostName [64],
         ProxyBindIpAddressString [TCPIP_ADDRESS_STRING_MAX+1],
         ProxyChainHostName [TCPIP_HOSTNAME_MAX+1],
         ProxyChainHostPort [TCPIP_HOSTNAME_MAX+1+8],
         ProxyChainIpAddressString [TCPIP_ADDRESS_STRING_MAX+1],
         ProxyChainPortString [16],
         ServerHostName [TCPIP_HOSTNAME_MAX+1],
         ServerHostPort [TCPIP_HOSTNAME_MAX+1+8],
         ServerIpAddressString [TCPIP_ADDRESS_STRING_MAX+1],
         ServerPortString [16];

   /* we'll have to cast these when we need them */
   void  *SSLclientPtr,
         *SSLserverPtr;

   IPADDRESS  BindIpAddress,
              ProxyBindIpAddress,
              ProxyChainIpAddress,
              ServerIpAddress;

   IO_SB  ServerIOsb;

   struct dsc$descriptor  LogFileNameDsc;
   
   struct FAB  LogFileFab;
   struct RAB  LogFileRab;

   unsigned short  ServerChannel;

   SOCKADDRESS  ServerSocketName;
};

typedef struct ServiceMetaStruct SERVICE_META;

struct ServiceMetaStruct
{
   BOOL  ServiceLooksValid;

   int  ServiceCount;

   SERVICE_STRUCT  *ListHead,
                   *ListTail;
   SERVICE_STRUCT  **HashTable;
   /* used during configuration load */
   SERVICE_STRUCT  ConfigService;

   /* only used when reporting or changing configuration */
   void  *RequestPtr;
};

/***********************/
/* function prototypes */
/***********************/

int ServiceConfigFromString (META_CONFIG**);
int ServiceConfigAdd (META_CONFIG*, SERVICE_STRUCT*);
int ServiceConfigLoad (META_CONFIG**);
ServiceConfigUnload (META_CONFIG*);
BOOL ServiceConfigLoadCallback (META_CONFIG*);
BOOL ServiceIsConfigured (char*);
ServiceConfigRevise (REQUEST_STRUCT*, REQUEST_AST, BOOL);
ServiceConfigReviseNow (REQUEST_STRUCT*, META_CONFIG*);
int ServiceParse (char*, int*, char*, int, int*, BOOL*);
BOOL ServiceFindVirtual (REQUEST_STRUCT*);
ServiceReport (REQUEST_STRUCT*, REQUEST_AST, BOOL);
ServiceReportNow (REQUEST_STRUCT*, META_CONFIG*);
int ServiceReportConfigFromString (REQUEST_STRUCT*, CONFIG_STRUCT*);

#endif /* SERVICE_H_LOADED */

/*****************************************************************************/
