/*****************************************************************************/
/*
                                  SSI.h
*/
/*****************************************************************************/

#ifndef SSI_H_LOADED
#define SSI_H_LOADED 1

#include "wasd.h"

/* essentially depth of if-else-endif nesting */
#define SSI_MAX_FLOW_CONTROL 8

#define SSI_INCLUDE_PART_MAX 63

/**************/
/* structures */
/**************/

#ifndef __VAX
#   pragma __member_alignment __save
#   pragma member_alignment
#endif

typedef struct SsiVarStruct SSI_VAR;

struct SsiVarStruct
{
   LIST_ENTRY  SsiVarList;
   int  NameLength,
        Size,
        ValueLength;
   char  *NamePtr,
         *ValuePtr;
   char  Data[1];
};

typedef struct SsiTaskStruct SSI_TASK;

struct SsiTaskStruct
{
   LIST_ENTRY  SsiTaskList;

   SSI_TASK  *ParentDocumentTaskPtr,
             *RootDocumentTaskPtr;

   BOOL  /* access to be expressed at "1st", "2nd", etc. */
         AccessOrdinal,
         /* indexed by 'FlowControlIndex', flow has executed */
         FlowControlHasExecuted [SSI_MAX_FLOW_CONTROL],
         /* indexed by 'FlowControlIndex', flow is executing */
         FlowControlIsExecuting [SSI_MAX_FLOW_CONTROL],
         /* currently inside an "<--#ssi" statement */
         InsideSsiStatement,
         /* OSU SSI? (detected via "OSU" in content description) */
         OsuCompliant,
         /* record format is fixed or undefined (don't add newlines) */
         RecordFormatFixed,
         /* stop processing the virtual document */
         StopProcessing,
         /* suppress blank lines result of flow control directive lines */
         SuppressLine,
         /* OSU-specific, tag verification */
         TagVerify,
         /* when tracing used to know when to insert carriage-control */
         TraceOutput,
         /* trace on or off */
         TraceState;

   int  /* number of time file accessed */
        AccessCount,
        /* attempt to make behaviour backward compatible */
        ComplianceLevel,
        /* */
        FileDetailsItem,
        /* line number currently being parsed (for error information) */
        LineNumber,
        /* index into flow-control nesting arrays */
        FlowControlIndex,
        /* buffer for logical value */
        OutputBufferEscapeHtml,
        /* note when a search-list has been searched for the file */
        SearchListCount,
        /* line number where current directive began */
        StatementLineNumber,
        /* length of SSI statement ;^) */
        StatementLength;
        
   int  /* indexed by 'FlowControlIndex', series of flow control states */
        FlowControlState [SSI_MAX_FLOW_CONTROL];

   unsigned long  /* stores the latest RDT of files during "#modified" */
                  LastModifiedBinTime [2],
                  /* source ssi file CDT */
                  FileCdtBinTime [2],
                  /* source ssi file RDT */
                  FileRdtBinTime [2];

   char  /* character overwriten by the end-of-statement terminating null */
         TerminatedChar;

   char  /* scratch space */
         AccessSinceText [128],
         /* OSU-compliant #include part for current document */
         CurrentPart [SSI_INCLUDE_PART_MAX+1],
         /* OSU-compliant #include part for about-to-be included document */
         IncludePart [SSI_INCLUDE_PART_MAX+1],
         /* for #include, etc., file names */
         ScratchFileName [ODS_MAX_FILE_NAME_LENGTH+1],
         /* scratch space to hold a format string */
         FormatString [64],
         /* result of sys$parse(), values from, #include, #created, etc. */
         TheFileNameVar [ODS_MAX_FILE_NAME_LENGTH+1];

   char  /* points to the list of CGI variables */
         *CgiBufferPtr,
         /* string containing document depth number */
         *DocumentDepthPtr,
         /* root of document URI */
         *DocumentRootPtr,
         /* message string when generating an SSI error */
         *ErrMsgPtr,
         /* current character position when parsing the buffer */
         *ParsePtr,
         /* pointer to storage allocated for size format string */
         *SizeFmtPtr,
         /* start of "<!--" or "#" */
         *StatementBeginPtr,
         /* end at "-->" or next "#" */
         *StatementEndPtr,
         /* points to char overwriten by the end-of-statement null */
         *TerminatedPtr,
         /* pointer to storage allocated for time format string */
         *TimeFmtPtr;
                                    
   /* structure for ACP info */
   FILE_QIO  FileAcpData;

   /* structures for file access */
   ODS_STRUCT  AccessOds,
               DetailsOds;

   /* access counter does not need to be ODS-5 aware (no NAM block) */
   struct FAB  AccessFab;
   struct RAB  AccessRab;
   struct XABDAT  AccessXabDat;
   struct XABPRO  AccessXabPro;

   /* pointer to function, used for specifying the next task */
   REQUEST_AST  AccessAstFunction;

   /* user variable list */
   LIST_HEAD  SsiVarList;

   /* structure for receiving the file's contents in-memory */
   FILE_CONTENT  *FileContentPtr;
};

#ifndef __VAX
#   pragma member_alignment __restore
#endif

/***********************/
/* function prototypes */
/***********************/

SsiAccessesClose (struct FAB*);
SsiAccessesConnectAst (struct RAB*);
SsiAccessesFileClosed (struct FAB*);
SsiAccessesGetAst (struct RAB*);
SsiAccessesOpen (REQUEST_STRUCT*);
SsiAccessesOpenAst (struct FAB*);
SsiAccessesOutput (REQUEST_STRUCT*);
SsiAccessesParseAst (struct FAB*);
SsiAccessesUpdateAst (struct RAB*);
SsiBegin (REQUEST_STRUCT*);
SsiDoAccesses (REQUEST_STRUCT*);
SsiDoDcl (REQUEST_STRUCT*);
SsiDoDir (REQUEST_STRUCT*);
SsiDoEcho (REQUEST_STRUCT*);
SsiDoElif (REQUEST_STRUCT*);
SsiDoElse (REQUEST_STRUCT*);
SsiDoEnd (REQUEST_STRUCT*);
SsiDoEndif (REQUEST_STRUCT*);
SsiDoIf (REQUEST_STRUCT*);
SsiDoInclude (REQUEST_STRUCT*);
SsiDoPrintEnv (REQUEST_STRUCT*);
SsiDoSet (REQUEST_STRUCT*);
SsiDoTrace (REQUEST_STRUCT*);
SsiEnd (REQUEST_STRUCT*);
SsiFileDetails (REQUEST_STRUCT*, int);
SsiFileDetailsParseAst (struct FAB*);
SsiFileDetailsAcpInfoAst (REQUEST_STRUCT*);
SsiGetFileSpec (REQUEST_STRUCT*, char*, char*, int);
SsiIncludeError (REQUEST_STRUCT*);
SsiNextRecord (REQUEST_STRUCT*);
SsiNextRecordAst (struct RAB*);
SsiParse (REQUEST_STRUCT*);
SsiProblem (REQUEST_STRUCT*, ...);
SsiStatement (REQUEST_STRUCT*);
SsiTraceGetVar (REQUEST_STRUCT*, char*, char*);
SsiTraceLine (REQUEST_STRUCT*, char*);
SsiTraceSetVar (REQUEST_STRUCT*, char*, char*);
char* SsiGetVar (REQUEST_STRUCT*, char*, char*, BOOL);
char* SsiGetCgiVar (REQUEST_STRUCT*, char*);
char* SsiGetServerVar (REQUEST_STRUCT*, char*, char*);
char* SsiGetUserVar (REQUEST_STRUCT*, char*);
int SsiTimeString (REQUEST_STRUCT*, unsigned long*, char*, char*, int);

#endif /* SSI_H_LOADED */

/*****************************************************************************/
