/*****************************************************************************/
/*
                                  StmLF.h
*/
/*****************************************************************************/

#ifndef STMLF_H_LOADED
#define STMLF_H_LOADED 1

#include "wasd.h"

/**************/
/* structures */
/**************/

struct StreamLfStruct
{
   BOOL  ConversionOk,
            DstFileCreated,
            OdsExtended;
   int  PurgeAttemptCount;
   char  Buffer [4096],
         DstExpFileName [ODS_MAX_FILE_NAME_LENGTH+1],
         DstResFileName [ODS_MAX_FILE_NAME_LENGTH+1],
         FileName [ODS_MAX_FILE_NAME_LENGTH+1],
         SrcExpFileName [ODS_MAX_FILE_NAME_LENGTH+1];
   struct FAB  SrcFileFab;
   struct FAB  DstFileFab;
#ifdef ODS_EXTENDED
   struct NAML  SrcFileNaml;
   struct NAML  DstFileNaml;
#endif /* ODS_EXTENDED */
   struct NAM  SrcFileNam;
   struct NAM  DstFileNam;
   struct RAB  SrcFileRab;
   struct RAB  DstFileRab;
};

/***********************/
/* function prototypes */
/***********************/

StmLfBegin (char*, char*, int, BOOL, BOOL);
StmLfEnd (struct StreamLfStruct*);
StmLfNextRecord (struct RAB*); 
StmLfNextRecordAst (struct RAB*); 
StmLfLog (struct StreamLfStruct*, char*, int);

#endif /* STMLF_H_LOADED */

/*****************************************************************************/
