/*****************************************************************************/
/*
                                 Strng.h
*/
/*****************************************************************************/

#ifndef STRNG_H_LOADED
#define STRNG_H_LOADED 1

/* application related header files */
#include "wasd.h"

/**********/
/* macros */
/**********/

#define SMATCH_STRING 1
#define SMATCH_GREEDY 2
#define SMATCH_STRING_REGEX 3
#define SMATCH_GREEDY_REGEX 4
#define SMATCH_REGEX 5

#define StringMatchGreedy(rqptr,this,with) \
        StringMatchAndRegex (rqptr,this,with,SMATCH_GREEDY,NULL,NULL)

#define StringMatch(rqptr,this,with) \
        StringMatchAndRegex (rqptr,this,with,SMATCH_STRING,NULL,NULL)

#define StringMatchGreedyRegex(rqptr,this,with) \
        StringMatchAndRegex (rqptr,this,with,SMATCH_GREEDY_REGEX,NULL,NULL)

#define StringMatchRegex(rqptr,this,with) \
        StringMatchAndRegex (rqptr,this,with,SMATCH_STRING_REGEX,NULL,NULL)

/* separator used between "records" in a string list by StringListAdd() */
#define STRING_LIST_CHAR '\n'

/***********************/
/* function prototypes */
/***********************/

StringListAdd (char*, char**, int*);
BOOL StringMatchAndRegex (REQUEST_STRUCT*, char*, char*,
                          int, regex_t*, regmatch_t*);
char* StringRegexCompile (char*, regex_t*);
StringMatchReport (REQUEST_STRUCT*, REQUEST_AST);
int StringMatchSubstitute (REQUEST_STRUCT*, char*, char*,
                          regmatch_t*, char*, int);
int StringParseNameValue (char**, BOOL, char*, int, char*, int);
int StringParseQuery (char**, char*, int, char*, int);
int StringParseValue (char**, char*, int);
int StringSpanValue (char**, char**, char**);
int StringUrlDecode (char*);
int StringUrlEncode (char*, char*, int);
int StringUrlEncodeURL (char*, char*, int);
StringWatchPmatch (char*, regmatch_t*);
int strzcpy (char*, char*, int);
int strsame (char*, char*, int);

#endif /* STRNG_H_LOADED */

/*****************************************************************************/
