/*****************************************************************************/
/*
                                 Support.h
*/
/*****************************************************************************/

#ifndef SUPPORT_H_LOADED
#define SUPPORT_H_LOADED 1

/* standard C header files */
#include <time.h>

/* VMS related header files */
#include <fab.h>
#include <nam.h>

/* application related header files */
#include "wasd.h"

/**********/
/* macros */
/**********/

/* the current size determined by the The Apache Group */
#define UNIQUE_ID_SIZE 19

/***********************/
/* function prototypes */
/***********************/

LIST_ENTRY* ListAddHead (LIST_HEAD*, LIST_ENTRY*);
LIST_ENTRY* ListAddTail (LIST_HEAD*, LIST_ENTRY*);
LIST_ENTRY* ListAddBefore (LIST_HEAD*, LIST_ENTRY*, LIST_ENTRY*);
LIST_ENTRY* ListRemove (LIST_HEAD*, LIST_ENTRY*);
ListDebug (LIST_HEAD*);

int CompareVmsBinTimes (unsigned long*, unsigned long*);
int CopyTextIntoHtml (char*, char*, int);
char* DayOfWeekName (unsigned long*);
char* DateTime (unsigned long*, int);
char* DigitDayTime (unsigned long*);
int FormatProtection (unsigned short, char*);
char* GenerateUniqueId (REQUEST_STRUCT*);
int GetVmsVersion ();
char* HeapStringAppend (REQUEST_STRUCT*, char*, char*, int);
char* HeapStringPrepend (REQUEST_STRUCT*, char*, char*, int);
char* HtmlMetaInfo (REQUEST_STRUCT*, char*);
char* HttpStatusCodeText (int);
char* HttpStatusCodeExplanation (REQUEST_STRUCT*, int);
int HttpGmTime (char*, unsigned long*);
int HttpGmTimeString (char*, unsigned long*);
int HttpIfModifiedSince (REQUEST_STRUCT*, unsigned long*, int);
char* ServerSignature (REQUEST_STRUCT*, char*, int);
int TimeAdjustGMT (BOOL, unsigned long*);
int TimeSetGMT ();
int TimeVmsToUnix (unsigned long*, struct tm*);
int strzcpy (char*, char*, int);

#endif /* SUPPORT_H_LOADED */

/*****************************************************************************/
