/*****************************************************************************/
/*
                                  Throttle.h
*/
/*****************************************************************************/

#ifndef THROTTLE_H_LOADED
#define THROTTLE_H_LOADED 1

#include "wasd.h"

/**************/
/* structures */
/**************/

typedef struct ThrottleStruct THROTTLE_STRUCT;

struct ThrottleStruct
{
   /* count of requests for this path currently being processed */
   int  CurrentlyProcessingCount,
        CurrentlyQueuedCount,
        MaxProcessingCount,
        MaxQueuedCount,
        Total503Count,
        TotalCount,
        TotalQueuedCount,
        TotalFiFoCount,
        TotalTimeoutBusyCount,
        TotalTimeoutQueueCount;

   /* list of pointers to requests waiting for processing */
   LIST_HEAD  QueuedList;
};

/***********************/
/* function prototypes */
/***********************/

ThrottleBegin (REQUEST_STRUCT*);
ThrottleControl (BOOL, int);
ThrottleEnd (REQUEST_STRUCT*);
ThrottleInit ();
ThrottleMonitorReset ();
ThrottleRelease (REQUEST_STRUCT*, BOOL);
ThrottleReport (REQUEST_STRUCT*, REQUEST_AST);
ThrottleTimeout (REQUEST_STRUCT*);
ThrottleZero ();

#endif /* THROTTLE_H_LOADED */

/*****************************************************************************/
