/*****************************************************************************/
/*
                                  upd.h
*/
/*****************************************************************************/

#ifndef UPD_H_LOADED
#define UPD_H_LOADED 1

#include "wasd.h"

/**************/
/* structures */
/**************/

typedef struct UpdTreeStruct UPD_TREE;

struct UpdTreeStruct
{
   UPD_TREE  *PrevTreeNodePtr,
             *NextTreeNodePtr;

   int  /* */
        FileNameLength;

   char  /* */
         FileName [ODS_MAX_FILE_NAME_LENGTH+1];

   /* "on-disk structure" supporting both ODS-2 and ODS-5 */
   ODS_STRUCT  SearchOds;
};

typedef struct UpdTaskStruct UPD_TASK;

struct UpdTaskStruct
{
/**   struct UpdTaskStruct  *UpdTaskPtr;**/

   BOOL  /* editing a server configuration file */
         ConfigurationEdit,
         /* upper-case, directories indicated [], etc. */
         FormatTreeLikeVms,
         /* edit file record format is FIX/UDF (don't add newlines) */
         RecordFormatFixed,
         /* */
         RuleCheckAvailable,
         /* generated tree is for "Update" facility */
         UpdateTree;

   int  /* numeric columns */
        Cols,
        /* for counting files in tree listings, etc. */
        FileCount,
        /* */
        NavigateSize,
        /* numeric rows */
        Rows,
        /* count of how many characters before beginning "|---", etc. */
        TreeIndent,
        /* directory nesting level */
        TreeLevel;

   unsigned long  /* when creating files and directories */
                  ProtectionMask;

   char  /* MUST be 512 bytes (one block) for file copy purposes */
         CopyBuffer [512],
         /* columns by rows, for edit file <TEXTAREA> window */
         CxR [16],
         /* used for reading record from files being edited */
         EditBuffer [2048],
         /* tree processing, contains any name, type, version */
         FileNamePart [ODS_MAX_FILE_NAME_LENGTH+1],
         /* HTML-escaped title :^) */
         HtmlEscapedTitle [256],
         /* used to store language-specific strings while in use */
         MsgString [256];

   char  /* pointer to MIME content-type */
         *ContentTypePtr,
         /* current position during use of language-specific string */
         *MsgStringPtr;

   /* "on-disk structure" supporting both ODS-2 and ODS-5 */
   ODS_STRUCT  FileOds,
               SearchOds;

   UPD_TREE  *TreeHeadPtr,
             *TreeNodePtr;

   /* pointer to function, used for specifying the next task */
   REQUEST_AST NextTaskFunction;
};

/***********************/
/* function prototypes */
/***********************/

UpdBegin (REQUEST_STRUCT*, REQUEST_AST);
UpdConfirmCreate (REQUEST_STRUCT*, char*);
UpdConfirmDelete (REQUEST_STRUCT*, char*, char*);
UpdConfirmProtect (REQUEST_STRUCT*, char*, char*);
UpdConfirmRename (REQUEST_STRUCT*, char*, char*);
UpdCopyFileBegin (REQUEST_STRUCT*, char*);
UpdCopyFileEnd (REQUEST_STRUCT*);
UpdCopyFileNextBlock (REQUEST_STRUCT*);
UpdCopyFileNextBlockAst (struct RAB*); 
UpdEditFileBegin (REQUEST_STRUCT*, REQUEST_AST, char*);
UpdEditFileEnd (REQUEST_STRUCT*);
UpdEditFileNextRecord (REQUEST_STRUCT*);
UpdEditFileNextRecordAst (struct RAB*); 
UpdEnd (REQUEST_STRUCT*);
UpdNavigateBeginFiles (REQUEST_STRUCT*);
UpdNavigateDirs (struct FAB*); 
UpdNavigateFiles (struct FAB*); 
UpdNavigateSearchDirs (REQUEST_STRUCT*); 
UpdNavigateSearchFiles (REQUEST_STRUCT*); 
UpdTreeListDirs (REQUEST_STRUCT*);
UpdTreeDirs (struct FAB*); 
UpdTreeEnd (REQUEST_STRUCT*);

#endif /* UPD_H_LOADED */

/*****************************************************************************/

