/*****************************************************************************/
/*
                                 version.c

Merely generate software ID and build information strings.


10-OCT-1999  MGD  moved from HTTPD.C for v6.1
*/
/*****************************************************************************/

#ifdef WASD_VMS_V6
#undef _VMS_V6_SOURCE
#define _VMS_V6_SOURCE
#undef __VMS_VER
#define __VMS_VER 60000000
#undef __CRTL_VER
#define __CRTL_VER 60000000
#endif

#include <stdio.h>
#include <ctype.h>

#include "wasd.h"

#ifdef __ia64
#  define HTTPD_ARCH "IA64"
#endif
#ifdef __ALPHA
#  define HTTPD_ARCH "AXP"
#endif
#ifdef __VAX
#  define HTTPD_ARCH "VAX"
#endif

#ifndef BUILD_DATETIME
#  define BUILD_DATETIME __DATE__ " " __TIME__
#endif

/******************/
/* global storage */
/******************/

int  ActivityGblSecVersion = ACTIVITY_GBLSEC_VERSION_NUMBER,
     AuthGblSecVersion = AUTH_GBLSEC_VERSION_NUMBER,
     HttpdGblSecVersion = HTTPD_GBLSEC_VERSION_NUMBER,
     SesolaGblSecVersion = SESOLA_GBLSEC_VERSION_NUMBER,
     ProxyVerifyGblSecVersion = PROXYVERIFY_GBLSEC_VERSION_NUMBER;

char  BuildDateTime [] = BUILD_DATETIME,
      BuildInfo [64],
      HttpdName [] = HTTPD_NAME,
      HttpdSoftwareIdName [] = HTTPD_SOFTWAREID_NAME,
      HttpdVersion [] = HTTPD_VERSION,
      SoftwareID [128];

/********************/
/* external storage */
/********************/

extern char  HttpdSesola[];

/*****************************************************************************/
/*
*/

VersionInfo ()

{
   char  *cptr, *sptr;

   /*********/
   /* begin */
   /*********/

   /* software ID can be specified on the command line! */
   if (!SoftwareID[0])
      sprintf (SoftwareID, "%s/%s OpenVMS/%s%s",
               HttpdSoftwareIdName, HttpdVersion, HTTPD_ARCH, HttpdSesola);

   sprintf (BuildInfo, "%s VMS %s DECC %d%s",
            BUILD_DATETIME, __VMS_VERSION+1, __DECC_VER,
            OPERATE_WITH_SYSPRV ? " [/SYSPRV]" : "");

   /* compress white-space */
   cptr = sptr = BuildInfo;
   while (*cptr)
   {
      if (*cptr == ' ')
      {
         *sptr++ = *cptr++;
         while (*cptr == ' ') cptr++;
      }
      else
         *sptr++ = *cptr++;
   }
   *sptr = '\0';
} 

/*****************************************************************************/

