/*****************************************************************************/
/*
                                 Vm.h
*/
/*****************************************************************************/

#ifndef VM_H_LOADED
#define VM_H_LOADED 1

#include "wasd.h"

/***********************/
/* function prototypes */
/***********************/

VmGeneralInit ();
char* VmGet (unsigned long);
VmFree (char*, char*, int);
char* VmRealloc (char*, unsigned long, char*, int);

VmHeapInit ();
char* VmGetHeap (REQUEST_STRUCT*, unsigned long);
VmFreeHeap (REQUEST_STRUCT*, char*, int);
VmFreeFromHeap (REQUEST_STRUCT*, char*, char*, int);
char* VmReallocHeap (REQUEST_STRUCT*, char*, unsigned long, char*, int);

VmRequestInit ();
VmRequestTune ();
REQUEST_STRUCT* VmGetRequest ();
VmFreeRequest (REQUEST_STRUCT*, char*, int);

VmCacheInit (int);
char* VmGetCache (unsigned long);
VmFreeCache (char*, char*, int);

VmPermCacheInit (int);
char* VmGetPermCache (unsigned long);
VmFreePermCache (char*, char*, int);

VmReport (REQUEST_STRUCT*, REQUEST_AST);
VmWrite (struct dsc$descriptor*, REQUEST_STRUCT*);

#endif /* VM_H_LOADED */

/*****************************************************************************/

