/*****************************************************************************
/*
                                  WASD.h

Main header file for WASD VMS HTTP daemon.


VERSION HISTORY
---------------
20-DEC-2004  MGD  v8.4.0, all "#ifdef __ALPHA"s changed to "#ifndef __VAX"
                          to support compilation for IA64
15-OCT-2002  MGD  v8.1.0, base compiler messages on WATCH_MOD not DBUG
12-DEC-2000  MGD  v7.2.0, remote user size changed for X509
                          major reorg of data types, etc.
06-MAY-2000  MGD  v7.0.0, reorganise data structures
23-DEC-1999  MGD  v6.1.2, DECC v6.2 warning control
31-OCT-1999  MGD  v6.1.0, CGIplus "agents"
16-OCT-1999  MGD  v6.0.3, DEC TCP/IP v5.n compatibility definitions
10-JAN-1999  MGD  v6.0.0, proxy serving
19-SEP-1998  MGD  v5.3.0, disperse to module headers :^)
14-APR-1998  MGD  v5.0.1, XSSI extensions
07-JAN-1998  MGD  v5.0.0, HTTPd version 5 (Secure Sockets Layer, using SSLeay)
05-OCT-1997  MGD  v4.5.0, file cache
06-SEP-1997  MGD  v4.4.0, multiple server host names and ports
08-JUN-1997  MGD  v4.2.0, CGIplus
01-FEB-1997  MGD  v4.0.0, HTTPd version 4
01-AUG-1996  MGD  v3.3.0, quite a few changes since 3.0.n
01-DEC-1995  MGD  v3.0.0, HTTPd version 3
20-DEC-1994  MGD  v2.0.0, multi-threaded version
20-JUN-1994  MGD  v1.0.0, single-threaded version
*/
/*****************************************************************************/

#ifndef WASD_H_LOADED
#define WASD_H_LOADED 1

#ifdef WATCH_MOD
#  if WATCH_MOD
#     ifndef __VAX
#        if (__DECC_VER > 60000000)
#           pragma message enable (ALL)
#           pragma message disable (CVTDIFTYPES)
#           pragma message disable (EMBEDCOMMENT)
#           pragma message disable (MAYLOSEDATA)
#           pragma message disable (NORETURNVAL1,NOTYPES,NONEWTYPE)
#           pragma message disable (PTRMISMATCH,PTRMISMATCH1)
#        else
#           pragma message disable (ALL)
#        endif
#     else
#        pragma message disable (ALL)
#     endif
#  else
#     pragma message disable (ALL)
#  endif
#else
#  pragma message disable (ALL)
#endif

/* VMS headers */
#include <descrip.h>
#include <rms.h>
#include <ssdef.h>
#include <stsdef.h>
#include <rmsdef.h>

/* this definition is not available in VMS versions earlier than 7.0 */
#ifndef EFN$C_ENF
#  define EFN$C_ENF 128  /* Event No Flag (no stored state) */
#endif 

/* Alpha NO MEMBER ALIGNMENT unless otherwise specified */
#ifndef __VAX
#   pragma nomember_alignment
#endif

#include "regex.h"

#ifndef VERSION_H_LOADED
#   include "version.h"
#endif

/**********/
/* macros */
/**********/

#define boolean int
#define true 1
#define false 0

#define FI_LI WASD_MODULE, __LINE__

/* an error severity equivalent of the warning severity status */
#define SS$_BUFFEROVF_ERROR (SS$_BUFFEROVF & 0xfffffffe)

#define CONFIG_AUTH_FILE_NAME      "HTTPD$AUTH"
#define CONFIG_FILE_NAME           "HTTPD$CONFIG"
#define CONFIG_MAP_FILE_NAME       "HTTPD$MAP"
#define CONFIG_MSG_FILE_NAME       "HTTPD$MSG"
#define CONFIG_SERVICE_FILE_NAME   "HTTPD$SERVICE"
#define CONFIG_SITELOG_FILE_NAME   "HTTPD$SITELOG"
#define DEFAULT_SITELOG_FILE_NAME  "HT_ROOT:[LOCAL]SITE.LOG"

#define CONFIG_SSL_CAFILE          "HTTPD$SSL_CAFILE"
#define CONFIG_SSL_CERT            "HTTPD$SSL_CERT"
#define CONFIG_SSL_CIPHER          "HTTPD$SSL_CIPHER"
#define CONFIG_SSL_KEY             "HTTPD$SSL_KEY"
#define CONFIG_SSL_PARAMS          "HTTPD$SSL_PARAMS"

/* allows the HTTPd to be operated with SYSPRV permanently enabled */
#define OPERATE_WITH_SYSPRV 0

#define DEFAULT_HTTP_PORT          80
#define DEFAULT_HTTPS_PORT        443
#define DEFAULT_HTTP_PROXY_PORT  8080
#define DEFAULT_LISTEN_BACKLOG      5

/* this value must also include connections in a "keep-alive" state */
#define DEFAULT_CONCURRENT_CONNECT_MAX    50

#define DEFAULT_TIMEOUT_INPUT_MINUTES       1
#define DEFAULT_TIMEOUT_OUTPUT_MINUTES     10
#define DEFAULT_TIMEOUT_NOPROGRESS_MINUTES  3
#define DEFAULT_TIMEOUT_KEEPALIVE_SECONDS   0

/* try to terminate an obstinate request every */
#define TERMINATED_COUNT_RETRY_SECONDS 60

/* helps ensure a client doesn't get into an infinite loop */
#define KEEPALIVE_MAX 100

#define DEFAULT_DCL_CGI_HEADER_SIZE   2048
#define DEFAULT_DCL_CGIPLUSIN_SIZE    3072
#define DEFAULT_DCL_SYSCOMMAND_SIZE   4096
#define DEFAULT_DCL_SYSOUTPUT_SIZE    4096
#define DEFAULT_FILE_BUFFER_SIZE      1024
#define DEFAULT_NET_READ_BUFFER_SIZE  2048
#define DEFAULT_OUTPUT_BUFFER_SIZE    4096
#define MAX_REQUEST_HEADER            8192

/* control pre-expired responses */
#define PRE_EXPIRE_ADMIN            1
#define PRE_EXPIRE_DELETE_ON_CLOSE  1
#define PRE_EXPIRE_FTP_PROXY        0
#define PRE_EXPIRE_INDEX_OF         0
#define PRE_EXPIRE_MAPPING_RULES    0
#define PRE_EXPIRE_MENU             1
#define PRE_EXPIRE_PUT              1
#define PRE_EXPIRE_SSI              0
#define PRE_EXPIRE_UPD              1
#define PRE_EXPIRE_UPD_TREE_OF      1
#define PRE_EXPIRE_WATCH            0

/* versions of the HTTP protocol */
#define HTTP_VERSION_NOT_SET   0
#define HTTP_VERSION_0_9       9
#define HTTP_VERSION_1_0      10
#define HTTP_VERSION_1_1      11
#define HTTP_VERSION_UNKNOWN  -1

/* constants used to identify HTTP methods */
#define HTTP_METHOD_DELETE   0x01
#define HTTP_METHOD_GET      0x02
#define HTTP_METHOD_HEAD     0x04
#define HTTP_METHOD_POST     0x08
#define HTTP_METHOD_PUT      0x10
#define HTTP_METHOD_CONNECT  0x20

/* constants for controlling logging */
#define LOGGING_BEGIN     1
#define LOGGING_CLOSE     2
#define LOGGING_END       3
#define LOGGING_ENTRY     4
#define LOGGING_FLUSH     5
#define LOGGING_OPEN      6
#define LOGGING_TIMESTAMP 7

/* constants for OPCOM messages */
#define OPCOM_HTTPD          0x01
#define OPCOM_CONTROL        0x02
#define OPCOM_ADMIN          0x04
#define OPCOM_AUTHORIZATION  0x08
#define OPCOM_PROXY_MAINT    0x10

/* constants used by HTTPd supervisor timer */
#define TIMER_INPUT             1
#define TIMER_THROTTLE          2
#define TIMER_OUTPUT            3
#define TIMER_NOPROGRESS        4
#define TIMER_KEEPALIVE         5

/* constants used by the description module */
#define DESCRIPTION_ALL         0x01
#define DESCRIPTION_TEXT_PLAIN  0x02
#define DESCRIPTION_TEXT_HTML   0x04
/* this is returned in the first character the file type contains none */
#define DESCRIPTION_IMPOSSIBLE  0xff

/* default directory listing layout */
#define DEFAULT_DIR_LAYOUT "I__L__R__S:b__D"

/* "http:", "https:" or "connect:" service and request */
#define SCHEME_HTTP     1
#define SCHEME_HTTPS    2
#define SCHEME_CONNECT  3

/* header fields for HTTP/1.0 keep alive response */
#define DEFAULT_KEEPALIVE_HTTP_HEADER \
        "Connection: Keep-Alive\r\nKeep-Alive:\r\n"

/* if true, stops HTTPd server account with SYSPRV PUT(etc)ing - DANGEROUS */
#define PUT_DISALLOW_SYSPRV 0

#define CONFIG_HOME_PAGES_MAX      16
#define CONFIG_README_FILES_MAX    16
#define CONFIG_SCRIPT_RUNTIME_MAX  16
#define CONFIG_REVALIDATE_MINUTES_MAX  1440

#define CONFIG_SERVER_SIGNATURE_OFF    0
#define CONFIG_SERVER_SIGNATURE_ON     1
#define CONFIG_SERVER_SIGNATURE_EMAIL  2

#define SCRIPT_NAME_SIZE  128
#define METHOD_NAME_SIZE   16

#define CONFIG_DEFAULT_DIR_BODY_TAG "<BODY>"
#define CONFIG_DEFAULT_ADMIN_BODY_TAG \
        "<BODY BGCOLOR=\"#ffffff\" LINK=\"#0000cc\" VLINK=\"#0000cc\">"
#define CONFIG_DEFAULT_REPORT_BODY_TAG \
        "<BODY BGCOLOR=\"#ffffff\" LINK=\"#0000cc\" VLINK=\"#0000cc\">"

/* maximum Kbytes (1024) that can be in a body to be POSTed or PUTted */
#define PUT_DEFAULT_KBYTES_MAX 250
/* number of versions retained for files POSTed or PUTed */
#define PUT_DEFAULT_VERSION_LIMIT 3
/* W:RE,G:RE,O:RWED,S:RWED */
#define PUT_DEFAULT_FILE_PROTECTION 0xaa00

/* number of times a request can internally redirect */
#define REQUEST_REDIRECTION_MAX 5

/* number of known fields processing in REQUEST.C */
#define REQUEST_KNOWN_FIELDS 21
/* number of request header fields stored */
#define REQUEST_FIELDS_MAX 48  /* (currently 21 used) */
/* number of unrecognised request header fields available to be stored */
#define REQUEST_UNKNOWN_FIELDS_MAX (REQUEST_FIELDS_MAX - REQUEST_KNOWN_FIELDS)

/* number of pointers available for adding server-generated cookies */
#define RESPONSE_COOKIE_MAX 3

/* internal "scripts" */
#define ADMIN_SCRIPT_ECHO   "/echo"
#define ADMIN_SCRIPT_HISS   "/hiss"
#define ADMIN_SCRIPT_HISS_MAX_BYTES 100000000
#define ADMIN_SCRIPT_TREE   "/tree"
#define ADMIN_SCRIPT_UPD    "/upd"
#define ADMIN_SCRIPT_WHERE  "/where"
#define ADMIN_SCRIPT_XRAY   "/xray"

/* default instance number when in demo mode */
#define DEMO_INSTANCE_GROUP_NUMBER 0

/* regular expression processing */
#define REGEX_CHAR '^'
/* number of structures for holding match offsets */
#define REGEX_PMATCH_MAX 10
/* compile flags, case-insensitive extended GREP */
#define REGEX_C_FLAGS (REG_EXTENDED | REG_ICASE)
/* execution flags */
#define REGEX_E_FLAGS (0)

/* for creating network mode detached processes */
#define NETWORK_MODE_LOG_NAME "NET$WASD.LOG"
#define LGI$M_NET_PROXY  1
#define UAF$S_USERNAME  12
#define UAF$S_PASSWORD  32
#define UAF$S_ACCOUNT    8

/*************/
/* durations */
/*************/

/* 1000 = 1mS, 100 = 100uS, 10 = 10uS, 1 = 1uS (for really fast systems :^) */
/** #define DURATION_UNITS_USECS 1000 **/

#ifdef __VAX
/* durations are to be in units of 0.1 milliseconds */
#  define DURATION_UNITS_USECS 100
#else /* Alpha or ia64 */
/* durations are to be in units of 0.001 milliseconds */
#  define DURATION_UNITS_USECS 1
#endif /* #ifdef __VAX */

#if DURATION_UNITS_USECS == 1
#  define DURATION_SUBSEC_MAX 999999
#  define DURATION_DECIMAL_PLACES 6
#elif DURATION_UNITS_USECS == 10
#  define DURATION_SUBSEC_MAX 99999
#  define DURATION_DECIMAL_PLACES 5
#elif DURATION_UNITS_USECS == 100
#  define DURATION_SUBSEC_MAX 9999
#  define DURATION_DECIMAL_PLACES 4
#else
   /* defaults to milliseconds */
#  undef DURATION_UNITS_USECS
#  define DURATION_UNITS_USECS 1000
#  define DURATION_SUBSEC_MAX 999
#  define DURATION_DECIMAL_PLACES 3
#endif

#define USECS_IN_A_SECOND 1000000

/*********************/
/* functional macros */
/*********************/

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) (!((x) & STS$M_SUCCESS))

/* is it linear-white-space? (avoids the call overhead of an isspace()) */
#define ISLWS(c) (c == ' ' || c == '\t')

/* end of CR or LF terminated line? */
#define EOL(c) (c == '\r' || c == '\n' || !c)
#define NOTEOL(c) (c != '\r' && c != '\n' && c)

/************/
/* typedefs */
/************/

typedef int BOOL;

typedef (*FAB_AST) (struct FAB*);
typedef (*GENERAL_AST) (unsigned long);
typedef (*PROXY_AST) (struct ProxyTaskStruct*);
typedef (*REQUEST_AST) (struct RequestStruct*);
typedef (*CALL_BACK) (unsigned long);

typedef struct RequestStruct REQUEST_STRUCT;
typedef struct RequestPathSetStruct REQUEST_PATHSET;

/*******************/
/* data structures */
/*******************/

typedef struct ItemList2Struct VMS_ITEM_LIST2;

struct ItemList2Struct
{
   unsigned short  buf_len;
   unsigned short  item;
   void  *buf_addr;
};

typedef struct ItemList3Struct VMS_ITEM_LIST3;

struct ItemList3Struct
{
   unsigned short  buf_len;
   unsigned short  item;
   void  *buf_addr;
   void  *ret_len;
};

struct AnExitHandler
{
   unsigned long  Flink;
   unsigned long  HandlerAddress;
   unsigned long  ArgCount;
   unsigned long  ExitStatusPtr;
};

typedef struct IoSbStruct IO_SB;

struct IoSbStruct
{
   unsigned short  Status;
   unsigned short  Count;
   variant_union {
      unsigned long  Unused;
      unsigned long  MbxPid;
   } Overlay1;
};

struct MbxSenseIOsb
{
   unsigned short  Status;
   unsigned short  MessageCount;
   unsigned long  MessageBytes;
};

#undef lksb
typedef struct lksb
{
   unsigned short int lksb$w_status;
   unsigned short int lksb$w_reserved;
   unsigned int lksb$l_lkid;
   unsigned char lksb$b_valblk [16];
};

#undef LKIDEF
#undef lki$l_mstlkid
#undef lki$l_pid
#undef lki$l_mstcsid
#undef lki$b_rqmode
#undef lki$b_grmode
#undef lki$b_queue
#undef lki$$$_spare
#undef lki$l_lkid
#undef lki$l_csid
typedef struct wasd_lkidef
{
   unsigned int lki$l_mstlkid;
   unsigned int lki$l_pid;
   unsigned int lki$l_mstcsid;
   unsigned char lki$b_rqmode;
   unsigned char lki$b_grmode;
   char lki$b_queue;
   char lki$$$_spare;
   unsigned int lki$l_lkid;
   unsigned int lki$l_csid;
} LKIDEF;
 

/*
   Store these structures naturally-aligned on AXP.
   Uses a bit more storage but makes access as efficient as possible.
*/

#ifndef __VAX
#   pragma member_alignment __save
#   pragma member_alignment
#endif

typedef struct ListEntryStruct LIST_ENTRY;

struct  ListEntryStruct
{
   LIST_ENTRY  *PrevPtr;
   LIST_ENTRY  *NextPtr;
   void  *DataPtr;
};

typedef struct ListHeadStruct LIST_HEAD;

struct  ListHeadStruct
{
   LIST_ENTRY  *HeadPtr;
   LIST_ENTRY  *TailPtr;
   int  EntryCount;
};

/* these macros operate on the list head */
#define LIST_GET_HEAD(lp) ((char*)((LIST_HEAD*)lp)->HeadPtr)
#define LIST_GET_TAIL(lp) ((char*)((LIST_HEAD*)lp)->TailPtr)
#define LIST_GET_COUNT(lp) (((LIST_HEAD*)lp)->EntryCount)
#define LIST_IS_EMPTY(lp) (!((LIST_HEAD*)lp)->EntryCount)

/* these macros operate on list entries */
#define LIST_GET_DATA(lp) ((char*)((char*)lp+sizeof(LIST_ENTRY)))
#define LIST_GET_PREV(lp) (((LIST_ENTRY*)lp)->PrevPtr)
#define LIST_GET_NEXT(lp) (((LIST_ENTRY*)lp)->NextPtr)
#define LIST_HAS_PREV(lp) ((((LIST_ENTRY*)lp)->PrevPtr) != NULL)
#define LIST_HAS_NEXT(lp) ((((LIST_ENTRY*)lp)->NextPtr) != NULL)

typedef struct SupervisorListStruct SUPERVISOR_LIST;

struct SupervisorListStruct
{
   LIST_HEAD  RequestList;
   int  ChunkSeconds;
};

typedef struct Md5HashStruct MD5_HASH;

struct Md5HashStruct
{
   variant_union {
      unsigned char  HashChar [16];
      unsigned short  HashShort [8];
      unsigned long  HashLong [4];
   } Overlay1;
};

typedef struct SysInfoStruct SYS_INFO;

struct SysInfoStruct
{
   unsigned short  HwNameLength,
                   NodeNameLength;
   unsigned long  AvailCpuCnt,
                  DECnetVersion,
                  MaxSysGroup,
                  MemSize,
                  MemoryMB,
                  PageFactor,
                  PageSize,
                  VersionInteger;
   unsigned long  BootBinTime [2];
   char  HwName [32],
         NodeName [16],
         Version [9];
};

typedef struct HttpdProcessStruct HTTPD_PROCESS;

struct HttpdProcessStruct
{
     BOOL  PrivilegedAccount,
           SysInputFile,
           SysOutputFile;
     int  BytLmAvailable,
          AstLm, BioLm, BytLm, DioLm, EnqLm, FilLm,
          Grp, Mode, Pid, PgFlQuo, PrcLm, TqLm, Uic;
     unsigned long  AuthPriv [2];
     char  *ModeName;
     char  PrcNam [16],
           SysInput [256],
           SysOutput [256],
           UserName [13];
};

#define RANGE_BYTE_MAX 256

typedef struct RangeByteStruct RANGE_BYTE;

struct RangeByteStruct
{
   int  /* number of ranges to be transfered (zero is none/invalid) */
        Count,
        /* current range being transfered (array index, 0 thru to n-1) */
        Index,
        /* total length of current range being transfered (last-first+1) */
        Length,
        /* offset for the first byte in the first bucket (used by FILE.C) */
        Offset,
        /* the number of bytes remaining for current range (used by FILE.C) */
        Remaining,
        /* number of ranges in the request */
        Total;

   int  /* first byte offset */
        First [RANGE_BYTE_MAX],
        /* last byte offset */
        Last [RANGE_BYTE_MAX];
};

/*******************************************/
/* header files we need early in the piece */
/*******************************************/

#include "tcpip.h"
#include "enamel.h"
#include "instance.h"
#include "odsstruct.h"
#include "metacon.h"
#include "proxystruct.h"

/**********************************/
/* request history data structure */
/**********************************/

/* 256 bytes (a somewhat arbitrary quantity) */
struct  RequestHistoryStruct
{
   LIST_ENTRY  HistoryListEntry;
   struct  ServiceStruct  *ServicePtr;
   unsigned long  BinaryTime [2];
   unsigned long  BytesRawRx,
                  BytesRawTx,
                  ConnectNumber,
                  ResponseDuration;
   int  ResponseStatusCode;
   char  *RequestPtr;
   BOOL  Truncated;
   char  ClientAndRequest [256-12-8-4-4-4-4-4-4-4];
};

/*************************/
/* per-server accounting */
/*************************/

typedef struct AccountingStruct ACCOUNTING_STRUCT;

struct AccountingStruct
{
   /* this MUST be the first member to allow zeroing of the rest */
   unsigned long  ZeroedCount;

   unsigned long  AuthAcmeCount,
                  AuthBasicCount,
                  AuthAgentCount,
                  AuthAuthorizedCount,
                  AuthDigestCount,
                  AuthHtDatabaseCount,
                  AuthNotAuthenticatedCount,
                  AuthNotAuthorizedCount,
                  AuthOtherCount,
                  AuthRFC1413Count,
                  AuthSimpleListCount,
                  AuthSkelKeyCount,
                  AuthVmsCount,
                  AuthX509Count,
                  CacheHitCount,
                  CacheHitNotModifiedCount,
                  CacheLoadCount,
                  ConnectAcceptedCount,
                  ConnectIpv4Count,
                  ConnectIpv6Count,
                  ConnectSslCount,
                  ConnectCurrent,
                  ConnectCurrentKeepAlive,
                  ConnectPeak,
                  ConnectPeakKeepAlive,
                  ConnectProcessing,
                  ConnectProcessingPeak,
                  ConnectRejectedCount,
                  ConnectTooBusyCount,
                  DclCgiPlusReusedCount,
                  DclCrePrcCount,
                  DclCrePrcDetachCount,
                  DclCrePrcPersonaCount,
                  DclCrePrcPersonaDefaultCount,
                  DclCrePrcPersonaInvUserCount,
                  DclCrePrcPersonaPrvUserCount,
                  DclCrePrcSubprocessCount,
                  DclDelPrcCount,
                  DclForceXCount,
                  DclRteReusedCount,
                  DoAutoScriptCount,
                  DoCgiPlusScriptCount,
                  DoDclCommandCount,
                  DoDECnetCount,
                  DoDECnetReuseCount,
                  DoDECnetCgiCount,
                  DoDECnetCgiReuseCount,
                  DoDECnetOsuCount,
                  DoDECnetOsuReuseCount,
                  DoDirectoryCount,
                  DoDotUrlCount,
                  DoIsMapCount,
                  DoRteScriptCount,
                  DoScriptCount,
                  DoFileCount,
                  DoFileNotModifiedCount,
                  DoMenuCount,
                  DoPutCount,
                  DoServerAdminCount,
                  DoSsiCount,
                  DoUpdateCount,
                  ErrorsNoticedCount,
                  LastExitStatus,
                  LookupDnsAddressCount,
                  LookupDnsAddressErrorCount,
                  LookupDnsNameCount,
                  LookupDnsNameErrorCount,
                  LookupLiteralCount,
                  LookupLiteralErrorCount,
                  LookupCacheAddressCount,
                  LookupCacheNameCount,
                  MethodConnectCount,
                  MethodDeleteCount,
                  MethodGetCount,
                  MethodHeadCount,
                  MethodPostCount,
                  MethodPutCount,
                  MethodTraceCount,
                  NcsCount,
                  NcsConvertCount,
                  NetReadErrorCount,
                  NetWriteErrorCount,
                  PathAlertCount,
                  RedirectLocalCount,
                  RedirectRemoteCount,
                  RequestTotalCount,
                  RequestErrorCount,
                  RequestForbiddenCount,
                  RequestKeepAliveCount,
                  RequestKeepAliveMax,
                  RequestParseCount,
                  RequestPragmaNoCacheCount,
                  RequestProxyCount,
                  ResponseDurationCount,
                  ResponseDurationMax,
                  ResponseDurationMin,
                  SpuriousWakeCount,
                  StartupCount,
                  StreamLfConversionCount,
                  ThrottleBusyMetric,
                  ThrottleCurrentlyQueued,
                  ThrottleCurrentlyProcessing;

   unsigned long  QuadBytesRawRx [2],
                  QuadBytesRawTx [2],
                  QuadResponseDuration [2];

   unsigned long  ResponseStatusCodeCountArray [6];
};

/************************/
/* HTTPd global section */
/************************/

typedef struct MonRequestStruct MONITOR_REQUEST;

struct MonRequestStruct
{
   BOOL  Alert;
   int  HttpStatus,
        BytesRawRx,
        BytesRawTx;
   char  ClientHostName [96],
         Duration [16],
         MethodName [16],
         PrcNam [16],
         ReadError [96],
         Service [96],
         Time [16],
         Uri [236],
         WriteError [96];
};

/* name is "WASD" + a version string + instance number + string */
#define GBLSEC_NAME_FAO "!AZ!AZ!UL_!AZ"

typedef struct HttpdGblSecStruct HTTPD_GBLSEC;

struct HttpdGblSecStruct
{
   unsigned long  GblSecVersion,
                  GblSecLength,
                  HttpdProcessId;
   unsigned long  Mutex [INSTANCE_MUTEX_COUNT+1],
                  MutexCount [INSTANCE_MUTEX_COUNT+1],
                  MutexWaitCount [INSTANCE_MUTEX_COUNT+1];
   char  HttpdVersion [16],
         StatusMessage [256],
         PkPasswd [64];
   ACCOUNTING_STRUCT  Accounting;
   PROXY_ACCOUNTING_STRUCT  ProxyAccounting;
   MONITOR_REQUEST  Request;
   int  InstanceStartupMax;
   char  AuthSkelKeyUserName [47+1],
         AuthSkelKeyPassword [31+1];
   int  AuthSkelKeyHttpdTickSecond;
   unsigned long  VmRequestSizePages;
};

#ifndef __VAX
#   pragma member_alignment __restore
#endif

/************************/
/* module include files */
/************************/

#ifndef ADMIN_H_LOADED
#   include "admin.h"
#endif
#ifndef AUTH_H_LOADED
#   include "auth.h"
#endif
#ifndef BASIC_H_LOADED
#   include "basic.h"
#endif
#ifndef BODY_H_LOADED
#   include "body.h"
#endif
#ifndef CACHE_H_LOADED
#   include "cache.h"
#endif
#ifndef RESPONSE_H_LOADED
#   include "response.h"
#endif
#ifndef CGI_H_LOADED
#   include "cgi.h"
#endif
#ifndef CONFIG_H_LOADED
#   include "config.h"
#endif
#ifndef CONTROL_H_LOADED
#   include "control.h"
#endif
#ifndef DESCR_H_LOADED
#   include "descr.h"
#endif
#ifndef DCL_H_LOADED
#   include "dcl.h"
#endif
#ifndef DIR_H_LOADED
#   include "dir.h"
#endif
#ifndef DECNET_H_LOADED
#   include "decnet.h"
#endif
#ifndef ERROR_H_LOADED
#   include "error.h"
#endif
#ifndef FAO_H_LOADED
#   include "fao.h"
#endif
#ifndef FILE_H_LOADED
#   include "file.h"
#endif
#ifndef FILEDOT_H_LOADED
#   include "filedot.h"
#endif
#ifndef GRAPH_H_LOADED
#   include "graph.h"
#endif
#ifndef HTADMIN_H_LOADED
#   include "htadmin.h"
#endif
#ifndef HTTPD_H_LOADED
#   include "httpd.h"
#endif
#ifndef INSTANCE_H_LOADED
#   include "instance.h"
#endif
#ifndef ISMAP_H_LOADED
#   include "ismap.h"
#endif
#ifndef MAPURL_H_LOADED
#   include "mapurl.h"
#endif
#ifndef MENU_H_LOADED
#   include "menu.h"
#endif
#ifndef MSG_H_LOADED
#   include "msg.h"
#endif
#ifndef NET_H_LOADED
#   include "net.h"
#endif
#ifndef ODS_H_LOADED
#   include "ods.h"
#endif
#ifndef PERSONA_H_LOADED
#   include "persona.h"
#endif
#ifndef PROXY_H_LOADED
#   include "proxy.h"
#endif
#ifndef PROXYCACHE_H_LOADED
#   include "proxycache.h"
#endif
#ifndef PROXYFTP_H_LOADED
#   include "proxyftp.h"
#endif
#ifndef PROXYMAINT_H_LOADED
#   include "proxymaint.h"
#endif
#ifndef PROXYVERIFY_H_LOADED
#   include "proxyverify.h"
#endif
#ifndef PUT_H_LOADED
#   include "put.h"
#endif
#ifndef REQUEST_H_LOADED
#   include "request.h"
#endif
#ifndef SSI_H_LOADED
#   include "ssi.h"
#endif
#ifndef SERVICE_H_LOADED
#   include "service.h"
#endif
#ifndef Sesola_H_LOADED
#   include "Sesola.h"
#endif
#ifndef STMLF_H_LOADED
#   include "stmlf.h"
#endif
#ifndef STRNG_H_LOADED
#   include "strng.h"
#endif
#ifndef SUPPORT_H_LOADED
#   include "support.h"
#endif
#ifndef THROTTLE_H_LOADED
#   include "throttle.h"
#endif
#ifndef TRACK_H_LOADED
#   include "track.h"
#endif
#ifndef UPD_H_LOADED
#   include "upd.h"
#endif
#ifndef VM_H_LOADED
#   include "vm.h"
#endif
#ifndef WATCH_H_LOADED
#   include "watch.h"
#endif

/*
   Store the following structures naturally-aligned on AXP.
   Uses a bit more storage but makes access as efficient as possible.
*/

#ifndef __VAX
#   pragma member_alignment __save
#   pragma member_alignment
#endif

/****************************************/
/* request authentication/authorization */
/****************************************/

struct RequestAuthorizationStruct
{
   BOOL  /* the user was authenticated using ACME */
         AcmeAuthenticated,
         /* a case-less username and password was performed */
         CaseLess,
         /* authenticated user may only access via https: (SSL) */
         HttpsOnly,
         /* do not cache authentication information, revalidate each time */
         NoCache,
         /* there was a problem with the configuration of the path */
         PathProblem,
         /* the authentication realm name is a synonym for the SYSUAF */
         RealmIsVmsSynonym,
         /* there was a problem with the configuration of the realm */
         RealmProblem,
         /* 'RemoteUser' was resolved rather than supplied by the user */
         ResolvedRemoteUser,
         /* the user was authenticated using a skeleton key */
         SkelKeyAuthenticated,
         /* the user was authenticated from the SYSUAF */
         SysUafAuthenticated,
         /* user may change SYSUAF password */
         SysUafCanChangePwd,
         /* user can authenticate even if hours seem to prohibit */
         SysUafNilAccess,
         /* primary password has expired */
         SysUafPwdExpired,
         /* authorization rule directed to use SYSUAF profile */
         VmsUserProfile,
         /* authorization rule directed to script SYSUAF username */
         VmsUserScriptAs;

   int  /* X509 client certificate fingerprint length */
        ClientCertFingerprintLength,
        /* X509 client certificate CA length */
        ClientCertIssuerLength,
        /*  X509 client certificate client length */
        ClientCertSubjectLength,
        /* VMS status result of authentication/authorization */
        FinalStatus,
        /* length of string */
        GroupReadLength,
        /* length of string */
        GroupWriteLength,
        /* length of path being authorized :^) */
        PathBeingAuthorizedLength,
        /* length of additional parameter(s) */
        PathParameterLength,
        /* length of mapping PROTECT RULE from pass 1 */
        Protect1Length,
        /* length of mapping PROTECT RULE from pass 1 */
        Protect2Length,
        /* length of proxy mapping string */
        ProxyStringLength,
        /* length of string */
        RealmLength,
        /* length of the reason string */
        ReasonLength,
        /* what was originally supplied in remote_user */
        RemoteUserLength,
        /* number of minutes before credentials need to be revalidated */
        RevalidateTimeout,
        /* authenticated user details length */
        UserDetailsLength,
        /* number of identifiers loaded into array */
        VmsIdentifiersCount;

   unsigned short  /* length of the user profile pointed to */
                   VmsUserProfileLength;

   unsigned long  /* value representation of scheme being used for challenge */
                  ChallengeScheme,
                  /* the capability flags of the authorization path */
                  GroupCan,
                  /* VMS identifier value controlling read access */
                  GroupReadVmsIdentifier,
                  /* VMS identifier value controlling write access */
                  GroupWriteVmsIdentifier,
                  /* VMS identifier value controlling authentication */
                  RealmVmsIdentifier,
                  /* the capability flags of the request (ACT ON THESE!) */
                  RequestCan,
                  /* value representation of scheme being used for request */
                  Scheme,
                  /* source of read-only group information */
                  SourceGroupRead,
                  /* source of full-access group information */
                  SourceGroupWrite,
                  /* source of realm information */
                  SourceRealm,
                  /* the capability flags of the remote user */
                  UserCan,
                  /* what everybody else can do on that path */
                  WorldCan;

   unsigned long  /* pointer to array of VMS identifiers (zero-terminated) */
                  *VmsIdentifiersPtr;

   char  /* BASIC challenge response header field */
         *BasicChallengePtr,
         /* X509 client certificate fingerprint */
         *ClientCertFingerprintPtr,
         /* X509 client certificate CA */
         *ClientCertIssuerPtr,
         /* X509 client certificate client */
         *ClientCertSubjectPtr,
         /* DIGEST challenge response header field */
         *DigestChallengePtr,
         /* when digest authenticating, the client-supplied nonce */
         *DigestNoncePtr,
         /* when digest authenticating, the client-supplied digest */
         *DigestResponsePtr,
         /* when digest authenticating, the client-supplied URI */
         *DigestUriPtr,
         /* locates the directory containing required databases */
         *DirectoryPtr,
         /* pointer to authorization group name */
         *GroupReadPtr,
         /* pointer to string of IP-address/username masks */
         *GroupRestrictListPtr,
         /* pointer to authorization group name */
         *GroupWritePtr,
         /* pointer to the path being authorized :^) */
         *PathBeingAuthorizedPtr,
         /* used for additional authorization parameters */
         *PathParameterPtr,
         /* mapping PROTECT RULE from pass 1 */
         *Protect1Ptr,
         /* mapping PROTECT RULE from pass 2 */
         *Protect2Ptr,
         /* pointer to a string containing proxy username mappings */
         *ProxyStringPtr,
         /* pointer to authorization realm name */
         *RealmPtr,
         /* pointer to authorization realm synonym string */
         *RealmDescrPtr,
         /* pointer to a string containing a 401/403 error message */
         *ReasonPtr,
         /* points to either "Authorization:" or "Proxy-Authorization:" field */
         *RequestAuthorizationPtr,
         /* authenticated user details */
         *UserDetailsPtr,
         /* user profile is used by sys$check_access() */
         *VmsUserProfilePtr,
         /* pointer to string of IP-address/username masks */
         *WorldRestrictListPtr;

   char  /* what was originally provide in remote_user */
         RemoteUser [AUTH_MAX_USERNAME_LENGTH+1],
         /* basic, digest, etc. */
         Type [16];

   /* a pointer to a template used when searching the cache */
   AUTH_CREC  *CacheSearchRecordPtr;

   /* when processing RFC1414 identification protocol authorization */
   AUTH_IDENT  *IdentPtr;

   /* structure used during SYSUAF processing */
   AUTH_SYSUAF  *SysUafDataPtr;

   /* structure used during ACME processing */
   AUTH_ACME  *AcmeDataPtr;

   /* AST function pointers */
   REQUEST_AST  AstFunctionBuffer;
   REQUEST_AST  AstFunction;
   REQUEST_AST  AgentCalloutFunction;
};

/******************/
/* request client */
/******************/

struct RequestClientStruct
{
   int  IpPort;
   unsigned short  Channel;
   char  IpAddressString [TCPIP_ADDRESS_STRING_MAX+1];
         
   IO_SB  IOsb;
   IPADDRESS  IpAddress;
   TCPIP_HOST_LOOKUP  Lookup;

   SOCKADDRESS  SocketName;
   int  SocketNameLength;
   VMS_ITEM_LIST3  SocketNameItem;
};

/**************************/
/* request content (body) */
/**************************/

struct  RequestBodyStruct
{
   int  /* how much has been read from the client */
        ContentCount,
        /* equivalent of request header content-length */
        ContentLength,
        /* amount of raw or processed data available in this buffer */
        DataCount,
        /* size of raw data buffer (maximum read capacity, etc.) */
        DataSize,
        /* VMS status of last buffer read or other operation */
        DataStatus,
        /* virtual block number (512 byte block) of output */
        DataVBN,
        /* how many 'chunks' have been read from the client */
        DiscardChunkCount,
        /* was processed as this sort of content (BODY_PROCESSED_AS..) */
        ProcessedAs;

   char  /* pointer to raw or processed data ('.DataCount' gives it's size) */
         *DataPtr;

   /* a pointer to body processing data */
   BODY_PROCESS  *ProcessPtr;

   /* "callback" function used to process/transfer body contents */
   REQUEST_AST  AstFunction;
   REQUEST_AST  ProcessFunction;
};

/*************************/
/* request cache storage */
/*************************/

typedef struct RequestCacheStruct REQUEST_CACHE;

struct RequestCacheStruct
{
   BOOL  /* do not cache this request (for some reason or another) */
         DoNotCache,
         /* content is currently being loaded */
         Loading,
         /* the request has been assessed to see if it requires loading */
         LoadCheck,
         /* loaded at the CGI access point */
         LoadFromCgi,
         /* loaded at the file access point */
         LoadFromFile,
         /* loaded at the network access point */
         LoadFromNet,
         /* content is currently not usable */
         NotUsable;

   int  /* VMS status reflecting data load */
        LoadStatus,
        /* maximum length of content data (size of buffer) */
        ContentBufferSize,
        /* length of content data */
        ContentLength,
        /* amount of buffer remaining */
        ContentRemaining,
        /* convenience for when performing record I/O in the file module */
        RecordBlockLength;

   /* MD5 hash of mapped path */
   MD5_HASH  Md5Hash;

   char  /* used both when loading and reading cache */
         *ContentPtr,
         /* data content-type */
         *ContentTypePtr,
         /* used both when loading and reading cache */
         *CurrentPtr;

   /* request is being used to fill a cache entry */
   struct CacheStruct  *EntryPtr;
};

/*************************/
/* request character set */
/*************************/

struct  RequestCharsetStruct
{
   int  /* character set name length */
        CharsetLength;

   unsigned long  /* context of NCS conversion function */
                  NcsCf;

   char  /* pointer to character set name to be converted to */
         CharsetPtr;
};

/***************************/
/* request CGI environment */
/***************************/

struct  RequestCgiStruct
{
   BOOL  /* one-shot, absorb script CGI or NHP response header */
         AbsorbHeader,
         /* an agent does not need to provide a CGI compilant output */
         AgentScript,
         /* do not output to client record-by-record, buffer */
         BufferRecords,
         /* script output escape is being processed */
         CalloutInProgress,
         /* the response is encode in some way, force stream mode */
         ContentEncoding,
         /* the MIME type is "text/..." */
         ContentTypeText,
         /* remove all non-printable characters */
         FilterStream,
         /* header does not contain carriage-control */
         HeaderCarRet,
         /* is NOT a script, just the CLI being used to execute some DCL */
         IsCliDcl,
         /* in the body of the response  */
         ProcessingBody;

   int  /* length of heap memory pointed to by BufferPtr */
        BufferLength,
        /* remaining space in heap memory pointed to by BufferPtr */
        BufferRemaining,
        /* count of characters pointed to by 'CalloutOutputPtr' */
        CalloutOutputCount,
        /* length of "end-of-file" (output) sequence */
        EofLength,
        /* length of "end-of-text" sequence */
        EotLength,
        /* length of "escape" sequence */
        EscLength,
        /* keep track of usage when buffering script header */
        HeaderLength,
        /* CGI header lines so far */
        HeaderLineCount,
        /* stream, record, crlf modes */
        OutputMode,
        /* number of records (may have multiple lines) received from a script */
        RecordCount,
        /* period before the dynamic content is considered stale */
        ScriptControlCacheExpiresAfter,
        /* use this as the maximum allowed size to be cached */
        ScriptControlCacheMaxKBytes,
        /* line in module error reported from */
        ScriptControlErrorLine,
        /* script has returned a VMS status value */
        ScriptControlErrorVmsStatus,
        /* how many attempts have been made to restart a CGI script */
        ScriptRetryCount,
        /* for VMS Apache compatibility (1.3.9 at least!) */
        XVMSRecordMode;

   char  /* heap memory in which the CGI variables are generated */
         *BufferPtr,
         /* current position in CGI variable buffer */
         *BufferCurrentPtr,
         /* pointer to a record output by a callout sequence */
         *CalloutOutputPtr,
         /* "end-of-file" (output) sequence */
         *EofPtr,
         /* "end-of-text" sequence */
         *EotPtr,
         /* "escape" sequence */
         *EscPtr,
         /* dynamically allocated space for buffering script header */
         *HeaderPtr,
         /* name of module error reported from */
         *ScriptControlErrorModulePtr,
         /* text of error message */
         *ScriptControlErrorTextPtr,
         /* text in commented portion of error message */
         *ScriptControlErrorVmsTextPtr,
         /* VMS syntax script file name */
         *ScriptFileNamePtr;
};

/******************************/
/* request header information */
/******************************/

struct  RequestHeaderStruct
{
   BOOL  /* user agent is our old friend Netscape 3.03/Gold */
         AdminNetscapeGold;

   int  /* "Accept:" field length */
        AcceptFieldLength,
        /* above value length */
        AcceptLength,
        /* "Accept-Charset:" field length */
        AcceptCharsetFieldLength,
        /* above value length */
        AcceptCharsetLength,
        /* "Accept-Encoding:" field length */
        AcceptEncodingFieldLength,
        /* above value length */
        AcceptEncodingLength,
        /* "Accept-Language:" field length */
        AcceptLangFieldLength,
        /* above value length */
        AcceptLangLength,
        /* when processing request header, count to find first blank line */
        ConsecutiveNewLineCount,
        /* "Content-Length:" value */
        ContentLength,
        /* "Forwarded:" line(s) length */
        ForwardedFieldLength,
        /* above value length */
        ForwardedLength,
        /* value representation of HTTP protocol version number */
        HttpVersion,
        /* "If-Modified-Since:" field length */
        IfModifiedSinceFieldLength,
        /* above value length */
        IfModifiedSinceLength,
        /* "Keep-Alive:" field length */
        KeepAliveFieldLength,
        /* value representation of request HTTP method */
        Method,
        /* lenth of URI (path plus query string) from HTTP header */
        RequestUriLength,
        /* length of path from HTTP header */
        PathInfoLength,
        /* length of query string from HTTP header */
        QueryStringLength,
        /* length of "Range:" field */
        RangeFieldLength,
        /* count of request header fields */
        RequestFieldsCount,
        /* number of characters up until the blank line */
        RequestHeaderLength,
        /* characters in the request line (e.g. "GET /path HTTP/1.0\n") */
        RequestLineLength,
        /* count of unknown request header fields */
        UnknownFieldsCount;

   char  /* "Accept:" header line */
         *AcceptFieldPtr,
         /* value (string) of above  */
         *AcceptPtr,
         /* "Accept-Charset:" header line */
         *AcceptCharsetFieldPtr,
         /* value of above  */
         *AcceptCharsetPtr,
         /* "Accept-Encoding:" header line */
         *AcceptEncodingPtr,
         /* value of above  */
         *AcceptEncodingFieldPtr,
         /* "Accept-Language:" header line */
         *AcceptLangFieldPtr,
         /* value of above  */
         *AcceptLangPtr,
         /* "Authorization:" header line */
         *AuthorizationFieldPtr,
         /* value of above  */
         *AuthorizationPtr,
         /* HTTP/1.1 field header line */
         *CacheControlFieldPtr,
         /* value of above  */
         *CacheControlPtr,
         /* "Content-Length:" header line */
         *ContentLengthFieldPtr,
         /* value of above  */
         *ContentLengthPtr,
         /* stream's MIME content type header line */
         *ContentTypeFieldPtr,
         /* value of above  */
         *ContentTypePtr,
         /* "Connection:" header line */
         *ConnectionFieldPtr,
         /* value of above  */
         *ConnectionPtr,
         /* "Cookie:" header line */
         *CookieFieldPtr,
         /* value of above  */
         *CookiePtr,
         /* "ETag:" header line (only for proxy use) */
         *ETagFieldPtr,
         /* value of above  */
         *ETagPtr,
         /* "Forwarded:" header line */
         *ForwardedFieldPtr,
         /* value of above  */
         *ForwardedPtr,
         /* "Host:" header line */
         *HostFieldPtr,
         /* value of above  */
         *HostPtr,
         /* "If-Modified-Since:" header line */
         *IfModifiedSinceFieldPtr,
         /* value of above  */
         *IfModifiedSincePtr,
         /* pointer to heap storage of keep alive field */
         *KeepAliveFieldPtr,
         /* value of above  */
         *KeepAlivePtr,
         /* pointer to heap storage of request path */
         *PathInfoPtr,
         /* "Pragma:" header line */
         *PragmaFieldPtr,
         /* value of above  */
         *PragmaPtr,
         /* pointer to heap storage of request query string */
         *QueryStringPtr,
         /* pointer to request header */
         *RequestHeaderPtr,
         /* pointer to requested resource (path and any query string) */
         *RequestUriPtr,
         /* "Proxy-Authorization:" header line */
         *ProxyAuthorizationFieldPtr,
         /* value of above  */
         *ProxyAuthorizationPtr,
         /* "Proxy-Connection:" header line */
         *ProxyConnectionFieldPtr,
         /* value of above  */
         *ProxyConnectionPtr,
         /* "Range:" header line */
         *RangeFieldPtr,
         /* value of above  */
         *RangePtr,
         /* "Referer:" header line */
         *RefererFieldPtr,
         /* value of above  */
         *RefererPtr,
         /* "User-Agent:" header line */
         *UserAgentFieldPtr,
         /* value of above  */
         *UserAgentPtr,
         /* "X-Forwarded-For:" header line */
         *XForwardedForFieldPtr,
         /* value of above  */
         *XForwardedForPtr;

   char  /* pointers to request header fields */
         *RequestFieldsPtr [REQUEST_FIELDS_MAX],
         /* pointers to unrecognised request header fields */
         *UnknownFieldsPtr [REQUEST_UNKNOWN_FIELDS_MAX];

   char  /* string representing the request's HTTP method */
         MethodName [METHOD_NAME_SIZE];

   /* byte-range structure */
   RANGE_BYTE  *RangeBytePtr;
};

/***********************************/
/* request network-related storage */
/***********************************/

/* must be located in the non-zeroed portion of the request stucture! */
struct  RequestNetStruct
{
   int  /* count of how many times the TCP/IP connection is reused */
        KeepAliveCount,
        /* size of network read */
        ReadBufferSize,
        /* size of network read buffer */
        ReadRawDataSize,
        /* incremented by NetReadRawAst() with each status block error */
        ReadErrorCount,
        /* incremented by NetWriteRawAst() with each status block error */
        WriteErrorCount,
        /* size of network write */
        WriteRawDataLength;

   unsigned long  /* first error status */
                  ReadErrorStatus,
                  /* first error status */
                  WriteErrorStatus;

   char  /* pointer to network reads */
         *ReadRawDataPtr,
         /* pointer to heap storage client-read network buffering */
         *ReadBufferPtr,
         /* pointer to network writes */
         *WriteRawDataPtr;

   /* I/O status blocks */
   IO_SB  ReadIOsb,
          WriteIOsb;

   /* network read and write AST function pointers */
   REQUEST_AST  ReadRawAstFunction;
   REQUEST_AST  WriteRawAstFunction;

   /* make it easy on ourselves, make the SSL structure pointer typeless! */
   void  *SesolaPtr;
};

/*************************/
/* request path settings */
/*************************/

struct RequestPathSetStruct
{
   BOOL  /* language variant is based on file type not file name */
         AcceptLangTypeVariant,
         /* language variant is based on file type not "text/.." */
         AcceptLangWildcard,
         /* alert if path is detected */
         Alert,
         /* all access must be authorized (or fail) */
         AuthorizeAll,
         /* only authorize the mapped path, rather than the request path */
         AuthorizeMapped,
         /* only authorize the full path (not as script then path) */
         AuthorizeOnce,
         /* cache CGI-compliant script output */
         CacheCGI,
         /* do not cache files (traditional/backward-compatible setting) */
         CacheNoFile,
         /* cache request network output of any kind */
         CacheNet,
         /* cache non-parse-header script output */
         CacheNPH,
         /* it's a permanent cache entry (cannot be flushed) */
         CachePermanent,
         /* cache this path with query-string */
         CacheQuery,
         /* cache Server Side Includes output */
         CacheSSI,
         /* terminate the CGIPLUS stream using an EOF after the empty record */
         CgiPlusInWriteof,
         /* access to directory listings is allowed */
         DirAccess,
         /* access to directory listings is not allowed */
         DirNoAccess,
         /* access is allowed the directory contains .WWW_BROWSABLE */
         DirAccessSelective,
         /* implied wildcard disabled */
         DirNoImpliedWildcard,
         /* wildcard specification allowed */
         DirWildcard,
         /* wildcard specification not allowed */
         DirNoWildcard,
         /* rule mapping, SET the path to be pre-expired */
         Expired,
         /* allow VMS '...' wildcard */
         MapEllipsis,
         /* apply mapping rules to empty paths */
         MapEmpty,
         /* if a script is mapped, DO NOT map the derived path portion */
         MapOnce,
         /* rule mapping, SET the path not-to-be-cached */
         NoCache,
         /* do not apply any default search script */
         NoDefaultSearch,
         /* rule mapping, SET the path not-to-be-logged */
         NoLog,
         /* VMS user profile does not apply to this path */
         NoProfile,
         /* path may contain SSI documents with privileged directives */
         PrivSsi,
         /* reverse proxy authorization verification */
         ProxyReverseVerify,
         /* provide unknown request fields in proxy request header */
         ProxyUnknownRequestFields,
         /* provide a basic, lightly detailed error/other report */
         ReportBasic,
         /* provide a fully detailed error/other report */
         ReportDetailed,
         /* for successful responses suppress end-of-header blank line */
         ResponseHeaderBegin,
         /* for successful responses do not *generate* a header */
         ResponseHeaderNone,
         /* do not search for the script file (for RTE use) */
         ScriptNoFind,
         /* check that the path exists as a file before activating script */
         ScriptPathFind,
         /* do not parse the query string, let the script handle it */
         ScriptQueryNone,
         /* do not report form-url-encoded error, let the script handle it */
         ScriptQueryRelaxed,
         /* rule mapping, SET the path allowing stream-LF conversion */
         StmLF;

   int  /* per-path config equivalent */
        AuthRevalidateTimeout,
        /* entry expires after this many seconds or day/hour/minute */
        CacheExpiresAfter,
        /* prevents a cache entry being immediately reloaded */
        CacheGuardSeconds,
        /* use this as the maximum allowed size to be cached */
        CacheMaxKBytes,
        /* style of directory listing */
        DirStyle,
        /* ODS-2, ODS-5, SRI, PATHWORKS, Advanced Server file name munging */
        PathOds,
        /* proxy service's proxy server port */
        ProxyChainPort,
        /* proxy "Forwarded: by" */
        ProxyForwardedBy,
        /* proxy "X-Forwarded-For:" */
        ProxyXForwardedFor,
        /* report bad request as this status code */
        Report400as,
        /* report forbidden as this status code */
        Report403as,
        /* report not found as this status code */
        Report404as,
        /* length of additional response header fields */
        ResponseHeaderAddLength,
        /* per-path config equivalent */
        ScriptBitBucketTimeout,
        /* length of script activating command */
        ScriptCommandLength,
        /* CPU limit of script */
        ScriptCpuMax,
        /* length of "(name=value[,name=value])" non-CGI variables */
        ScriptParamsLength,
        /* length of 'ssi=exec=' */
        SsiExecLength,
        /* SSL CGI variables */
        SSLCGIvar,
        /* index into array of lists of throttled requests */
        ThrottleIndex,
        /* aboslute maximum requests before 503 "busy" */
        ThrottleBusy,
        /* concurrent requests before queueing */
        ThrottleFrom,
        /* concurrent requests after which FIFOing ceases */
        ThrottleResume,
        /* concurrent requests before FIFO processing */
        ThrottleTo,
        /* seconds before queued request is terminated */
        ThrottleTimeoutBusy,
        /* seconds before queued request is set to processing */
        ThrottleTimeoutQueue,
        /* per-path config equivalent */
        TimeoutKeepAlive,
        /* per-path config equivalent */
        TimeoutNoProgress,
        /* per-path config equivalent */
        TimeoutOutput;

   char  /* if non-zero then attempt to resolve a language-specific file */
         AcceptLangChar;
         
   char  /* default language of files in path */
         *AcceptLangPtr,
         /* redirection URL if VMS-authenticated password is expired */
         *AuthSysUafPwdExpUrlPtr,
         /* associate path with a CGI variable prefix */
         *CgiPrefixPtr,
         /* associate path with a specific charset */
         *CharsetPtr,
         /* associate path with a specific content-type */
         *ContentTypePtr,
         /* associate directory listing with a specific charset */
         *DirCharsetPtr,
         /* document root */
         *MapRootPtr,
         /* page formatting */
         *HtmlBodyTagPtr,
         /* page footer formatting */
         *HtmlFooterPtr,
         /* page footer formatting */
         *HtmlFooterTagPtr,
         /* page header formatting */
         *HtmlHeaderPtr,
         /* page header formatting */
         *HtmlHeaderTagPtr,
         /* associate path with a "Index of" format */
         *IndexPtr,
         /* string with host name and port */
         *ProxyChainHostPortPtr,
         /* when reverse proxying rewrites any 302 "Location:" URL */
         *ProxyReverseLocationPtr,
         /* list of additional response header fields */
         *ResponseHeaderAddPtr,
         /* the username the script should execute under */
         *ScriptAsPtr,
         /* script activating command and/or qualifiers and/or parameters */
         *ScriptCommandPtr,
         /* script default directory */
         *ScriptDefaultPtr,
         /* a list of "(name=value[,name=value])" non-CGI variables */
         *ScriptParamsPtr,
         /* string containig allowed SSI #exec commands */
         *SsiExecPtr;

   char  /* CGIPLUSIN records have explicit <LF>, <CR>, or <CR><LF> added */
         CgiPlusInCC [4];

   IPADDRESS  /* the proxy outgoing IP address has been set */
              ProxyBindIpAddress,
              /* proxy service's proxy server */
              ProxyChainIpAddress;
};

/********************/
/* request response */
/********************/

struct  RequestResponseStruct
{
   BOOL  /* response header has been sent to client */
         HeaderSent,
         /* response include an "Expires:" the same as "Last-Modified:" */
         PreExpired,
         /* report any errors using the error report script */
         ErrorReportByRedirect;

   int  /* character set length */
        CharsetLength,
        /* NCS conversion buffer size */
        CharsetNcsBufferSize,
        /* the output buffer need to be this many time bigger than input */
        CharsetNcsCfFactor,
        /* from generated response headers (if specified) */
        ContentLength,
        /* used during HEAD method to determine when header ends */
        HeaderNewlineCount,
        /* buffer for data length */
        HeaderDataLength,
        /* length of reponse header */
        HeaderLength,
        /* numeric equivalent of the "200", "302", etc., HTTP status code */
        HttpStatus,
        /* length of error report text/query-string */
        ErrorReportLength;

   unsigned long  /* NCS conversion function */
                  CharsetNcsCf,
                  /* response duration */
                  Duration;

   char  /* NCS conversion buffer */
         *CharsetNcsBufferPtr,
         /* from generated headers and CGI responses */
         *ContentTypePtr,
         /* "Cookie:" response header array */
         *CookiePtr [RESPONSE_COOKIE_MAX],
         /* pointer to response header */
         *HeaderPtr,
         /* buffer for data pointer */
         *HeaderDataPtr,
         /* pointer to heap storage of redirection location path */
         *LocationPtr,
         /* pointer to other info when generating error report */
         *ErrorOtherTextPtr,
         /* pointer to error text/query-string */
         *ErrorReportPtr,
         /* pointer to explanation when generating error report */
         *ErrorTextPtr,
         /* message character set */
         *MsgCharsetPtr,
         /* pointer to boundary string */
         *MultipartBoundaryPtr;
         
   /* AST function pointers */
   REQUEST_AST  HeaderAstFunction;
};

/************************/
/* request time storage */
/************************/

struct  RequestTimeStruct
{
   unsigned long  /* start of request processing */
                  Vms64bit [2],
                  /* time from "If-Modified-Since:" header */
                  IfModifiedSinceVMS64bit [2];

   unsigned short  /* component equivalent of 'Vms64bit' */
                   VmsVector [7];

   char  /* GMT-adjusted string equivalent of 'Vms64bit' */
         GmDateTime [48];
};

/******************/
/* request timers */
/******************/

/* must be located in the non-zeroed portion of the request stucture! */
struct  RequestTmrStruct
{
   LIST_ENTRY  ListEntry;

   int  /* counter for input timeout */
        InputSecond,
        /* counter for keep-alive timeout */
        KeepAliveSecond,
        /* index into 5, 15, 60, 300, 300+ (etc.) second queues */
        ListIndex,
        /* previous Rx bytes for output no-progress checking */
        NoProgressBytesRx,
        /* previous Tx bytes for output no-progress checking */
        NoProgressBytesTx,
        /* counter for output no-progress */
        NoProgressSecond,
        /* storage for server value (WATCH must be able to manipulate this) */
        NoProgressPeriod,
        /* counter for output timeout */
        OutputSecond,
        /* supervisor timer has expired */
        TerminatedCount,
        /* counter for throttle timeout */
        ThrottleSecond;
};

/****************************/
/* request output buffering */
/****************************/

struct  RequestOutputStruct
{
   /* the head of the output buffer list */
   LIST_HEAD  BufferList;

   /* pointer to heap storage structure for output buffering */
   LIST_ENTRY  *BufferStructPtr,
               *BufferNowStructPtr;

   /* pointer to any AST function */
   REQUEST_AST  BufferAstFunction;

   BOOL  /* escapes HTML-forbidden characters as sent to client */
         BufferEscapeHtml,
         /* all output buffers must be written to network */
         BufferFlush;

   int  /* count of all data in all output buffers */
        BufferCount,
        /* bytes still available in the current output buffer */
        BufferRemaining,
        /* size of buffer */
        BufferSize;

   char  /* pointer to the start of the current buffer */
         *BufferPtr,
         /* pointer used to point into 'Buffer' storage */
         *BufferCurrentPtr;
};

/*********************************/
/* request heap management stats */
/*********************************/

struct  RequestHeapStatsStruct
{
   unsigned long  ByteCount,
                  GetCount,
                  GetByteCount,
                  GetByteMax,
                  GetByteMin,
                  FreeCount,
                  FreeByteCount,
                  FreeByteMax,
                  FreeByteMin,
                  ReallocCount,
                  ReallocByteCount,
                  ReallocByteMax,
                  ReallocByteMin;
};

/******************************/
/* per-request data structure */
/******************************/

struct RequestStruct
{
   /***************************/
   /* general purpose storage */
   /***************************/

   /*
      Storage areas at the beginning of this structure, specifically
      above the field 'RetainAboveZeroBelow', are retained between
      successive requests during persistent connections.
      When a "keep-alive" connection is reinitialized ready for a
      potential new request all of this structure below (and including)
      that field are zeroed, effectively allowing a new request.
   */

   /* for maintaining the list of request structures */
   LIST_ENTRY  RequestListEntry;

   /* zone ID for request heap's virtual memory management */
   unsigned long  VmHeapZoneId;

   /* client connection, network parameters, request timer data, etc */
   struct RequestClientStruct  rqClient;
   struct RequestNetStruct  rqNet;
   struct RequestTmrStruct  rqTmr;
   struct RequestHeapStatsStruct  rqHeapStats;

   /* pointer to service structure of host/port etc of service connected to */
   SERVICE_STRUCT  *ServicePtr;

   int  /* server number of IP accept() and request creation */
        ConnectNumber,
        /* notepad is persistent */
        NotePadLength,
        /* avoid redirection loops by keeping track of the number */
        RedirectCount,
        /* an error is being reported from a redirect path */
        RedirectErrorStatusCode,
        /* request is being WATCHed */
        WatchItem;

   char  /* notepad is persistent */
         *NotePadPtr,
         /* location rewrite storage is persistent */
         *ProxyReverseLocationPtr,
         /* when redirecting this points to any current authentication realm */
         *RedirectErrorAuthRealmDescrPtr;

   /* the rest of this structure will be zeroed with a persistent connection */
   /***************************/
    unsigned long  ZeroedBegin;
   /***************************/

   BOOL  /* "temporary" file, delete it on close */
         DeleteOnClose,
         /* true if a mapping rule identifies this as a "CGIplus" script */
         IsCgiPlusScript,
         /* this request has a "Connection: Keep-Alive" token */
         KeepAliveRequest,
         /* the server has responded with "keep-alive" */
         KeepAliveResponse,
         /* this persistent connection has timed out */
         KeepAliveTimeout,
         /* extended file specifications to be used on this path */
         PathOdsExtended,
         /* "Pragma: no-cache" HTTP request header line encountered */
         PragmaNoCache,
         /* proxy request (e.g. "http://...", "ftp://...") */
         ProxyRequest;

   int  /* counter representing request activity has been incremented */
        AccountingDone,
        /* length of configuration directory */
        ConfigDirectoryLength,
        /* size of buffer space for sys$output from DCL subprocess */
        DclSysOutputSize,
        /* when trying home pages this returns the VMS status */
        HomePageStatus,
        /* length of mapped path */
        MappedPathLength,
        /* pass through rules (mapping rules, 1 or 2) */
        MetaConPass,
        /* prevent runaway restarts through rules */
        MetaConRestartCount,
        /* integer representing prefered message language */
        MsgLanguage,
        /* on-disk file naming specification */
        PathOds,
        /* length of remote user name */
        RemoteUserLength,
        /* count of home page file names tried */
        RequestHomePageIndex;

   unsigned long  /* count of REQUEST-RELATED bytes received from the client */
                  BytesRx,
                  /* count of REQUEST-RELATED bytes sent to the client */
                  BytesTx,
                  /* count of TOTAL bytes received from the client */
                  BytesRawRx,
                  /* count of TOTAL bytes sent to the client */
                  BytesRawTx;

   char  /* buffer space for sys$output from DCL subprocess */
         *DclSysOutputPtr,
         /* pointer to mapped path */
         *MappedPathPtr,
         /* pointer to (being) mapped path (during mapping rule processing) */
         *MetaConMappedPtr,
         /* pointer to script name (during mapping rule processing) */
         *MetaConScriptPtr;

   char  /* source of configuration information */
         ConfigDirectory [METACON_CONFIG_DIR_LENGTH+1],
         /* authenticated user name from "Authorization:" */
         RemoteUser [AUTH_MAX_USERNAME_LENGTH+1],
         /* storage when authenticating remote user */
         RemoteUserPassword [AUTH_MAX_PASSWORD_LENGTH+1],
         /* file mapped from path to specification */
         RequestMappedFile [ODS_MAX_FILE_NAME_LENGTH+1],
         /* run-time mapped from rules */
         RequestMappedRunTime [ODS_MAX_FILE_NAME_LENGTH+1],
         /* script mapped from path to specification */
         RequestMappedScript [ODS_MAX_FILE_NAME_LENGTH+1],
         /* mapped script name */
         ScriptName [SCRIPT_NAME_SIZE+1],
         /* unique ID used for tracking */
         TrackId [TRACK_ID_SIZE+1];

   /* MD5 hash of mapped path */
   MD5_HASH  Md5HashPath;

   /* structures containing specific request storage */
   struct  RequestHeaderStruct         rqHeader;
   struct  RequestBodyStruct           rqBody;
   struct  RequestAuthorizationStruct  rqAuth;
   struct  RequestCacheStruct          rqCache;
   struct  RequestCgiStruct            rqCgi;
   struct  RequestOutputStruct         rqOutput;
   struct  RequestPathSetStruct        rqPathSet;
   struct  RequestResponseStruct       rqResponse;
   struct  RequestTimeStruct           rqTime;
   struct  ContentTypeStruct           rqContentInfo;

   /* when a path is throttled this will be in the active or waiting list */
   LIST_ENTRY  ThrottleListEntry;

   FILE_CONTENT   *FileContentPtr;
   ODS_STRUCT     ParseOds;

   /* AST function pointers */
   REQUEST_AST  WatchShowNextTaskFunction;

   /**************/
   /* task lists */
   /**************/

   /* these two modules can have multiple, concurrent instances */
   LIST_HEAD     DirTaskList,
                 SsiTaskList;

   /* these modules/tasks can only have one total or multiple serially */
   DCL_TASK      *DclTaskPtr;
   DECNET_TASK   *DECnetTaskPtr;
   DESCR_TASK    *DescrTaskPtr;
   DIR_TASK      *DirTaskPtr;
   FILE_TASK     *FileTaskPtr;
   GRAPH_TASK    *GraphTaskPtr;
   HTADMIN_TASK  *HTAdminTaskPtr;
   ISMAP_TASK    *IsMapTaskPtr;
   MENU_TASK     *MenuTaskPtr;
   PROXY_TASK    *ProxyTaskPtr;
   PUT_TASK      *PutTaskPtr;
   SSI_TASK      *SsiTaskPtr;
   UPD_TASK      *UpdTaskPtr;

   REQUEST_AST   NextTaskFunction;

   /*************************/
    unsigned long  ZeroedEnd;
   /*************************/

};

#ifndef __VAX
#   pragma member_alignment __restore
#endif

#endif /* WASD_H_LOADED */

/*****************************************************************************/
                                                                                                                                                                                                                                                                                                                                                                                                                   