// hi2CGIplus.java
// Compile using: $ javac "hi2CGIplus.java"
//
// 09-DEC-97  MGD  initial
//
// Quick demonstration of using the CGIplus class for a "CGIplus" script.
// Can be invoked using ... http://host/cgiplus-bin/hi2cgiplus.class

import java.io.*;

public class hi2cgiplus {

   private static CGIplus cgienv = new CGIplus();
   private static String lastUsageTime = null;

   public static void main (String args[]) {

      /* CGIplus "infinite loop" */
      for (;;) {

         cgienv.begin();

         // CGI-compliant header line making document HTML (and pre-expired)
         System.out.print("Content-Type: text/html\n" +
                          "Expires: Thu, 01-Jan-1970 00:00:01 GMT\n\n");

         if (cgienv.getCgiVar("WWW_KEY_1") != null) {
            System.out.print("<H2>bye ...</H2>\n");
            cgienv.end();
            System.exit(0);
         }

         System.out.print("<H1><U>Hi &nbsp;" +
                          cgienv.getCgiVar("WWW_REMOTE_HOST") +
                          "</U></H1>\n" + 
                          "You are using \"<B>" +
                          cgienv.getCgiVar("WWW_HTTP_USER_AGENT") +
                          "</B>\"\n<P>It\'s currently <B>" +
                          cgienv.getCgiVar("WWW_REQUEST_TIME_LOCAL") +
                          "</B> here at <B>" +
                          cgienv.getCgiVar("WWW_SERVER_NAME") +
                          "</B>");

         System.out.print("<P><I>This Java <B>CGIplus</B> script has been used ");

         if (cgienv.getUsageCount() == 1) {
            System.out.print("once (use again!)");
         }
         else {
            System.out.print(cgienv.getUsageCount() +
                             " times, last at " + lastUsageTime + "\n");
         }

         System.out.print("<P>Notice the difference in latency " +
            "after it's been loaded! " +
            "<BR>To see that again <A HREF=\"" +
            cgienv.getCgiVar("WWW_SCRIPT_NAME") +
            "?exit\">click here</A> (script exits requiring reload).");

         lastUsageTime = cgienv.getCgiVar("WWW_REQUEST_TIME_LOCAL");

         cgienv.end();
      }
   }
}
