$!----------------------------------------------------------------------------
$! JAVA.COM
$!
$! DCL for supporting Java classes as HTTPd scripts.
$! Works in conjunction with the CGIplus class provided in CGIplus.java 
$! May require modification for local site Java environment.
$! Move any modified version to HT_ROOT:[SCRIPT_LOCAL]JAVA.COM
$! Class names must be all lower-case due to way HTTPd invokes the class file.
$!
$! 24-NOV-2002  MGD  WASD 8.1 directory restructure
$! 05-MAR-2002  MGD  increasing complexity (JDK 1.3.1)
$! 03-SEP-1998  MGD  changes for JDK 1.1.6 final release
$! 09-DEC-1997  MGD  initial, JDK1.1 beta kit
$!----------------------------------------------------------------------------
$ if f$type(javaSetup) .eqs. "" then javaSetup = ""
$ dbug = 0
$!
$ say = "write sys$output"
$ if dbug
$ then
$    say "Content-Type: text/plain"
$    say ""
$    set verify
$ endif
$ set noon
$!
$ if javaSetup .eqs. ""
$ then
$!   (find the latest Java kit and use the setup from that!)
$    loop:
$       jdir = f$search("SYS$COMMON:[000000]JAVA$*.DIR")
$       if jdir .eqs. "" then goto endLoop
$       javaDir = jdir
$       goto loop
$    endLoop:
$    javaDir = JavaDir - "000000]" - ".DIR;1" + "]"
$    javaComDir = javaDir - "]" + ".COM]"
$    javaSetup = f$search("''javaComDir'JAVA$%%%_SETUP.COM")
$ endif
$!
$ if dbug
$ then
$    @'javaSetup'
$    show symbol *
$    show log /process
$ else
$    define sys$output nl:
$    define sys$error nl:
$    @'javaSetup'
$    deassign sys$output
$    deassign sys$error
$ endif
$!
$!(include Java class directory in the local class path)
$ if f$trnlnm("JAVA$CLASSPATH") .nes. ""
$ then
$    path = ""
$    count = 0
$    classpath_loop:
$       item = f$trnlnm("JAVA$CLASSPATH",,count)
$       if item .eqs. "" then goto classpath_loop_end
$       if path .nes. "" then path = path + ","
$       path = path + item
$       count = count + 1
$       goto classpath_loop
$    classpath_loop_end:
$    if path .nes. "" then path = path + ","
$    if f$trnlnm("HT_JAVA_ROOT") .nes. ""
$       then path = path + "ht_java_root:[java]"
$       else path = path + "cgi-bin:[000000]"
$    endif
$    define/process/user JAVA$CLASSPATH 'path'
$ else
$    path = f$trnlnm("CLASSPATH")
$    if path .nes. "" then path = path + ":.:"
$    if f$trnlnm("HT_JAVA_ROOT") .nes. ""
$       then path = path + "/ht_java_root/java/"
$       else path = path + "/cgi-bin/"
$    endif
$    define /user CLASSPATH "''path'"
$ endif
$!(extract just the class file name from the full file path)
$ class = f$edit(f$element(0,".",f$element(1,"]",p1)),"lowercase")
$!
$ dcgipluseof = f$trnlnm("CGIPLUSEOF")
$ if dcgipluseof .nes. "" -
     then dcgipluseof = """-Dcgipluseof=" + dcgipluseof + """"
$!(reading from System.in should give the standard CGI HTTP stream)
$ define /user sys$input http$input
$!
$!(ok, here's the Java command)
$ java 'dcgipluseof' 'class'
$!
$!(bit of tidying up)
$ statuslognam = "JAVA$STATUS_" + f$getjpi("","PID")
$ if f$trnlnm(statuslognam) then deassign /job 'statuslognam'
$!----------------------------------------------------------------------------
