/*****************************************************************************/
/*
                                   colors.c

Access via:   <A HREF="/cgi-bin/colors">colors</A>

              <FORM METHOD=POST ACTION="/cgi-bin/colors">
              <INPUT TYPE=submit VALUE="colors">
              </FORM>


BUILD
-----
See BUILD_COLORS.COM


VERSION HISTORY
---------------
31-MAY-2004  MGD  v1.1.2, add RGB:(n,n,n) values to text
23-DEC-2003  MGD  v1.1.1, minor conditional mods to support IA64
28-APR-1998  MGD  v1.1.0, default to "standard" (216) colours
22-FEB-1997  MGD  v1.0.0, quick hack
*/
/*****************************************************************************/

#define SOFTWAREVN "1.1.2"
#define SOFTWARENM "COLORS"
#ifdef __ALPHA
   char SoftwareID [] = SOFTWARENM " AXP-" SOFTWAREVN;
#endif
#ifdef __ia64
   char SoftwareID [] = SOFTWARENM " IA64-" SOFTWAREVN;
#endif
#ifdef __VAX
   char SoftwareID [] = SOFTWARENM " VAX-" SOFTWAREVN;
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <file.h>

#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

#define boolean int
#define true 1
#define false 0

/* macro provides NULL pointer if CGI variable does not exist */
#define GetCgiVarIfExists(CharPointer,CgiVariableName) \
   CharPointer = getenv(CgiVariableName)

/* macro provides pointer to empty string even if CGI variable does not exist */
#define GetCgiVar(CharPointer,CgiVariableName) \
   if ((CharPointer = getenv(CgiVariableName)) == NULL) \
       CharPointer = ""; \
   if (Debug) fprintf (stdout, "%s |%s|\n", CgiVariableName, CharPointer);

char  Utility [] = "COLORS";

boolean  Debug,
         HttpHasBeenOutput;

int  Interval = 51;

char  *CgiKey1Ptr,
      *CgiKey2Ptr;

char  String [] =
"0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz";

/* function prototype */
TimeoutAst ();

/*****************************************************************************/
/*
*/

main ()

{
   int  status,
        ColorCount,
        Red,
        Green,
        Blue;
   char  *BgColorPtr,
         *IntervalCommentPtr,
         *TextColorPtr;

   /*********/
   /* begin */
   /*********/

   if (getenv ("COLORS$DBUG")) Debug = true;
   if (Debug) system ("show symbol *");
   if (!Debug)
   {
      /* reopen output stream so that the '\r' and '\n' are not filtered */
      fclose (stdout);
#ifdef __DECC
      if ((stdout = fopen ("SYS$OUTPUT", "w", "ctx=bin")) == NULL)
         exit (vaxc$errno);
#else
      if ((stdout = fopen ("SYS$OUTPUT", "w", "rfm=udf")) == NULL)
         exit (vaxc$errno);
#endif
   }

   GetCgiVar (CgiKey1Ptr, "WWW_KEY_1");
   GetCgiVar (CgiKey2Ptr, "WWW_KEY_2");
   BgColorPtr = "ffffff";
   if (strlen(CgiKey1Ptr) == 6)
      BgColorPtr = CgiKey1Ptr;
   else
   if (isdigit(CgiKey1Ptr[0]))
      Interval = atoi(CgiKey1Ptr);
   if (strlen(CgiKey2Ptr) == 6)
      BgColorPtr = CgiKey2Ptr;
   else
   if (isdigit(CgiKey2Ptr[0]))
      Interval = atoi(CgiKey2Ptr);
   if (Interval <= 0 || Interval >= 255) Interval = 51;

   if (tolower(BgColorPtr[0]) < '8' &&
       tolower(BgColorPtr[2]) < '8' &&
       tolower(BgColorPtr[4]) < '8')
      TextColorPtr = "ffffff";
   else
      TextColorPtr = "000000";

   if (Interval == 51)
      IntervalCommentPtr = " &nbsp;(&quot;standard&quot; color map, 216 colors)";
   else
      IntervalCommentPtr = " &nbsp;(non-&quot;standard&quot; color map)";

   fprintf (stdout,
"HTTP/1.0 200 Ok\r\n\
Server: %s\r\n\
Content-Type: text/html\r\n\
\r\n\
<HTML>\n\
<HEAD>\n\
<TITLE></TITLE>\n\
</HEAD>\n\
<BODY BGCOLOR=\"#%s\" TEXT=\"#%s\">\n\
<B>Interval: %d%s</B>\n\
<P>\n\
<TABLE CELLPADDING=15 CELLSPACING=0 BORDER=0>\n\
<TR><TD>\n\
<TABLE CELLPADDING=3 CELLSPACING=0 BORDER=0>\n",
      SoftwareID, BgColorPtr, TextColorPtr,
      Interval, IntervalCommentPtr);

   ColorCount = 1;

   for (Red = 0; Red <= 255; Red += Interval)
   {
      for (Green = 0; Green <= 255; Green += Interval)
      {
         for (Blue = 0; Blue <= 255; Blue += Interval)
         {
            fprintf (stdout,
"<TR><TD ALIGN=right WIDTH=30><B>%d.</B>&nbsp;&nbsp;</TD>\
<TD ALIGN=left><FONT SIZE+1><TT>#%02x%02x%02x</TT>&nbsp;</FONT></TD>\
<TD ALIGN=right><FONT SIZE+1><TT>%d,%d,%d</TT>&nbsp;&nbsp;&nbsp;&nbsp;</FONT></TD>\
<TD><FONT COLOR=\"#%02x%02x%02x\"><NOBR>%s</NOBR></FONT></TD></TR>\n\
<TR><TD COLSPAN=3></TD><TD BGCOLOR=\"#000000\">\
<NOBR><FONT COLOR=\"#%02x%02x%02x\">%s</FONT></NOBR></TD></TR>\n\
<TR><TD COLSPAN=3></TD><TD BGCOLOR=\"#%02x%02x%02x\">\
<NOBR><FONT COLOR=\"#000000\">%s</FONT></NOBR></TD></TR>\n\
<TR><TD COLSPAN=3></TD>\<TD BGCOLOR=\"#%02x%02x%02x\">\
<NOBR><FONT COLOR=\"#ffffff\">%s</FONT></NOBR></TD></TR>\n",
               ColorCount++,
               Red & 0xff, Green & 0xff, Blue & 0xff,
               Red & 0xff, Green & 0xff, Blue & 0xff,
               Red & 0xff, Green & 0xff, Blue & 0xff,
               String,
               Red & 0xff, Green & 0xff, Blue & 0xff,
               String,
               Red & 0xff, Green & 0xff, Blue & 0xff,
               String,
               Red & 0xff, Green & 0xff, Blue & 0xff,
               String);
         }
         fprintf (stdout, "<TR><TD></TD></TR>\n");
      }
   }

   fprintf (stdout, "</TABLE>\n</TD></TR>\n</TABLE>\n</BODY>\n</HTML>\n");

   exit (SS$_NORMAL);
}

/*****************************************************************************/

